/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.org.apache.kafka09.common.network;

import java.util.Map;
import org.graylog.shaded.org.apache.kafka09.common.network.ChannelBuilder;
import org.graylog.shaded.org.apache.kafka09.common.network.LoginType;
import org.graylog.shaded.org.apache.kafka09.common.network.Mode;
import org.graylog.shaded.org.apache.kafka09.common.network.PlaintextChannelBuilder;
import org.graylog.shaded.org.apache.kafka09.common.network.SaslChannelBuilder;
import org.graylog.shaded.org.apache.kafka09.common.network.SslChannelBuilder;
import org.graylog.shaded.org.apache.kafka09.common.protocol.SecurityProtocol;
import org.graylog.shaded.org.apache.kafka09.common.security.auth.DefaultPrincipalBuilder;
import org.graylog.shaded.org.apache.kafka09.common.security.auth.PrincipalBuilder;
import org.graylog.shaded.org.apache.kafka09.common.utils.Utils;

public class ChannelBuilders {
    private ChannelBuilders() {
    }

    public static ChannelBuilder create(SecurityProtocol securityProtocol, Mode mode, LoginType loginType, Map<String, ?> configs) {
        ChannelBuilder channelBuilder;
        switch (securityProtocol) {
            case SSL: {
                ChannelBuilders.requireNonNullMode(mode, securityProtocol);
                channelBuilder = new SslChannelBuilder(mode);
                break;
            }
            case SASL_SSL: 
            case SASL_PLAINTEXT: {
                ChannelBuilders.requireNonNullMode(mode, securityProtocol);
                if (loginType == null) {
                    throw new IllegalArgumentException("`loginType` must be non-null if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
                }
                channelBuilder = new SaslChannelBuilder(mode, loginType, securityProtocol);
                break;
            }
            case PLAINTEXT: 
            case TRACE: {
                channelBuilder = new PlaintextChannelBuilder();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected securityProtocol " + (Object)((Object)securityProtocol));
            }
        }
        channelBuilder.configure(configs);
        return channelBuilder;
    }

    static PrincipalBuilder createPrincipalBuilder(Map<String, ?> configs) {
        Class principalBuilderClass = (Class)configs.get("principal.builder.class");
        PrincipalBuilder principalBuilder = principalBuilderClass == null ? new DefaultPrincipalBuilder() : (PrincipalBuilder)Utils.newInstance(principalBuilderClass);
        principalBuilder.configure(configs);
        return principalBuilder;
    }

    private static void requireNonNullMode(Mode mode, SecurityProtocol securityProtocol) {
        if (mode == null) {
            throw new IllegalArgumentException("`mode` must be non-null if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
        }
    }
}

