/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.utils;

import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.kafka09.org.I0Itec.zkclient.ZkClient;
import org.graylog.shaded.kafka09.org.I0Itec.zkclient.ZkConnection;
import org.graylog.shaded.kafka09.scala.MatchError;
import org.graylog.shaded.kafka09.scala.Tuple2;
import org.graylog.shaded.kafka09.scala.collection.mutable.StringBuilder;
import org.graylog.shaded.kafka09.scala.runtime.BoxesRunTime;
import org.graylog.shaded.kafka09.utils.ZKStringSerializer$;
import org.graylog.shaded.kafka09.utils.ZkUtils;
import org.graylog.shaded.org.apache.kafka09.zookeeper.ZooDefs;
import org.graylog.shaded.org.apache.kafka09.zookeeper.data.ACL;

public final class ZkUtils$ {
    public static final ZkUtils$ MODULE$;
    private final String ConsumersPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String ReassignPartitionsPath;
    private final String DeleteTopicsPath;
    private final String PreferredReplicaLeaderElectionPath;
    private final String BrokerSequenceIdPath;
    private final String IsrChangeNotificationPath;
    private final String EntityConfigPath;
    private final String EntityConfigChangesPath;

    static {
        new ZkUtils$();
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String ReassignPartitionsPath() {
        return this.ReassignPartitionsPath;
    }

    public String DeleteTopicsPath() {
        return this.DeleteTopicsPath;
    }

    public String PreferredReplicaLeaderElectionPath() {
        return this.PreferredReplicaLeaderElectionPath;
    }

    public String BrokerSequenceIdPath() {
        return this.BrokerSequenceIdPath;
    }

    public String IsrChangeNotificationPath() {
        return this.IsrChangeNotificationPath;
    }

    public String EntityConfigPath() {
        return this.EntityConfigPath;
    }

    public String EntityConfigChangesPath() {
        return this.EntityConfigChangesPath;
    }

    public ZkUtils apply(String zkUrl, int sessionTimeout, int connectionTimeout, boolean isZkSecurityEnabled) {
        Tuple2<ZkClient, ZkConnection> tuple2 = this.createZkClientAndConnection(zkUrl, sessionTimeout, connectionTimeout);
        if (tuple2 != null) {
            Tuple2<ZkClient, ZkConnection> tuple22;
            ZkClient zkClient = tuple2._1();
            ZkConnection zkConnection = tuple2._2();
            Tuple2<ZkClient, ZkConnection> tuple23 = tuple22 = new Tuple2<ZkClient, ZkConnection>(zkClient, zkConnection);
            ZkClient zkClient2 = tuple23._1();
            ZkConnection zkConnection2 = tuple23._2();
            return new ZkUtils(zkClient2, zkConnection2, isZkSecurityEnabled);
        }
        throw new MatchError(tuple2);
    }

    public ZkUtils apply(ZkClient zkClient, boolean isZkSecurityEnabled) {
        return new ZkUtils(zkClient, null, isZkSecurityEnabled);
    }

    public ZkClient createZkClient(String zkUrl, int sessionTimeout, int connectionTimeout) {
        ZkClient zkClient = new ZkClient(zkUrl, sessionTimeout, connectionTimeout, ZKStringSerializer$.MODULE$);
        return zkClient;
    }

    public Tuple2<ZkClient, ZkConnection> createZkClientAndConnection(String zkUrl, int sessionTimeout, int connectionTimeout) {
        ZkConnection zkConnection = new ZkConnection(zkUrl, sessionTimeout);
        ZkClient zkClient = new ZkClient(zkConnection, connectionTimeout, ZKStringSerializer$.MODULE$);
        return new Tuple2<ZkClient, ZkConnection>(zkClient, zkConnection);
    }

    /*
     * WARNING - void declaration
     */
    public List<ACL> DefaultAcls(boolean isSecure) {
        ArrayList<ACL> arrayList;
        if (isSecure) {
            void var2_2;
            ArrayList<ACL> list2 = new ArrayList<ACL>();
            list2.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
            list2.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
            arrayList = var2_2;
        } else {
            arrayList = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        }
        return arrayList;
    }

    public void maybeDeletePath(String zkUrl, String dir) {
        try {
            ZkClient zk = this.createZkClient(zkUrl, 30000, 30000);
            zk.deleteRecursive(dir);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    public String getTopicPath(String topic) {
        return new StringBuilder().append((Object)this.BrokerTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    public String getTopicPartitionsPath(String topic) {
        return new StringBuilder().append((Object)this.getTopicPath(topic)).append((Object)"/partitions").toString();
    }

    public String getTopicPartitionPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionsPath(topic)).append((Object)"/").append(BoxesRunTime.boxToInteger(partitionId)).toString();
    }

    public String getTopicPartitionLeaderAndIsrPath(String topic, int partitionId) {
        return new StringBuilder().append((Object)this.getTopicPartitionPath(topic, partitionId)).append((Object)"/").append((Object)"state").toString();
    }

    public String getEntityConfigRootPath(String entityType) {
        return new StringBuilder().append((Object)this.EntityConfigPath()).append((Object)"/").append((Object)entityType).toString();
    }

    public String getEntityConfigPath(String entityType, String entity) {
        return new StringBuilder().append((Object)this.getEntityConfigRootPath(entityType)).append((Object)"/").append((Object)entity).toString();
    }

    public String getDeleteTopicPath(String topic) {
        return new StringBuilder().append((Object)this.DeleteTopicsPath()).append((Object)"/").append((Object)topic).toString();
    }

    private ZkUtils$() {
        MODULE$ = this;
        this.ConsumersPath = "/consumers";
        this.BrokerIdsPath = "/brokers/ids";
        this.BrokerTopicsPath = "/brokers/topics";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.ReassignPartitionsPath = "/admin/reassign_partitions";
        this.DeleteTopicsPath = "/admin/delete_topics";
        this.PreferredReplicaLeaderElectionPath = "/admin/preferred_replica_election";
        this.BrokerSequenceIdPath = "/brokers/seqid";
        this.IsrChangeNotificationPath = "/isr_change_notification";
        this.EntityConfigPath = "/config";
        this.EntityConfigChangesPath = "/config/changes";
    }
}

