/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.tools;

import org.graylog.shaded.kafka09.api.OffsetRequest;
import org.graylog.shaded.kafka09.api.OffsetRequest$;
import org.graylog.shaded.kafka09.api.PartitionOffsetRequestInfo;
import org.graylog.shaded.kafka09.api.PartitionOffsetsResponse;
import org.graylog.shaded.kafka09.cluster.Broker;
import org.graylog.shaded.kafka09.common.KafkaException;
import org.graylog.shaded.kafka09.common.TopicAndPartition;
import org.graylog.shaded.kafka09.consumer.ConsumerConfig;
import org.graylog.shaded.kafka09.consumer.SimpleConsumer;
import org.graylog.shaded.kafka09.scala.MatchError;
import org.graylog.shaded.kafka09.scala.None$;
import org.graylog.shaded.kafka09.scala.Option;
import org.graylog.shaded.kafka09.scala.Predef$;
import org.graylog.shaded.kafka09.scala.Predef$ArrowAssoc$;
import org.graylog.shaded.kafka09.scala.Serializable;
import org.graylog.shaded.kafka09.scala.Some;
import org.graylog.shaded.kafka09.scala.Tuple2;
import org.graylog.shaded.kafka09.scala.collection.Seq;
import org.graylog.shaded.kafka09.scala.collection.immutable.List$;
import org.graylog.shaded.kafka09.scala.collection.immutable.Map;
import org.graylog.shaded.kafka09.scala.collection.immutable.Nil$;
import org.graylog.shaded.kafka09.scala.collection.immutable.StringOps;
import org.graylog.shaded.kafka09.scala.collection.mutable.StringBuilder;
import org.graylog.shaded.kafka09.scala.runtime.BoxedUnit;
import org.graylog.shaded.kafka09.scala.runtime.BoxesRunTime;
import org.graylog.shaded.kafka09.scala.runtime.IntRef;
import org.graylog.shaded.kafka09.scala.runtime.Nothing$;
import org.graylog.shaded.kafka09.utils.ZKGroupTopicDirs;
import org.graylog.shaded.kafka09.utils.ZkUtils;
import org.graylog.shaded.kafka09.utils.ZkUtils$;
import org.graylog.shaded.org.apache.kafka09.common.protocol.SecurityProtocol;
import org.graylog.shaded.org.apache.kafka09.common.security.JaasUtils;
import org.graylog.shaded.org.apache.kafka09.common.utils.Utils;

public final class UpdateOffsetsInZK$ {
    public static final UpdateOffsetsInZK$ MODULE$;
    private final String Earliest;
    private final String Latest;

    static {
        new UpdateOffsetsInZK$();
    }

    public String Earliest() {
        return this.Earliest;
    }

    public String Latest() {
        return this.Latest;
    }

    public void main(String[] args) {
        if (args.length < 3) {
            this.usage();
        }
        ConsumerConfig config = new ConsumerConfig(Utils.loadProps(args[1]));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(config.zkConnect(), config.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), JaasUtils.isZkSecurityEnabled());
        String string2 = args[0];
        String string3 = this.Earliest();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.getAndSetOffsets(zkUtils, OffsetRequest$.MODULE$.EarliestTime(), config, args[2]);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string5 = this.Latest();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                this.getAndSetOffsets(zkUtils, OffsetRequest$.MODULE$.LatestTime(), config, args[2]);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.usage();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void getAndSetOffsets(ZkUtils zkUtils, long offsetOption, ConsumerConfig config, String topic) {
        org.graylog.shaded.kafka09.scala.collection.mutable.Map<String, Seq<Object>> partitionsPerTopicMap = zkUtils.getPartitionsForTopics((Seq<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Seq<Nothing$> partitions = Nil$.MODULE$;
        Option option = partitionsPerTopicMap.get(topic);
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq l = (Seq)some.x();
            partitions = (Seq)l.sortWith(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(int s2, int t) {
                    return this.apply$mcZII$sp(s2, t);
                }

                public boolean apply$mcZII$sp(int s2, int t) {
                    return s2 < t;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            IntRef numParts = IntRef.create(0);
            partitions.foreach(new Serializable(zkUtils, offsetOption, config, topic, numParts){
                public static final long serialVersionUID = 0L;
                private final ZkUtils zkUtils$1;
                private final long offsetOption$1;
                private final ConsumerConfig config$1;
                private final String topic$1;
                private final IntRef numParts$1;

                public final void apply(int partition2) {
                    this.apply$mcVI$sp(partition2);
                }

                public void apply$mcVI$sp(int partition2) {
                    Option<Object> brokerHostingPartition = this.zkUtils$1.getLeaderForPartition(this.topic$1, partition2);
                    Option<Object> option = brokerHostingPartition;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int b = BoxesRunTime.unboxToInt(some.x());
                        int n = b;
                        int broker = n;
                        Option<Broker> option2 = this.zkUtils$1.getBrokerInfo(broker);
                        if (option2 instanceof Some) {
                            Some some2 = (Some)option2;
                            Broker brokerInfo = (Broker)some2.x();
                            SimpleConsumer consumer = new SimpleConsumer(brokerInfo.getBrokerEndPoint(SecurityProtocol.PLAINTEXT).host(), brokerInfo.getBrokerEndPoint(SecurityProtocol.PLAINTEXT).port(), 10000, 102400, "UpdateOffsetsInZk");
                            TopicAndPartition topicAndPartition = new TopicAndPartition(this.topic$1, partition2);
                            OffsetRequest request = new OffsetRequest((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicAndPartition), new PartitionOffsetRequestInfo(this.offsetOption$1, 1))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                            long offset = BoxesRunTime.unboxToLong(((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply(topicAndPartition)).offsets().head());
                            ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(this.config$1.groupId(), this.topic$1);
                            Predef$.MODULE$.println(new StringBuilder().append((Object)"updating partition ").append(BoxesRunTime.boxToInteger(partition2)).append((Object)" with new offset: ").append(BoxesRunTime.boxToLong(offset)).toString());
                            this.zkUtils$1.updatePersistentPath(new StringBuilder().append((Object)topicDirs.consumerOffsetDir()).append((Object)"/").append(BoxesRunTime.boxToInteger(partition2)).toString(), ((Object)BoxesRunTime.boxToLong(offset)).toString(), this.zkUtils$1.updatePersistentPath$default$3());
                            ++this.numParts$1.elem;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        if (None$.MODULE$.equals(option2)) {
                            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Broker information for broker id %d does not exist in ZK")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(broker)})));
                        }
                        throw new MatchError(option2);
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new KafkaException(new StringBuilder().append((Object)"Broker ").append(brokerHostingPartition).append((Object)" is unavailable. Cannot issue ").append((Object)"getOffsetsBefore request").toString());
                    }
                    throw new MatchError(option);
                }
                {
                    this.zkUtils$1 = zkUtils$1;
                    this.offsetOption$1 = offsetOption$1;
                    this.config$1 = config$1;
                    this.topic$1 = topic$1;
                    this.numParts$1 = numParts$1;
                }
            });
            Predef$.MODULE$.println(new StringBuilder().append((Object)"updated the offset for ").append(BoxesRunTime.boxToInteger(numParts.elem)).append((Object)" partitions").toString());
            return;
        }
        throw new RuntimeException(new StringBuilder().append((Object)"Can't find topic ").append((Object)topic).toString());
    }

    private void usage() {
        Predef$.MODULE$.println(new StringBuilder().append((Object)"USAGE: ").append((Object)this.getClass().getName()).append((Object)" [earliest | latest] consumer.properties topic").toString());
        System.exit(1);
    }

    private UpdateOffsetsInZK$() {
        MODULE$ = this;
        this.Earliest = "earliest";
        this.Latest = "latest";
    }
}

