/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import org.apache.log4j.Logger;
import org.graylog.shaded.kafka09.joptsimple.ArgumentAcceptingOptionSpec;
import org.graylog.shaded.kafka09.joptsimple.OptionParser;
import org.graylog.shaded.kafka09.joptsimple.OptionSet;
import org.graylog.shaded.kafka09.joptsimple.OptionSpec;
import org.graylog.shaded.kafka09.scala.Function0;
import org.graylog.shaded.kafka09.scala.Function1;
import org.graylog.shaded.kafka09.scala.MatchError;
import org.graylog.shaded.kafka09.scala.Predef$;
import org.graylog.shaded.kafka09.scala.Predef$ArrowAssoc$;
import org.graylog.shaded.kafka09.scala.Serializable;
import org.graylog.shaded.kafka09.scala.Tuple2;
import org.graylog.shaded.kafka09.scala.collection.immutable.Map;
import org.graylog.shaded.kafka09.scala.collection.immutable.Nil$;
import org.graylog.shaded.kafka09.scala.collection.mutable.StringBuilder;
import org.graylog.shaded.kafka09.scala.runtime.BoxedUnit;
import org.graylog.shaded.kafka09.scala.runtime.ObjectRef;
import org.graylog.shaded.kafka09.utils.CommandLineUtils$;
import org.graylog.shaded.kafka09.utils.Log4jController$;
import org.graylog.shaded.kafka09.utils.Logging;
import org.graylog.shaded.kafka09.utils.Logging$class;
import org.graylog.shaded.kafka09.utils.ZkUtils;
import org.graylog.shaded.kafka09.utils.ZkUtils$;
import org.graylog.shaded.org.apache.kafka09.common.security.JaasUtils;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ImportZkOffsets$
implements Logging {
    public static final ImportZkOffsets$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ImportZkOffsets$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ImportZkOffsets$ importZkOffsets$ = this;
        synchronized (importZkOffsets$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> zkConnectOpt = parser.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo("localhost:2181", (String[])((Object[])new String[0])).ofType(String.class);
        ArgumentAcceptingOptionSpec<String> inFileOpt = parser.accepts("input-file", "Input file").withRequiredArg().ofType(String.class);
        parser.accepts("help", "Print this message.");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Import offsets to zookeeper from files.");
        }
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{inFileOpt}));
        String zkConnect = options.valueOf(zkConnectOpt);
        String partitionOffsetFile = options.valueOf(inFileOpt);
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkConnect, 30000, 30000, JaasUtils.isZkSecurityEnabled());
        Map<String, String> partitionOffsets = this.getPartitionOffsetsFromFile(partitionOffsetFile);
        this.updateZkOffsets(zkUtils, partitionOffsets);
    }

    private Map<String, String> getPartitionOffsetsFromFile(String filename) {
        FileReader fr = new FileReader(filename);
        BufferedReader br = new BufferedReader(fr);
        Map<String, String> partOffsetsMap = (Map<String, String>)Predef$.MODULE$.Map().apply(Nil$.MODULE$);
        ObjectRef<String> s2 = ObjectRef.create(br.readLine());
        while ((String)s2.elem != null && ((String)s2.elem).length() >= 1) {
            String[] tokens = ((String)s2.elem).split(":");
            partOffsetsMap = partOffsetsMap.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tokens[0]), tokens[1]));
            this.debug((Function0<String>)((Object)new Serializable(s2){
                public static final long serialVersionUID = 0L;
                private final ObjectRef s$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"adding node path [").append((Object)((String)this.s$1.elem)).append((Object)"]").toString();
                }
                {
                    this.s$1 = s$1;
                }
            }));
            s2.elem = br.readLine();
        }
        return partOffsetsMap;
    }

    private void updateZkOffsets(ZkUtils zkUtils, Map<String, String> partitionOffsets) {
        partitionOffsets.withFilter((Function1<String, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        })).foreach(new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<String, String> x$1) {
                BoxedUnit boxedUnit;
                Tuple2<String, String> tuple2 = x$1;
                if (tuple2 == null) throw new MatchError(tuple2);
                String partition2 = tuple2._1();
                String offset = tuple2._2();
                ImportZkOffsets$.MODULE$.debug((Function0<String>)((Object)new Serializable(this, partition2, offset){
                    public static final long serialVersionUID = 0L;
                    private final String partition$1;
                    private final String offset$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"updating [").append((Object)this.partition$1).append((Object)"] with offset [").append((Object)this.offset$1).append((Object)"]").toString();
                    }
                    {
                        this.partition$1 = partition$1;
                        this.offset$1 = offset$1;
                    }
                }));
                try {
                    this.zkUtils$1.updatePersistentPath(partition2, offset.toString(), this.zkUtils$1.updatePersistentPath$default$3());
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            {
                this.zkUtils$1 = zkUtils$1;
            }
        });
    }

    private ImportZkOffsets$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

