/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.tools;

import java.nio.channels.ClosedByInterruptException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.graylog.shaded.kafka09.consumer.ConsumerIterator;
import org.graylog.shaded.kafka09.consumer.ConsumerTimeoutException;
import org.graylog.shaded.kafka09.consumer.KafkaStream;
import org.graylog.shaded.kafka09.joptsimple.ArgumentAcceptingOptionSpec;
import org.graylog.shaded.kafka09.joptsimple.OptionSet;
import org.graylog.shaded.kafka09.joptsimple.OptionSpec;
import org.graylog.shaded.kafka09.joptsimple.OptionSpecBuilder;
import org.graylog.shaded.kafka09.message.MessageAndMetadata;
import org.graylog.shaded.kafka09.scala.Predef$;
import org.graylog.shaded.kafka09.scala.collection.Iterator;
import org.graylog.shaded.kafka09.scala.collection.immutable.List;
import org.graylog.shaded.kafka09.scala.collection.mutable.StringBuilder;
import org.graylog.shaded.kafka09.scala.reflect.ScalaSignature;
import org.graylog.shaded.kafka09.scala.runtime.BoxesRunTime;
import org.graylog.shaded.kafka09.tools.ConsumerPerformance$;
import org.graylog.shaded.kafka09.tools.PerfConfig;
import org.graylog.shaded.kafka09.utils.CommandLineUtils$;
import org.graylog.shaded.kafka09.utils.IteratorTemplate;
import org.graylog.shaded.org.apache.kafka09.clients.consumer.KafkaConsumer;
import org.graylog.shaded.org.apache.kafka09.common.serialization.ByteArrayDeserializer;
import org.graylog.shaded.org.apache.kafka09.common.utils.Utils;

@ScalaSignature(bytes="\u0006\u0001\t\u001dt!B\u0001\u0003\u0011\u00039\u0011aE\"p]N,X.\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0014\u0007>t7/^7feB+'OZ8s[\u0006t7-Z\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\ta\u0001\\8hO\u0016\u0014X#\u0001\r\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012!\u00027pORR'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001eL!!\t\u000e\u0003\r1{wmZ3s\u0011\u0019\u0019\u0013\u0002)A\u00051\u00059An\\4hKJ\u0004\u0003\"B\u0013\n\t\u00031\u0013\u0001B7bS:$\"a\n\u0016\u0011\u00055A\u0013BA\u0015\u000f\u0005\u0011)f.\u001b;\t\u000b-\"\u0003\u0019\u0001\u0017\u0002\t\u0005\u0014xm\u001d\t\u0004\u001b5z\u0013B\u0001\u0018\u000f\u0005\u0015\t%O]1z!\t\u00014G\u0004\u0002\u000ec%\u0011!GD\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u00023\u001d!)q'\u0003C\u0001q\u000591m\u001c8tk6,GCC\u0014:\u000fVSF,a8\u0002t\")!H\u000ea\u0001w\u0005A1m\u001c8tk6,'\u000f\u0005\u0003=\u0003\u000e\u001bU\"A\u001f\u000b\u0005ir$BA A\u0003\u001d\u0019G.[3oiNT!!\u0002\u000f\n\u0005\tk$!D&bM.\f7i\u001c8tk6,'\u000fE\u0002\u000e[\u0011\u0003\"!D#\n\u0005\u0019s!\u0001\u0002\"zi\u0016DQ\u0001\u0013\u001cA\u0002%\u000ba\u0001^8qS\u000e\u001c\bc\u0001&S_9\u00111\n\u0015\b\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u001a\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005Es\u0011a\u00029bG.\fw-Z\u0005\u0003'R\u0013A\u0001T5ti*\u0011\u0011K\u0004\u0005\u0006-Z\u0002\raV\u0001\u0006G>,h\u000e\u001e\t\u0003\u001baK!!\u0017\b\u0003\t1{gn\u001a\u0005\u00067Z\u0002\raV\u0001\bi&lWm\\;u\u0011\u0015if\u00071\u0001_\u0003\u0019\u0019wN\u001c4jOB\u0011q\fY\u0007\u0002\u0013\u0019!\u0011-\u0003\u0001c\u0005I\u0019uN\\:v[\u0016\u0014\b+\u001a:g\u0007>tg-[4\u0014\u0005\u0001\u001c\u0007C\u0001\u0005e\u0013\t)'A\u0001\u0006QKJ47i\u001c8gS\u001eD\u0001b\u000b1\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006'\u0001$\t\u0001\u001b\u000b\u0003=&DQaK4A\u00021Bqa\u001b1C\u0002\u0013\u0005A.\u0001\u0007{W\u000e{gN\\3di>\u0003H/F\u0001n!\rq\u0017oL\u0007\u0002_*\t\u0001/\u0001\u0006k_B$8/[7qY\u0016L!A]8\u00037\u0005\u0013x-^7f]R\f5mY3qi&twm\u00149uS>t7\u000b]3d\u0011\u0019!\b\r)A\u0005[\u0006i!p[\"p]:,7\r^(qi\u0002BqA\u001e1C\u0002\u0013\u0005A.A\nc_>$8\u000f\u001e:baN+'O^3sg>\u0003H\u000f\u0003\u0004yA\u0002\u0006I!\\\u0001\u0015E>|Go\u001d;sCB\u001cVM\u001d<feN|\u0005\u000f\u001e\u0011\t\u000fi\u0004'\u0019!C\u0001Y\u0006AAo\u001c9jG>\u0003H\u000f\u0003\u0004}A\u0002\u0006I!\\\u0001\ni>\u0004\u0018nY(qi\u0002BqA 1C\u0002\u0013\u0005A.\u0001\u0006he>,\b/\u00133PaRDq!!\u0001aA\u0003%Q.A\u0006he>,\b/\u00133PaR\u0004\u0003\"CA\u0003A\n\u0007I\u0011AA\u0004\u000311W\r^2i'&TXm\u00149u+\t\tI\u0001\u0005\u0003oc\u0006-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0016\u0005!!.\u0019<b\u0013\u0011\tI\"a\u0004\u0003\u000f%sG/Z4fe\"A\u0011Q\u00041!\u0002\u0013\tI!A\u0007gKR\u001c\u0007nU5{K>\u0003H\u000f\t\u0005\n\u0003C\u0001'\u0019!C\u0001\u0003G\tqC]3tKR\u0014UmZ5o]&twm\u00144gg\u0016$x\n\u001d;\u0016\u0005\u0005\u0015\u0002c\u00018\u0002(%\u0019\u0011\u0011F8\u0003#=\u0003H/[8o'B,7MQ;jY\u0012,'\u000f\u0003\u0005\u0002.\u0001\u0004\u000b\u0011BA\u0013\u0003a\u0011Xm]3u\u0005\u0016<\u0017N\u001c8j]\u001e|eMZ:fi>\u0003H\u000f\t\u0005\n\u0003c\u0001'\u0019!C\u0001\u0003\u000f\t1c]8dW\u0016$()\u001e4gKJ\u001c\u0016N_3PaRD\u0001\"!\u000eaA\u0003%\u0011\u0011B\u0001\u0015g>\u001c7.\u001a;Ck\u001a4WM]*ju\u0016|\u0005\u000f\u001e\u0011\t\u0013\u0005e\u0002M1A\u0005\u0002\u0005\u001d\u0011!\u00048v[RC'/Z1eg>\u0003H\u000f\u0003\u0005\u0002>\u0001\u0004\u000b\u0011BA\u0005\u00039qW/\u001c+ie\u0016\fGm](qi\u0002B\u0011\"!\u0011a\u0005\u0004%\t!a\u0002\u0002\u001d9,XNR3uG\",'o](qi\"A\u0011Q\t1!\u0002\u0013\tI!A\bok64U\r^2iKJ\u001cx\n\u001d;!\u0011%\tI\u0005\u0019b\u0001\n\u0003\t\u0019#A\tvg\u0016tUm^\"p]N,X.\u001a:PaRD\u0001\"!\u0014aA\u0003%\u0011QE\u0001\u0013kN,g*Z<D_:\u001cX/\\3s\u001fB$\b\u0005\u0003\u0005\u0002R\u0001\u0014\r\u0011\"\u0001m\u0003E\u0019wN\\:v[\u0016\u00148i\u001c8gS\u001e|\u0005\u000f\u001e\u0005\b\u0003+\u0002\u0007\u0015!\u0003n\u0003I\u0019wN\\:v[\u0016\u00148i\u001c8gS\u001e|\u0005\u000f\u001e\u0011\t\u0013\u0005e\u0003M1A\u0005\u0002\u0005m\u0013aB8qi&|gn]\u000b\u0003\u0003;\u00022A\\A0\u0013\r\t\tg\u001c\u0002\n\u001fB$\u0018n\u001c8TKRD\u0001\"!\u001aaA\u0003%\u0011QL\u0001\t_B$\u0018n\u001c8tA!I\u0011\u0011\u000e1C\u0002\u0013\u0005\u00111N\u0001\u000fkN,g*Z<D_:\u001cX/\\3s+\t\ti\u0007E\u0002\u000e\u0003_J1!!\u001d\u000f\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u001eaA\u0003%\u0011QN\u0001\u0010kN,g*Z<D_:\u001cX/\\3sA!I\u0011\u0011\u00101C\u0002\u0013\u0005\u00111P\u0001\u0006aJ|\u0007o]\u000b\u0003\u0003{\u0002B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b\u0019\"\u0001\u0003vi&d\u0017\u0002BAD\u0003\u0003\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011!\tY\t\u0019Q\u0001\n\u0005u\u0014A\u00029s_B\u001c\b\u0005C\u0005\u0002\u0010\u0002\u0014\r\u0011\"\u0001\u0002\u0012\u0006Qa.^7UQJ,\u0017\rZ:\u0016\u0005\u0005M\u0005cA\u0007\u0002\u0016&\u0019\u0011q\u0013\b\u0003\u0007%sG\u000f\u0003\u0005\u0002\u001c\u0002\u0004\u000b\u0011BAJ\u0003-qW/\u001c+ie\u0016\fGm\u001d\u0011\t\u0013\u0005}\u0005M1A\u0005\u0002\u0005\u0005\u0016!\u0002;pa&\u001cW#A\u0018\t\u000f\u0005\u0015\u0006\r)A\u0005_\u00051Ao\u001c9jG\u0002B\u0011\"!+a\u0005\u0004%\t!a+\u0002\u00179,X.T3tg\u0006<Wm]\u000b\u0002/\"9\u0011q\u00161!\u0002\u00139\u0016\u0001\u00048v[6+7o]1hKN\u0004\u0003\"CAZA\n\u0007I\u0011AAI\u0003E\u0011X\r]8si&tw-\u00138uKJ4\u0018\r\u001c\u0005\t\u0003o\u0003\u0007\u0015!\u0003\u0002\u0014\u0006\u0011\"/\u001a9peRLgnZ%oi\u0016\u0014h/\u00197!\u0011%\tY\f\u0019b\u0001\n\u0003\tY'A\ttQ><H)\u001a;bS2,Gm\u0015;biND\u0001\"a0aA\u0003%\u0011QN\u0001\u0013g\"|w\u000fR3uC&dW\rZ*uCR\u001c\b\u0005C\u0005\u0002D\u0002\u0014\r\u0011\"\u0001\u0002F\u0006QA-\u0019;f\r>\u0014X.\u0019;\u0016\u0005\u0005\u001d\u0007\u0003BAe\u0003\u001fl!!a3\u000b\t\u00055\u00171C\u0001\u0005i\u0016DH/\u0003\u0003\u0002R\u0006-'\u0001E*j[BdW\rR1uK\u001a{'/\\1u\u0011!\t)\u000e\u0019Q\u0001\n\u0005\u001d\u0017a\u00033bi\u00164uN]7bi\u0002B\u0011\"!7a\u0005\u0004%\t!a\u001b\u0002\u0015!LG-\u001a%fC\u0012,'\u000f\u0003\u0005\u0002^\u0002\u0004\u000b\u0011BA7\u0003-A\u0017\u000eZ3IK\u0006$WM\u001d\u0011\t\u000f\u0005\u0005h\u00071\u0001\u0002d\u0006\tBo\u001c;bY6+7o]1hKN\u0014V-\u00193\u0011\t\u0005\u0015\u0018q^\u0007\u0003\u0003OTA!!;\u0002l\u00061\u0011\r^8nS\u000eTA!!<\u0002\u0002\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005E\u0018q\u001d\u0002\u000b\u0003R|W.[2M_:<\u0007bBA{m\u0001\u0007\u00111]\u0001\u000fi>$\u0018\r\u001c\"zi\u0016\u001c(+Z1e\u0011\u001d\tI0\u0003C\u0001\u0003w\fA\u0003\u001d:j]R\u0004&o\\4sKN\u001cX*Z:tC\u001e,G#E\u0014\u0002~\n\u0005!Q\u0001B\u0005\u0005\u001b\u0011\tB!\u0006\u0003\u001a!A\u0011q`A|\u0001\u0004\t\u0019*\u0001\u0002jI\"9!1AA|\u0001\u00049\u0016!\u00032zi\u0016\u001c(+Z1e\u0011\u001d\u00119!a>A\u0002]\u000bQ\u0002\\1ti\nKH/Z:SK\u0006$\u0007b\u0002B\u0006\u0003o\u0004\raV\u0001\r[\u0016\u001c8/Y4fgJ+\u0017\r\u001a\u0005\b\u0005\u001f\t9\u00101\u0001X\u0003Aa\u0017m\u001d;NKN\u001c\u0018mZ3t%\u0016\fG\rC\u0004\u0003\u0014\u0005]\b\u0019A,\u0002\u000fM$\u0018M\u001d;Ng\"9!qCA|\u0001\u00049\u0016!B3oI6\u001b\b\u0002CAb\u0003o\u0004\r!a2\u0007\r\tu\u0011\u0002\u0001B\u0010\u0005I\u0019uN\\:v[\u0016\u0014\b+\u001a:g)\"\u0014X-\u00193\u0014\t\tm!\u0011\u0005\t\u0005\u0003\u001b\u0011\u0019#\u0003\u0003\u0003&\u0005=!A\u0002+ie\u0016\fG\rC\u0006\u0003*\tm!\u0011!Q\u0001\n\u0005M\u0015\u0001\u0003;ie\u0016\fG-\u00133\t\u0015\t5\"1\u0004B\u0001B\u0003%q&\u0001\u0003oC6,\u0007b\u0003B\u0019\u00057\u0011\t\u0011)A\u0005\u0005g\taa\u001d;sK\u0006l\u0007C\u0002B\u001b\u0005s\u00195)\u0004\u0002\u00038)\u0011!\bB\u0005\u0005\u0005w\u00119DA\u0006LC\u001a\\\u0017m\u0015;sK\u0006l\u0007\"C/\u0003\u001c\t\u0005\t\u0015!\u0003_\u0011-\t\tOa\u0007\u0003\u0002\u0003\u0006I!a9\t\u0017\u0005U(1\u0004B\u0001B\u0003%\u00111\u001d\u0005\f\u0005\u000b\u0012YB!A!\u0002\u0013\u00119%A\bd_:\u001cX/\\3s)&lWm\\;u!\u0011\t)O!\u0013\n\t\t-\u0013q\u001d\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\u000fM\u0011Y\u0002\"\u0001\u0003PQ\u0001\"\u0011\u000bB*\u0005+\u00129F!\u0017\u0003\\\tu#q\f\t\u0004?\nm\u0001\u0002\u0003B\u0015\u0005\u001b\u0002\r!a%\t\u000f\t5\"Q\na\u0001_!A!\u0011\u0007B'\u0001\u0004\u0011\u0019\u0004\u0003\u0004^\u0005\u001b\u0002\rA\u0018\u0005\t\u0003C\u0014i\u00051\u0001\u0002d\"A\u0011Q\u001fB'\u0001\u0004\t\u0019\u000f\u0003\u0005\u0003F\t5\u0003\u0019\u0001B$\u0011!\u0011\u0019Ga\u0007\u0005B\t\u0015\u0014a\u0001:v]R\tq\u0005")
public final class ConsumerPerformance {
    public static void printProgressMessage(int n, long l, long l2, long l3, long l4, long l5, long l6, SimpleDateFormat simpleDateFormat) {
        ConsumerPerformance$.MODULE$.printProgressMessage(n, l, l2, l3, l4, l5, l6, simpleDateFormat);
    }

    public static void consume(KafkaConsumer<byte[], byte[]> kafkaConsumer, List<String> list2, long l, long l2, ConsumerPerfConfig consumerPerfConfig, AtomicLong atomicLong, AtomicLong atomicLong2) {
        ConsumerPerformance$.MODULE$.consume(kafkaConsumer, list2, l, l2, consumerPerfConfig, atomicLong, atomicLong2);
    }

    public static void main(String[] stringArray) {
        ConsumerPerformance$.MODULE$.main(stringArray);
    }

    public static class ConsumerPerfConfig
    extends PerfConfig {
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over. This option is only used with the old consumer.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> bootstrapServersOpt = this.parser().accepts("broker-list", "A broker list to use for connecting if using the new consumer.").withRequiredArg().describedAs("host").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> groupIdOpt = this.parser().accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo(new StringBuilder().append((Object)"perf-consumer-").append(BoxesRunTime.boxToInteger(new Random().nextInt(100000))).toString(), (String[])((Object[])new String[0])).ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = this.parser().accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x100000), (Integer[])((Object[])new Integer[0]));
        private final OptionSpecBuilder resetBeginningOffsetOpt = this.parser().accepts("from-latest", "If the consumer does not already have an established offset to consume from, start with the latest message present in the log rather than the earliest message.");
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x200000), (Integer[])((Object[])new Integer[0]));
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of processing threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(10), (Integer[])((Object[])new Integer[0]));
        private final ArgumentAcceptingOptionSpec<Integer> numFetchersOpt = this.parser().accepts("num-fetch-threads", "Number of fetcher threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1), (Integer[])((Object[])new Integer[0]));
        private final OptionSpecBuilder useNewConsumerOpt = this.parser().accepts("new-consumer", "Use the new consumer implementation.");
        private final ArgumentAcceptingOptionSpec<String> consumerConfigOpt = this.parser().accepts("consumer.config", "Consumer config properties file.").withRequiredArg().describedAs("config file").ofType(String.class);
        private final OptionSet options;
        private final boolean useNewConsumer;
        private final Properties props;
        private final int numThreads;
        private final String topic;
        private final long numMessages;
        private final int reportingInterval;
        private final boolean showDetailedStats;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> bootstrapServersOpt() {
            return this.bootstrapServersOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> groupIdOpt() {
            return this.groupIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt() {
            return this.fetchSizeOpt;
        }

        public OptionSpecBuilder resetBeginningOffsetOpt() {
            return this.resetBeginningOffsetOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numFetchersOpt() {
            return this.numFetchersOpt;
        }

        public OptionSpecBuilder useNewConsumerOpt() {
            return this.useNewConsumerOpt;
        }

        public ArgumentAcceptingOptionSpec<String> consumerConfigOpt() {
            return this.consumerConfigOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public boolean useNewConsumer() {
            return this.useNewConsumer;
        }

        public Properties props() {
            return this.props;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public String topic() {
            return this.topic;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public boolean showDetailedStats() {
            return this.showDetailedStats;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public ConsumerPerfConfig(String[] args) {
            super(args);
            Object object;
            this.options = this.parser().parse(args);
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicOpt(), this.numMessagesOpt()}));
            this.useNewConsumer = this.options().has(this.useNewConsumerOpt());
            Properties properties = this.props = this.options().has(this.consumerConfigOpt()) ? Utils.loadProps(this.options().valueOf(this.consumerConfigOpt())) : new Properties();
            if (this.useNewConsumer()) {
                this.props().put("bootstrap.servers", this.options().valueOf(this.bootstrapServersOpt()));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("receive.buffer.bytes", this.options().valueOf(this.socketBufferSizeOpt()).toString());
                this.props().put("max.partition.fetch.bytes", this.options().valueOf(this.fetchSizeOpt()).toString());
                this.props().put("auto.offset.reset", this.options().has(this.resetBeginningOffsetOpt()) ? "latest" : "earliest");
                this.props().put("key.deserializer", ByteArrayDeserializer.class);
                this.props().put("value.deserializer", ByteArrayDeserializer.class);
                object = this.props().put("check.crcs", "false");
            } else {
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.zkConnectOpt(), this.numMessagesOpt()}));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("socket.receive.buffer.bytes", this.options().valueOf(this.socketBufferSizeOpt()).toString());
                this.props().put("fetch.message.max.bytes", this.options().valueOf(this.fetchSizeOpt()).toString());
                this.props().put("auto.offset.reset", this.options().has(this.resetBeginningOffsetOpt()) ? "largest" : "smallest");
                this.props().put("zookeeper.connect", this.options().valueOf(this.zkConnectOpt()));
                this.props().put("consumer.timeout.ms", "1000");
                object = this.props().put("num.consumer.fetchers", this.options().valueOf(this.numFetchersOpt()).toString());
            }
            this.numThreads = this.options().valueOf(this.numThreadsOpt());
            this.topic = this.options().valueOf(this.topicOpt());
            this.numMessages = this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = this.options().valueOf(this.reportingIntervalOpt());
            this.showDetailedStats = this.options().has(this.showDetailedStatsOpt());
            this.dateFormat = new SimpleDateFormat(this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has(this.hideHeaderOpt());
        }
    }

    public static class ConsumerPerfThread
    extends Thread {
        private final int threadId;
        private final KafkaStream<byte[], byte[]> stream;
        private final ConsumerPerfConfig config;
        private final AtomicLong totalMessagesRead;
        private final AtomicLong totalBytesRead;
        private final AtomicBoolean consumerTimeout;

        @Override
        public void run() {
            long startMs;
            long bytesRead = 0L;
            long messagesRead = 0L;
            long lastReportTime = startMs = System.currentTimeMillis();
            long lastBytesRead = 0L;
            long lastMessagesRead = 0L;
            try {
                Iterator iter2 = this.stream.iterator();
                while (((IteratorTemplate)iter2).hasNext() && messagesRead < this.config.numMessages()) {
                    Object messageAndMetadata = ((ConsumerIterator)iter2).next();
                    bytesRead += (long)((byte[])((MessageAndMetadata)messageAndMetadata).message()).length;
                    if (++messagesRead % (long)this.config.reportingInterval() != 0L) continue;
                    if (this.config.showDetailedStats()) {
                        ConsumerPerformance$.MODULE$.printProgressMessage(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, lastReportTime, System.currentTimeMillis(), this.config.dateFormat());
                    }
                    lastReportTime = System.currentTimeMillis();
                    lastMessagesRead = messagesRead;
                    lastBytesRead = bytesRead;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            catch (ConsumerTimeoutException consumerTimeoutException) {
                this.consumerTimeout.set(true);
            }
            catch (ClosedByInterruptException closedByInterruptException) {
            }
            catch (InterruptedException interruptedException) {}
            this.totalMessagesRead.addAndGet(messagesRead);
            this.totalBytesRead.addAndGet(bytesRead);
            if (this.config.showDetailedStats()) {
                ConsumerPerformance$.MODULE$.printProgressMessage(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, System.currentTimeMillis(), this.config.dateFormat());
            }
        }

        public ConsumerPerfThread(int threadId, String name, KafkaStream<byte[], byte[]> stream, ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead, AtomicBoolean consumerTimeout) {
            this.threadId = threadId;
            this.stream = stream;
            this.config = config;
            this.totalMessagesRead = totalMessagesRead;
            this.totalBytesRead = totalBytesRead;
            this.consumerTimeout = consumerTimeout;
            super(name);
        }
    }
}

