/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.message;

import java.nio.ByteBuffer;
import org.graylog.shaded.kafka09.message.CompressionCodec;
import org.graylog.shaded.kafka09.message.CompressionCodec$;
import org.graylog.shaded.kafka09.message.InvalidMessageException;
import org.graylog.shaded.kafka09.message.Message$;
import org.graylog.shaded.kafka09.message.NoCompressionCodec$;
import org.graylog.shaded.kafka09.scala.Predef$;
import org.graylog.shaded.kafka09.scala.collection.immutable.StringOps;
import org.graylog.shaded.kafka09.scala.collection.mutable.StringBuilder;
import org.graylog.shaded.kafka09.scala.math.package$;
import org.graylog.shaded.kafka09.scala.reflect.ScalaSignature;
import org.graylog.shaded.kafka09.scala.runtime.BoxedUnit;
import org.graylog.shaded.kafka09.scala.runtime.BoxesRunTime;
import org.graylog.shaded.kafka09.utils.CoreUtils$;
import org.graylog.shaded.org.apache.kafka09.common.utils.Utils;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dv!B\u0001\u0003\u0011\u00039\u0011aB'fgN\fw-\u001a\u0006\u0003\u0007\u0011\tq!\\3tg\u0006<WMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0002-\u0011q!T3tg\u0006<Wm\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\t\u000fYI!\u0019!C\u0001/\u0005I1I]2PM\u001a\u001cX\r^\u000b\u00021A\u0011Q\"G\u0005\u000359\u00111!\u00138u\u0011\u0019a\u0012\u0002)A\u00051\u0005Q1I]2PM\u001a\u001cX\r\u001e\u0011\t\u000fyI!\u0019!C\u0001/\u0005I1I]2MK:<G\u000f\u001b\u0005\u0007A%\u0001\u000b\u0011\u0002\r\u0002\u0015\r\u00138\rT3oORD\u0007\u0005C\u0004#\u0013\t\u0007I\u0011A\f\u0002\u00175\u000bw-[2PM\u001a\u001cX\r\u001e\u0005\u0007I%\u0001\u000b\u0011\u0002\r\u0002\u00195\u000bw-[2PM\u001a\u001cX\r\u001e\u0011\t\u000f\u0019J!\u0019!C\u0001/\u0005YQ*Y4jG2+gn\u001a;i\u0011\u0019A\u0013\u0002)A\u00051\u0005aQ*Y4jG2+gn\u001a;iA!9!&\u0003b\u0001\n\u00039\u0012\u0001E!uiJL'-\u001e;fg>3gm]3u\u0011\u0019a\u0013\u0002)A\u00051\u0005\t\u0012\t\u001e;sS\n,H/Z:PM\u001a\u001cX\r\u001e\u0011\t\u000f9J!\u0019!C\u0001/\u0005\u0001\u0012\t\u001e;sS\n,H/Z:MK:<G\u000f\u001b\u0005\u0007a%\u0001\u000b\u0011\u0002\r\u0002#\u0005#HO]5ckR,7\u000fT3oORD\u0007\u0005C\u00043\u0013\t\u0007I\u0011A\f\u0002\u001b-+\u0017pU5{K>3gm]3u\u0011\u0019!\u0014\u0002)A\u00051\u0005q1*Z=TSj,wJ\u001a4tKR\u0004\u0003b\u0002\u001c\n\u0005\u0004%\taF\u0001\u000e\u0017\u0016L8+\u001b>f\u0019\u0016tw\r\u001e5\t\raJ\u0001\u0015!\u0003\u0019\u00039YU-_*ju\u0016dUM\\4uQ\u0002BqAO\u0005C\u0002\u0013\u0005q#A\u0005LKf|eMZ:fi\"1A(\u0003Q\u0001\na\t!bS3z\u001f\u001a47/\u001a;!\u0011\u001dq\u0014B1A\u0005\u0002]\tqBV1mk\u0016\u001c\u0016N_3MK:<G\u000f\u001b\u0005\u0007\u0001&\u0001\u000b\u0011\u0002\r\u0002!Y\u000bG.^3TSj,G*\u001a8hi\"\u0004\u0003b\u0002\"\n\u0005\u0004%\taF\u0001\u0010\u001b\u0016\u001c8/Y4f\u001fZ,'\u000f[3bI\"1A)\u0003Q\u0001\na\t\u0001#T3tg\u0006<Wm\u0014<fe\",\u0017\r\u001a\u0011\t\u000f\u0019K!\u0019!C\u0001/\u0005iQ*\u001b8IK\u0006$WM]*ju\u0016Da\u0001S\u0005!\u0002\u0013A\u0012AD'j]\"+\u0017\rZ3s'&TX\r\t\u0005\b\u0015&\u0011\r\u0011\"\u0001L\u0003E\u0019UO\u001d:f]Rl\u0015mZ5d-\u0006dW/Z\u000b\u0002\u0019B\u0011Q\"T\u0005\u0003\u001d:\u0011AAQ=uK\"1\u0001+\u0003Q\u0001\n1\u000b!cQ;se\u0016tG/T1hS\u000e4\u0016\r\\;fA!9!+\u0003b\u0001\n\u00039\u0012aE\"p[B\u0014Xm]:j_:\u001cu\u000eZ3NCN\\\u0007B\u0002+\nA\u0003%\u0001$\u0001\u000bD_6\u0004(/Z:tS>t7i\u001c3f\u001b\u0006\u001c8\u000e\t\u0005\b-&\u0011\r\u0011\"\u0001\u0018\u00035qunQ8naJ,7o]5p]\"1\u0001,\u0003Q\u0001\na\taBT8D_6\u0004(/Z:tS>t\u0007E\u0002\u0003\u000b\u0005\u0001Q6CA-\r\u0011!a\u0016L!b\u0001\n\u0003i\u0016A\u00022vM\u001a,'/F\u0001_!\tyF-D\u0001a\u0015\t\t'-A\u0002oS>T\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002fA\nQ!)\u001f;f\u0005V4g-\u001a:\t\u0011\u001dL&\u0011!Q\u0001\ny\u000bqAY;gM\u0016\u0014\b\u0005C\u0003\u00143\u0012\u0005\u0011\u000e\u0006\u0002kWB\u0011\u0001\"\u0017\u0005\u00069\"\u0004\rA\u0018\u0005\u0006'e#\t!\u001c\u000b\u0007U:\u001cXO\u001f?\t\u000b=d\u0007\u0019\u00019\u0002\u000b\tLH/Z:\u0011\u00075\tH*\u0003\u0002s\u001d\t)\u0011I\u001d:bs\")A\u000f\u001ca\u0001a\u0006\u00191.Z=\t\u000bYd\u0007\u0019A<\u0002\u000b\r|G-Z2\u0011\u0005!A\u0018BA=\u0003\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\rC\u0003|Y\u0002\u0007\u0001$A\u0007qCfdw.\u00193PM\u001a\u001cX\r\u001e\u0005\u0006{2\u0004\r\u0001G\u0001\fa\u0006LHn\\1e'&TX\rC\u0003\u00143\u0012\u0005q\u0010F\u0004k\u0003\u0003\t\u0019!!\u0002\t\u000b=t\b\u0019\u00019\t\u000bQt\b\u0019\u00019\t\u000bYt\b\u0019A<\t\rMIF\u0011AA\u0005)\u0015Q\u00171BA\u0007\u0011\u0019y\u0017q\u0001a\u0001a\"1a/a\u0002A\u0002]DaaE-\u0005\u0002\u0005EA#\u00026\u0002\u0014\u0005U\u0001BB8\u0002\u0010\u0001\u0007\u0001\u000f\u0003\u0004u\u0003\u001f\u0001\r\u0001\u001d\u0005\u0007'e#\t!!\u0007\u0015\u0007)\fY\u0002\u0003\u0004p\u0003/\u0001\r\u0001\u001d\u0005\b\u0003?IF\u0011AA\u0011\u0003=\u0019w.\u001c9vi\u0016\u001c\u0005.Z2lgVlGCAA\u0012!\ri\u0011QE\u0005\u0004\u0003Oq!\u0001\u0002'p]\u001eDq!a\u000bZ\t\u0003\ti#\u0001\u0005dQ\u0016\u001c7n];n+\t\t\u0019\u0003C\u0004\u00022e#\t!a\r\u0002\u000f%\u001ch+\u00197jIV\u0011\u0011Q\u0007\t\u0004\u001b\u0005]\u0012bAA\u001d\u001d\t9!i\\8mK\u0006t\u0007bBA\u001f3\u0012\u0005\u0011qH\u0001\fK:\u001cXO]3WC2LG\r\u0006\u0002\u0002BA\u0019Q\"a\u0011\n\u0007\u0005\u0015cB\u0001\u0003V]&$\bBBA%3\u0012\u0005q#\u0001\u0003tSj,\u0007BBA'3\u0012\u0005q#A\u0004lKf\u001c\u0016N_3\t\u000f\u0005E\u0013\f\"\u0001\u00024\u00051\u0001.Y:LKfDa!!\u0016Z\t\u00139\u0012!\u00059bs2|\u0017\rZ*ju\u0016|eMZ:fi\")Q0\u0017C\u0001/!9\u00111L-\u0005\u0002\u0005u\u0013AB5t\u001dVdG\u000e\u0006\u0002\u00026!1\u0011\u0011M-\u0005\u0002-\u000bQ!\\1hS\u000eDa!!\u001aZ\t\u0003Y\u0015AC1uiJL'-\u001e;fg\"9\u0011\u0011N-\u0005\u0002\u0005-\u0014\u0001E2p[B\u0014Xm]:j_:\u001cu\u000eZ3d+\u00059\bBBA83\u0012\u0005Q,A\u0004qCfdw.\u00193\t\u000bQLF\u0011A/\t\u000f\u0005U\u0014\f\"\u0003\u0002x\u0005q1\u000f\\5dK\u0012+G.[7ji\u0016$Gc\u00010\u0002z!9\u00111PA:\u0001\u0004A\u0012!B:uCJ$\bbBA@3\u0012\u0005\u0013\u0011Q\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0011\t\u0005\u0003\u000b\u000bYID\u0002\u000e\u0003\u000fK1!!#\u000f\u0003\u0019\u0001&/\u001a3fM&!\u0011QRAH\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0012\b\t\u000f\u0005M\u0015\f\"\u0011\u0002\u0016\u00061Q-];bYN$B!!\u000e\u0002\u0018\"A\u0011\u0011TAI\u0001\u0004\tY*A\u0002b]f\u00042!DAO\u0013\r\tyJ\u0004\u0002\u0004\u0003:L\bbBAR3\u0012\u0005\u0013QU\u0001\tQ\u0006\u001c\bnQ8eKR\t\u0001\u0004")
public class Message {
    private final ByteBuffer buffer;

    public static int NoCompression() {
        return Message$.MODULE$.NoCompression();
    }

    public static int CompressionCodeMask() {
        return Message$.MODULE$.CompressionCodeMask();
    }

    public static byte CurrentMagicValue() {
        return Message$.MODULE$.CurrentMagicValue();
    }

    public static int MinHeaderSize() {
        return Message$.MODULE$.MinHeaderSize();
    }

    public static int MessageOverhead() {
        return Message$.MODULE$.MessageOverhead();
    }

    public static int ValueSizeLength() {
        return Message$.MODULE$.ValueSizeLength();
    }

    public static int KeyOffset() {
        return Message$.MODULE$.KeyOffset();
    }

    public static int KeySizeLength() {
        return Message$.MODULE$.KeySizeLength();
    }

    public static int KeySizeOffset() {
        return Message$.MODULE$.KeySizeOffset();
    }

    public static int AttributesLength() {
        return Message$.MODULE$.AttributesLength();
    }

    public static int AttributesOffset() {
        return Message$.MODULE$.AttributesOffset();
    }

    public static int MagicLength() {
        return Message$.MODULE$.MagicLength();
    }

    public static int MagicOffset() {
        return Message$.MODULE$.MagicOffset();
    }

    public static int CrcLength() {
        return Message$.MODULE$.CrcLength();
    }

    public static int CrcOffset() {
        return Message$.MODULE$.CrcOffset();
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public long computeChecksum() {
        return CoreUtils$.MODULE$.crc32(this.buffer().array(), this.buffer().arrayOffset() + Message$.MODULE$.MagicOffset(), this.buffer().limit() - Message$.MODULE$.MagicOffset());
    }

    public long checksum() {
        return Utils.readUnsignedInt(this.buffer(), Message$.MODULE$.CrcOffset());
    }

    public boolean isValid() {
        return this.checksum() == this.computeChecksum();
    }

    public void ensureValid() {
        if (this.isValid()) {
            return;
        }
        throw new InvalidMessageException(new StringBuilder().append((Object)"Message is corrupt (stored crc = ").append(BoxesRunTime.boxToLong(this.checksum())).append((Object)", computed crc = ").append(BoxesRunTime.boxToLong(this.computeChecksum())).append((Object)")").toString());
    }

    public int size() {
        return this.buffer().limit();
    }

    public int keySize() {
        return this.buffer().getInt(Message$.MODULE$.KeySizeOffset());
    }

    public boolean hasKey() {
        return this.keySize() >= 0;
    }

    private int payloadSizeOffset() {
        return Message$.MODULE$.KeyOffset() + package$.MODULE$.max(0, this.keySize());
    }

    public int payloadSize() {
        return this.buffer().getInt(this.payloadSizeOffset());
    }

    public boolean isNull() {
        return this.payloadSize() < 0;
    }

    public byte magic() {
        return this.buffer().get(Message$.MODULE$.MagicOffset());
    }

    public byte attributes() {
        return this.buffer().get(Message$.MODULE$.AttributesOffset());
    }

    public CompressionCodec compressionCodec() {
        return CompressionCodec$.MODULE$.getCompressionCodec(this.buffer().get(Message$.MODULE$.AttributesOffset()) & Message$.MODULE$.CompressionCodeMask());
    }

    public ByteBuffer payload() {
        return this.sliceDelimited(this.payloadSizeOffset());
    }

    public ByteBuffer key() {
        return this.sliceDelimited(Message$.MODULE$.KeySizeOffset());
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuffer sliceDelimited(int start) {
        ByteBuffer byteBuffer;
        int size2 = this.buffer().getInt(start);
        if (size2 < 0) {
            byteBuffer = null;
        } else {
            void var3_3;
            ByteBuffer b = this.buffer().duplicate();
            b.position(start + 4);
            b = b.slice();
            b.limit(size2);
            b.rewind();
            byteBuffer = var3_3;
        }
        return byteBuffer;
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("Message(magic = %d, attributes = %d, crc = %d, key = %s, payload = %s)")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToByte(this.magic()), BoxesRunTime.boxToByte(this.attributes()), BoxesRunTime.boxToLong(this.checksum()), this.key(), this.payload()}));
    }

    public boolean equals(Object any) {
        boolean bl;
        Object object = any;
        if (object instanceof Message) {
            Message message = (Message)object;
            bl = this.buffer().equals(message.buffer());
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.buffer().hashCode();
    }

    public Message(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public Message(byte[] bytes, byte[] key, CompressionCodec codec, int payloadOffset, int payloadSize) {
        this(ByteBuffer.allocate(Message$.MODULE$.CrcLength() + Message$.MODULE$.MagicLength() + Message$.MODULE$.AttributesLength() + Message$.MODULE$.KeySizeLength() + (key == null ? 0 : key.length) + Message$.MODULE$.ValueSizeLength() + (bytes == null ? 0 : (payloadSize >= 0 ? payloadSize : bytes.length - payloadOffset))));
        ByteBuffer byteBuffer;
        this.buffer().position(Message$.MODULE$.MagicOffset());
        this.buffer().put(Message$.MODULE$.CurrentMagicValue());
        byte attributes = 0;
        if (codec.codec() > 0) {
            attributes = (byte)(attributes | Message$.MODULE$.CompressionCodeMask() & codec.codec());
        }
        this.buffer().put(attributes);
        if (key == null) {
            byteBuffer = this.buffer().putInt(-1);
        } else {
            this.buffer().putInt(key.length);
            byteBuffer = this.buffer().put(key, 0, key.length);
        }
        int size2 = bytes == null ? -1 : (payloadSize >= 0 ? payloadSize : bytes.length - payloadOffset);
        this.buffer().putInt(size2);
        Object object = bytes != null ? this.buffer().put(bytes, payloadOffset, size2) : BoxedUnit.UNIT;
        this.buffer().rewind();
        Utils.writeUnsignedInt(this.buffer(), Message$.MODULE$.CrcOffset(), this.computeChecksum());
    }

    public Message(byte[] bytes, byte[] key, CompressionCodec codec) {
        this(bytes, key, codec, 0, -1);
    }

    public Message(byte[] bytes, CompressionCodec codec) {
        this(bytes, null, codec);
    }

    public Message(byte[] bytes, byte[] key) {
        this(bytes, key, NoCompressionCodec$.MODULE$);
    }

    public Message(byte[] bytes) {
        this(bytes, null, NoCompressionCodec$.MODULE$);
    }
}

