/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.kafka09.admin;

import java.util.Properties;
import java.util.Random;
import org.apache.log4j.Logger;
import org.graylog.shaded.kafka09.admin.AdminOperationException;
import org.graylog.shaded.kafka09.admin.AdminUtils$;
import org.graylog.shaded.kafka09.api.PartitionMetadata;
import org.graylog.shaded.kafka09.api.TopicMetadata;
import org.graylog.shaded.kafka09.api.TopicMetadata$;
import org.graylog.shaded.kafka09.cluster.Broker;
import org.graylog.shaded.kafka09.cluster.BrokerEndPoint;
import org.graylog.shaded.kafka09.common.ErrorMapping$;
import org.graylog.shaded.kafka09.common.InvalidTopicException;
import org.graylog.shaded.kafka09.common.LeaderNotAvailableException;
import org.graylog.shaded.kafka09.common.ReplicaNotAvailableException;
import org.graylog.shaded.kafka09.common.ReplicaNotAvailableException$;
import org.graylog.shaded.kafka09.common.Topic$;
import org.graylog.shaded.kafka09.common.TopicAlreadyMarkedForDeletionException;
import org.graylog.shaded.kafka09.common.TopicAndPartition;
import org.graylog.shaded.kafka09.common.TopicExistsException;
import org.graylog.shaded.kafka09.log.LogConfig$;
import org.graylog.shaded.kafka09.org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.graylog.shaded.kafka09.scala.Array$;
import org.graylog.shaded.kafka09.scala.Function0;
import org.graylog.shaded.kafka09.scala.Function1;
import org.graylog.shaded.kafka09.scala.Function2;
import org.graylog.shaded.kafka09.scala.MatchError;
import org.graylog.shaded.kafka09.scala.None$;
import org.graylog.shaded.kafka09.scala.Option;
import org.graylog.shaded.kafka09.scala.Predef$;
import org.graylog.shaded.kafka09.scala.Predef$ArrowAssoc$;
import org.graylog.shaded.kafka09.scala.Serializable;
import org.graylog.shaded.kafka09.scala.Some;
import org.graylog.shaded.kafka09.scala.Tuple2;
import org.graylog.shaded.kafka09.scala.collection.GenTraversable;
import org.graylog.shaded.kafka09.scala.collection.Iterable;
import org.graylog.shaded.kafka09.scala.collection.Iterable$;
import org.graylog.shaded.kafka09.scala.collection.JavaConversions$;
import org.graylog.shaded.kafka09.scala.collection.Map;
import org.graylog.shaded.kafka09.scala.collection.Seq;
import org.graylog.shaded.kafka09.scala.collection.Seq$;
import org.graylog.shaded.kafka09.scala.collection.SeqLike;
import org.graylog.shaded.kafka09.scala.collection.Set;
import org.graylog.shaded.kafka09.scala.collection.Set$;
import org.graylog.shaded.kafka09.scala.collection.TraversableLike;
import org.graylog.shaded.kafka09.scala.collection.TraversableOnce;
import org.graylog.shaded.kafka09.scala.collection.immutable.List;
import org.graylog.shaded.kafka09.scala.collection.immutable.List$;
import org.graylog.shaded.kafka09.scala.collection.immutable.Nil$;
import org.graylog.shaded.kafka09.scala.collection.immutable.StringOps;
import org.graylog.shaded.kafka09.scala.collection.mutable.HashMap;
import org.graylog.shaded.kafka09.scala.collection.mutable.ListBuffer;
import org.graylog.shaded.kafka09.scala.collection.mutable.Map$;
import org.graylog.shaded.kafka09.scala.collection.mutable.StringBuilder;
import org.graylog.shaded.kafka09.scala.reflect.ClassTag$;
import org.graylog.shaded.kafka09.scala.runtime.BoxedUnit;
import org.graylog.shaded.kafka09.scala.runtime.BoxesRunTime;
import org.graylog.shaded.kafka09.scala.runtime.IntRef;
import org.graylog.shaded.kafka09.scala.runtime.ObjectRef;
import org.graylog.shaded.kafka09.scala.runtime.RichInt$;
import org.graylog.shaded.kafka09.server.ConfigType$;
import org.graylog.shaded.kafka09.utils.Json$;
import org.graylog.shaded.kafka09.utils.Log4jController$;
import org.graylog.shaded.kafka09.utils.Logging;
import org.graylog.shaded.kafka09.utils.Logging$class;
import org.graylog.shaded.kafka09.utils.ZKGroupDirs;
import org.graylog.shaded.kafka09.utils.ZKGroupTopicDirs;
import org.graylog.shaded.kafka09.utils.ZkUtils;
import org.graylog.shaded.kafka09.utils.ZkUtils$;
import org.graylog.shaded.org.apache.kafka09.common.protocol.SecurityProtocol;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class AdminUtils$
implements Logging {
    public static final AdminUtils$ MODULE$;
    private final Random rand;
    private final String AdminClientId;
    private final String EntityConfigChangeZnodePrefix;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new AdminUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminUtils$ adminUtils$ = this;
        synchronized (adminUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Random rand() {
        return this.rand;
    }

    public String AdminClientId() {
        return this.AdminClientId;
    }

    public String EntityConfigChangeZnodePrefix() {
        return this.EntityConfigChangeZnodePrefix;
    }

    public Map<Object, Seq<Object>> assignReplicasToBrokers(Seq<Object> brokerList, int nPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        if (nPartitions <= 0) {
            throw new AdminOperationException("number of partitions must be larger than 0");
        }
        if (replicationFactor <= 0) {
            throw new AdminOperationException("replication factor must be larger than 0");
        }
        if (replicationFactor > brokerList.size()) {
            throw new AdminOperationException(new StringBuilder().append((Object)"replication factor: ").append(BoxesRunTime.boxToInteger(replicationFactor)).append((Object)" larger than available brokers: ").append(BoxesRunTime.boxToInteger(brokerList.size())).toString());
        }
        HashMap ret = new HashMap();
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerList.size());
        IntRef currentPartitionId = IntRef.create(startPartitionId >= 0 ? startPartitionId : 0);
        IntRef nextReplicaShift = IntRef.create(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerList.size()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(brokerList, replicationFactor, ret, startIndex, currentPartitionId, nextReplicaShift){
            public static final long serialVersionUID = 0L;
            public final Seq brokerList$1;
            private final int replicationFactor$1;
            private final HashMap ret$1;
            private final int startIndex$1;
            private final IntRef currentPartitionId$1;
            public final IntRef nextReplicaShift$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                if (this.currentPartitionId$1.elem > 0 && this.currentPartitionId$1.elem % this.brokerList$1.size() == 0) {
                    ++this.nextReplicaShift$1.elem;
                }
                int firstReplicaIndex = (this.currentPartitionId$1.elem + this.startIndex$1) % this.brokerList$1.size();
                ObjectRef<GenTraversable> replicaList = ObjectRef.create(List$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt(this.brokerList$1.apply(firstReplicaIndex))})));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.replicationFactor$1 - 1).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, firstReplicaIndex, replicaList){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.assignReplicasToBrokers.1 $outer;
                    private final int firstReplicaIndex$1;
                    private final ObjectRef replicaList$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        this.replicaList$1.elem = ((List)this.replicaList$1.elem).$colon$colon(this.$outer.brokerList$1.apply(AdminUtils$.MODULE$.kafka$admin$AdminUtils$$replicaIndex(this.firstReplicaIndex$1, this.$outer.nextReplicaShift$1.elem, j, this.$outer.brokerList$1.size())));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.firstReplicaIndex$1 = firstReplicaIndex$1;
                        this.replicaList$1 = replicaList$1;
                    }
                }));
                this.ret$1.put(BoxesRunTime.boxToInteger(this.currentPartitionId$1.elem), ((List)replicaList.elem).reverse());
                ++this.currentPartitionId$1.elem;
            }
            {
                this.brokerList$1 = brokerList$1;
                this.replicationFactor$1 = replicationFactor$1;
                this.ret$1 = ret$1;
                this.startIndex$1 = startIndex$1;
                this.currentPartitionId$1 = currentPartitionId$1;
                this.nextReplicaShift$1 = nextReplicaShift$1;
            }
        }));
        return ret.toMap(Predef$.MODULE$.$conforms());
    }

    public int assignReplicasToBrokers$default$4() {
        return -1;
    }

    public int assignReplicasToBrokers$default$5() {
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public void addPartitions(ZkUtils zkUtils, String topic, int numPartitions, String replicaAssignmentStr, boolean checkBrokerAvailable) {
        existingPartitionsReplicaList = zkUtils.getReplicaAssignmentForTopics((Seq<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        if (existingPartitionsReplicaList.size() == 0) {
            throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("The topic %s does not exist")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        }
        existingReplicaList = (Seq)((Tuple2)existingPartitionsReplicaList.head())._2();
        partitionsToAdd = numPartitions - existingPartitionsReplicaList.size();
        if (partitionsToAdd <= 0) {
            throw new AdminOperationException("The number of partitions for a topic can only be increased");
        }
        brokerList = zkUtils.getSortedBrokerList();
        if (replicaAssignmentStr == null) ** GOTO lbl-1000
        v0 = replicaAssignmentStr;
        var11_10 = "";
        if (!(v0 != null ? v0.equals(var11_10) == false : var11_10 != null)) lbl-1000:
        // 2 sources

        {
            v1 = this.assignReplicasToBrokers(brokerList, partitionsToAdd, existingReplicaList.size(), BoxesRunTime.unboxToInt(existingReplicaList.head()), existingPartitionsReplicaList.size());
        } else {
            v1 = this.getManualReplicaAssignment(replicaAssignmentStr, brokerList.toSet(), existingPartitionsReplicaList.size(), checkBrokerAvailable);
        }
        newPartitionReplicaList = v1;
        unmatchedRepFactorList = (Iterable)newPartitionReplicaList.values().filter(new Serializable(existingReplicaList){
            public static final long serialVersionUID = 0L;
            private final Seq existingReplicaList$1;

            public final boolean apply(Seq<Object> p) {
                return p.size() != this.existingReplicaList$1.size();
            }
            {
                this.existingReplicaList$1 = existingReplicaList$1;
            }
        });
        if (unmatchedRepFactorList.size() != 0) {
            throw new AdminOperationException(new StringBuilder().append((Object)"The replication factor in manual replication assignment  is not equal to the existing replication factor for the topic ").append(BoxesRunTime.boxToInteger(existingReplicaList.size())).toString());
        }
        this.info((Function0<String>)new Serializable(topic, newPartitionReplicaList){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final Map newPartitionReplicaList$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Add partition list for %s is %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, this.newPartitionReplicaList$1}));
            }
            {
                this.topic$1 = topic$1;
                this.newPartitionReplicaList$1 = newPartitionReplicaList$1;
            }
        });
        partitionReplicaList = existingPartitionsReplicaList.map((Function1<TopicAndPartition, Seq<Object>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(p._1().partition())), p._2());
            }
        }, Map$.MODULE$.canBuildFrom());
        partitionReplicaList.$plus$plus$eq(newPartitionReplicaList);
        x$10 = zkUtils;
        x$11 = topic;
        x$12 = partitionReplicaList;
        x$13 = true;
        x$14 = this.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
        this.createOrUpdateTopicPartitionAssignmentPathInZK(x$10, x$11, x$12, x$14, x$13);
    }

    public int addPartitions$default$3() {
        return 1;
    }

    public String addPartitions$default$4() {
        return "";
    }

    public boolean addPartitions$default$5() {
        return true;
    }

    public Map<Object, List<Object>> getManualReplicaAssignment(String replicaAssignmentList, Set<Object> availableBrokerList, int startPartitionId, boolean checkBrokerAvailable) {
        ObjectRef<String[]> partitionList = ObjectRef.create(replicaAssignmentList.split(","));
        HashMap ret = new HashMap();
        IntRef partitionId = IntRef.create(startPartitionId);
        partitionList.elem = (String[])Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList.elem)).takeRight(Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList.elem)).size() - partitionId.elem);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.refArrayOps((Object[])((String[])partitionList.elem)).size()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(availableBrokerList, startPartitionId, checkBrokerAvailable, partitionList, ret, partitionId){
            public static final long serialVersionUID = 0L;
            private final Set availableBrokerList$1;
            private final int startPartitionId$1;
            private final boolean checkBrokerAvailable$1;
            private final ObjectRef partitionList$1;
            private final HashMap ret$2;
            private final IntRef partitionId$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int[] brokerList = (int[])Predef$.MODULE$.refArrayOps((Object[])((String[])this.partitionList$1.elem)[i].split(":")).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String s2) {
                        return new StringOps(Predef$.MODULE$.augmentString(s2.trim())).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                if (Predef$.MODULE$.intArrayOps(brokerList).size() <= 0) {
                    throw new AdminOperationException("replication factor must be larger than 0");
                }
                if (Predef$.MODULE$.intArrayOps(brokerList).size() != Predef$.MODULE$.intArrayOps(brokerList).toSet().size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"duplicate brokers in replica assignment: ").append(brokerList).toString());
                }
                if (this.checkBrokerAvailable$1 && !Predef$.MODULE$.intArrayOps(brokerList).toSet().subsetOf(this.availableBrokerList$1)) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"some specified brokers not available. specified brokers: ").append((Object)brokerList.toString()).append((Object)"available broker:").append((Object)this.availableBrokerList$1.toString()).toString());
                }
                this.ret$2.put(BoxesRunTime.boxToInteger(this.partitionId$1.elem), Predef$.MODULE$.intArrayOps(brokerList).toList());
                if (((SeqLike)this.ret$2.apply(BoxesRunTime.boxToInteger(this.partitionId$1.elem))).size() != ((SeqLike)this.ret$2.apply(BoxesRunTime.boxToInteger(this.startPartitionId$1))).size()) {
                    throw new AdminOperationException(new StringBuilder().append((Object)"partition ").append(BoxesRunTime.boxToInteger(i)).append((Object)" has different replication factor: ").append(brokerList).toString());
                }
                ++this.partitionId$1.elem;
            }
            {
                this.availableBrokerList$1 = availableBrokerList$1;
                this.startPartitionId$1 = startPartitionId$1;
                this.checkBrokerAvailable$1 = checkBrokerAvailable$1;
                this.partitionList$1 = partitionList$1;
                this.ret$2 = ret$2;
                this.partitionId$1 = partitionId$1;
            }
        }));
        return ret.toMap(Predef$.MODULE$.$conforms());
    }

    public boolean getManualReplicaAssignment$default$4() {
        return true;
    }

    public void deleteTopic(ZkUtils zkUtils, String topic) {
        try {
            zkUtils.createPersistentPath(ZkUtils$.MODULE$.getDeleteTopicPath(topic), zkUtils.createPersistentPath$default$2(), zkUtils.createPersistentPath$default$3());
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        }
    }

    public boolean isConsumerGroupActive(ZkUtils zkUtils, String group) {
        return zkUtils.getConsumersInGroup(group).nonEmpty();
    }

    public boolean deleteConsumerGroupInZK(ZkUtils zkUtils, String group) {
        boolean bl;
        if (this.isConsumerGroupActive(zkUtils, group)) {
            bl = false;
        } else {
            ZKGroupDirs dir = new ZKGroupDirs(group);
            zkUtils.deletePathRecursive(dir.consumerGroupDir());
            bl = true;
        }
        return bl;
    }

    public boolean deleteConsumerGroupInfoForTopicInZK(ZkUtils zkUtils, String group, String topic) {
        boolean bl;
        Seq<String> topics;
        Seq<String> seq = topics = zkUtils.getTopicsByConsumerGroup(group);
        Object CC = Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        if (!(seq != null ? !seq.equals(CC) : CC != null)) {
            bl = this.deleteConsumerGroupInZK(zkUtils, group);
        } else if (this.isConsumerGroupActive(zkUtils, group)) {
            bl = false;
        } else {
            ZKGroupTopicDirs dir = new ZKGroupTopicDirs(group, topic);
            zkUtils.deletePathRecursive(dir.consumerOwnerDir());
            zkUtils.deletePathRecursive(dir.consumerOffsetDir());
            bl = true;
        }
        return bl;
    }

    public void deleteAllConsumerGroupInfoForTopicInZK(ZkUtils zkUtils, String topic) {
        Set<String> groups = zkUtils.getAllConsumerGroupsForTopic(topic);
        groups.foreach(new Serializable(zkUtils, topic){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;
            private final String topic$3;

            public final boolean apply(String group) {
                return AdminUtils$.MODULE$.deleteConsumerGroupInfoForTopicInZK(this.zkUtils$1, group, this.topic$3);
            }
            {
                this.zkUtils$1 = zkUtils$1;
                this.topic$3 = topic$3;
            }
        });
    }

    public boolean topicExists(ZkUtils zkUtils, String topic) {
        return zkUtils.zkClient().exists(ZkUtils$.MODULE$.getTopicPath(topic));
    }

    public void createTopic(ZkUtils zkUtils, String topic, int partitions, int replicationFactor, Properties topicConfig) {
        Seq<Object> brokerList = zkUtils.getSortedBrokerList();
        Map<Object, Seq<Object>> replicaAssignment = this.assignReplicasToBrokers(brokerList, partitions, replicationFactor, this.assignReplicasToBrokers$default$4(), this.assignReplicasToBrokers$default$5());
        this.createOrUpdateTopicPartitionAssignmentPathInZK(zkUtils, topic, replicaAssignment, topicConfig, this.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
    }

    public Properties createTopic$default$5() {
        return new Properties();
    }

    public void createOrUpdateTopicPartitionAssignmentPathInZK(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update2) {
        Topic$.MODULE$.validate(topic);
        Predef$.MODULE$.require(((TraversableOnce)partitionReplicaAssignment.values().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<Object> x$1) {
                return x$1.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet().size() == 1, (Function0<Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "All partitions should have the same number of replicas.";
            }
        }));
        String topicPath = ZkUtils$.MODULE$.getTopicPath(topic);
        if (!update2) {
            Seq<String> allTopics;
            Seq collidingTopics;
            if (zkUtils.zkClient().exists(topicPath)) {
                throw new TopicExistsException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" already exists.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
            }
            if (Topic$.MODULE$.hasCollisionChars(topic) && (collidingTopics = (Seq)(allTopics = zkUtils.getAllTopics()).filter((Function1<String, Object>)((Object)new Serializable(topic){
                public static final long serialVersionUID = 0L;
                private final String topic$2;

                public final boolean apply(String t) {
                    return Topic$.MODULE$.hasCollision(this.topic$2, t);
                }
                {
                    this.topic$2 = topic$2;
                }
            }))).nonEmpty()) {
                throw new InvalidTopicException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" collides with existing topics: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, collidingTopics.mkString(", ")})));
            }
        }
        partitionReplicaAssignment.values().foreach(new Serializable(partitionReplicaAssignment){
            public static final long serialVersionUID = 0L;
            public final Map partitionReplicaAssignment$1;

            public final void apply(Seq<Object> reps) {
                Predef$.MODULE$.require(reps.size() == reps.toSet().size(), (Function0<Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createOrUpdateTopicPartitionAssignmentPathInZK.3 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Duplicate replica assignment found: ").append(this.$outer.partitionReplicaAssignment$1).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.partitionReplicaAssignment$1 = partitionReplicaAssignment$1;
            }
        });
        if (!update2) {
            LogConfig$.MODULE$.validate(config);
            this.writeEntityConfig(zkUtils, ConfigType$.MODULE$.Topic(), topic, config);
        }
        this.writeTopicPartitionAssignment(zkUtils, topic, partitionReplicaAssignment, update2);
    }

    public Properties createOrUpdateTopicPartitionAssignmentPathInZK$default$4() {
        return new Properties();
    }

    public boolean createOrUpdateTopicPartitionAssignmentPathInZK$default$5() {
        return false;
    }

    private void writeTopicPartitionAssignment(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> replicaAssignment, boolean update2) {
        try {
            String zkPath = ZkUtils$.MODULE$.getTopicPath(topic);
            String jsonPartitionData = zkUtils.replicaAssignmentZkData(replicaAssignment.map((Function1<Object, Seq<Object>>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Seq<Object>> apply(Tuple2<Object, Seq<Object>> e) {
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((Object)BoxesRunTime.boxToInteger(e._1$mcI$sp())).toString()), e._2());
                }
            }), org.graylog.shaded.kafka09.scala.collection.Map$.MODULE$.canBuildFrom()));
            if (update2) {
                this.info((Function0<String>)((Object)new Serializable(jsonPartitionData){
                    public static final long serialVersionUID = 0L;
                    private final String jsonPartitionData$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Topic update ").append((Object)this.jsonPartitionData$1.toString()).toString();
                    }
                    {
                        this.jsonPartitionData$1 = jsonPartitionData$1;
                    }
                }));
                zkUtils.updatePersistentPath(zkPath, jsonPartitionData, zkUtils.updatePersistentPath$default$3());
            } else {
                this.info((Function0<String>)((Object)new Serializable(jsonPartitionData){
                    public static final long serialVersionUID = 0L;
                    private final String jsonPartitionData$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Topic creation ").append((Object)this.jsonPartitionData$1.toString()).toString();
                    }
                    {
                        this.jsonPartitionData$1 = jsonPartitionData$1;
                    }
                }));
                zkUtils.createPersistentPath(zkPath, jsonPartitionData, zkUtils.createPersistentPath$default$3());
            }
            this.debug((Function0<String>)((Object)new Serializable(zkPath, jsonPartitionData){
                public static final long serialVersionUID = 0L;
                private final String zkPath$1;
                private final String jsonPartitionData$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.zkPath$1, this.jsonPartitionData$1}));
                }
                {
                    this.zkPath$1 = zkPath$1;
                    this.jsonPartitionData$1 = jsonPartitionData$1;
                }
            }));
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new TopicExistsException(new StringOps(Predef$.MODULE$.augmentString("topic %s already exists")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        }
    }

    public void changeClientIdConfig(ZkUtils zkUtils, String clientId, Properties configs) {
        this.changeEntityConfig(zkUtils, ConfigType$.MODULE$.Client(), clientId, configs);
    }

    public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configs) {
        if (this.topicExists(zkUtils, topic)) {
            LogConfig$.MODULE$.validate(configs);
            this.changeEntityConfig(zkUtils, ConfigType$.MODULE$.Topic(), topic, configs);
            return;
        }
        throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
    }

    private void changeEntityConfig(ZkUtils zkUtils, String entityType, String entityName, Properties configs) {
        this.writeEntityConfig(zkUtils, entityType, entityName, configs);
        String seqNode = new StringBuilder().append((Object)ZkUtils$.MODULE$.EntityConfigChangesPath()).append((Object)"/").append((Object)this.EntityConfigChangeZnodePrefix()).toString();
        String content = Json$.MODULE$.encode(this.getConfigChangeZnodeData(entityType, entityName));
        zkUtils.zkClient().createPersistentSequential(seqNode, content);
    }

    public Map<String, Object> getConfigChangeZnodeData(String entityType, String entityName) {
        return (Map)org.graylog.shaded.kafka09.scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("version"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("entity_type"), entityType), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("entity_name"), entityName)}));
    }

    private void writeEntityConfig(ZkUtils zkUtils, String entityType, String entityName, Properties config) {
        org.graylog.shaded.kafka09.scala.collection.mutable.Map<String, String> configMap = JavaConversions$.MODULE$.propertiesAsScalaMap(config);
        Map map2 = (Map)org.graylog.shaded.kafka09.scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("version"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("config"), configMap)}));
        zkUtils.updatePersistentPath(ZkUtils$.MODULE$.getEntityConfigPath(entityType, entityName), Json$.MODULE$.encode(map2), zkUtils.updatePersistentPath$default$3());
    }

    /*
     * WARNING - void declaration
     */
    public Properties fetchEntityConfig(ZkUtils zkUtils, String entityType, String entity) {
        void var4_4;
        block4: {
            block5: {
                Properties props;
                block2: {
                    Some some;
                    Object config;
                    Some some2;
                    Object mapAnon;
                    Option<Object> option;
                    String str;
                    block3: {
                        str = (String)zkUtils.zkClient().readData(ZkUtils$.MODULE$.getEntityConfigPath(entityType, entity), true);
                        props = new Properties();
                        if (str == null) break block2;
                        option = Json$.MODULE$.parseFull(str);
                        if (!None$.MODULE$.equals(option)) break block3;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block2;
                    }
                    if (!(option instanceof Some) || !((mapAnon = (some2 = (Some)option).x()) instanceof Map)) break block4;
                    Map map2 = (Map)mapAnon;
                    Map map3 = map2.collect(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        /*
                         * WARNING - void declaration
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            void var8_10;
                            A1 A1 = x1;
                            if (A1 != null) {
                                Object k = A1._1();
                                Object v = A1._2();
                                if (k instanceof String) {
                                    String string2 = (String)k;
                                    if (v instanceof Object) {
                                        Object object = v;
                                        Tuple2<String, Object> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(string2), object);
                                        return var8_10;
                                    }
                                }
                            }
                            B1 B1 = function1.apply(x1);
                            return var8_10;
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                            Tuple2<Object, Object> tuple2 = x1;
                            if (tuple2 == null) return false;
                            Object k = tuple2._1();
                            Object v = tuple2._2();
                            if (!(k instanceof String)) return false;
                            if (!(v instanceof Object)) return false;
                            return true;
                        }
                    }, org.graylog.shaded.kafka09.scala.collection.Map$.MODULE$.canBuildFrom());
                    Predef$.MODULE$.require(BoxesRunTime.equals(map3.apply("version"), BoxesRunTime.boxToInteger(1)));
                    Option option2 = map3.get("config");
                    if (!(option2 instanceof Some) || !((config = (some = (Some)option2).x()) instanceof Map)) break block5;
                    Map map4 = (Map)config;
                    map4.foreach(new Serializable(entityType, str, props){
                        public static final long serialVersionUID = 0L;
                        private final String entityType$1;
                        private final String str$1;
                        private final Properties props$1;

                        public final Object apply(Tuple2<Object, Object> configTup) {
                            Tuple2<Object, Object> tuple2 = configTup;
                            if (tuple2 != null) {
                                Object k = tuple2._1();
                                Object v = tuple2._2();
                                if (k instanceof String) {
                                    String string2 = (String)k;
                                    if (v instanceof String) {
                                        String string3 = (String)v;
                                        Object object = this.props$1.setProperty(string2, string3);
                                        return object;
                                    }
                                }
                            }
                            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid ").append((Object)this.entityType$1).append((Object)" config: ").append((Object)this.str$1).toString());
                        }
                        {
                            this.entityType$1 = entityType$1;
                            this.str$1 = str$1;
                            this.props$1 = props$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                }
                return props;
            }
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid ").append((Object)entityType).append((Object)" config: ").append(var4_4).toString());
        }
        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Unexpected value in config:(%s), entity_type: (%s), entity: (%s)")).format(Predef$.MODULE$.genericWrapArray(new Object[]{var4_4, entityType, entity})));
    }

    public Map<String, Properties> fetchAllTopicConfigs(ZkUtils zkUtils) {
        return ((TraversableOnce)zkUtils.getAllTopics().map(new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$2;

            public final Tuple2<String, Properties> apply(String topic) {
                return new Tuple2<String, Properties>(topic, AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$2, ConfigType$.MODULE$.Topic(), topic));
            }
            {
                this.zkUtils$2 = zkUtils$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(ZkUtils zkUtils, String entityType) {
        return ((TraversableOnce)zkUtils.getAllEntitiesWithConfig(entityType).map(new Serializable(zkUtils, entityType){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$3;
            private final String entityType$2;

            public final Tuple2<String, Properties> apply(String entity) {
                return new Tuple2<String, Properties>(entity, AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$3, this.entityType$2, entity));
            }
            {
                this.zkUtils$3 = zkUtils$3;
                this.entityType$2 = entityType$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public TopicMetadata fetchTopicMetadataFromZk(String topic, ZkUtils zkUtils) {
        return this.kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(topic, zkUtils, new HashMap<Object, Broker>(), this.kafka$admin$AdminUtils$$fetchTopicMetadataFromZk$default$4());
    }

    public Set<TopicMetadata> fetchTopicMetadataFromZk(Set<String> topics, ZkUtils zkUtils) {
        HashMap cachedBrokerInfo = new HashMap();
        return topics.map(new Serializable(zkUtils, cachedBrokerInfo){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$5;
            private final HashMap cachedBrokerInfo$2;

            public final TopicMetadata apply(String topic) {
                return AdminUtils$.MODULE$.kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(topic, this.zkUtils$5, this.cachedBrokerInfo$2, AdminUtils$.MODULE$.kafka$admin$AdminUtils$$fetchTopicMetadataFromZk$default$4());
            }
            {
                this.zkUtils$5 = zkUtils$5;
                this.cachedBrokerInfo$2 = cachedBrokerInfo$2;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public TopicMetadata kafka$admin$AdminUtils$$fetchTopicMetadataFromZk(String topic, ZkUtils zkUtils, HashMap<Object, Broker> cachedBrokerInfo, SecurityProtocol protocol) {
        TopicMetadata topicMetadata;
        if (zkUtils.pathExists(ZkUtils$.MODULE$.getTopicPath(topic))) {
            Map topicPartitionAssignment = (Map)zkUtils.getPartitionAssignmentForTopics((Seq<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get(topic).get();
            List sortedPartitions = (List)topicPartitionAssignment.toList().sortWith((Function2)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Seq<Object>> m1, Tuple2<Object, Seq<Object>> m2) {
                    return m1._1$mcI$sp() < m2._1$mcI$sp();
                }
            }));
            List<PartitionMetadata> partitionMetadata = sortedPartitions.map(new Serializable(topic, zkUtils, cachedBrokerInfo, protocol){
                public static final long serialVersionUID = 0L;
                public final String topic$4;
                private final ZkUtils zkUtils$4;
                private final HashMap cachedBrokerInfo$1;
                public final SecurityProtocol protocol$1;

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final PartitionMetadata apply(Tuple2<Object, Seq<Object>> partitionMap) {
                    PartitionMetadata partitionMetadata;
                    int partition2 = partitionMap._1$mcI$sp();
                    Seq<Object> replicas = partitionMap._2();
                    Seq<Object> inSyncReplicas = this.zkUtils$4.getInSyncReplicasForPartition(this.topic$4, partition2);
                    Option<Object> leader = this.zkUtils$4.getLeaderForPartition(this.topic$4, partition2);
                    AdminUtils$.MODULE$.debug((Function0<String>)((Object)new Serializable(this, replicas, inSyncReplicas, leader){
                        public static final long serialVersionUID = 0L;
                        private final Seq replicas$1;
                        private final Seq inSyncReplicas$1;
                        private final Option leader$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"replicas = ").append(this.replicas$1).append((Object)", in sync replicas = ").append(this.inSyncReplicas$1).append((Object)", leader = ").append(this.leader$1).toString();
                        }
                        {
                            this.replicas$1 = replicas$1;
                            this.inSyncReplicas$1 = inSyncReplicas$1;
                            this.leader$1 = leader$1;
                        }
                    }));
                    Option leaderInfo = None$.MODULE$;
                    ObjectRef<Nil$> replicaInfo = ObjectRef.create(Nil$.MODULE$);
                    ObjectRef<Nil$> isrInfo = ObjectRef.create(Nil$.MODULE$);
                    try {
                        Option<Object> option = leader;
                        if (!(option instanceof Some)) {
                            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                            throw new LeaderNotAvailableException(new StringBuilder().append((Object)"No leader exists for partition ").append(BoxesRunTime.boxToInteger(partition2)).toString());
                        }
                        Some some = (Some)option;
                        int l = BoxesRunTime.unboxToInt(some.x());
                        Option option2 = this.liftedTree1$1(partition2, l);
                        leaderInfo = option2;
                        try {
                            replicaInfo.elem = AdminUtils$.MODULE$.kafka$admin$AdminUtils$$getBrokerInfoFromCache(this.zkUtils$4, this.cachedBrokerInfo$1, replicas).map(new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.8 $outer;

                                public final BrokerEndPoint apply(Broker x$2) {
                                    return x$2.getBrokerEndPoint(this.$outer.protocol$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            isrInfo.elem = AdminUtils$.MODULE$.kafka$admin$AdminUtils$$getBrokerInfoFromCache(this.zkUtils$4, this.cachedBrokerInfo$1, inSyncReplicas).map(new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.8 $outer;

                                public final BrokerEndPoint apply(Broker x$3) {
                                    return x$3.getBrokerEndPoint(this.$outer.protocol$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                        }
                        catch (Throwable throwable) {
                            throw new ReplicaNotAvailableException(throwable, ReplicaNotAvailableException$.MODULE$.$lessinit$greater$default$2());
                        }
                        if (((Seq)replicaInfo.elem).size() < replicas.size()) {
                            throw new ReplicaNotAvailableException(new StringBuilder().append((Object)"Replica information not available for following brokers: ").append((Object)((TraversableOnce)replicas.filterNot((Function1<Object, Object>)((Object)new Serializable(this, replicaInfo){
                                public static final long serialVersionUID = 0L;
                                private final ObjectRef replicaInfo$1;

                                public final boolean apply(int x$5) {
                                    return this.apply$mcZI$sp(x$5);
                                }

                                public boolean apply$mcZI$sp(int x$5) {
                                    return ((SeqLike)((Seq)this.replicaInfo$1.elem).map(new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(BrokerEndPoint x$4) {
                                            return x$4.id();
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).contains(BoxesRunTime.boxToInteger(x$5));
                                }
                                {
                                    this.replicaInfo$1 = replicaInfo$1;
                                }
                            }))).mkString(",")).toString());
                        }
                        if (((Seq)isrInfo.elem).size() < inSyncReplicas.size()) {
                            throw new ReplicaNotAvailableException(new StringBuilder().append((Object)"In Sync Replica information not available for following brokers: ").append((Object)((TraversableOnce)inSyncReplicas.filterNot((Function1<Object, Object>)((Object)new Serializable(this, isrInfo){
                                public static final long serialVersionUID = 0L;
                                private final ObjectRef isrInfo$1;

                                public final boolean apply(int x$7) {
                                    return this.apply$mcZI$sp(x$7);
                                }

                                public boolean apply$mcZI$sp(int x$7) {
                                    return ((SeqLike)((Seq)this.isrInfo$1.elem).map(new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(BrokerEndPoint x$6) {
                                            return x$6.id();
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).contains(BoxesRunTime.boxToInteger(x$7));
                                }
                                {
                                    this.isrInfo$1 = isrInfo$1;
                                }
                            }))).mkString(",")).toString());
                        }
                        partitionMetadata = new PartitionMetadata(partition2, leaderInfo, (Seq)replicaInfo.elem, (Seq)isrInfo.elem, ErrorMapping$.MODULE$.NoError());
                        return partitionMetadata;
                    }
                    catch (Throwable throwable) {
                        AdminUtils$.MODULE$.debug((Function0<String>)((Object)new Serializable(this, partition2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.8 $outer;
                            private final int partition$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Error while fetching metadata for partition [%s,%d]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic$4, BoxesRunTime.boxToInteger(this.partition$1)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.partition$1 = partition$1;
                            }
                        }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                            public static final long serialVersionUID = 0L;
                            private final Throwable e$1;

                            public final Throwable apply() {
                                return this.e$1;
                            }
                            {
                                this.e$1 = e$1;
                            }
                        }));
                        partitionMetadata = new PartitionMetadata(partition2, leaderInfo, (Seq)replicaInfo.elem, (Seq)isrInfo.elem, ErrorMapping$.MODULE$.codeFor(throwable.getClass()));
                    }
                    return partitionMetadata;
                }

                private final Option liftedTree1$1(int partition$1, int l$1) {
                    try {
                        return new Some<BrokerEndPoint>(((Broker)AdminUtils$.MODULE$.kafka$admin$AdminUtils$$getBrokerInfoFromCache(this.zkUtils$4, this.cachedBrokerInfo$1, (Seq<Object>)List$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{l$1}))).head()).getBrokerEndPoint(this.protocol$1));
                    }
                    catch (Throwable throwable) {
                        throw new LeaderNotAvailableException(new StringOps(Predef$.MODULE$.augmentString("Leader not available for partition [%s,%d]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$4, BoxesRunTime.boxToInteger(partition$1)})), throwable);
                    }
                }
                {
                    this.topic$4 = topic$4;
                    this.zkUtils$4 = zkUtils$4;
                    this.cachedBrokerInfo$1 = cachedBrokerInfo$1;
                    this.protocol$1 = protocol$1;
                }
            }, List$.MODULE$.canBuildFrom());
            topicMetadata = new TopicMetadata(topic, partitionMetadata, TopicMetadata$.MODULE$.$lessinit$greater$default$3());
        } else {
            topicMetadata = new TopicMetadata(topic, (Seq)Seq$.MODULE$.empty(), ErrorMapping$.MODULE$.UnknownTopicOrPartitionCode());
        }
        return topicMetadata;
    }

    public SecurityProtocol kafka$admin$AdminUtils$$fetchTopicMetadataFromZk$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Seq<Broker> kafka$admin$AdminUtils$$getBrokerInfoFromCache(ZkUtils zkUtils, org.graylog.shaded.kafka09.scala.collection.mutable.Map<Object, Broker> cachedBrokerInfo, Seq<Object> brokerIds) {
        ObjectRef failedBrokerIds = ObjectRef.create(new ListBuffer());
        Seq<Option<Broker>> brokerMetadata = brokerIds.map(new Serializable(zkUtils, cachedBrokerInfo, failedBrokerIds){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$6;
            private final org.graylog.shaded.kafka09.scala.collection.mutable.Map cachedBrokerInfo$3;
            private final ObjectRef failedBrokerIds$1;

            public final Option<Broker> apply(int id) {
                Option<B> option;
                block4: {
                    Option<Broker> option2;
                    block7: {
                        Option option3;
                        block3: {
                            Option option4;
                            block6: {
                                block5: {
                                    block2: {
                                        Option<B> optionalBrokerInfo = this.cachedBrokerInfo$3.get(BoxesRunTime.boxToInteger(id));
                                        option = optionalBrokerInfo;
                                        if (!(option instanceof Some)) break block2;
                                        Some some = (Some)option;
                                        Broker brokerInfo = (Broker)some.x();
                                        option3 = new Some<Broker>(brokerInfo);
                                        break block3;
                                    }
                                    if (!None$.MODULE$.equals(option)) break block4;
                                    option2 = this.zkUtils$6.getBrokerInfo(id);
                                    if (!(option2 instanceof Some)) break block5;
                                    Some some = (Some)option2;
                                    Broker brokerInfo = (Broker)some.x();
                                    this.cachedBrokerInfo$3.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(id)), brokerInfo));
                                    option4 = new Some<Broker>(brokerInfo);
                                    break block6;
                                }
                                if (!None$.MODULE$.equals(option2)) break block7;
                                ((ListBuffer)this.failedBrokerIds$1.elem).$plus$eq(BoxesRunTime.boxToInteger(id));
                                option4 = None$.MODULE$;
                            }
                            option3 = option4;
                        }
                        return option3;
                    }
                    throw new MatchError(option2);
                }
                throw new MatchError(option);
            }
            {
                this.zkUtils$6 = zkUtils$6;
                this.cachedBrokerInfo$3 = cachedBrokerInfo$3;
                this.failedBrokerIds$1 = failedBrokerIds$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return ((TraversableLike)brokerMetadata.filter((Function1<Option<Broker>, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Broker> x$8) {
                return x$8.isDefined();
            }
        }))).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(Option<Broker> x$9) {
                return x$9.get();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public int kafka$admin$AdminUtils$$replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        int shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (firstReplicaIndex + shift) % nBrokers;
    }

    private AdminUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.rand = new Random();
        this.AdminClientId = "__admin_client";
        this.EntityConfigChangeZnodePrefix = "config_change_";
    }
}

