/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.io.factory.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Model;
import org.graphwalker.core.model.Requirement;
import org.graphwalker.core.model.RuntimeBase;
import org.graphwalker.core.model.Vertex;
import org.graphwalker.io.factory.ContextFactoryException;
import org.graphwalker.io.factory.json.JsonEdge;
import org.graphwalker.io.factory.json.JsonVertex;

public class JsonModel {
    private String name;
    private String id;
    private String generator;
    private String startElementId;
    private List<String> actions;
    private List<String> requirements;
    private Map<String, Object> properties;
    private List<JsonVertex> vertices;
    private List<JsonEdge> edges;
    private List<String> predefinedPathEdgeIds;

    public String getId() {
        return this.id;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public List<String> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(List<String> requirements) {
        this.requirements = requirements;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStartElementId() {
        return this.startElementId;
    }

    public void setStartElementId(String startElementId) {
        this.startElementId = startElementId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public List<JsonVertex> getVertices() {
        return this.vertices;
    }

    public void setVertices(List<JsonVertex> vertices) {
        this.vertices = vertices;
    }

    public List<JsonEdge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<JsonEdge> edges) {
        this.edges = edges;
    }

    public List<String> getPredefinedPathEdgeIds() {
        return this.predefinedPathEdgeIds;
    }

    public void setPredefinedPathEdgeIds(List<String> predefinedPathEdgeIds) {
        this.predefinedPathEdgeIds = predefinedPathEdgeIds;
    }

    public boolean isModel() {
        return null != this.name && null != this.generator && null != this.edges && null != this.vertices;
    }

    public Model getModel() {
        Model model = new Model();
        model.setName(this.name);
        model.setId(this.id);
        if (this.properties != null) {
            model.setProperties(this.properties);
        }
        if (this.actions != null) {
            for (String action : this.actions) {
                model.addAction(new Action(action));
            }
        }
        if (this.vertices != null) {
            for (JsonVertex jsonVertex : this.getVertices()) {
                model.addVertex(jsonVertex.getVertex());
            }
        }
        if (this.edges != null) {
            for (JsonEdge jsonEdge : this.getEdges()) {
                Edge edge = jsonEdge.getEdge();
                for (Vertex vertex : model.getVertices()) {
                    if (vertex.getId().equals(jsonEdge.getSourceVertexId())) {
                        edge.setSourceVertex(vertex);
                    }
                    if (!vertex.getId().equals(jsonEdge.getTargetVertexId())) continue;
                    edge.setTargetVertex(vertex);
                }
                model.addEdge(edge);
            }
        }
        if (this.predefinedPathEdgeIds != null) {
            List predefinedPath = this.getPredefinedPathEdgeIds().stream().map(this::findEdgeById).collect(Collectors.toList());
            model.setPredefinedPath(predefinedPath);
        }
        return model;
    }

    public void setModel(Model.RuntimeModel model) {
        this.name = model.getName();
        this.id = model.getId();
        if (model.hasActions()) {
            this.actions = new ArrayList<String>();
            for (Action action : model.getActions()) {
                this.actions.add(action.getScript());
            }
        }
        if (model.hasRequirements()) {
            this.requirements = new ArrayList<String>();
            for (Requirement requirement : model.getRequirements()) {
                this.requirements.add(requirement.getKey());
            }
        }
        if (model.hasProperties()) {
            this.properties = new HashMap<String, Object>();
            this.properties.putAll(model.getProperties());
        }
        this.vertices = new ArrayList<JsonVertex>();
        for (Vertex.RuntimeVertex vertex : model.getVertices()) {
            JsonVertex jsonVertex = new JsonVertex();
            jsonVertex.setVertex(vertex);
            this.vertices.add(jsonVertex);
        }
        this.edges = new ArrayList<JsonEdge>();
        for (Edge.RuntimeEdge edge : model.getEdges()) {
            JsonEdge jsonEdge = new JsonEdge();
            jsonEdge.setEdge(edge);
            this.edges.add(jsonEdge);
        }
        if (model.hasPredefinedPath()) {
            this.predefinedPathEdgeIds = model.getPredefinedPath().stream().map(RuntimeBase::getId).collect(Collectors.toList());
        }
    }

    public void setModel(Model model) {
        this.setModel(model.build());
    }

    public void copyValuesTo(Model model) {
        if (this.name != null) {
            model.setName(this.name);
        }
        if (this.id != null) {
            model.setId(this.id);
        }
        if (this.actions != null && !this.actions.isEmpty()) {
            this.actions = new ArrayList<String>();
            for (String action : this.actions) {
                model.addAction(new Action(action));
            }
        }
        if (this.requirements != null && !this.requirements.isEmpty()) {
            this.requirements = new ArrayList<String>();
            for (String requirement : this.requirements) {
                model.addRequirement(new Requirement(requirement));
            }
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            model.getProperties().putAll(this.properties);
        }
    }

    private Edge findEdgeById(String edgeId) {
        return this.getEdges().stream().filter(edge -> edgeId.equals(edge.getEdge().getId())).findFirst().orElseThrow(() -> new ContextFactoryException("Edge with id \"" + edgeId + "\" could not be found in JsonModel")).getEdge();
    }
}

