/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.io.factory.java;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Vertex;
import org.graphwalker.io.factory.ContextFactory;
import org.graphwalker.io.factory.ContextFactoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaContextFactory
implements ContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(JavaContextFactory.class);
    private static final String FILE_TYPE = "java";
    private static final Set<String> SUPPORTED_TYPE = new HashSet<String>(Arrays.asList("**/*.java"));
    public static final List<String> javaCodeTemplate = ImmutableList.of((Object)"import org.graphwalker.core.condition.*;", (Object)"import org.graphwalker.core.generator.*;", (Object)"import org.graphwalker.core.machine.*;", (Object)"import org.graphwalker.core.model.*;", (Object)"", (Object)"public class {CLASS_NAME} {", (Object)"", (Object)"  public final class ModelTestContext extends ExecutionContext {", (Object)"  }", (Object)"", (Object)"  public static void main(String... aArgs) {", (Object)"    {CLASS_NAME} modeltest = new {CLASS_NAME}();", (Object[])new String[]{"    modeltest.run();", "  }", "", "  private void run() {", "    {ADD_VERTICES}", "", "    Model model = new Model();", "    {ADD_EDGES}", "", "    Context context = new ModelTestContext();", "    context.setModel(model.build()).setPathGenerator(new RandomPath(new EdgeCoverage(100)));", "    context.setNextElement(context.getModel().findElements(\"{START_ELEMENT_NAME}\").get(0));", "", "    Machine machine = new SimpleMachine(context);", "    while (machine.hasNextStep()) {", "      machine.getNextStep();", "      System.out.println(context.getCurrentElement().getName());", "    }", "  }", "}"});

    @Override
    public Set<String> getSupportedFileTypes() {
        return SUPPORTED_TYPE;
    }

    @Override
    public boolean accept(Path path) {
        return FilenameUtils.getExtension((String)path.toString()).equalsIgnoreCase(FILE_TYPE);
    }

    @Override
    public List<Context> create(Path path) {
        throw new ContextFactoryException("Creating a context from a java file is not supported.");
    }

    @Override
    public String getAsString(List<Context> contexts) {
        String javaStr = "";
        for (Context context : contexts) {
            String template = StringUtils.join((Object[])javaCodeTemplate.toArray(), (String)"\n");
            template = template.replaceAll("\\{CLASS_NAME\\}", context.getModel().getName());
            int index = 0;
            String add_vertices = "";
            for (Vertex.RuntimeVertex vertex : context.getModel().getVertices()) {
                String id = vertex.getId() != null && !vertex.getId().equals("") ? vertex.getId() : "n" + index++;
                add_vertices = add_vertices + "Vertex " + vertex.getName() + " = new Vertex().setName(\"" + vertex.getName() + "\").setId(\"" + id + "\");";
                add_vertices = add_vertices + "\n";
            }
            template = template.replace("{ADD_VERTICES}", add_vertices);
            index = 0;
            String add_edges = "";
            for (Edge.RuntimeEdge edge : context.getModel().getEdges()) {
                String id = edge.getId() != null && !edge.getId().equals("") ? edge.getId() : "n" + index++;
                add_edges = add_edges + "model.addEdge( new Edge()";
                if (edge.getSourceVertex() != null) {
                    add_edges = add_edges + ".setSourceVertex(" + edge.getSourceVertex().getName() + ")";
                }
                add_edges = add_edges + ".setTargetVertex(" + edge.getTargetVertex().getName() + ")";
                add_edges = add_edges + ".setName(\"" + edge.getName() + "\").setId(\"" + id + "\")";
                if (edge.hasGuard()) {
                    add_edges = add_edges + ".setGuard(new Guard(\"" + edge.getGuard().getScript() + "\"))";
                }
                if (edge.hasActions()) {
                    for (Action action : edge.getActions()) {
                        add_edges = add_edges + ".addAction(new Action(\"" + action.getScript() + "\"))";
                    }
                }
                add_edges = add_edges + ");\n";
            }
            template = template.replace("{ADD_EDGES}", add_edges);
            template = template.replace("{START_ELEMENT_NAME}", context.getNextElement().getName());
            javaStr = javaStr + template;
        }
        return javaStr;
    }

    @Override
    public void write(List<Context> contexts, Path path) throws IOException {
        Path javaFile = Paths.get(path.toString(), contexts.get(0).getModel().getName() + ".java");
        try (OutputStream outputStream = Files.newOutputStream(javaFile, new OpenOption[0]);){
            outputStream.write(this.getAsString(contexts).getBytes());
        }
    }
}

