/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.util.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;

public final class ImageCache$ {
    public static final ImageCache$ MODULE$;
    private final HashMap<String, BufferedImage> imageCache;
    private BufferedImage dummy;

    static {
        new ImageCache$();
    }

    public HashMap<String, BufferedImage> imageCache() {
        return this.imageCache;
    }

    public BufferedImage dummy() {
        return this.dummy;
    }

    public void dummy_$eq(BufferedImage x$1) {
        this.dummy = x$1;
    }

    public void init() {
        BufferedImage img = new BufferedImage(16, 16, 1);
        Graphics2D g2 = img.createGraphics();
        g2.setColor(Color.RED);
        g2.drawRect(0, 0, img.getWidth() - 1, img.getHeight() - 1);
        g2.drawLine(0, 0, img.getWidth() - 1, img.getHeight() - 1);
        g2.drawLine(0, img.getHeight() - 1, img.getWidth() - 1, 0);
        this.dummy_$eq(img);
    }

    public Option<BufferedImage> loadImage(String fileNameOrUrl) {
        return this.loadImage(fileNameOrUrl, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<BufferedImage> loadImage(String fileNameOrUrl, boolean forceTryReload) {
        Some some;
        Option option = this.imageCache().get((Object)fileNameOrUrl);
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            BoxedUnit boxedUnit;
            URL url = this.getClass().getClassLoader().getResource(fileNameOrUrl);
            BufferedImage image = null;
            if (url == null) {
                try {
                    URL url2 = new URL(fileNameOrUrl);
                    image = ImageIO.read(url2);
                    boxedUnit = this.imageCache().put((Object)fileNameOrUrl, (Object)image);
                    return new Some((Object)image);
                }
                catch (Throwable throwable) {
                    try {
                        image = ImageIO.read(new File(fileNameOrUrl));
                        boxedUnit = this.imageCache().put((Object)fileNameOrUrl, (Object)image);
                        return new Some((Object)image);
                    }
                    catch (Throwable throwable2) {
                        image = this.dummy();
                        this.imageCache().put((Object)fileNameOrUrl, (Object)image);
                        Logger.getLogger(this.getClass().getSimpleName()).log(Level.WARNING, new StringOps(Predef$.MODULE$.augmentString("Cannot read image '%s'.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileNameOrUrl})), throwable2);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                return new Some((Object)image);
            }
            Object i = null;
            try {
                image = ImageIO.read(url);
                boxedUnit = this.imageCache().put((Object)fileNameOrUrl, (Object)image);
                return new Some((Object)image);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                boxedUnit = BoxedUnit.UNIT;
            }
            return new Some((Object)image);
        }
        if (!(option instanceof Some)) throw new MatchError((Object)option);
        Some some3 = (Some)option;
        Object object = some3.get();
        BufferedImage bufferedImage = this.dummy();
        if (!(object != null ? !object.equals(bufferedImage) : bufferedImage != null) && forceTryReload) {
            this.imageCache().$minus$eq((Object)fileNameOrUrl);
            some = this.loadImage(fileNameOrUrl);
            return some;
        } else {
            some = some3;
        }
        return some;
    }

    public BufferedImage dummyImage() {
        return this.dummy();
    }

    private ImageCache$() {
        MODULE$ = this;
        this.imageCache = new HashMap();
        this.dummy = null;
        this.init();
    }
}

