/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer.shape.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Path2D;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.renderer.ConnectorSkeleton;
import org.graphstream.ui.j2dviewer.renderer.Skeleton;
import org.graphstream.ui.j2dviewer.renderer.shape.Connector$class;
import org.graphstream.ui.j2dviewer.renderer.shape.Decorable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.HasSkel$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.AreaConnectorShape;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.AreaConnectorShape$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ConnectorShape$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Fillable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.IconAndText;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Shadowable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeDecor;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapePaint;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeStroke;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Strokable$class;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001E\u0011!\"\u00118hY\u0016\u001c\u0006.\u00199f\u0015\t\u0019A!A\u0003to&twM\u0003\u0002\u0006\r\u0005)1\u000f[1qK*\u0011q\u0001C\u0001\te\u0016tG-\u001a:fe*\u0011\u0011BC\u0001\nUJ\"g/[3xKJT!a\u0003\u0007\u0002\u0005UL'BA\u0007\u000f\u0003-9'/\u00199igR\u0014X-Y7\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0011\u0011DG\u0007\u0002\u0005%\u00111D\u0001\u0002\u0013\u0003J,\u0017mQ8o]\u0016\u001cGo\u001c:TQ\u0006\u0004X\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0011\u0004\u0001\u0005\bC\u0001\u0001\r\u0011\"\u0005#\u0003!!\b.Z*iCB,W#A\u0012\u0011\u0005\u0011rcBA\u0013-\u001b\u00051#BA\u0014)\u0003\u00119Wm\\7\u000b\u0005%R\u0013aA1xi*\t1&\u0001\u0003kCZ\f\u0017BA\u0017'\u0003\u0019\u0001\u0016\r\u001e53\t&\u0011q\u0006\r\u0002\u0007\t>,(\r\\3\u000b\u000552\u0003b\u0002\u001a\u0001\u0001\u0004%\tbM\u0001\ri\",7\u000b[1qK~#S-\u001d\u000b\u0003i]\u0002\"aE\u001b\n\u0005Y\"\"\u0001B+oSRDq\u0001O\u0019\u0002\u0002\u0003\u00071%A\u0002yIEBaA\u000f\u0001!B\u0013\u0019\u0013!\u0003;iKNC\u0017\r]3!\u0011\u0015a\u0004\u0001\"\u0005>\u0003\u0011i\u0017m[3\u0015\u0007QrD\tC\u0003@w\u0001\u0007\u0001)A\u0002cG.\u0004\"!\u0011\"\u000e\u0003!I!a\u0011\u0005\u0003\u000f\t\u000b7m[3oI\")Qi\u000fa\u0001\r\u000611-Y7fe\u0006\u0004\"!Q$\n\u0005!C!AB\"b[\u0016\u0014\u0018\rC\u0003=\u0001\u0011E!\n\u0006\u00045\u00172\u0003&\u000b\u0016\u0005\u0006\u000b&\u0003\rA\u0012\u0005\u0006\u001b&\u0003\rAT\u0001\u0004g>D\bCA\nP\u0013\tyC\u0003C\u0003R\u0013\u0002\u0007a*A\u0002t_fDQaU%A\u00029\u000b1a]<y\u0011\u0015)\u0016\n1\u0001O\u0003\r\u0019x/\u001f\u0005\u0006/\u0002!\t\u0002W\u0001\u000b[\u0006\\Wm\u00148MS:,GC\u0002\u001bZ5ncV\fC\u0003F-\u0002\u0007a\tC\u0003N-\u0002\u0007a\nC\u0003R-\u0002\u0007a\nC\u0003T-\u0002\u0007a\nC\u0003V-\u0002\u0007a\nC\u0003`\u0001\u0011E\u0001-\u0001\bnC.,wJ\u001c)pYfd\u0017N\\3\u0015\rQ\n'm\u00193f\u0011\u0015)e\f1\u0001G\u0011\u0015ie\f1\u0001O\u0011\u0015\tf\f1\u0001O\u0011\u0015\u0019f\f1\u0001O\u0011\u0015)f\f1\u0001O\u0011\u00159\u0007\u0001\"\u0005i\u0003-i\u0017m[3P]\u000e+(O^3\u0015\rQJ'n\u001b7n\u0011\u0015)e\r1\u0001G\u0011\u0015ie\r1\u0001O\u0011\u0015\tf\r1\u0001O\u0011\u0015\u0019f\r1\u0001O\u0011\u0015)f\r1\u0001O\u0011\u0015y\u0007\u0001\"\u0005q\u0003%i\u0017m[3Nk2$\u0018\u000e\u0006\u00045cJ\u001cH/\u001e\u0005\u0006\u000b:\u0004\rA\u0012\u0005\u0006\u001b:\u0004\rA\u0014\u0005\u0006#:\u0004\rA\u0014\u0005\u0006':\u0004\rA\u0014\u0005\u0006+:\u0004\rA\u0014\u0005\u0006o\u0002!\t\u0002_\u0001\t[\u0006\\W\rT8paR1A'\u001f>|yvDQ!\u0012<A\u0002\u0019CQ!\u0014<A\u00029CQ!\u0015<A\u00029CQa\u0015<A\u00029CQ!\u0016<A\u00029Caa \u0001\u0005\u0012\u0005\u0005\u0011AC7bW\u0016\u001c\u0006.\u00193poR)A'a\u0001\u0002\u0006!)qH a\u0001\u0001\")QI a\u0001\r\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0011\u0001\u0004:f]\u0012,'o\u00155bI><H#\u0003\u001b\u0002\u000e\u0005=\u0011\u0011CA\u0011\u0011\u0019y\u0014q\u0001a\u0001\u0001\"1Q)a\u0002A\u0002\u0019C\u0001\"a\u0005\u0002\b\u0001\u0007\u0011QC\u0001\bK2,W.\u001a8u!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000e\u0015\u0005aqM]1qQ&\u001cwI]1qQ&!\u0011qDA\r\u000599%/\u00199iS\u000e,E.Z7f]RD\u0001\"a\t\u0002\b\u0001\u0007\u0011QE\u0001\u0005g.,G\u000e\u0005\u0003\u0002(\u0005%R\"\u0001\u0004\n\u0007\u0005-bA\u0001\u0005TW\u0016dW\r^8o\u0011\u001d\ty\u0003\u0001C\u0001\u0003c\taA]3oI\u0016\u0014H#\u0003\u001b\u00024\u0005U\u0012qGA\u001d\u0011\u0019y\u0014Q\u0006a\u0001\u0001\"1Q)!\fA\u0002\u0019C\u0001\"a\u0005\u0002.\u0001\u0007\u0011Q\u0003\u0005\t\u0003G\ti\u00031\u0001\u0002&\u0001")
public class AngleShape
implements AreaConnectorShape {
    private Path2D.Double theShape;
    private ShapePaint shadowPaint;
    private final Point2 theShadowWidth;
    private final Point2 theShadowOff;
    private Color strokeColor;
    private ShapeStroke theStroke;
    private double theStrokeWidth;
    private ShapePaint fillPaint;
    private double theFillPercent;
    private Color theFillColor;
    private boolean plainFast;
    private String text;
    private ShapeDecor theDecor;
    private GraphicEdge theEdge;
    private double theSize;
    private Point2 theTargetSize;
    private Point2 theSourceSize;
    private boolean isDirected;
    private ConnectorSkeleton skel;

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$AreaConnectorShape$$super$configureForGroup(Backend bck, Style style, Camera camera) {
        ConnectorShape$class.configureForGroup(this, bck, style, camera);
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$AreaConnectorShape$$super$configureForElement(Backend bck, GraphicElement element, Skeleton skel, Camera camera) {
        ConnectorShape$class.configureForElement(this, bck, element, skel, camera);
    }

    @Override
    public void configureForGroup(Backend bck, Style style, Camera camera) {
        AreaConnectorShape$class.configureForGroup(this, bck, style, camera);
    }

    @Override
    public void configureForElement(Backend bck, GraphicElement element, Skeleton skel, Camera camera) {
        AreaConnectorShape$class.configureForElement(this, bck, element, skel, camera);
    }

    @Override
    public ShapePaint shadowPaint() {
        return this.shadowPaint;
    }

    @Override
    public void shadowPaint_$eq(ShapePaint x$1) {
        this.shadowPaint = x$1;
    }

    @Override
    public Point2 theShadowWidth() {
        return this.theShadowWidth;
    }

    @Override
    public Point2 theShadowOff() {
        return this.theShadowOff;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowWidth_$eq(Point2 x$1) {
        this.theShadowWidth = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowOff_$eq(Point2 x$1) {
        this.theShadowOff = x$1;
    }

    @Override
    public void shadowWidth(double width, double height) {
        Shadowable$class.shadowWidth(this, width, height);
    }

    @Override
    public void shadowOffset(double xoff, double yoff) {
        Shadowable$class.shadowOffset(this, xoff, yoff);
    }

    @Override
    public void cast(Graphics2D g, Shape shape) {
        Shadowable$class.cast(this, g, shape);
    }

    @Override
    public void configureShadowableForGroup(Style style, Camera camera) {
        Shadowable$class.configureShadowableForGroup(this, style, camera);
    }

    @Override
    public Color strokeColor() {
        return this.strokeColor;
    }

    @Override
    public void strokeColor_$eq(Color x$1) {
        this.strokeColor = x$1;
    }

    @Override
    public ShapeStroke theStroke() {
        return this.theStroke;
    }

    @Override
    public void theStroke_$eq(ShapeStroke x$1) {
        this.theStroke = x$1;
    }

    @Override
    public double theStrokeWidth() {
        return this.theStrokeWidth;
    }

    @Override
    public void theStrokeWidth_$eq(double x$1) {
        this.theStrokeWidth = x$1;
    }

    @Override
    public void stroke(Graphics2D g, Shape shape) {
        Strokable$class.stroke(this, g, shape);
    }

    @Override
    public void configureStrokableForGroup(Style style, Camera camera) {
        Strokable$class.configureStrokableForGroup(this, style, camera);
    }

    @Override
    public ShapePaint fillPaint() {
        return this.fillPaint;
    }

    @Override
    public void fillPaint_$eq(ShapePaint x$1) {
        this.fillPaint = x$1;
    }

    @Override
    public double theFillPercent() {
        return this.theFillPercent;
    }

    @Override
    public void theFillPercent_$eq(double x$1) {
        this.theFillPercent = x$1;
    }

    @Override
    public Color theFillColor() {
        return this.theFillColor;
    }

    @Override
    public void theFillColor_$eq(Color x$1) {
        this.theFillColor = x$1;
    }

    @Override
    public boolean plainFast() {
        return this.plainFast;
    }

    @Override
    public void plainFast_$eq(boolean x$1) {
        this.plainFast = x$1;
    }

    @Override
    public void fill(Graphics2D g, double dynColor, Color optColor, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, dynColor, optColor, shape, camera);
    }

    @Override
    public void fill(Graphics2D g, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, shape, camera);
    }

    @Override
    public void configureFillableForGroup(Backend bck, Style style, Camera camera) {
        Fillable$class.configureFillableForGroup(this, bck, style, camera);
    }

    @Override
    public void configureFillableForElement(Style style, Camera camera, GraphicElement element) {
        Fillable$class.configureFillableForElement(this, style, camera, element);
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    @TraitSetter
    public void text_$eq(String x$1) {
        this.text = x$1;
    }

    @Override
    public ShapeDecor theDecor() {
        return this.theDecor;
    }

    @Override
    @TraitSetter
    public void theDecor_$eq(ShapeDecor x$1) {
        this.theDecor = x$1;
    }

    @Override
    public void decorArea(Backend backend, Camera camera, IconAndText iconAndText, GraphicElement element, Shape shape) {
        Decorable$class.decorArea(this, backend, camera, iconAndText, element, shape);
    }

    @Override
    public void decorConnector(Backend backend, Camera camera, IconAndText iconAndText, GraphicElement element, Shape shape) {
        Decorable$class.decorConnector(this, backend, camera, iconAndText, element, shape);
    }

    @Override
    public void configureDecorableForGroup(Style style, Camera camera) {
        Decorable$class.configureDecorableForGroup(this, style, camera);
    }

    @Override
    public void configureDecorableForElement(Backend backend, Camera camera, GraphicElement element, Skeleton skel) {
        Decorable$class.configureDecorableForElement(this, backend, camera, element, skel);
    }

    @Override
    public GraphicEdge theEdge() {
        return this.theEdge;
    }

    @Override
    @TraitSetter
    public void theEdge_$eq(GraphicEdge x$1) {
        this.theEdge = x$1;
    }

    @Override
    public double theSize() {
        return this.theSize;
    }

    @Override
    @TraitSetter
    public void theSize_$eq(double x$1) {
        this.theSize = x$1;
    }

    @Override
    public Point2 theTargetSize() {
        return this.theTargetSize;
    }

    @Override
    @TraitSetter
    public void theTargetSize_$eq(Point2 x$1) {
        this.theTargetSize = x$1;
    }

    @Override
    public Point2 theSourceSize() {
        return this.theSourceSize;
    }

    @Override
    @TraitSetter
    public void theSourceSize_$eq(Point2 x$1) {
        this.theSourceSize = x$1;
    }

    @Override
    public boolean isDirected() {
        return this.isDirected;
    }

    @Override
    @TraitSetter
    public void isDirected_$eq(boolean x$1) {
        this.isDirected = x$1;
    }

    @Override
    public Point3 fromPos() {
        return Connector$class.fromPos(this);
    }

    @Override
    public Point3 byPos1() {
        return Connector$class.byPos1(this);
    }

    @Override
    public Point3 byPos2() {
        return Connector$class.byPos2(this);
    }

    @Override
    public Point3 toPos() {
        return Connector$class.toPos(this);
    }

    @Override
    public void configureConnectorForGroup(Style style, Camera camera) {
        Connector$class.configureConnectorForGroup(this, style, camera);
    }

    @Override
    public void configureConnectorForElement(Camera camera, GraphicEdge element, ConnectorSkeleton skel) {
        Connector$class.configureConnectorForElement(this, camera, element, skel);
    }

    @Override
    public ConnectorSkeleton skel() {
        return this.skel;
    }

    @Override
    @TraitSetter
    public void skel_$eq(ConnectorSkeleton x$1) {
        this.skel = x$1;
    }

    public Path2D.Double theShape() {
        return this.theShape;
    }

    public void theShape_$eq(Path2D.Double x$1) {
        this.theShape = x$1;
    }

    @Override
    public void make(Backend bck, Camera camera) {
        this.make(camera, 0.0, 0.0, 0.0, 0.0);
    }

    public void make(Camera camera, double sox, double soy, double swx, double swy) {
        if (this.skel().isCurve()) {
            this.makeOnCurve(camera, sox, soy, swx, swy);
        } else if (this.skel().isPoly()) {
            this.makeOnPolyline(camera, sox, soy, swx, swy);
        } else {
            this.makeOnLine(camera, sox, soy, swx, swy);
        }
    }

    public void makeOnLine(Camera camera, double sox, double soy, double swx, double swy) {
        double fromx = this.skel().from().x + sox;
        double fromy = this.skel().from().y + soy;
        double tox = this.skel().to().x + sox;
        double toy = this.skel().to().y + soy;
        Vector2 dir = new Vector2(tox - fromx, toy - fromy);
        Vector2 perp = new Vector2(dir.y(), -dir.x());
        perp.normalize();
        perp.scalarMult((this.theSize() + swx) / 2.0);
        this.theShape().reset();
        this.theShape().moveTo(fromx + perp.x(), fromy + perp.y());
        if (this.isDirected()) {
            this.theShape().lineTo(tox, toy);
        } else {
            this.theShape().lineTo(tox + perp.x(), toy + perp.y());
            this.theShape().lineTo(tox - perp.x(), toy - perp.y());
        }
        this.theShape().lineTo(fromx - perp.x(), fromy - perp.y());
        this.theShape().closePath();
    }

    public void makeOnPolyline(Camera camera, double sox, double soy, double swx, double swy) {
        this.makeOnLine(camera, sox, soy, swx, swy);
    }

    public void makeOnCurve(Camera camera, double sox, double soy, double swx, double swy) {
        if (this.skel().isLoop()) {
            this.makeLoop(camera, sox, soy, swx, swy);
        } else {
            this.makeMulti(camera, sox, soy, swx, swy);
        }
    }

    public void makeMulti(Camera camera, double sox, double soy, double swx, double swy) {
        double fromx = this.skel().apply((int)0).x + sox;
        double fromy = this.skel().apply((int)0).y + soy;
        double tox = this.skel().apply((int)3).x + sox;
        double toy = this.skel().apply((int)3).y + soy;
        double c1x = this.skel().apply((int)1).x + sox;
        double c1y = this.skel().apply((int)1).y + soy;
        double c2x = this.skel().apply((int)2).x + sox;
        double c2y = this.skel().apply((int)2).y + soy;
        Vector2 maindir = new Vector2(c2x - c1x, c2y - c1y);
        Vector2 perp = new Vector2(maindir.y(), -maindir.x());
        perp.normalize();
        Vector2 perp1 = new Vector2(perp.x(), perp.y());
        Vector2 perp2 = new Vector2(perp.x(), perp.y());
        perp.scalarMult((this.theSize() + swx) * 0.5);
        if (this.isDirected()) {
            perp1.scalarMult((this.theSize() + swx) * (double)0.4f);
            perp2.scalarMult((this.theSize() + swx) * (double)0.2f);
        } else {
            perp1.scalarMult((this.theSize() + swx) * 0.5);
            perp2.scalarMult((this.theSize() + swx) * 0.5);
        }
        this.theShape().reset();
        this.theShape().moveTo(fromx + perp.x(), fromy + perp.y());
        if (this.isDirected()) {
            this.theShape().curveTo(c1x + perp1.x(), c1y + perp1.y(), c2x + perp2.x(), c2y + perp2.y(), tox, toy);
            this.theShape().curveTo(c2x - perp2.x(), c2y - perp2.y(), c1x - perp1.x(), c1y - perp1.y(), fromx - perp.x(), fromy - perp.y());
        } else {
            this.theShape().curveTo(c1x + perp.x(), c1y + perp.y(), c2x + perp.x(), c2y + perp.y(), tox + perp.x(), toy + perp.y());
            this.theShape().lineTo(tox - perp.x(), toy - perp.y());
            this.theShape().curveTo(c2x - perp.x(), c2y - perp.y(), c1x - perp.x(), c1y - perp.y(), fromx - perp.x(), fromy - perp.y());
        }
        this.theShape().closePath();
    }

    public void makeLoop(Camera camera, double sox, double soy, double swx, double swy) {
        double fromx = this.skel().apply((int)0).x + sox;
        double fromy = this.skel().apply((int)0).y + soy;
        double tox = this.skel().apply((int)3).x + sox;
        double toy = this.skel().apply((int)3).y + soy;
        double c1x = this.skel().apply((int)1).x + sox;
        double c1y = this.skel().apply((int)1).y + soy;
        double c2x = this.skel().apply((int)2).x + sox;
        double c2y = this.skel().apply((int)2).y + soy;
        Vector2 dirFrom = new Vector2(c1x - fromx, c1y - fromy);
        Vector2 dirTo = new Vector2(tox - c2x, toy - c2y);
        Vector2 mainDir = new Vector2(c2x - c1x, c2y - c1y);
        Vector2 perpFrom = new Vector2(dirFrom.y(), -dirFrom.x());
        perpFrom.normalize();
        Vector2 mid1 = new Vector2(dirFrom);
        mid1.sub(mainDir);
        mid1.normalize();
        Vector2 mid2 = new Vector2(mainDir);
        mid2.sub(dirTo);
        mid2.normalize();
        perpFrom.scalarMult(this.theSize() * 0.5);
        if (this.isDirected()) {
            mid1.scalarMult(this.theSize() * (double)0.8f);
            mid2.scalarMult(this.theSize() * (double)0.6f);
        } else {
            mid1.scalarMult(this.theSize() * (double)0.99f);
            mid2.scalarMult(this.theSize() * (double)0.99f);
        }
        this.theShape().reset();
        this.theShape().moveTo(fromx + perpFrom.x(), fromy + perpFrom.y());
        if (this.isDirected()) {
            this.theShape().curveTo(c1x + mid1.x(), c1y + mid1.y(), c2x + mid2.x(), c2y + mid2.y(), tox, toy);
            this.theShape().curveTo(c2x - mid2.x(), c2y - mid2.y(), c1x - mid1.x(), c1y - mid1.y(), fromx - perpFrom.x(), fromy - perpFrom.y());
        } else {
            Vector2 perpTo = new Vector2(dirTo.y(), -dirTo.x());
            perpTo.normalize();
            perpTo.scalarMult(this.theSize() * 0.5);
            this.theShape().curveTo(c1x + mid1.x(), c1y + mid1.y(), c2x + mid2.x(), c2y + mid2.y(), tox + perpTo.x(), toy + perpTo.y());
            this.theShape().lineTo(tox - perpTo.x(), toy - perpTo.y());
            this.theShape().curveTo(c2x - mid2.x(), c2y - mid2.y(), c1x - mid1.x(), c1y - mid1.y(), fromx - perpFrom.x(), fromy - perpFrom.y());
        }
        this.theShape().closePath();
    }

    @Override
    public void makeShadow(Backend bck, Camera camera) {
        if (this.skel().isCurve()) {
            this.makeOnCurve(camera, this.theShadowOff().x, this.theShadowOff().y, this.theShadowWidth().x, this.theShadowWidth().y);
        } else {
            this.makeOnLine(camera, this.theShadowOff().x, this.theShadowOff().y, this.theShadowWidth().x, this.theShadowWidth().y);
        }
    }

    @Override
    public void renderShadow(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        this.makeShadow(bck, camera);
        this.cast(bck.graphics2D(), this.theShape());
    }

    @Override
    public void render(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        Graphics2D g = bck.graphics2D();
        this.make(bck, camera);
        this.stroke(g, this.theShape());
        this.fill(g, this.theShape(), camera);
        this.decorConnector(bck, camera, skel.iconAndText(), element, this.theShape());
    }

    public AngleShape() {
        HasSkel$class.$init$(this);
        Connector$class.$init$(this);
        Decorable$class.$init$(this);
        ConnectorShape$class.$init$(this);
        Fillable$class.$init$(this);
        Strokable$class.$init$(this);
        Shadowable$class.$init$(this);
        AreaConnectorShape$class.$init$(this);
        this.theShape = new Path2D.Double();
    }
}

