/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer;

import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.graphstream.graph.Element;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.StyleGroupListener;
import org.graphstream.ui.graphicGraph.StyleGroupSet;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.BackendJ2D;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.J2DGraphRenderer$;
import org.graphstream.ui.j2dviewer.renderer.GraphBackgroundRenderer;
import org.graphstream.ui.j2dviewer.renderer.JComponentRenderer;
import org.graphstream.ui.j2dviewer.renderer.SelectionRenderer;
import org.graphstream.ui.j2dviewer.renderer.StyleRenderer;
import org.graphstream.ui.j2dviewer.renderer.StyleRenderer$;
import org.graphstream.ui.swingViewer.GraphRenderer;
import org.graphstream.ui.swingViewer.LayerRenderer;
import org.graphstream.ui.swingViewer.util.GraphMetrics;
import org.graphstream.ui.swingViewer.util.Graphics2DOutput;
import org.graphstream.ui.util.FPSLogger;
import org.graphstream.ui.util.Selection;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001dt!B\u0001\u0003\u0011\u0003Y\u0011\u0001\u0005&3\t\u001e\u0013\u0018\r\u001d5SK:$WM]3s\u0015\t\u0019A!A\u0005ke\u00114\u0018.Z<fe*\u0011QAB\u0001\u0003k&T!a\u0002\u0005\u0002\u0017\u001d\u0014\u0018\r\u001d5tiJ,\u0017-\u001c\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001A\u0011A\"D\u0007\u0002\u0005\u0019)aB\u0001E\u0001\u001f\t\u0001\"J\r#He\u0006\u0004\bNU3oI\u0016\u0014XM]\n\u0003\u001bA\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007\"B\f\u000e\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\f\u0011\u001dQRB1A\u0005\u0002m\t\u0001\u0003R#G\u0003VcEk\u0018*F\u001d\u0012+%+\u0012*\u0016\u0003q\u0001\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\t1\fgn\u001a\u0006\u0002C\u0005!!.\u0019<b\u0013\t\u0019cD\u0001\u0004TiJLgn\u001a\u0005\u0007K5\u0001\u000b\u0011\u0002\u000f\u0002#\u0011+e)Q+M)~\u0013VI\u0014#F%\u0016\u0013\u0006E\u0002\u0003\u000f\u0005\u000193\u0003\u0002\u0014)WE\u0002\"!H\u0015\n\u0005)r\"AB(cU\u0016\u001cG\u000f\u0005\u0002-_5\tQF\u0003\u0002/\t\u0005Y1o^5oOZKWm^3s\u0013\t\u0001TFA\u0007He\u0006\u0004\bNU3oI\u0016\u0014XM\u001d\t\u0003eUj\u0011a\r\u0006\u0003i\u0011\tAb\u001a:ba\"L7m\u0012:ba\"L!AN\u001a\u0003%M#\u0018\u0010\\3He>,\b\u000fT5ti\u0016tWM\u001d\u0005\u0006/\u0019\"\t\u0001\u000f\u000b\u0002sA\u0011AB\n\u0005\bw\u0019\u0002\r\u0011\"\u0005=\u0003\u0019\u0019\u0017-\\3sCV\tQ\b\u0005\u0002\r}%\u0011qH\u0001\u0002\u0007\u0007\u0006lWM]1\t\u000f\u00053\u0003\u0019!C\t\u0005\u0006Q1-Y7fe\u0006|F%Z9\u0015\u0005\r3\u0005CA\tE\u0013\t)%C\u0001\u0003V]&$\bbB$A\u0003\u0003\u0005\r!P\u0001\u0004q\u0012\n\u0004BB%'A\u0003&Q(A\u0004dC6,'/\u0019\u0011\t\u000f-3\u0003\u0019!C\t\u0019\u0006)qM]1qQV\tQ\n\u0005\u00023\u001d&\u0011qj\r\u0002\r\u000fJ\f\u0007\u000f[5d\u000fJ\f\u0007\u000f\u001b\u0005\b#\u001a\u0002\r\u0011\"\u0005S\u0003%9'/\u00199i?\u0012*\u0017\u000f\u0006\u0002D'\"9q\tUA\u0001\u0002\u0004i\u0005BB+'A\u0003&Q*\u0001\u0004he\u0006\u0004\b\u000e\t\u0005\b/\u001a\u0012\r\u0011\"\u0005Y\u0003%\u0019X\r\\3di&|g.F\u0001Z!\tQV,D\u0001\\\u0015\taF!\u0001\u0003vi&d\u0017B\u00010\\\u0005%\u0019V\r\\3di&|g\u000e\u0003\u0004aM\u0001\u0006I!W\u0001\u000bg\u0016dWm\u0019;j_:\u0004\u0003b\u00022'\u0001\u0004%\tbY\u0001\rE\u0006\u001c7NU3oI\u0016\u0014XM]\u000b\u0002IB\u0011A&Z\u0005\u0003M6\u0012Q\u0002T1zKJ\u0014VM\u001c3fe\u0016\u0014\bb\u00025'\u0001\u0004%\t\"[\u0001\u0011E\u0006\u001c7NU3oI\u0016\u0014XM]0%KF$\"a\u00116\t\u000f\u001d;\u0017\u0011!a\u0001I\"1AN\nQ!\n\u0011\fQBY1dWJ+g\u000eZ3sKJ\u0004\u0003b\u00028'\u0001\u0004%\tbY\u0001\rM>\u0014XMU3oI\u0016\u0014XM\u001d\u0005\ba\u001a\u0002\r\u0011\"\u0005r\u0003A1wN]3SK:$WM]3s?\u0012*\u0017\u000f\u0006\u0002De\"9qi\\A\u0001\u0002\u0004!\u0007B\u0002;'A\u0003&A-A\u0007g_J,'+\u001a8eKJ,'\u000f\t\u0005\bm\u001a\u0002\r\u0011\"\u0005x\u0003\u001d\u0011\u0017mY6f]\u0012,\u0012\u0001\u001f\t\u0003\u0019eL!A\u001f\u0002\u0003\u000f\t\u000b7m[3oI\"9AP\na\u0001\n#i\u0018a\u00032bG.,g\u000eZ0%KF$\"a\u0011@\t\u000f\u001d[\u0018\u0011!a\u0001q\"9\u0011\u0011\u0001\u0014!B\u0013A\u0018\u0001\u00032bG.,g\u000e\u001a\u0011\t\u0013\u0005\u0015a\u00051A\u0005\u0012\u0005\u001d\u0011!\u00034qg2{wmZ3s+\t\tI\u0001E\u0002[\u0003\u0017I1!!\u0004\\\u0005%1\u0005k\u0015'pO\u001e,'\u000fC\u0005\u0002\u0012\u0019\u0002\r\u0011\"\u0005\u0002\u0014\u0005ia\r]:M_\u001e<WM]0%KF$2aQA\u000b\u0011%9\u0015qBA\u0001\u0002\u0004\tI\u0001\u0003\u0005\u0002\u001a\u0019\u0002\u000b\u0015BA\u0005\u0003)1\u0007o\u001d'pO\u001e,'\u000f\t\u0005\b\u0003;1C\u0011AA\u0010\u0003\u0011y\u0007/\u001a8\u0015\u000b\r\u000b\t#a\t\t\r-\u000bY\u00021\u0001N\u0011!\t)#a\u0007A\u0002\u0005\u001d\u0012A\u00043sC^LgnZ*ve\u001a\f7-\u001a\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011Q\u0006\u0011\u0002\u0007\u0005<H/\u0003\u0003\u00022\u0005-\"!C\"p]R\f\u0017N\\3s\u0011\u001d\t)D\nC\u0001\u0003o\tQa\u00197pg\u0016$\u0012a\u0011\u0005\b\u0003w1C\u0011AA\u001f\u0003%9W\r^\"b[\u0016\u0014\u0018\r\u0006\u0002\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002F\u0011\tAA^5fo&\u0019q(a\u0011\t\u000f\u0005-c\u0005\"\u0001\u0002N\u0005\u0011b-\u001b8e\u001d>$Wm\u0014:TaJLG/Z!u)\u0019\ty%!\u0016\u0002`A\u0019!'!\u0015\n\u0007\u0005M3G\u0001\bHe\u0006\u0004\b.[2FY\u0016lWM\u001c;\t\u0011\u0005]\u0013\u0011\na\u0001\u00033\n\u0011\u0001\u001f\t\u0004#\u0005m\u0013bAA/%\t1Ai\\;cY\u0016D\u0001\"!\u0019\u0002J\u0001\u0007\u0011\u0011L\u0001\u0002s\"9\u0011Q\r\u0014\u0005\u0002\u0005\u001d\u0014aE1mY:{G-Z:PeN\u0003(/\u001b;fg&sGCCA5\u0003g\n9(a\u001f\u0002\u0000A1\u00111NA8\u0003\u001fj!!!\u001c\u000b\u0005q\u0003\u0013\u0002BA9\u0003[\u0012\u0011\"\u0011:sCfd\u0015n\u001d;\t\u0011\u0005U\u00141\ra\u0001\u00033\n!\u0001_\u0019\t\u0011\u0005e\u00141\ra\u0001\u00033\n!!_\u0019\t\u0011\u0005u\u00141\ra\u0001\u00033\n!\u0001\u001f\u001a\t\u0011\u0005\u0005\u00151\ra\u0001\u00033\n!!\u001f\u001a\t\u000f\u0005\u0015e\u0005\"\u0001\u0002\b\u0006\u0001\"/\u001a8eKJLgnZ*ve\u001a\f7-Z\u000b\u0003\u0003OAq!a#'\t#\ti)\u0001\thKR\u001cF/\u001f7f%\u0016tG-\u001a:feR!\u0011qRAN!\u0011\t\t*a&\u000e\u0005\u0005M%bAAK\u0005\u0005A!/\u001a8eKJ,'/\u0003\u0003\u0002\u001a\u0006M%aF$sCBD')Y2lOJ|WO\u001c3SK:$WM]3s\u0011\u0019Y\u0015\u0011\u0012a\u0001\u001b\"9\u00111\u0012\u0014\u0005\u0012\u0005}E\u0003BAQ\u0003O\u0003B!!%\u0002$&!\u0011QUAJ\u00055\u0019F/\u001f7f%\u0016tG-\u001a:fe\"A\u0011\u0011VAO\u0001\u0004\tY+A\u0003tifdW\rE\u00023\u0003[K1!a,4\u0005)\u0019F/\u001f7f\u000fJ|W\u000f\u001d\u0005\b\u0003\u00173C\u0011CAZ)\u0011\t\t+!.\t\u0011\u0005]\u0016\u0011\u0017a\u0001\u0003\u001f\nq!\u001a7f[\u0016tG\u000fC\u0004\u0002<\u001a\"\t\"a\u000e\u0002\u001fI,Wn\u001c<f%\u0016tG-\u001a:feNDq!a0'\t\u0003\t\t-\u0001\tcK\u001eLgnU3mK\u000e$\u0018n\u001c8BiR)1)a1\u0002F\"A\u0011qKA_\u0001\u0004\tI\u0006\u0003\u0005\u0002b\u0005u\u0006\u0019AA-\u0011\u001d\tIM\nC\u0001\u0003\u0017\f\u0001c]3mK\u000e$\u0018n\u001c8He><8/\u0011;\u0015\u000b\r\u000bi-a4\t\u0011\u0005]\u0013q\u0019a\u0001\u00033B\u0001\"!\u0019\u0002H\u0002\u0007\u0011\u0011\f\u0005\b\u0003'4C\u0011AAk\u00039)g\u000eZ*fY\u0016\u001cG/[8o\u0003R$RaQAl\u00033D\u0001\"a\u0016\u0002R\u0002\u0007\u0011\u0011\f\u0005\t\u0003C\n\t\u000e1\u0001\u0002Z!9\u0011Q\u001c\u0014\u0005\u0002\u0005}\u0017aD7pm\u0016,E.Z7f]R\fE\u000f\u0015=\u0015\u000f\r\u000b\t/a9\u0002f\"A\u0011qWAn\u0001\u0004\ty\u0005\u0003\u0005\u0002X\u0005m\u0007\u0019AA-\u0011!\t\t'a7A\u0002\u0005e\u0003bBAuM\u0011\u0005\u00111^\u0001\u0007e\u0016tG-\u001a:\u0015\u0017\r\u000bi/a>\u0002\u0000\n\u0005!Q\u0001\u0005\t\u0003_\f9\u000f1\u0001\u0002r\u0006\tq\r\u0005\u0003\u0002*\u0005M\u0018\u0002BA{\u0003W\u0011!b\u0012:ba\"L7m\u001d\u001aE\u0011!\t9&a:A\u0002\u0005e\bcA\t\u0002|&\u0019\u0011Q \n\u0003\u0007%sG\u000f\u0003\u0005\u0002b\u0005\u001d\b\u0019AA}\u0011!\u0011\u0019!a:A\u0002\u0005e\u0018!B<jIRD\u0007\u0002\u0003B\u0004\u0003O\u0004\r!!?\u0002\r!,\u0017n\u001a5u\u0011\u001d\u0011YA\nC\t\u0003o\t!b\u001d;beR4%/Y7f\u0011\u001d\u0011yA\nC\t\u0003o\t\u0001\"\u001a8e\rJ\fW.\u001a\u0005\b\u0005'1C\u0011CA\u001c\u0003=\u0011XM\u001c3fe\n\u000b7m\u001b'bs\u0016\u0014\bb\u0002B\fM\u0011E\u0011qG\u0001\u0010e\u0016tG-\u001a:G_J,G*Y=fe\"9!1\u0004\u0014\u0005\u0012\tu\u0011a\u0003:f]\u0012,'\u000fT1zKJ$2a\u0011B\u0010\u0011\u001d\t)J!\u0007A\u0002\u0011DqAa\t'\t#\t9$A\u0007tKR,\bo\u0012:ba\"L7m\u001d\u0005\b\u0005O1C\u0011\u0001B\u0015\u0003)\u00198M]3f]NDw\u000e\u001e\u000b\b\u0007\n-\"1\bB\u001f\u0011!\u0011iC!\nA\u0002\t=\u0012\u0001\u00034jY\u0016t\u0017-\\3\u0011\t\tE\"q\u0007\b\u0004#\tM\u0012b\u0001B\u001b%\u00051\u0001K]3eK\u001aL1a\tB\u001d\u0015\r\u0011)D\u0005\u0005\t\u0005\u0007\u0011)\u00031\u0001\u0002z\"A!q\u0001B\u0013\u0001\u0004\tI\u0010C\u0004\u0003B\u0019\"\tAa\u0011\u0002)M,GOQ1dW2\u000b\u00170\u001a:SK:$WM]3s)\r\u0019%Q\t\u0005\b\u0003+\u0013y\u00041\u0001e\u0011\u001d\u0011IE\nC\u0001\u0005\u0017\nQc]3u\r>\u0014X\rT1z_V$(+\u001a8eKJ,'\u000fF\u0002D\u0005\u001bBq!!&\u0003H\u0001\u0007A\rC\u0004\u0003R\u0019\"\tAa\u0015\u0002'\u0015dW-\\3oiN#\u0018\u0010\\3DQ\u0006tw-\u001a3\u0015\u000f\r\u0013)F!\u0019\u0003f!A\u0011q\u0017B(\u0001\u0004\u00119\u0006\u0005\u0003\u0003Z\tuSB\u0001B.\u0015\tYe!\u0003\u0003\u0003`\tm#aB#mK6,g\u000e\u001e\u0005\t\u0005G\u0012y\u00051\u0001\u0002,\u0006Aq\u000e\u001c3TifdW\r\u0003\u0005\u0002*\n=\u0003\u0019AAV\u0001")
public class J2DGraphRenderer
implements GraphRenderer,
StyleGroupListener {
    private Camera camera = null;
    private GraphicGraph graph = null;
    private final Selection selection = new Selection();
    private LayerRenderer backRenderer = null;
    private LayerRenderer foreRenderer = null;
    private Backend backend = null;
    private FPSLogger fpsLogger = null;

    public static String DEFAULT_RENDERER() {
        return J2DGraphRenderer$.MODULE$.DEFAULT_RENDERER();
    }

    public Camera camera() {
        return this.camera;
    }

    public void camera_$eq(Camera x$1) {
        this.camera = x$1;
    }

    public GraphicGraph graph() {
        return this.graph;
    }

    public void graph_$eq(GraphicGraph x$1) {
        this.graph = x$1;
    }

    public Selection selection() {
        return this.selection;
    }

    public LayerRenderer backRenderer() {
        return this.backRenderer;
    }

    public void backRenderer_$eq(LayerRenderer x$1) {
        this.backRenderer = x$1;
    }

    public LayerRenderer foreRenderer() {
        return this.foreRenderer;
    }

    public void foreRenderer_$eq(LayerRenderer x$1) {
        this.foreRenderer = x$1;
    }

    public Backend backend() {
        return this.backend;
    }

    public void backend_$eq(Backend x$1) {
        this.backend = x$1;
    }

    public FPSLogger fpsLogger() {
        return this.fpsLogger;
    }

    public void fpsLogger_$eq(FPSLogger x$1) {
        this.fpsLogger = x$1;
    }

    public void open(GraphicGraph graph, Container drawingSurface) {
        if (this.graph() == null) {
            this.graph_$eq(graph);
            this.backend_$eq(new BackendJ2D());
            this.camera_$eq(new Camera(graph));
            graph.getStyleGroups().addListener((StyleGroupListener)this);
            this.backend().open(drawingSurface);
            return;
        }
        throw new RuntimeException("renderer already open, use close() first");
    }

    public void close() {
        if (this.graph() != null) {
            if (this.fpsLogger() != null) {
                this.fpsLogger().close();
                this.fpsLogger_$eq(null);
            }
            this.removeRenderers();
            this.backend().close();
            this.graph().getStyleGroups().removeListener((StyleGroupListener)this);
            this.graph_$eq(null);
            this.backend_$eq(null);
            this.camera_$eq(null);
        }
    }

    public org.graphstream.ui.view.Camera getCamera() {
        return this.camera();
    }

    public GraphicElement findNodeOrSpriteAt(double x, double y) {
        return this.camera().findNodeOrSpriteAt(this.graph(), x, y);
    }

    public ArrayList<GraphicElement> allNodesOrSpritesIn(double x1, double y1, double x2, double y2) {
        return this.camera().allNodesOrSpritesIn(this.graph(), x1, y1, x2, y2);
    }

    public Container renderingSurface() {
        return this.backend().drawingSurface();
    }

    public GraphBackgroundRenderer getStyleRenderer(GraphicGraph graph) {
        if (graph.getStyle().getRenderer("dr") == null) {
            graph.getStyle().addRenderer("dr", (GraphicElement.SwingElementRenderer)new GraphBackgroundRenderer(graph, graph.getStyle()));
        }
        return (GraphBackgroundRenderer)graph.getStyle().getRenderer("dr");
    }

    public StyleRenderer getStyleRenderer(StyleGroup style) {
        if (style.getRenderer("dr") == null) {
            style.addRenderer("dr", (GraphicElement.SwingElementRenderer)StyleRenderer$.MODULE$.apply(style, this));
        }
        return (StyleRenderer)style.getRenderer("dr");
    }

    public StyleRenderer getStyleRenderer(GraphicElement element) {
        return this.getStyleRenderer(element.getStyle());
    }

    public void removeRenderers() {
        this.graph().getStyle().removeRenderer("dr");
        JavaConversions$.MODULE$.asScalaIterator(this.graph().getNodeIterator()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final GraphicElement.SwingElementRenderer apply(GraphicNode node) {
                return node.getStyle().removeRenderer("dr");
            }
        });
        JavaConversions$.MODULE$.asScalaIterator(this.graph().getEdgeIterator()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final GraphicElement.SwingElementRenderer apply(GraphicEdge edge) {
                return edge.getStyle().removeRenderer("dr");
            }
        });
        JavaConversions$.MODULE$.asScalaIterator(this.graph().getSpriteIterator()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final GraphicElement.SwingElementRenderer apply(GraphicSprite sprite) {
                return sprite.getStyle().removeRenderer("dr");
            }
        });
    }

    public void beginSelectionAt(double x, double y) {
        this.selection().active_$eq(true);
        this.selection().begins(x, y);
        Logger.getLogger(this.getClass().getSimpleName()).fine(new StringOps(Predef$.MODULE$.augmentString("Selection begins at %f %f.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y)})));
    }

    public void selectionGrowsAt(double x, double y) {
        this.selection().grows(x, y);
    }

    public void endSelectionAt(double x, double y) {
        this.selection().grows(x, y);
        this.selection().active_$eq(false);
    }

    public void moveElementAtPx(GraphicElement element, double x, double y) {
        Point3 p = this.camera().transformPxToGu(x, y);
        element.move(p.x, p.y, element.getZ());
    }

    public void render(Graphics2D g, int x, int y, int width, int height) {
        if (this.graph() != null) {
            this.startFrame();
            if (this.backend() == null) {
                this.backend_$eq(new BackendJ2D());
            }
            this.backend().prepareNewFrame(g);
            this.camera().setBackend(this.backend());
            StyleGroupSet sgs = this.graph().getStyleGroups();
            this.setupGraphics();
            this.graph().computeBounds();
            this.camera().setBounds(this.graph());
            this.camera().setViewport(x, y, width, height);
            this.getStyleRenderer(this.graph()).render(this.backend(), this.camera(), width, height);
            this.renderBackLayer();
            this.camera().pushView(this.graph());
            JavaConversions$.MODULE$.iterableAsScalaIterable(sgs.shadows()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ J2DGraphRenderer $outer;

                public final void apply(StyleGroup x$1) {
                    this.$outer.getStyleRenderer(x$1).renderShadow(this.$outer.backend(), this.$outer.camera());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            JavaConversions$.MODULE$.iterableAsScalaIterable(sgs.zIndex()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ J2DGraphRenderer $outer;

                public final void apply(HashSet<StyleGroup> groups) {
                    JavaConversions$.MODULE$.asScalaSet(groups).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$render$2 $outer;

                        public final void apply(StyleGroup group) {
                            Selector.Type type = group.getType();
                            Selector.Type type2 = Selector.Type.GRAPH;
                            if (type == null ? type2 != null : !type.equals(type2)) {
                                this.$outer.org$graphstream$ui$j2dviewer$J2DGraphRenderer$$anonfun$$$outer().getStyleRenderer(group).render(this.$outer.org$graphstream$ui$j2dviewer$J2DGraphRenderer$$anonfun$$$outer().backend(), this.$outer.org$graphstream$ui$j2dviewer$J2DGraphRenderer$$anonfun$$$outer().camera());
                            }
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ J2DGraphRenderer org$graphstream$ui$j2dviewer$J2DGraphRenderer$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.camera().popView();
            this.renderForeLayer();
            if (this.selection().renderer() == null) {
                this.selection().renderer_$eq(new SelectionRenderer(this.selection(), this.graph()));
            }
            this.selection().renderer().render(this.backend(), this.camera(), width, height);
            this.endFrame();
        }
    }

    public void startFrame() {
        if (this.fpsLogger() == null && this.graph().hasLabel("ui.log")) {
            this.fpsLogger_$eq(new FPSLogger(this.graph().getLabel("ui.log")));
        }
        if (this.fpsLogger() != null) {
            this.fpsLogger().beginFrame();
        }
    }

    public void endFrame() {
        if (this.fpsLogger() != null) {
            this.fpsLogger().endFrame();
        }
    }

    public void renderBackLayer() {
        if (this.backRenderer() != null) {
            this.renderLayer(this.backRenderer());
        }
    }

    public void renderForeLayer() {
        if (this.foreRenderer() != null) {
            this.renderLayer(this.foreRenderer());
        }
    }

    public void renderLayer(LayerRenderer renderer) {
        GraphMetrics metrics = this.camera().metrics();
        renderer.render(this.backend().graphics2D(), this.graph(), metrics.ratioPx2Gu, (int)metrics.viewport[2], (int)metrics.viewport[3], metrics.loVisible.x, metrics.loVisible.y, metrics.hiVisible.x, metrics.hiVisible.y);
    }

    public void setupGraphics() {
        this.backend().setAntialias(this.graph().hasAttribute("ui.antialias"));
        this.backend().setQuality(this.graph().hasAttribute("ui.quality"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void screenshot(String filename, int width, int height) {
        if (filename.toLowerCase().endsWith("png")) {
            BufferedImage img = new BufferedImage(width, height, 2);
            this.render(img.createGraphics(), 0, 0, width, height);
            File file = new File(filename);
            ImageIO.write((RenderedImage)img, "png", file);
            return;
        }
        if (filename.toLowerCase().endsWith("bmp")) {
            BufferedImage img = new BufferedImage(width, height, 1);
            this.render(img.createGraphics(), 0, 0, width, height);
            File file = new File(filename);
            ImageIO.write((RenderedImage)img, "bmp", file);
            return;
        }
        if (filename.toLowerCase().endsWith("jpg") || filename.toLowerCase().endsWith("jpeg")) {
            BufferedImage img = new BufferedImage(width, height, 1);
            this.render(img.createGraphics(), 0, 0, width, height);
            File file = new File(filename);
            ImageIO.write((RenderedImage)img, "jpg", file);
            return;
        }
        if (!filename.toLowerCase().endsWith("svg")) {
            Logger.getLogger(this.getClass().getSimpleName()).warning(new StringOps(Predef$.MODULE$.augmentString("Unknown screenshot filename extension %s, saving to jpeg.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filename})));
            BufferedImage img = new BufferedImage(width, height, 1);
            this.render(img.createGraphics(), 0, 0, width, height);
            File file = new File(new StringBuilder().append((Object)filename).append((Object)".jpg").toString());
            ImageIO.write((RenderedImage)img, "jpg", file);
            return;
        }
        try {
            String plugin = "org.graphstream.ui.batik.BatikGraphics2D";
            Class<?> c = Class.forName(plugin);
            Object o = c.newInstance();
            if (o instanceof Graphics2DOutput) {
                Graphics2DOutput out = (Graphics2DOutput)o;
                Graphics2D g2 = out.getGraphics();
                this.render(g2, 0, 0, width, height);
                out.outputTo(filename);
                return;
            }
            Logger.getLogger(this.getClass().getSimpleName()).warning(new StringOps(Predef$.MODULE$.augmentString("Plugin %s is not an instance of Graphics2DOutput (%s).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{plugin, o.getClass().getName()})));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setBackLayerRenderer(LayerRenderer renderer) {
        this.backRenderer_$eq(renderer);
    }

    public void setForeLayoutRenderer(LayerRenderer renderer) {
        this.foreRenderer_$eq(renderer);
    }

    public void elementStyleChanged(Element element, StyleGroup oldStyle, StyleGroup style) {
        GraphicElement.SwingElementRenderer renderer;
        if (oldStyle == null && oldStyle != null && (renderer = oldStyle.getRenderer(J2DGraphRenderer$.MODULE$.DEFAULT_RENDERER())) != null && renderer instanceof JComponentRenderer) {
            ((JComponentRenderer)renderer).unequipElement((GraphicElement)element);
        }
    }
}

