/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.parser;

import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.Node;
import org.graphper.parser.DotTempAttrListener;
import org.graphper.parser.ParserUtils;
import org.graphper.parser.PostGraphComponents;
import org.graphper.parser.grammar.DOTParser;

public class NodeExtractor
extends DotTempAttrListener {
    private final Map<String, Node> nodeMap = new HashMap<String, Node>();
    private final Map<String, Map<String, String>> nodeStmtContextMap = new HashMap<String, Map<String, String>>();
    private final PostGraphComponents postGraphComponents;

    public NodeExtractor(PostGraphComponents postGraphComponents) {
        this.postGraphComponents = postGraphComponents;
    }

    @Override
    public void enterNode_stmt(DOTParser.Node_stmtContext ctx) {
        this.parseNodeAttrs(null, ctx);
    }

    @Override
    public void enterEdge_stmt(DOTParser.Edge_stmtContext ctx) {
        ParserRuleContext first = ctx.node_id() != null ? ctx.node_id() : ctx.subgraph();
        int edgeCount = ctx.edgeRHS().children.size() / 2;
        for (int c = 0; c < edgeCount; ++c) {
            ParseTree second = (ParseTree)ctx.edgeRHS().children.get(2 * c + 1);
            if (first instanceof DOTParser.Node_idContext) {
                String leftId = ((DOTParser.Node_idContext)first).id_().getText();
                this.parseNodeAttrs(leftId, null);
            }
            if (second instanceof DOTParser.Node_idContext) {
                String rightId = ((DOTParser.Node_idContext)second).id_().getText();
                this.parseNodeAttrs(rightId, null);
            }
            first = second;
        }
    }

    public Node getNode(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        return this.nodeMap.computeIfAbsent(nodeId, k -> {
            Node.NodeBuilder builder = Node.builder();
            builder.id(nodeId);
            Map<String, String> nodeAttrs = this.nodeStmtContextMap.get(k);
            if (nodeAttrs == null) {
                this.postNode(builder);
                return builder.build();
            }
            ParserUtils.nodeAttributes(builder, nodeAttrs);
            this.postNode(builder);
            return builder.build();
        });
    }

    private void postNode(Node.NodeBuilder builder) {
        if (this.postGraphComponents != null) {
            this.postGraphComponents.postNode(builder);
        }
    }

    private void parseNodeAttrs(String id, DOTParser.Node_stmtContext ctx) {
        if (StringUtils.isEmpty((CharSequence)id) && ctx == null) {
            return;
        }
        if (ctx != null) {
            id = ctx.node_id().id_().getText();
        }
        Map<String, String> attrs = this.combineAttrs(this.nodeStmtContextMap.get(id), ctx);
        attrs = NodeExtractor.combineAttrs(this.currentTempAttrs(), attrs);
        this.nodeStmtContextMap.put(id, attrs);
    }

    private Map<String, String> combineAttrs(Map<String, String> sourceAttrs, DOTParser.Node_stmtContext targetNodeCtx) {
        return this.combineAttrs(sourceAttrs, targetNodeCtx != null ? targetNodeCtx.attr_list() : null);
    }

    @Override
    protected boolean isFocusStmtType(DOTParser.Attr_stmtContext ctx) {
        return ctx.NODE() != null;
    }
}

