/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.parser;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.Html;
import org.graphper.parser.ParseException;
import org.graphper.parser.ParserUtils;
import org.graphper.parser.grammar.HTMLParser;
import org.graphper.parser.grammar.HTMLParserBaseListener;
import org.graphper.util.CollectionUtils;

public class HtmlListener
extends HTMLParserBaseListener {
    private Object root;
    private Deque<Html.Table> tableQueue;
    private Deque<List<Html.Td>> tdQueue;
    private Deque<Tag> tagQueue;

    @Override
    public void enterHtmlTag(HTMLParser.HtmlTagContext ctx) {
        if (ctx.table() != null) {
            return;
        }
        HTMLParser.TagContentContext tagCtx = ctx.tagContent();
        if (tagCtx == null) {
            return;
        }
        if (CollectionUtils.isEmpty(tagCtx.htmlElement())) {
            this.root = tagCtx.getText();
            return;
        }
        this.pushTag(new Tag(labelTag -> {
            this.root = labelTag;
        }));
    }

    @Override
    public void exitHtmlTag(HTMLParser.HtmlTagContext ctx) {
        this.pollAndConsTag();
    }

    @Override
    public void enterTable(HTMLParser.TableContext ctx) {
        Html.Table t = Html.table();
        List<Html.Td> tds = this.peekTds();
        if (CollectionUtils.isNotEmpty(tds)) {
            Html.Td td = tds.get(tds.size() - 1);
            td.table(t);
        }
        this.pushTable(t);
        if (this.root == null) {
            this.root = t;
        }
    }

    @Override
    public void exitTable(HTMLParser.TableContext ctx) {
        this.popCurrentTable();
    }

    @Override
    public void enterTr(HTMLParser.TrContext ctx) {
        this.pushTds();
    }

    @Override
    public void exitTr(HTMLParser.TrContext ctx) {
        List<Html.Td> tds = this.peekTds();
        if (CollectionUtils.isEmpty(tds)) {
            throw new ParseException("<tr> not contains any <td>");
        }
        this.curretTable().tr(tds.toArray(new Html.Td[0]));
        this.pollTds();
    }

    @Override
    public void enterTd(HTMLParser.TdContext ctx) {
        List<Html.Td> tds = this.peekTds();
        if (tds == null) {
            throw new ParseException("<td> not belong to any <tr>");
        }
        Html.Td td = Html.td();
        tds.add(td);
        HTMLParser.TdContentContext tdCtx = ctx.tdContent();
        if (this.pureText(tdCtx)) {
            String text = tdCtx.getText();
            text = StringUtils.isEmpty((CharSequence)text) ? "" : text.trim();
            td.text(text);
            return;
        }
        if (CollectionUtils.isNotEmpty(tdCtx.htmlElement())) {
            this.pushTag(new Tag(arg_0 -> ((Html.Td)this.currentTd()).textTag(arg_0)));
        }
    }

    @Override
    public void exitTd(HTMLParser.TdContext ctx) {
        this.pollAndConsTag();
    }

    @Override
    public void enterHtmlAttribute(HTMLParser.HtmlAttributeContext ctx) {
        if (ctx.TAG_NAME() == null || ctx.ATTVALUE_VALUE() == null) {
            return;
        }
        String attributeValue = ctx.ATTVALUE_VALUE().getText();
        if (StringUtils.isEmpty((CharSequence)attributeValue)) {
            return;
        }
        attributeValue = HtmlListener.adaptAttrValue(attributeValue);
        ParserRuleContext parent = ctx.getParent();
        if (parent instanceof HTMLParser.TdContext) {
            ParserUtils.setTdAttributes(this.currentTd(), ctx.TAG_NAME().getText(), attributeValue);
        }
        if (parent instanceof HTMLParser.TableContext) {
            ParserUtils.setTableAttributes(this.curretTable(), ctx.TAG_NAME().getText(), attributeValue);
        }
    }

    @Override
    public void enterHtmlElement(HTMLParser.HtmlElementContext ctx) {
        HTMLParser.FontTagContext font = ctx.fontTag();
        HTMLParser.BTagContext bold = ctx.bTag();
        HTMLParser.ITagContext italic = ctx.iTag();
        HTMLParser.UTagContext underline = ctx.uTag();
        HTMLParser.STagContext strikethrough = ctx.sTag();
        HTMLParser.OTagContext overline = ctx.oTag();
        HTMLParser.SupTagContext superscript = ctx.supTag();
        HTMLParser.SubTagContext subscript = ctx.subTag();
        HTMLParser.VtTagContext verticalTop = ctx.vtTag();
        HTMLParser.VbTagContext verticalBottom = ctx.vbTag();
        HTMLParser.VcTagContext verticalCenter = ctx.vcTag();
        HTMLParser.HlTagContext horizontalLeft = ctx.hlTag();
        HTMLParser.HrTagContext horizontalRight = ctx.hrTag();
        HTMLParser.HcTagContext horizontalCenter = ctx.hcTag();
        HTMLParser.BrTagContext br = ctx.brTag();
        if (font != null) {
            Html.FontAttrs fontAttrs = this.parseFontAttrs(font.htmlAttribute());
            if (fontAttrs == null) {
                this.handleTagCtx(font.tagContent(), Html::font, Html.LabelTag::font);
            } else {
                this.handleTagCtx(font.tagContent(), tag -> Html.font((Html.LabelTag)tag, (Html.FontAttrs)fontAttrs), (tag, childTag) -> tag.font(childTag, fontAttrs));
            }
        }
        if (bold != null) {
            this.handleTagCtx(bold.tagContent(), Html::bold, Html.LabelTag::bold);
        }
        if (italic != null) {
            this.handleTagCtx(italic.tagContent(), Html::italic, Html.LabelTag::italic);
        }
        if (underline != null) {
            this.handleTagCtx(underline.tagContent(), Html::underline, Html.LabelTag::underline);
        }
        if (strikethrough != null) {
            this.handleTagCtx(strikethrough.tagContent(), Html::strikeThrough, Html.LabelTag::strikeThrough);
        }
        if (overline != null) {
            this.handleTagCtx(overline.tagContent(), Html::overline, Html.LabelTag::overline);
        }
        if (superscript != null) {
            this.handleTagCtx(superscript.tagContent(), Html::superscript, Html.LabelTag::superscript);
        }
        if (subscript != null) {
            this.handleTagCtx(subscript.tagContent(), Html::subscript, Html.LabelTag::subscript);
        }
        if (verticalTop != null) {
            this.handleTagCtx(verticalTop.tagContent(), Html::top, Html.LabelTag::top);
        }
        if (verticalBottom != null) {
            this.handleTagCtx(verticalBottom.tagContent(), Html::bottom, Html.LabelTag::bottom);
        }
        if (verticalCenter != null) {
            this.handleTagCtx(verticalCenter.tagContent(), Html::verticalCenter, Html.LabelTag::verticalCenter);
        }
        if (horizontalLeft != null) {
            this.handleTagCtx(horizontalLeft.tagContent(), Html::left, Html.LabelTag::left);
        }
        if (horizontalRight != null) {
            this.handleTagCtx(horizontalRight.tagContent(), Html::right, Html.LabelTag::right);
        }
        if (horizontalCenter != null) {
            this.handleTagCtx(horizontalCenter.tagContent(), Html::horizontalCenter, Html.LabelTag::horizontalCenter);
        }
        if (br != null) {
            this.peekAndConsTagIfAbsent(Html::br, Html.LabelTag::br);
        }
    }

    @Override
    public void exitHtmlElement(HTMLParser.HtmlElementContext ctx) {
        HTMLParser.BrTagContext br = ctx.brTag();
        if (br == null) {
            this.pollAndConsTag();
        }
    }

    @Override
    public void enterHtmlChardata(HTMLParser.HtmlChardataContext ctx) {
        if (this.getLabel() != null) {
            return;
        }
        String text = StringUtils.isEmpty((CharSequence)ctx.getText()) ? "" : ctx.getText();
        String t = text = text.replace("\n", "").replace("\r", "").replace("\t", "");
        this.peekAndConsTagIfAbsent(() -> Html.text((String)t), labelTag -> labelTag.text(t));
    }

    public String getLabel() {
        if (this.root instanceof String) {
            return (String)this.root;
        }
        return null;
    }

    public Html.Table getTable() {
        if (this.root instanceof Html.Table) {
            return (Html.Table)this.root;
        }
        return null;
    }

    public Html.LabelTag getLabelTag() {
        if (this.root instanceof Html.LabelTag) {
            return (Html.LabelTag)this.root;
        }
        return null;
    }

    private Html.Td currentTd() {
        List<Html.Td> tds = this.peekTds();
        if (CollectionUtils.isEmpty(tds)) {
            throw new ParseException("Cannot found current td");
        }
        return tds.get(tds.size() - 1);
    }

    private Html.Table curretTable() {
        if (this.tableQueue == null) {
            throw new ParseException("Cannot found current table");
        }
        Html.Table t = this.tableQueue.peek();
        if (t == null) {
            throw new ParseException("Cannot found current table");
        }
        return t;
    }

    private void popCurrentTable() {
        if (this.tableQueue == null) {
            return;
        }
        this.tableQueue.pop();
    }

    private void pushTable(Html.Table table) {
        if (this.tableQueue == null) {
            this.tableQueue = new LinkedList<Html.Table>();
        }
        this.tableQueue.push(table);
    }

    private List<Html.Td> pollTds() {
        if (this.tdQueue == null) {
            return null;
        }
        return this.tdQueue.poll();
    }

    private List<Html.Td> peekTds() {
        if (this.tdQueue == null) {
            return null;
        }
        return this.tdQueue.peek();
    }

    private void pushTds() {
        if (this.tdQueue == null) {
            this.tdQueue = new LinkedList<List<Html.Td>>();
        }
        this.tdQueue.push(new ArrayList());
    }

    private void pushTag(Tag tag) {
        if (this.tagQueue == null) {
            this.tagQueue = new LinkedList<Tag>();
        }
        this.tagQueue.push(tag);
    }

    private Tag peekTag() {
        if (this.tagQueue == null) {
            return null;
        }
        return this.tagQueue.peek();
    }

    private Tag pollTag() {
        if (this.tagQueue == null) {
            return null;
        }
        return this.tagQueue.poll();
    }

    private void pollAndConsTag() {
        Tag tag = this.pollTag();
        if (tag != null) {
            tag.consumeTag();
        }
    }

    private void peekAndConsTagIfAbsent(Supplier<Html.LabelTag> supplier, Consumer<Html.LabelTag> labelTagCons) {
        Tag tag = this.peekTag();
        if (tag == null) {
            return;
        }
        if (tag.labelTag != null) {
            labelTagCons.accept(tag.labelTag);
        } else {
            tag.labelTag = supplier.get();
        }
    }

    private void handleTagCtx(HTMLParser.TagContentContext tagCtx, UnaryOperator<Html.LabelTag> tagTagSupplier, BiConsumer<Html.LabelTag, Html.LabelTag> tagChainTagConsumer) {
        if (tagCtx == null) {
            return;
        }
        this.pushTag(new Tag(labelTag -> this.peekAndConsTagIfAbsent(() -> (Html.LabelTag)tagTagSupplier.apply((Html.LabelTag)labelTag), lt -> tagChainTagConsumer.accept((Html.LabelTag)lt, (Html.LabelTag)labelTag))));
    }

    private boolean pureText(HTMLParser.TdContentContext tdCtx) {
        return CollectionUtils.isEmpty(tdCtx.table()) && CollectionUtils.isEmpty(tdCtx.htmlElement());
    }

    private Html.FontAttrs parseFontAttrs(List<HTMLParser.HtmlAttributeContext> fontAttrsCtx) {
        if (CollectionUtils.isEmpty(fontAttrsCtx)) {
            return null;
        }
        Html.FontAttrs fontAttrs = Html.fontAttrs();
        for (HTMLParser.HtmlAttributeContext attr : fontAttrsCtx) {
            String attributeValue = attr.ATTVALUE_VALUE().getText();
            if (StringUtils.isEmpty((CharSequence)attributeValue)) continue;
            ParserUtils.setFontAttributes(fontAttrs, attr.TAG_NAME().getText(), HtmlListener.adaptAttrValue(attributeValue));
        }
        return fontAttrs;
    }

    private static String adaptAttrValue(String attributeValue) {
        if ((attributeValue = attributeValue.trim()).startsWith("'") && attributeValue.endsWith("'") || attributeValue.startsWith("\"") && attributeValue.endsWith("\"")) {
            attributeValue = attributeValue.substring(1, attributeValue.length() - 1).trim();
        }
        return attributeValue;
    }

    private static class Tag {
        private Html.LabelTag labelTag;
        private final Consumer<Html.LabelTag> labelTagCons;

        public Tag(Consumer<Html.LabelTag> labelTagCons) {
            this.labelTagCons = labelTagCons;
        }

        private void consumeTag() {
            this.labelTagCons.accept(this.labelTag);
        }
    }
}

