/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.Graphviz;
import org.graphper.parser.DotSyntaxErrorListener;
import org.graphper.parser.GraphvizListener;
import org.graphper.parser.NodeExtractor;
import org.graphper.parser.PostGraphComponents;
import org.graphper.parser.grammar.DOTLexer;
import org.graphper.parser.grammar.DOTParser;
import org.graphper.util.Asserts;

public class DotParser {
    private DotParser() {
    }

    public static Graphviz parse(File file) throws IOException {
        Asserts.nullArgument((Object)file);
        return DotParser.parse(file, StandardCharsets.UTF_8);
    }

    public static Graphviz parse(File file, Charset charset) throws IOException {
        Asserts.nullArgument((Object)file);
        charset = charset == null ? StandardCharsets.UTF_8 : charset;
        return DotParser.parse(Files.newInputStream(file.toPath(), new OpenOption[0]), charset);
    }

    public static Graphviz parse(InputStream in, Charset charset) throws IOException {
        return DotParser.parse(in, charset, "anonymous InputStream");
    }

    public static Graphviz parse(InputStream in, Charset charset, String sourceName) throws IOException {
        Asserts.nullArgument((Object)in);
        charset = charset == null ? StandardCharsets.UTF_8 : charset;
        try (InputStreamReader r = new InputStreamReader(in, charset);){
            CodePointCharStream charStream = CharStreams.fromReader((Reader)r, (String)sourceName);
            Graphviz graphviz = DotParser.parse((CharStream)charStream);
            return graphviz;
        }
    }

    public static Graphviz parse(String in) {
        return DotParser.parse(in, "anonymous String");
    }

    public static Graphviz parse(String in, String sourceName) {
        Asserts.illegalArgument((boolean)StringUtils.isEmpty((CharSequence)in), (String)"Empty dot");
        CodePointCharStream charStream = CharStreams.fromString((String)in, (String)sourceName);
        return DotParser.parse((CharStream)charStream);
    }

    public static Graphviz parse(CharStream charStream) {
        return DotParser.parse(charStream, null);
    }

    public static Graphviz parse(CharStream charStream, PostGraphComponents postGraphComponents) {
        Asserts.nullArgument((Object)charStream);
        DOTLexer lexer = new DOTLexer(charStream);
        DOTParser p = new DOTParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        p.removeErrorListeners();
        lexer.removeErrorListeners();
        DotSyntaxErrorListener dotSyntaxErrorListener = new DotSyntaxErrorListener();
        p.addErrorListener((ANTLRErrorListener)dotSyntaxErrorListener);
        lexer.addErrorListener((ANTLRErrorListener)dotSyntaxErrorListener);
        DOTParser.GraphContext graphCtx = p.graph();
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
        NodeExtractor nodeExtractor = new NodeExtractor(postGraphComponents);
        parseTreeWalker.walk((ParseTreeListener)nodeExtractor, (ParseTree)graphCtx);
        GraphvizListener gl = new GraphvizListener(nodeExtractor, postGraphComponents);
        parseTreeWalker.walk((ParseTreeListener)gl, (ParseTree)graphCtx);
        return gl.getGraphviz();
    }
}

