/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.granite.client.configuration.Configuration;
import org.granite.client.messaging.ClientAliasRegistry;
import org.granite.client.messaging.Consumer;
import org.granite.client.messaging.Producer;
import org.granite.client.messaging.RemoteService;
import org.granite.client.messaging.ResponseListener;
import org.granite.client.messaging.ResultFaultIssuesResponseListener;
import org.granite.client.messaging.ServerApp;
import org.granite.client.messaging.TopicAgent;
import org.granite.client.messaging.TopicSubscriptionListener;
import org.granite.client.messaging.channel.Channel;
import org.granite.client.messaging.channel.ChannelBuilder;
import org.granite.client.messaging.channel.ChannelFactory;
import org.granite.client.messaging.channel.ChannelStatusListener;
import org.granite.client.messaging.channel.ChannelStatusNotifier;
import org.granite.client.messaging.channel.Credentials;
import org.granite.client.messaging.channel.MessagingChannel;
import org.granite.client.messaging.channel.RemotingChannel;
import org.granite.client.messaging.channel.SessionAwareChannel;
import org.granite.client.messaging.channel.UsernamePasswordCredentials;
import org.granite.client.messaging.codec.MessagingCodec;
import org.granite.client.messaging.events.Event;
import org.granite.client.messaging.events.FaultEvent;
import org.granite.client.messaging.events.IncomingMessageEvent;
import org.granite.client.messaging.events.IssueEvent;
import org.granite.client.messaging.events.ResultEvent;
import org.granite.client.messaging.messages.responses.FaultMessage;
import org.granite.client.messaging.messages.responses.ResultMessage;
import org.granite.client.messaging.transport.Transport;
import org.granite.client.messaging.transport.TransportException;
import org.granite.client.messaging.transport.TransportStatusHandler;
import org.granite.client.platform.Platform;
import org.granite.client.tide.ApplicationConfigurable;
import org.granite.client.tide.Context;
import org.granite.client.tide.ContextAware;
import org.granite.client.tide.Identity;
import org.granite.client.tide.impl.FaultHandler;
import org.granite.client.tide.impl.ResultHandler;
import org.granite.client.tide.server.Fault;
import org.granite.client.tide.server.TideFaultEvent;
import org.granite.client.tide.server.TideResultEvent;
import org.granite.client.tide.server.TideRpcEvent;
import org.granite.client.validation.InvalidValue;
import org.granite.config.ConvertersConfig;
import org.granite.logging.Logger;
import org.granite.messaging.AliasRegistry;
import org.granite.util.ContentType;
import org.granite.util.TypeUtil;

@ApplicationConfigurable
@Named
public class ServerSession
implements ContextAware {
    private static Logger log = Logger.getLogger(ServerSession.class);
    public static final String SERVER_TIME_TAG = "org.granite.time";
    public static final String SESSION_ID_TAG = "org.granite.sessionId";
    public static final String SESSION_EXP_TAG = "org.granite.sessionExp";
    public static final String CONTEXT_RESULT = "org.granite.tide.result";
    public static final String CONTEXT_FAULT = "org.granite.tide.fault";
    public static final String LOGIN = "org.granite.client.tide.login";
    public static final String LOGOUT = "org.granite.client.tide.logout";
    public static final String SESSION_EXPIRED = "org.granite.client.tide.sessionExpired";
    private ServerApp serverApp;
    private ContentType contentType = ContentType.JMF_AMF;
    private ClientAliasRegistry aliasRegistry;
    private Class<? extends ChannelFactory> channelFactoryClass = null;
    private Transport remotingTransport = null;
    private Transport messagingTransport = null;
    private Map<String, Transport> messagingTransports = new HashMap<String, Transport>();
    private Context context = null;
    private Status status = new DefaultStatus();
    private String sessionId = null;
    private LogoutState logoutState = new LogoutState(1500L);
    private String destination = "server";
    private Object platformContext = null;
    private ChannelBuilder defaultChannelBuilder = null;
    private String defaultChannelType = null;
    private ChannelFactory channelFactory;
    private RemotingChannel remotingChannel = null;
    private Map<String, MessagingChannel> messagingChannelsByType = new HashMap<String, MessagingChannel>();
    protected Map<String, RemoteService> remoteServices = new HashMap<String, RemoteService>();
    protected Map<String, TopicAgent> topicAgents = new HashMap<String, TopicAgent>();
    private Set<String> packageNames = new HashSet<String>();
    private ConvertersConfig convertersConfig = null;
    private ServiceFactory serviceFactory = new DefaultServiceFactory();
    private ChannelStatusBinder channelStatusBinder = new ChannelStatusBinder();
    private final TopicSubscriptionListener consumerSubscriptionListener = new TopicSubscriptionListener(){

        public void onUnsubscribing(Consumer consumer) {
            ServerSession.this.checkWaitForLogout();
        }

        public void onUnsubscriptionSuccess(Consumer consumer, ResultEvent event, String subscriptionId) {
            ServerSession.this.tryLogout();
        }

        public void onUnsubscriptionFault(Consumer consumer, IssueEvent event, String subscriptionId) {
            ServerSession.this.tryLogout();
        }

        public void onSubscribing(Consumer consumer) {
            ServerSession.this.checkWaitForLogout();
        }

        public void onSubscriptionSuccess(Consumer consumer, ResultEvent event, String subscriptionId) {
            ServerSession.this.tryLogout();
        }

        public void onSubscriptionFault(Consumer consumer, IssueEvent event) {
            ServerSession.this.tryLogout();
        }
    };
    private ScheduledExecutorService sessionExpirationTimer = null;
    private ScheduledFuture<?> sessionExpirationFuture = null;
    private Runnable sessionExpirationTask = new Runnable(){

        @Override
        public void run() {
            Identity identity = ServerSession.this.context.byType(Identity.class);
            identity.checkLoggedIn(null);
        }
    };
    private final TransportStatusHandler statusHandler = new TransportStatusHandler(){
        private int busyCount = 0;
        private final Runnable setBusy = new Runnable(){

            @Override
            public void run() {
                ServerSession.this.status.setBusy(busyCount > 0);
            }
        };

        public void handleIO(boolean active) {
            this.busyCount = active ? ++this.busyCount : --this.busyCount;
            ServerSession.this.context.callLater(this.setBusy);
            ServerSession.this.notifyIOListeners(ServerSession.this.status.isBusy());
        }

        public void handleException(TransportException e) {
            log.debug((Throwable)e, "Transport failed", new Object[0]);
            ServerSession.this.notifyExceptionListeners(e);
        }
    };
    private long defaultTimeToLive = -1L;
    private List<TransportIOListener> transportIOListeners = new ArrayList<TransportIOListener>();
    private List<TransportExceptionListener> transportExceptionListeners = new ArrayList<TransportExceptionListener>();

    public ServerSession() throws Exception {
    }

    public ServerSession(String contextRoot, String serverName, int serverPort) {
        this(contextRoot, false, serverName, serverPort);
    }

    public ServerSession(String contextRoot, boolean secure, String serverName, int serverPort) {
        this.serverApp = new ServerApp(contextRoot, secure, serverName, serverPort);
    }

    public ServerSession(ServerApp serverApp) {
        this.serverApp = serverApp;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        if (contentType == null) {
            throw new NullPointerException("contentType cannot be null");
        }
        this.contentType = contentType;
    }

    public void setDefaultChannelBuilder(ChannelBuilder channelBuilder) {
        this.defaultChannelBuilder = channelBuilder;
        if (this.channelFactory != null) {
            this.channelFactory.setDefaultChannelBuilder(this.defaultChannelBuilder);
        }
    }

    public void setDefaultChannelType(String channelType) {
        this.defaultChannelType = channelType;
        if (this.channelFactory != null) {
            this.channelFactory.setDefaultChannelType(this.defaultChannelType);
        }
    }

    public void setChannelFactoryClass(Class<? extends ChannelFactory> channelFactoryClass) {
        this.channelFactoryClass = channelFactoryClass;
    }

    public void setServerApp(ServerApp serverApp) {
        this.serverApp = serverApp;
    }

    public void setLogoutTimeout(long timeout) {
        this.logoutState.setTimeout(timeout);
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
        if (this.platformContext == null) {
            this.platformContext = context.getPlatformContext();
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void setPlatformContext(Object platformContext) {
        this.platformContext = platformContext;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setRemotingTransport(Transport transport) {
        this.remotingTransport = transport;
    }

    public void setMessagingTransport(Transport transport) {
        this.messagingTransport = transport;
    }

    public void setMessagingTransport(String channelType, Transport transport) {
        this.messagingTransports.put(channelType, transport);
    }

    public void addRemoteAliasPackage(String packageName) {
        this.packageNames.add(packageName);
    }

    public void setRemoteAliasPackages(Set<String> packageNames) {
        this.packageNames.clear();
        this.packageNames.addAll(packageNames);
    }

    public ClientAliasRegistry getAliasRegistry() {
        return this.aliasRegistry;
    }

    public Object convert(Object value, Type expectedType) {
        if (this.contentType == ContentType.JMF_AMF || this.convertersConfig == null) {
            return value;
        }
        return this.convertersConfig.getConverters().convert(value, expectedType);
    }

    public void start() {
        block20: {
            if (this.channelFactory != null) {
                return;
            }
            this.aliasRegistry = new ClientAliasRegistry();
            this.aliasRegistry.registerAlias(InvalidValue.class);
            if (this.channelFactoryClass != null) {
                Constructor<? extends ChannelFactory> constructor = null;
                try {
                    constructor = this.channelFactoryClass.getConstructor(Object.class, Configuration.class);
                    Configuration configuration = Platform.getInstance().newConfiguration();
                    configuration.setClientType(MessagingCodec.ClientType.JAVA);
                    configuration.load();
                    this.convertersConfig = (ConvertersConfig)configuration.getGraniteConfig();
                    try {
                        this.channelFactory = constructor.newInstance(this.platformContext, configuration);
                        break block20;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not create ChannelFactory", e);
                    }
                }
                catch (NoSuchMethodException nsme) {
                    try {
                        constructor = this.channelFactoryClass.getConstructor(Object.class);
                        this.channelFactory = constructor.newInstance(this.platformContext);
                        break block20;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not create ChannelFactory", e);
                    }
                }
            }
            if (this.contentType == ContentType.JMF_AMF) {
                try {
                    this.channelFactory = (ChannelFactory)TypeUtil.newInstance((String)"org.granite.client.messaging.channel.JMFChannelFactory", (Class[])new Class[]{Object.class}, (Object[])new Object[]{this.platformContext});
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create JMFChannelFactory", e);
                }
            }
            Configuration configuration = Platform.getInstance().newConfiguration();
            configuration.setClientType(MessagingCodec.ClientType.JAVA);
            configuration.load();
            this.convertersConfig = (ConvertersConfig)configuration.getGraniteConfig();
            try {
                this.channelFactory = (ChannelFactory)TypeUtil.newInstance((String)"org.granite.client.messaging.channel.AMFChannelFactory", (Class[])new Class[]{Object.class, Configuration.class}, (Object[])new Object[]{this.platformContext, configuration});
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create AMFChannelFactory", e);
            }
        }
        this.channelFactory.setAliasRegistry((AliasRegistry)this.aliasRegistry);
        this.channelFactory.setScanPackageNames(this.packageNames);
        if (this.defaultChannelType != null) {
            this.channelFactory.setDefaultChannelType(this.defaultChannelType);
        }
        if (this.remotingTransport != null) {
            this.channelFactory.setRemotingTransport(this.remotingTransport);
        }
        if (this.messagingTransport != null) {
            this.channelFactory.setMessagingTransport(this.messagingTransport);
        }
        for (Map.Entry<String, Transport> me : this.messagingTransports.entrySet()) {
            this.channelFactory.setMessagingTransport(me.getKey(), me.getValue());
        }
        if (this.defaultChannelBuilder != null) {
            this.channelFactory.setDefaultChannelBuilder(this.defaultChannelBuilder);
        }
        if (this.defaultTimeToLive >= 0L) {
            this.channelFactory.setDefaultTimeToLive(this.defaultTimeToLive);
        }
        this.channelFactory.start();
        this.channelFactory.getRemotingTransport().setStatusHandler(this.statusHandler);
        for (Transport transport : this.channelFactory.getMessagingTransports().values()) {
            transport.setStatusHandler(this.statusHandler);
        }
        this.remotingChannel = this.channelFactory.newRemotingChannel("graniteamf", this.serverApp, 1);
        this.setupChannel((Channel)this.remotingChannel);
        this.sessionExpirationTimer = Executors.newSingleThreadScheduledExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            if (this.sessionExpirationFuture != null) {
                this.sessionExpirationFuture.cancel(false);
                this.sessionExpirationFuture = null;
            }
            if (this.sessionExpirationTimer != null) {
                this.sessionExpirationTimer.shutdownNow();
                this.sessionExpirationTimer = null;
            }
        }
        finally {
            if (this.channelFactory != null) {
                this.channelFactory.stop();
                this.channelFactory = null;
            }
            this.unsetupChannel((Channel)this.remotingChannel);
            this.remotingChannel = null;
            for (Channel channel : this.messagingChannelsByType.values()) {
                this.unsetupChannel(channel);
            }
            this.messagingChannelsByType.clear();
            this.aliasRegistry = null;
        }
    }

    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    private void setupChannel(Channel channel) {
        channel.addListener((ChannelStatusListener)this.channelStatusBinder);
        channel.bindStatus((ChannelStatusNotifier)this.channelStatusBinder);
    }

    private void unsetupChannel(Channel channel) {
        channel.removeListener((ChannelStatusListener)this.channelStatusBinder);
        channel.unbindStatus((ChannelStatusNotifier)this.channelStatusBinder);
    }

    public RemoteService getRemoteService() {
        return this.getRemoteService(this.destination);
    }

    public synchronized RemoteService getRemoteService(String destination) {
        if (this.remotingChannel == null) {
            throw new IllegalStateException("Channel not defined for server session");
        }
        RemoteService remoteService = this.remoteServices.get(destination);
        if (remoteService == null) {
            remoteService = this.serviceFactory.newRemoteService(this.remotingChannel, destination);
            this.remoteServices.put(destination, remoteService);
        }
        return remoteService;
    }

    public MessagingChannel getMessagingChannel(String channelType) {
        MessagingChannel messagingChannel = this.messagingChannelsByType.get(channelType);
        if (messagingChannel != null) {
            return messagingChannel;
        }
        messagingChannel = this.channelFactory.newMessagingChannel(channelType, channelType + "amf", this.serverApp);
        messagingChannel.setSessionId(this.sessionId);
        this.setupChannel((Channel)messagingChannel);
        this.messagingChannelsByType.put(channelType, messagingChannel);
        return messagingChannel;
    }

    public synchronized Consumer getConsumer(String destination, String topic, String channelType) {
        MessagingChannel messagingChannel;
        if (channelType == null) {
            channelType = this.channelFactory.getDefaultChannelType();
        }
        if ((messagingChannel = this.getMessagingChannel(channelType)) == null) {
            throw new IllegalStateException("Channel not defined in server session for type " + channelType + "");
        }
        String key = "C:" + destination + '@' + topic;
        Consumer consumer = (Consumer)this.topicAgents.get(key);
        if (consumer == null) {
            consumer = this.serviceFactory.newConsumer(messagingChannel, destination, topic);
            consumer.addSubscriptionListener(this.consumerSubscriptionListener);
            this.topicAgents.put(key, (TopicAgent)consumer);
        }
        return consumer;
    }

    public synchronized Consumer getConsumer(String destination, String topic) {
        return this.getConsumer(destination, topic, this.channelFactory.getDefaultChannelType());
    }

    public synchronized void removeConsumer(Consumer consumer) {
        String key = "C:" + consumer.getDestination() + "@" + consumer.getTopic();
        if (this.topicAgents.get(key) != consumer) {
            throw new IllegalArgumentException("Consumer " + key + " not managed by session");
        }
        consumer.removeSubscriptionListener(this.consumerSubscriptionListener);
        this.topicAgents.remove(key);
    }

    public synchronized Producer getProducer(String destination, String topic, String channelType) {
        MessagingChannel messagingChannel;
        if (channelType == null) {
            channelType = this.channelFactory.getDefaultChannelType();
        }
        if ((messagingChannel = this.getMessagingChannel(channelType)) == null) {
            throw new IllegalStateException("Channel not defined for server session");
        }
        String key = "P:" + destination + '@' + topic;
        Producer producer = (Producer)this.topicAgents.get(key);
        if (producer == null) {
            producer = this.serviceFactory.newProducer(messagingChannel, destination, topic);
            this.topicAgents.put(key, (TopicAgent)producer);
        }
        return producer;
    }

    public synchronized Producer getProducer(String destination, String topic) {
        return this.getProducer(destination, topic, this.channelFactory.getDefaultChannelType());
    }

    public synchronized void removeProducer(Producer producer) {
        String key = "P:" + producer.getDestination() + "@" + producer.getTopic();
        if (this.topicAgents.get(key) != producer) {
            throw new IllegalArgumentException("Producer " + key + " not managed by session");
        }
        this.topicAgents.remove(key);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isLogoutInProgress() {
        return this.logoutState.logoutInProgress;
    }

    private void rescheduleSessionExpirationTask(long serverTime, int sessionExpirationDelay) {
        Identity identity = this.context.byType(Identity.class);
        if (identity == null || !identity.isLoggedIn()) {
            return;
        }
        long clientOffset = serverTime - new Date().getTime();
        this.sessionExpirationFuture = this.sessionExpirationTimer.schedule(this.sessionExpirationTask, clientOffset + (long)sessionExpirationDelay * 1000L + 1500L, TimeUnit.MILLISECONDS);
    }

    public void onResultEvent(Event event) {
        if (this.sessionExpirationFuture != null) {
            this.sessionExpirationFuture.cancel(false);
        }
        String oldSessionId = this.sessionId;
        if (event instanceof ResultEvent) {
            ResultMessage message = (ResultMessage)((ResultEvent)event).getMessage();
            this.sessionId = (String)message.getHeader(SESSION_ID_TAG);
            if (this.sessionId != null) {
                long serverTime = (Long)message.getHeader(SERVER_TIME_TAG);
                int sessionExpirationDelay = (Integer)message.getHeader(SESSION_EXP_TAG);
                this.rescheduleSessionExpirationTask(serverTime, sessionExpirationDelay);
            }
        } else if (event instanceof IncomingMessageEvent) {
            this.sessionId = (String)((IncomingMessageEvent)event).getMessage().getHeader(SESSION_ID_TAG);
        }
        if (this.sessionId == null && oldSessionId != null || this.sessionId != null && !this.sessionId.equals(oldSessionId)) {
            log.debug("Received new sessionId %s (!= %s)", new Object[]{this.sessionId, oldSessionId});
        }
        if (oldSessionId != null || this.sessionId != null) {
            for (MessagingChannel messagingChannel : this.messagingChannelsByType.values()) {
                messagingChannel.setSessionId(this.sessionId);
            }
        }
        this.status.setConnected(true);
    }

    public void onFaultEvent(FaultEvent event, FaultMessage emsg) {
        if (this.sessionExpirationFuture != null) {
            this.sessionExpirationFuture.cancel(false);
        }
        String oldSessionId = this.sessionId;
        this.sessionId = (String)((FaultMessage)event.getMessage()).getHeader(SESSION_ID_TAG);
        if (this.sessionId != null) {
            long serverTime = (Long)((FaultMessage)event.getMessage()).getHeader(SERVER_TIME_TAG);
            int sessionExpirationDelay = (Integer)((FaultMessage)event.getMessage()).getHeader(SESSION_EXP_TAG);
            this.rescheduleSessionExpirationTask(serverTime, sessionExpirationDelay);
        }
        if (this.sessionId == null || !this.sessionId.equals(oldSessionId)) {
            log.info("Received new sessionId %s", new Object[]{this.sessionId});
        }
        if (oldSessionId != null || this.sessionId != null) {
            for (MessagingChannel messagingChannel : this.messagingChannelsByType.values()) {
                messagingChannel.setSessionId(this.sessionId);
            }
        }
        if (emsg != null && emsg.getCode().equals((Object)FaultMessage.Code.SERVER_CALL_FAILED)) {
            this.status.setConnected(false);
        }
    }

    public void onIssueEvent(IssueEvent event) {
        if (event.getType() != Event.Type.CANCELLED) {
            this.status.setConnected(false);
        }
    }

    public Transport getRemotingTransport() {
        return this.channelFactory != null ? this.channelFactory.getRemotingTransport() : this.remotingTransport;
    }

    public Transport getMessagingTransport() {
        return this.channelFactory != null ? this.channelFactory.getMessagingTransport() : this.messagingTransport;
    }

    public void login(String username, String password) {
        this.remotingChannel.setCredentials((Credentials)new UsernamePasswordCredentials(username, password));
        for (MessagingChannel messagingChannel : this.messagingChannelsByType.values()) {
            messagingChannel.setCredentials((Credentials)new UsernamePasswordCredentials(username, password));
        }
    }

    public void login(String username, String password, Charset charset) {
        this.remotingChannel.setCredentials((Credentials)new UsernamePasswordCredentials(username, password, charset));
        for (MessagingChannel messagingChannel : this.messagingChannelsByType.values()) {
            messagingChannel.setCredentials((Credentials)new UsernamePasswordCredentials(username, password, charset));
        }
    }

    public void afterLogin() {
        log.info("Application session authenticated", new Object[0]);
        this.context.getEventBus().raiseEvent(this.context, LOGIN, new Object[0]);
    }

    public void sessionExpired() {
        log.info("Application session expired", new Object[0]);
        this.logoutState.sessionExpired();
        this.context.getEventBus().raiseEvent(this.context, SESSION_EXPIRED, new Object[0]);
        this.context.getEventBus().raiseEvent(this.context, LOGOUT, new Object[0]);
        this.remotingChannel.logout(false, new ResponseListener[0]);
        for (MessagingChannel messagingChannel : this.messagingChannelsByType.values()) {
            messagingChannel.logout(false, new ResponseListener[0]);
        }
        this.sessionId = null;
        if (this.remotingChannel instanceof SessionAwareChannel) {
            ((SessionAwareChannel)this.remotingChannel).setSessionId(null);
        }
        for (MessagingChannel messagingChannel : this.messagingChannelsByType.values()) {
            messagingChannel.setSessionId(null);
        }
    }

    public void logout(final Observer logoutObserver) {
        if (this.sessionExpirationFuture != null) {
            this.sessionExpirationFuture.cancel(false);
            this.sessionExpirationFuture = null;
        }
        this.logoutState.logout(logoutObserver, new TimerTask(){

            @Override
            public void run() {
                log.info("Force session logout", new Object[0]);
                ServerSession.this.logoutState.logout(logoutObserver);
                ServerSession.this.tryLogout();
            }
        });
        this.context.getEventBus().raiseEvent(this.context, LOGOUT, new Object[0]);
        this.tryLogout();
    }

    public void checkWaitForLogout() {
        this.logoutState.checkWait();
    }

    public void tryLogout() {
        if (this.logoutState.stillWaiting()) {
            return;
        }
        if (this.logoutState.isSessionExpired()) {
            this.logoutState.loggedOut(null);
            return;
        }
        if (this.remotingChannel != null) {
            this.remotingChannel.logout(new ResponseListener[]{new ResultFaultIssuesResponseListener(){

                public void onResult(final ResultEvent event) {
                    ServerSession.this.context.callLater(new Runnable(){

                        @Override
                        public void run() {
                            log.info("Application session logged out", new Object[0]);
                            new ResultHandler(ServerSession.this, null, "logout").handleResult(ServerSession.this.context, null, null);
                            ServerSession.this.context.getContextManager().destroyContexts();
                            ServerSession.this.logoutState.loggedOut(new TideResultEvent<Object>(ServerSession.this.context, ServerSession.this, null, event.getResult()));
                        }
                    });
                }

                public void onFault(final FaultEvent event) {
                    ServerSession.this.context.callLater(new Runnable(){

                        @Override
                        public void run() {
                            log.error("Could not log out %s", new Object[]{event.getDescription()});
                            new FaultHandler(ServerSession.this, null, "logout").handleFault(ServerSession.this.context, (FaultMessage)event.getMessage(), null);
                            Fault fault = new Fault(event.getCode(), event.getDescription(), event.getDetails(), event.getUnknownCode());
                            fault.setContent(event.getMessage());
                            fault.setCause(event.getCause());
                            ServerSession.this.logoutState.loggedOut(new TideFaultEvent(ServerSession.this.context, ServerSession.this, null, fault, event.getExtended()));
                        }
                    });
                }

                public void onIssue(final IssueEvent event) {
                    ServerSession.this.context.callLater(new Runnable(){

                        @Override
                        public void run() {
                            log.error("Could not logout %s", new Object[]{event.getType()});
                            new FaultHandler(ServerSession.this, null, "logout").handleFault(ServerSession.this.context, null, null);
                            Fault fault = new Fault(FaultMessage.Code.SERVER_CALL_FAILED, event.getType().name(), "", null);
                            ServerSession.this.logoutState.loggedOut(new TideFaultEvent(ServerSession.this.context, ServerSession.this, null, fault, null));
                        }
                    });
                }
            }});
        }
        for (MessagingChannel messagingChannel : this.messagingChannelsByType.values()) {
            if (messagingChannel == this.remotingChannel) continue;
            messagingChannel.logout(new ResponseListener[0]);
        }
    }

    public void setDefaultTimeToLive(long timeToLive) {
        this.defaultTimeToLive = timeToLive;
        if (this.channelFactory != null) {
            this.channelFactory.setDefaultTimeToLive(timeToLive);
        }
        for (MessagingChannel messagingChannel : this.messagingChannelsByType.values()) {
            messagingChannel.setDefaultTimeToLive(timeToLive);
        }
        if (this.remotingChannel != null) {
            this.remotingChannel.setDefaultTimeToLive(timeToLive);
        }
    }

    public void addListener(TransportIOListener listener) {
        this.transportIOListeners.add(listener);
    }

    public void removeListener(TransportIOListener listener) {
        this.transportIOListeners.remove(listener);
    }

    public void addListener(TransportExceptionListener listener) {
        this.transportExceptionListeners.add(listener);
    }

    public void removeListener(TransportExceptionListener listener) {
        this.transportExceptionListeners.remove(listener);
    }

    public void notifyIOListeners(boolean busy) {
        for (TransportIOListener listener : this.transportIOListeners) {
            listener.handleIO(busy);
        }
    }

    public void notifyExceptionListeners(TransportException e) {
        for (TransportExceptionListener listener : this.transportExceptionListeners) {
            listener.handleException(e);
        }
    }

    public static interface TransportExceptionListener {
        public void handleException(TransportException var1);
    }

    public static interface TransportIOListener {
        public void handleIO(boolean var1);
    }

    public static class DefaultStatus
    implements Status {
        private boolean showBusyCursor = true;
        private boolean connected = false;
        private boolean busy = false;

        @Override
        public boolean isBusy() {
            return this.busy;
        }

        @Override
        public void setBusy(boolean busy) {
            this.busy = busy;
        }

        @Override
        public boolean isConnected() {
            return this.connected;
        }

        @Override
        public void setConnected(boolean connected) {
            this.connected = connected;
        }

        @Override
        public boolean isShowBusyCursor() {
            return this.showBusyCursor;
        }

        @Override
        public void setShowBusyCursor(boolean showBusyCursor) {
            this.showBusyCursor = showBusyCursor;
        }
    }

    public static interface Status {
        public boolean isBusy();

        public void setBusy(boolean var1);

        public boolean isConnected();

        public void setConnected(boolean var1);

        public boolean isShowBusyCursor();

        public void setShowBusyCursor(boolean var1);
    }

    private static class LogoutState
    extends Observable {
        private long timeout = 1500L;
        private boolean logoutInProgress = false;
        private int waitForLogout = 0;
        private boolean sessionExpired = false;
        private Timer logoutTimeout = null;

        public LogoutState(long timeout) {
            this.timeout = timeout;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public synchronized void logout(Observer logoutObserver, TimerTask forceLogout) {
            this.logout(logoutObserver);
            this.logoutTimeout = new Timer(true);
            this.logoutTimeout.schedule(forceLogout, this.timeout);
        }

        public synchronized void logout(Observer logoutObserver) {
            if (logoutObserver != null) {
                this.addObserver(logoutObserver);
            }
            if (!this.logoutInProgress) {
                this.logoutInProgress = true;
                this.waitForLogout = 1;
            }
        }

        public synchronized void checkWait() {
            if (this.logoutInProgress) {
                ++this.waitForLogout;
            }
        }

        public synchronized boolean stillWaiting() {
            if (this.sessionExpired) {
                return false;
            }
            if (!this.logoutInProgress) {
                return true;
            }
            --this.waitForLogout;
            return this.waitForLogout > 0;
        }

        public boolean isSessionExpired() {
            return this.sessionExpired;
        }

        public synchronized void loggedOut(TideRpcEvent event) {
            if (this.logoutTimeout != null) {
                this.logoutTimeout.cancel();
                this.logoutTimeout = null;
            }
            if (event != null) {
                this.setChanged();
                this.notifyObservers(event);
                this.deleteObservers();
            }
            this.logoutInProgress = false;
            this.waitForLogout = 0;
            this.sessionExpired = false;
        }

        public synchronized void sessionExpired() {
            this.logoutInProgress = false;
            this.waitForLogout = 0;
            this.sessionExpired = true;
        }
    }

    private class ChannelStatusBinder
    implements ChannelStatusListener,
    ChannelStatusNotifier {
        private List<ChannelStatusListener> listeners = new ArrayList<ChannelStatusListener>();

        private ChannelStatusBinder() {
        }

        public void addListener(ChannelStatusListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ChannelStatusListener listener) {
            this.listeners.remove(listener);
        }

        public void pingedChanged(Channel channel, boolean pinged) {
            for (ChannelStatusListener listener : this.listeners) {
                listener.pingedChanged(channel, pinged);
            }
        }

        public void authenticatedChanged(Channel channel, boolean authenticated) {
            for (ChannelStatusListener listener : this.listeners) {
                listener.authenticatedChanged(channel, authenticated);
            }
        }

        public void fault(Channel channel, final FaultMessage faultMessage) {
            ServerSession.this.context.callLater(new Runnable(){

                @Override
                public void run() {
                    new FaultHandler(ServerSession.this, null, "channel").handleFault(ServerSession.this.context, faultMessage, null);
                }
            });
        }
    }

    private static class DefaultServiceFactory
    implements ServiceFactory {
        private DefaultServiceFactory() {
        }

        @Override
        public RemoteService newRemoteService(RemotingChannel remotingChannel, String destination) {
            return new RemoteService((Channel)remotingChannel, destination);
        }

        @Override
        public Producer newProducer(MessagingChannel messagingChannel, String destination, String topic) {
            return new Producer(messagingChannel, destination, topic);
        }

        @Override
        public Consumer newConsumer(MessagingChannel messagingChannel, String destination, String topic) {
            return new Consumer(messagingChannel, destination, topic);
        }
    }

    public static interface ServiceFactory {
        public RemoteService newRemoteService(RemotingChannel var1, String var2);

        public Producer newProducer(MessagingChannel var1, String var2, String var3);

        public Consumer newConsumer(MessagingChannel var1, String var2, String var3);
    }
}

