/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.security.spring;

import javax.inject.Named;
import org.granite.client.messaging.RemoteAlias;
import org.granite.client.tide.BaseIdentity;
import org.granite.client.tide.security.TidePermissionCache;
import org.granite.client.tide.security.TideRoleCache;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.tide.server.TideResponder;

@RemoteAlias(value="org.granite.tide.spring.security.Identity")
@Named
public class Identity
extends BaseIdentity {
    private final TideRoleCache ifAllGrantedCache = new TideRoleCache(this, "ifAllGranted");
    private final TideRoleCache ifAnyGrantedCache = new TideRoleCache(this, "ifAnyGranted");
    private final TideRoleCache ifNotGrantedCache = new TideRoleCache(this, "ifNotGranted");
    private final TidePermissionCache hasPermissionCache = new TidePermissionCache(this);

    public Identity() {
    }

    public Identity(ServerSession serverSession) {
        super(serverSession);
    }

    public boolean hasRole(String roleName, TideResponder<Boolean> tideResponder) {
        return this.ifAllGranted(roleName, tideResponder);
    }

    public boolean ifAllGranted(String roleName, TideResponder<Boolean> tideResponder) {
        return this.ifAllGrantedCache.get(roleName, tideResponder);
    }

    public boolean ifAnyGranted(String roleName, TideResponder<Boolean> tideResponder) {
        return this.ifAnyGrantedCache.get(roleName, tideResponder);
    }

    public boolean ifNotGranted(String roleName, TideResponder<Boolean> tideResponder) {
        return this.ifNotGrantedCache.get(roleName, tideResponder);
    }

    public boolean hasPermission(Object object, String action, TideResponder<Boolean> tideResponder) {
        return this.hasPermissionCache.get(object, action, tideResponder);
    }

    protected void initSecurityCache() {
        this.ifAllGrantedCache.clear();
        this.ifAnyGrantedCache.clear();
        this.ifNotGrantedCache.clear();
        this.hasPermissionCache.clear();
    }

    @Override
    public void clearSecurityCache() {
        super.clearSecurityCache();
        this.ifAllGrantedCache.clear();
        this.ifAnyGrantedCache.clear();
        this.ifNotGrantedCache.clear();
        this.hasPermissionCache.clear();
    }
}

