/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.granite.client.tide.Context;
import org.granite.client.tide.Factory;

public class InstanceFactory {
    private List<Factory<?>> initializers = new ArrayList();
    private Map<String, Factory<?>> factoriesByName = new HashMap();
    private Map<Class<?>, List<Factory<?>>> factoriesByType = new HashMap();

    public void initModules(Set<Class<?>> moduleClasses) {
        for (Class<?> moduleClass : moduleClasses) {
            this.setupModule(moduleClass);
        }
    }

    private void setupModule(Class<?> moduleClass) {
        for (Method method : moduleClass.getMethods()) {
            if (method.getDeclaringClass() != moduleClass || !Modifier.isStatic(method.getModifiers())) continue;
            Class<?> type = method.getReturnType();
            if (type == Void.class || type == Void.TYPE) {
                this.initializers.add(new MethodFactory(method));
                continue;
            }
            if (method.isAnnotationPresent(Named.class)) {
                String name = method.getAnnotation(Named.class).value();
                if ("".equals(name)) {
                    name = method.getName();
                }
                this.registerFactory(name, new MethodFactory(method, name));
                continue;
            }
            this.registerFactory(type, new MethodFactory(method));
        }
    }

    public void registerFactory(String name, Factory<?> factory) {
        this.factoriesByName.put(name, factory);
        for (Class<?> type : factory.getTargetTypes()) {
            this.registerFactory(type, factory);
        }
    }

    public void registerFactory(Class<?> type, Factory<?> factory) {
        List<Factory<?>> factories = this.factoriesByType.get(type);
        if (factories == null) {
            factories = new ArrayList();
            this.factoriesByType.put(type, factories);
        } else if (factories.get(0).isSingleton() != factory.isSingleton()) {
            throw new IllegalStateException("Cannot define different scopes for factories of type " + type);
        }
        factories.add(factory);
    }

    public void initContext(Context context) {
        for (Factory<?> factory : this.initializers) {
            if (factory.isSingleton() != context.isGlobal()) continue;
            factory.create(context);
        }
    }

    public Factory<?> forName(String name, boolean singleton) {
        Factory<?> factory = this.factoriesByName.get(name);
        if (factory == null) {
            return null;
        }
        return factory.isSingleton() || !singleton ? factory : null;
    }

    public List<Factory<?>> forType(Class<?> type, boolean singleton) {
        ArrayList factories = new ArrayList();
        for (Map.Entry<Class<?>, List<Factory<?>>> me : this.factoriesByType.entrySet()) {
            if (!type.isAssignableFrom(me.getKey())) continue;
            for (Factory<?> factory : me.getValue()) {
                if (!factory.isSingleton() && singleton || factories.contains(factory)) continue;
                factories.add(factory);
            }
        }
        return factories;
    }

    private static class MethodFactory<T>
    implements Factory<T> {
        private final Method method;
        private final String name;
        private final boolean singleton;

        public MethodFactory(Method method, String name) {
            this.method = method;
            this.name = name;
            this.singleton = method.isAnnotationPresent(Singleton.class);
        }

        public MethodFactory(Method method) {
            this(method, null);
        }

        @Override
        public boolean isSingleton() {
            return this.singleton;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public T create(Context context) {
            Class<?>[] parametersTypes = this.method.getParameterTypes();
            Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
            Object[] args = new Object[parametersTypes.length];
            for (int i = 0; i < parametersTypes.length; ++i) {
                if (parametersTypes[i] == Context.class) {
                    args[i] = context;
                    continue;
                }
                String name = null;
                for (Annotation annotation : parameterAnnotations[i]) {
                    if (annotation.annotationType() != Named.class) continue;
                    name = ((Named)annotation).value();
                    if (!"".equals(name)) break;
                    throw new RuntimeException("Can not inject @Named value without explicit name for method " + this.method.getName() + " argument " + i);
                }
                if (name != null) {
                    args[i] = context.byName(name);
                    if (args[i] != null) continue;
                    throw new RuntimeException("Cannot find injected value named " + name + " for arg " + i + " of method " + this.method.toGenericString());
                }
                args[i] = context.byType(parametersTypes[i]);
                if (args[i] != null) continue;
                throw new RuntimeException("Cannot find injected value of type " + parametersTypes[i] + " for arg " + i + " of method " + this.method.toGenericString());
            }
            try {
                return (T)this.method.invoke(null, args);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create instance with method " + this.method.toGenericString(), e);
            }
        }

        @Override
        public Set<Class<?>> getTargetTypes() {
            HashSet targetTypes = new HashSet();
            targetTypes.add(this.method.getReturnType());
            Class<?>[] arr$ = this.method.getReturnType().getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Class<?> itf;
                Class<?> i = itf = arr$[i$];
                do {
                    targetTypes.add(i);
                } while ((i = i.getSuperclass()) != null && i != Object.class);
            }
            return targetTypes;
        }
    }
}

