/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.impl;

import java.util.Map;
import org.granite.client.messaging.events.Event;
import org.granite.client.messaging.events.FailureEvent;
import org.granite.client.messaging.events.FaultEvent;
import org.granite.client.messaging.events.IssueEvent;
import org.granite.client.messaging.events.TimeoutEvent;
import org.granite.client.messaging.messages.responses.FaultMessage;
import org.granite.client.tide.Context;
import org.granite.client.tide.server.ComponentListener;
import org.granite.client.tide.server.ExceptionHandler;
import org.granite.client.tide.server.Fault;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.tide.server.TideFaultEvent;
import org.granite.client.tide.server.TideResponder;
import org.granite.logging.Logger;

public class FaultHandler<T>
implements Runnable {
    private static final Logger log = Logger.getLogger(FaultHandler.class);
    private final ServerSession serverSession;
    private final Context sourceContext;
    private final String componentName;
    private final String operation;
    private final Event event;
    private final Object info;
    private final TideResponder<T> tideResponder;
    private final ComponentListener<T> componentListener;
    private boolean executed = false;

    public FaultHandler(ServerSession serverSession, String componentName, String operation) {
        this.serverSession = serverSession;
        this.sourceContext = null;
        this.componentName = componentName;
        this.operation = operation;
        this.event = null;
        this.info = null;
        this.tideResponder = null;
        this.componentListener = null;
    }

    public FaultHandler(ServerSession serverSession, Context sourceContext, String componentName, String operation, Event event, Object info, TideResponder<T> tideResponder, ComponentListener<T> componentListener) {
        this.serverSession = serverSession;
        this.sourceContext = sourceContext;
        this.componentName = componentName;
        this.operation = operation;
        this.event = event;
        this.info = info;
        this.tideResponder = tideResponder;
        this.componentListener = componentListener;
    }

    public FaultHandler(ServerSession serverSession, Event event) {
        this.serverSession = serverSession;
        this.sourceContext = null;
        this.componentName = null;
        this.operation = null;
        this.event = event;
        this.info = null;
        this.tideResponder = null;
        this.componentListener = null;
    }

    @Override
    public void run() {
        if (this.executed) {
            return;
        }
        this.executed = true;
        log.debug("fault %s", new Object[]{this.event.toString()});
        Context context = this.sourceContext.getContextManager().retrieveContext(this.sourceContext, null, false, false);
        FaultMessage emsg = null;
        Map extendedData = null;
        if (this.event instanceof FaultEvent) {
            Object m = emsg = (FaultMessage)((FaultEvent)this.event).getMessage();
            Map map = extendedData = emsg != null ? emsg.getExtended() : null;
            do {
                if (m == null || m.getCode() == null || !m.isSecurityFault()) continue;
                emsg = m;
                extendedData = emsg != null ? emsg.getExtended() : null;
                break;
            } while ((m = m != null && m.getCause() instanceof FaultEvent ? (FaultMessage)((FaultEvent)m.getCause()).getCause() : (m.getCause() instanceof FaultMessage ? (FaultMessage)m.getCause() : null)) != null);
            this.serverSession.onFaultEvent((FaultEvent)this.event, emsg);
        } else {
            this.serverSession.onIssueEvent((IssueEvent)this.event);
        }
        boolean handled = this.handleFault(context, emsg, extendedData);
        if (!handled && !this.serverSession.isLogoutInProgress()) {
            context.getEventBus().raiseEvent(context, "org.granite.tide.fault", this.event instanceof FaultEvent ? (FaultMessage)((FaultEvent)this.event).getMessage() : null);
        }
        this.serverSession.tryLogout();
    }

    public boolean handleFault(Context context, FaultMessage emsg, Map<String, Object> extendedData) {
        boolean handled = false;
        Fault fault = null;
        if (this.event instanceof FaultEvent) {
            fault = new Fault(emsg.getCode(), emsg.getDescription(), emsg.getDetails(), emsg.getUnknownCode());
            fault.setContent(((FaultEvent)this.event).getMessage());
            fault.setCause(((FaultEvent)this.event).getCause());
        } else if (this.event != null && this.event.getType() == Event.Type.FAILURE) {
            fault = new Fault(FaultMessage.Code.CLIENT_CALL_FAILED, null, ((FailureEvent)this.event).getCause() != null ? ((FailureEvent)this.event).getCause().getMessage() : null, null);
            fault.setCause(((FailureEvent)this.event).getCause());
            emsg = new FaultMessage(null, null, FaultMessage.Code.CLIENT_CALL_FAILED, null, null, null, null);
        } else if (this.event != null && this.event.getType() == Event.Type.TIMEOUT) {
            fault = new Fault(FaultMessage.Code.CLIENT_CALL_TIMED_OUT, null, String.valueOf(((TimeoutEvent)this.event).getTime()), null);
            emsg = new FaultMessage(null, null, FaultMessage.Code.CLIENT_CALL_TIMED_OUT, null, null, null, null);
        } else if (this.event != null && this.event.getType() == Event.Type.CANCELLED) {
            fault = new Fault(FaultMessage.Code.CLIENT_CALL_CANCELLED, null, null, null);
            emsg = new FaultMessage(null, null, FaultMessage.Code.CLIENT_CALL_CANCELLED, null, null, null, null);
        } else if (this.event == null && emsg != null) {
            fault = new Fault(emsg.getCode(), emsg.getDescription(), emsg.getDetails(), emsg.getUnknownCode());
        } else {
            fault = emsg != null ? new Fault(FaultMessage.Code.UNKNOWN, emsg.getDescription(), emsg.getDetails(), emsg.getUnknownCode()) : new Fault(FaultMessage.Code.UNKNOWN, null, null, null);
            emsg = new FaultMessage(null, null, FaultMessage.Code.UNKNOWN, null, null, null, null);
        }
        TideFaultEvent faultEvent = new TideFaultEvent(context, this.serverSession, this.componentListener, fault, extendedData);
        if (this.tideResponder != null) {
            this.tideResponder.fault(faultEvent);
            if (faultEvent.isDefaultPrevented()) {
                handled = true;
            }
        }
        if (!handled) {
            ExceptionHandler[] exceptionHandlers = context.getContextManager().getContext(null).allByType(ExceptionHandler.class);
            if (exceptionHandlers != null && emsg != null) {
                for (ExceptionHandler handler : exceptionHandlers) {
                    if (!handler.accepts(emsg)) continue;
                    handler.handle(context, emsg, faultEvent);
                    handled = true;
                    break;
                }
                if (!handled) {
                    log.error("Unhandled fault msg: %s", new Object[]{emsg});
                }
            } else if (exceptionHandlers != null && exceptionHandlers.length > 0 && this.event instanceof FaultEvent) {
                exceptionHandlers[0].handle(context, (FaultMessage)((FaultEvent)this.event).getMessage(), faultEvent);
            } else {
                log.error("Unknown fault event: %s, msg: %s", new Object[]{this.event, emsg});
            }
        }
        return handled;
    }
}

