/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import org.granite.client.messaging.RemoteAlias;
import org.granite.client.messaging.events.Event;
import org.granite.client.messaging.events.FaultEvent;
import org.granite.client.messaging.events.IssueEvent;
import org.granite.client.messaging.events.ResultEvent;
import org.granite.client.tide.Context;
import org.granite.client.tide.ContextAware;
import org.granite.client.tide.NameAware;
import org.granite.client.tide.data.spi.MergeContext;
import org.granite.client.tide.impl.ComponentListenerImpl;
import org.granite.client.tide.impl.FaultHandler;
import org.granite.client.tide.impl.ResultHandler;
import org.granite.client.tide.server.ArgumentPreprocessor;
import org.granite.client.tide.server.Component;
import org.granite.client.tide.server.ComponentListener;
import org.granite.client.tide.server.InvocationInterceptor;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.tide.server.TideResponder;
import org.granite.client.tide.server.TideResultEvent;
import org.granite.client.util.PropertyHolder;
import org.granite.logging.Logger;

public class ComponentImpl
implements Component,
ContextAware,
NameAware,
InvocationHandler {
    private static final Logger log = Logger.getLogger(ComponentImpl.class);
    private String name;
    private Context context;
    private final ServerSession serverSession;

    public ComponentImpl() {
        this.serverSession = null;
    }

    public ComponentImpl(ServerSession serverSession) {
        this.serverSession = serverSession;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    protected Context getContext() {
        return this.context;
    }

    protected ServerSession getServerSession() {
        return this.serverSession;
    }

    @Override
    public <T> Future<T> call(String operation, Object ... args) {
        Context context = this.context;
        if (args != null && args.length > 0 && args[0] instanceof Context) {
            context = (Context)args[0];
            Object[] newArgs = new Object[args.length - 1];
            for (int i = 1; i < args.length - 1; ++i) {
                newArgs[i - 1] = args[i];
            }
            args = newArgs;
        }
        return this.callComponent(context, operation, args);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!method.getDeclaringClass().isAnnotationPresent(RemoteAlias.class)) {
            return method.invoke(proxy, args);
        }
        return this.callComponent(this.getContext(), method.getName(), args);
    }

    protected <T> Future<T> callComponent(Context context, String operation, Object[] args) {
        ArgumentPreprocessor[] apps;
        int i;
        context.checkValid();
        log.debug("callComponent %s.%s", new Object[]{this.getName(), operation});
        TideResponder responder = null;
        if (args != null && args.length > 0 && args[args.length - 1] instanceof TideResponder) {
            responder = (TideResponder)args[args.length - 1];
            Object[] newArgs = new Object[args.length - 1];
            for (int i2 = 0; i2 < args.length - 1; ++i2) {
                newArgs[i2] = args[i2];
            }
            args = newArgs;
        }
        MergeContext mergeContext = context.getEntityManager().initMerge(this.serverSession);
        List argsList = Arrays.asList(args);
        for (i = 0; i < args.length; ++i) {
            if (!(argsList.get(i) instanceof PropertyHolder)) continue;
            argsList.set(i, ((PropertyHolder)args[i]).getObject());
        }
        argsList = (List)context.getEntityManager().mergeExternal(mergeContext, argsList, null, null, null, false);
        for (i = 0; i < args.length; ++i) {
            args[i] = argsList.get(i);
        }
        Method method = null;
        for (Method m : this.getClass().getMethods()) {
            if (!m.getName().equals(operation) || m.getParameterTypes().length != args.length) continue;
            method = m;
            break;
        }
        if (method != null && (apps = context.allByType(ArgumentPreprocessor.class)) != null) {
            for (ArgumentPreprocessor app : apps) {
                args = app.preprocess(this.serverSession, method, args);
            }
        }
        return this.invoke(context, operation, args, responder);
    }

    protected <T> Future<T> invoke(Context context, String operation, Object[] args, TideResponder<T> tideResponder) {
        log.debug("invokeComponent %s > %s.%s", new Object[]{context.getContextId(), this.getName() != null ? this.getName() : this.getClass().getName(), operation});
        ComponentListener.Handler handler = new ComponentListener.Handler<T>(){

            @Override
            public Runnable result(Context context, ResultEvent event, Object info, String componentName, String operation, TideResponder<T> tideResponder, ComponentListener<T> componentListener) {
                return new ResultHandler(ComponentImpl.this.serverSession, context, componentName, operation, (Event)event, info, tideResponder, componentListener);
            }

            @Override
            public Runnable fault(Context context, FaultEvent event, Object info, String componentName, String operation, TideResponder<T> tideResponder, ComponentListener<T> componentListener) {
                return new FaultHandler(ComponentImpl.this.serverSession, context, componentName, operation, (Event)event, info, tideResponder, componentListener);
            }

            @Override
            public Runnable issue(Context context, IssueEvent event, Object info, String componentName, String operation, TideResponder<T> tideResponder, ComponentListener<T> componentListener) {
                return new FaultHandler(ComponentImpl.this.serverSession, context, componentName, operation, (Event)event, info, tideResponder, componentListener);
            }
        };
        ComponentListenerImpl<T> componentListener = new ComponentListenerImpl<T>(context, handler, this, operation, args, null, tideResponder);
        InvocationInterceptor[] interceptors = context.allByType(InvocationInterceptor.class);
        if (interceptors != null) {
            for (InvocationInterceptor interceptor : interceptors) {
                interceptor.beforeInvocation(context, this, operation, args, componentListener);
            }
        }
        context.getContextManager().destroyFinishedContexts();
        return componentListener.invoke(this.serverSession);
    }

    public <T> TideResultEvent<T> newResultEvent(T result) {
        return new TideResultEvent<T>(this.getContext(), this.getServerSession(), null, result);
    }
}

