/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data.spi;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.client.tide.data.Conflicts;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.data.impl.ObjectUtil;
import org.granite.client.tide.data.spi.DataManager;
import org.granite.client.tide.data.spi.DirtyCheckContext;
import org.granite.client.tide.server.ServerSession;

public class MergeContext {
    private static ThreadLocal<Map<EntityManager, MergeContext>> mergeContext = new ThreadLocal<Map<EntityManager, MergeContext>>(){

        @Override
        protected Map<EntityManager, MergeContext> initialValue() {
            return new IdentityHashMap<EntityManager, MergeContext>();
        }
    };
    private final EntityManager entityManager;
    private final DirtyCheckContext dirtyCheckContext;
    private IdentityHashMap<Object, Object> entityCache = null;
    private LinkedList<Object> mergeStack = new LinkedList();
    private String externalDataSessionId = null;
    private EntityManager sourceEntityManager = null;
    private ServerSession serverSession = null;
    private boolean mergeUpdate = false;
    private boolean merging = false;
    private Set<Object> versionChangeCache = null;
    private boolean resolvingConflict = false;
    private boolean skipDirtyCheck = false;
    private Conflicts mergeConflicts = null;
    private boolean uninitializing = false;

    public static MergeContext get(EntityManager entityManager) {
        return mergeContext.get().get(entityManager);
    }

    public static void destroy(EntityManager entityManager) {
        mergeContext.get().remove(entityManager);
    }

    public MergeContext(EntityManager entityManager, DirtyCheckContext dirtyCheckContext, ServerSession serverSession) {
        this.entityManager = entityManager;
        this.dirtyCheckContext = dirtyCheckContext;
        this.serverSession = serverSession;
        mergeContext.get().put(entityManager, this);
    }

    public void initMerge() {
        if (this.entityCache == null) {
            this.entityCache = new IdentityHashMap();
            this.mergeUpdate = true;
        }
    }

    public void clear() {
        this.entityCache = null;
        this.mergeConflicts = null;
        this.versionChangeCache = null;
        this.resolvingConflict = false;
        this.uninitializing = false;
        this.merging = false;
        this.mergeUpdate = false;
    }

    public void addConflict(Object localEntity, Object receivedEntity, List<String> properties) {
        if (this.mergeConflicts == null) {
            this.mergeConflicts = new Conflicts(this.entityManager, this.serverSession);
        }
        this.mergeConflicts.addConflict(localEntity, receivedEntity, properties);
    }

    public void initMergeConflicts() {
        this.entityCache = null;
        this.versionChangeCache = null;
        this.resolvingConflict = false;
    }

    public void checkConflictsResolved() {
        if (this.mergeConflicts != null && this.mergeConflicts.isAllResolved()) {
            this.mergeConflicts = null;
        }
    }

    public boolean isResolvingConflict() {
        return this.resolvingConflict;
    }

    public void setResolvingConflict(boolean resolvingConflict) {
        this.resolvingConflict = resolvingConflict;
    }

    public Conflicts getMergeConflicts() {
        return this.mergeConflicts;
    }

    public Map<?, ?> getEntityCache() {
        return this.entityCache;
    }

    public IdentityHashMap<Object, Object> saveEntityCache() {
        IdentityHashMap<Object, Object> entityCache = this.entityCache;
        this.entityCache = new IdentityHashMap();
        return entityCache;
    }

    public void restoreEntityCache(IdentityHashMap<Object, Object> entityCache) {
        this.entityCache = entityCache;
    }

    public String getExternalDataSessionId() {
        return this.externalDataSessionId;
    }

    public void setExternalDataSessionId(String externalDataSessionId) {
        this.externalDataSessionId = externalDataSessionId;
    }

    public ServerSession getServerSession() {
        return this.serverSession;
    }

    public void setSourceEntityManager(EntityManager sourceEntityManager) {
        this.sourceEntityManager = sourceEntityManager;
    }

    public EntityManager getSourceEntityManager() {
        return this.sourceEntityManager;
    }

    public boolean isMergeUpdate() {
        return this.mergeUpdate;
    }

    public void setMergeUpdate(boolean mergeUpdate) {
        this.mergeUpdate = mergeUpdate;
    }

    public boolean isMerging() {
        return this.merging;
    }

    public void setMerging(boolean merging) {
        this.merging = merging;
    }

    public boolean isSkipDirtyCheck() {
        return this.skipDirtyCheck;
    }

    public void setSkipDirtyCheck(boolean skipDirtyCheck) {
        this.skipDirtyCheck = skipDirtyCheck;
    }

    public Object getFromCache(Object obj) {
        if (this.entityCache == null) {
            return null;
        }
        return this.entityCache.get(obj);
    }

    public void pushMerge(Object obj, Object dest) {
        this.pushMerge(obj, dest, true);
    }

    public void pushMerge(Object obj, Object dest, boolean push) {
        if (this.entityCache != null) {
            this.entityCache.put(obj, dest);
        }
        if (push) {
            this.mergeStack.push(dest);
        }
    }

    public Object getCachedMerge(Object obj) {
        return this.entityCache.get(obj);
    }

    public Object popMerge() {
        return this.mergeStack.pop();
    }

    public Object getCurrentMerge() {
        return this.mergeStack.peek();
    }

    public void setCurrentMerge(Object merge) {
        this.mergeStack.set(0, merge);
    }

    public int getMergeStackSize() {
        return this.mergeStack.size();
    }

    public Object mergeExternal(Object object, Object dest, Object parent, String propertyName) {
        return this.entityManager.mergeExternal(this, object, dest, parent, propertyName, false);
    }

    public Map<String, Object> getSavedProperties(Object object) {
        return this.dirtyCheckContext.getSavedProperties(object);
    }

    public Object getCachedObject(Object object) {
        return this.entityManager.getCachedObject(object, true);
    }

    public Object[] getOwnerEntity(Object entity) {
        return this.entityManager.getOwnerEntity(entity);
    }

    public boolean isUnsaved(Object object) {
        return this.dirtyCheckContext.isUnsaved(object);
    }

    public void clearCache() {
        this.entityCache = null;
    }

    public DataManager getDataManager() {
        return this.entityManager.getDataManager();
    }

    public boolean objectEquals(Object o1, Object o2) {
        return ObjectUtil.objectEquals(this.entityManager.getDataManager(), o1, o2);
    }

    private Set<Object> getVersionChangeCache() {
        if (this.versionChangeCache == null) {
            this.versionChangeCache = new HashSet<Object>();
        }
        return this.versionChangeCache;
    }

    public void markVersionChanged(Object obj) {
        this.getVersionChangeCache().add(obj);
    }

    public boolean hasVersionChanged(Object obj) {
        return this.versionChangeCache != null ? this.versionChangeCache.contains(obj) : false;
    }

    public void setUninitializing(boolean uninitializing) {
        this.uninitializing = uninitializing;
    }

    public boolean isUninitializing() {
        return this.uninitializing;
    }

    public boolean isUninitializeAllowed() {
        return this.entityManager.isUninitializeAllowed();
    }

    public void setUninitializeAllowed(boolean uninitializeAllowed) {
        this.entityManager.setUninitializeAllowed(uninitializeAllowed);
    }
}

