/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.granite.client.tide.data.spi.DataManager;

public class UIDWeakSet {
    private final DataManager dataManager;
    private final WeakHashMap<Object, Object>[] table;

    public UIDWeakSet(DataManager dataManager) {
        this(dataManager, 64);
    }

    public UIDWeakSet(DataManager dataManager, int capacity) {
        this.dataManager = dataManager;
        this.table = new WeakHashMap[capacity];
    }

    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
    }

    public Object put(Object uidObject) {
        int h = this.hash(this.dataManager.getCacheKey(uidObject));
        WeakHashMap<Object, Object> dic = this.table[h];
        if (dic == null) {
            dic = new WeakHashMap();
            this.table[h] = dic;
        }
        Object old = null;
        for (Object o : dic.keySet()) {
            if (o == uidObject) {
                return o;
            }
            if (this.dataManager.getUid(o) != this.dataManager.getUid(uidObject) || !o.getClass().getName().equals(uidObject.getClass().getName())) continue;
            old = o;
            dic.remove(o);
            break;
        }
        dic.put(uidObject, null);
        return old;
    }

    public Object get(String cacheKey) {
        int h = this.hash(cacheKey);
        Object uidObject = null;
        WeakHashMap<Object, Object> dic = this.table[h];
        if (dic != null) {
            for (Object o : dic.keySet()) {
                if (!this.dataManager.getCacheKey(o).equals(cacheKey)) continue;
                uidObject = o;
                break;
            }
        }
        return uidObject;
    }

    public Object find(Matcher matcher) {
        for (int i = 0; i < this.table.length; ++i) {
            WeakHashMap<Object, Object> dic = this.table[i];
            if (dic == null) continue;
            for (Object o : dic.keySet()) {
                if (!matcher.match(o)) continue;
                return o;
            }
        }
        return null;
    }

    public void apply(Operation operation) {
        for (int i = 0; i < this.table.length; ++i) {
            WeakHashMap<Object, Object> dic = this.table[i];
            if (dic == null) continue;
            for (Object o : dic.keySet()) {
                operation.apply(o);
            }
        }
    }

    public Object remove(String cacheKey) {
        int h = this.hash(cacheKey);
        Object uidObject = null;
        WeakHashMap<Object, Object> dic = this.table[h];
        if (dic != null) {
            for (Object o : dic.keySet()) {
                if (!this.dataManager.getCacheKey(o).equals(cacheKey)) continue;
                uidObject = o;
                dic.remove(o);
                break;
            }
        }
        return uidObject;
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.table.length; ++i) {
            WeakHashMap<Object, Object> dic = this.table[i];
            if (dic == null) continue;
            size += dic.size();
        }
        return size;
    }

    public List<Object> data() {
        ArrayList<Object> d = new ArrayList<Object>();
        for (int i = 0; i < this.table.length; ++i) {
            WeakHashMap<Object, Object> dic = this.table[i];
            if (dic == null) continue;
            d.addAll(dic.keySet());
        }
        return d;
    }

    private int hash(String uid) {
        int h = 0;
        int max = uid.length();
        for (int i = 0; i < max; ++i) {
            h = 31 * h + uid.charAt(i);
        }
        return Math.abs(h) % this.table.length;
    }

    public static interface Operation {
        public void apply(Object var1);
    }

    public static interface Matcher {
        public boolean match(Object var1);
    }
}

