/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.granite.client.messaging.RemoteService;
import org.granite.client.messaging.ResponseListener;
import org.granite.client.messaging.ResultFaultIssuesResponseListener;
import org.granite.client.messaging.events.Event;
import org.granite.client.messaging.events.FaultEvent;
import org.granite.client.messaging.events.IssueEvent;
import org.granite.client.messaging.events.ResultEvent;
import org.granite.client.messaging.messages.responses.FaultMessage;
import org.granite.client.tide.Context;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.data.PersistenceManager;
import org.granite.client.tide.data.RemoteInitializer;
import org.granite.client.tide.data.impl.ObjectUtil;
import org.granite.client.tide.impl.FaultHandler;
import org.granite.client.tide.impl.ResultHandler;
import org.granite.client.tide.server.ServerSession;
import org.granite.logging.Logger;
import org.granite.tide.invocation.InvocationCall;
import org.granite.tide.invocation.InvocationResult;

public class RemoteInitializerImpl
implements RemoteInitializer {
    private static final Logger log = Logger.getLogger(RemoteInitializerImpl.class);
    private final Context context;
    private boolean enabled = true;
    private List<Object[]> objectsInitializing = new ArrayList<Object[]>();

    public RemoteInitializerImpl(Context context) {
        this.context = context;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initializeObject(ServerSession serverSession, Object entity, String propertyName, Object object) {
        if (!this.enabled || this.context.isFinished()) {
            return false;
        }
        log.debug("initialize {0}", new Object[]{ObjectUtil.toString(object)});
        EntityManager entityManager = PersistenceManager.getEntityManager(entity);
        if (entityManager == null) {
            return false;
        }
        entityManager.addReference(entity, null, null);
        List<Object[]> list = this.objectsInitializing;
        synchronized (list) {
            this.objectsInitializing.add(new Object[]{this.context, entity, propertyName});
        }
        this.context.callLater(new DoInitializeObjects(serverSession));
        return true;
    }

    public class InitializerListener
    extends ResultFaultIssuesResponseListener {
        private final ServerSession serverSession;
        private final Object entity;

        public InitializerListener(ServerSession serverSession, Object entity) {
            this.serverSession = serverSession;
            this.entity = entity;
        }

        public void onResult(final ResultEvent event) {
            this.serverSession.tryLogout();
            RemoteInitializerImpl.this.context.callLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EntityManager entityManager = PersistenceManager.getEntityManager(InitializerListener.this.entity);
                    boolean saveUninitializeAllowed = entityManager.isUninitializeAllowed();
                    try {
                        entityManager.setUninitializeAllowed(false);
                        InvocationResult invocationResult = (InvocationResult)event.getResult();
                        new ResultHandler(InitializerListener.this.serverSession, (Event)event).handleResult(RemoteInitializerImpl.this.context, invocationResult, invocationResult.getResult());
                    }
                    finally {
                        entityManager.setUninitializeAllowed(saveUninitializeAllowed);
                    }
                }
            });
        }

        public void onFault(final FaultEvent event) {
            this.serverSession.tryLogout();
            RemoteInitializerImpl.this.context.callLater(new Runnable(){

                @Override
                public void run() {
                    log.error("Fault initializing collection " + ObjectUtil.toString(InitializerListener.this.entity) + " " + event.toString(), new Object[0]);
                    new FaultHandler(InitializerListener.this.serverSession, (Event)event).handleFault(RemoteInitializerImpl.this.context, (FaultMessage)event.getMessage(), null);
                }
            });
        }

        public void onIssue(final IssueEvent event) {
            this.serverSession.tryLogout();
            RemoteInitializerImpl.this.context.callLater(new Runnable(){

                @Override
                public void run() {
                    log.error("Fault initializing collection " + ObjectUtil.toString(InitializerListener.this.entity) + " " + event.toString(), new Object[0]);
                    new FaultHandler(InitializerListener.this.serverSession, (Event)event).handleFault(RemoteInitializerImpl.this.context, null, null);
                }
            });
        }
    }

    public class DoInitializeObjects
    implements Runnable {
        private final ServerSession serverSession;

        public DoInitializeObjects(ServerSession serverSession) {
            this.serverSession = serverSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap<Object, ArrayList<String>> initMap = new HashMap<Object, ArrayList<String>>();
            List list = RemoteInitializerImpl.this.objectsInitializing;
            synchronized (list) {
                for (int i = 0; i < RemoteInitializerImpl.this.objectsInitializing.size(); ++i) {
                    if (((Object[])RemoteInitializerImpl.this.objectsInitializing.get(i))[0] != RemoteInitializerImpl.this.context) continue;
                    ArrayList<String> propertyNames = (ArrayList<String>)initMap.get(((Object[])RemoteInitializerImpl.this.objectsInitializing.get(i))[1]);
                    if (propertyNames == null) {
                        propertyNames = new ArrayList<String>();
                        propertyNames.add((String)((Object[])RemoteInitializerImpl.this.objectsInitializing.get(i))[2]);
                        initMap.put(((Object[])RemoteInitializerImpl.this.objectsInitializing.get(i))[1], propertyNames);
                    } else {
                        propertyNames.add((String)((Object[])RemoteInitializerImpl.this.objectsInitializing.get(i))[2]);
                    }
                    RemoteInitializerImpl.this.objectsInitializing.remove(i--);
                }
            }
            RemoteService rs = this.serverSession.getRemoteService();
            for (Object entity : initMap.keySet()) {
                this.serverSession.checkWaitForLogout();
                rs.newInvocation("initializeObject", new Object[]{entity, ((List)initMap.get(entity)).toArray(), new InvocationCall()}).addListener((ResponseListener)new InitializerListener(this.serverSession, entity)).invoke();
            }
        }
    }
}

