/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.granite.client.tide.data.spi.DataManager;
import org.granite.client.util.PropertyHolder;
import org.granite.util.TypeUtil;

public class ObjectUtil {
    private static final Class<?> LOCAL_DATE = ObjectUtil.initClass("java.time.LocalDate");
    private static final Class<?> LOCAL_DATETIME = ObjectUtil.initClass("java.time.LocalDateTime");
    private static final Class<?> LOCAL_TIME = ObjectUtil.initClass("java.time.LocalTime");

    private static Class<?> initClass(String type) {
        try {
            return TypeUtil.forName((String)type);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean isSimple(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Number || value instanceof Date || LOCAL_DATE != null && LOCAL_DATE.isInstance(value) || LOCAL_DATETIME != null && LOCAL_DATETIME.isInstance(value) || LOCAL_TIME != null && LOCAL_TIME.isInstance(value);
    }

    public static String toString(Object obj) {
        return obj != null ? obj.toString() : "null";
    }

    public static boolean isEmpty(Object val) {
        if (val == null) {
            return true;
        }
        if (val instanceof String) {
            return val.equals("");
        }
        if (val.getClass().isArray()) {
            return Array.getLength(val) == 0;
        }
        if (val instanceof Date) {
            return ((Date)val).getTime() == 0L;
        }
        if (val instanceof Collection) {
            return ((Collection)val).size() == 0;
        }
        if (val instanceof Map) {
            return ((Map)val).size() == 0;
        }
        return false;
    }

    public static boolean objectEquals(DataManager dataManager, Object obj1, Object obj2) {
        if (obj1 instanceof PropertyHolder && dataManager.isEntity(obj2) || dataManager.isEntity(obj1) && obj2 instanceof PropertyHolder) {
            return false;
        }
        if (dataManager.isEntity(obj1) && dataManager.isEntity(obj2) && obj1.getClass() == obj2.getClass()) {
            if (!dataManager.isInitialized(obj1) || !dataManager.isInitialized(obj2)) {
                try {
                    return ObjectUtil.objectEquals(dataManager, dataManager.getId(obj1), dataManager.getId(obj2));
                }
                catch (Exception e) {
                    return obj1.equals(obj2);
                }
            }
            return dataManager.getUid(obj1).equals(dataManager.getUid(obj2));
        }
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }
}

