/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.binding.PropertyChangeHelper;
import org.granite.binding.collection.CollectionChangeEvent;
import org.granite.binding.collection.CollectionChangeListener;
import org.granite.binding.collection.ObservableCollection;
import org.granite.client.tide.data.impl.AbstractDataManager;
import org.granite.client.tide.data.spi.DataManager;
import org.granite.client.util.WeakIdentityHashMap;
import org.granite.util.Introspector;
import org.granite.util.PropertyDescriptor;

public class JavaBeanDataManager
extends AbstractDataManager {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DataManager.TrackingHandler trackingHandler;
    private CollectionChangeListener listChangeListener = new DefaultCollectionChangeListener();
    private CollectionChangeListener setChangeListener = new DefaultCollectionChangeListener();
    private CollectionChangeListener mapChangeListener = new DefaultMapChangeListener();
    private PropertyChangeListener entityPropertyChangeListener = new EntityPropertyChangeListener();
    private CollectionChangeListener entityListChangeListener = new EntityCollectionChangeListener();
    private CollectionChangeListener entitySetChangeListener = new EntityCollectionChangeListener();
    private CollectionChangeListener entityMapChangeListener = new EntityMapChangeListener();
    private WeakIdentityHashMap<Object, DataManager.TrackingType> trackingListeners = new WeakIdentityHashMap();
    private boolean dirty = false;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void setPropertyValue(Object entity, String name, Object value) {
        if (entity == null) {
            return;
        }
        try {
            PropertyDescriptor[] pds;
            boolean found = false;
            for (PropertyDescriptor pd : pds = Introspector.getPropertyDescriptors(entity.getClass())) {
                if (!pd.getName().equals(name) || pd.getWriteMethod() == null) continue;
                Object oldValue = null;
                if (pd.getReadMethod() != null) {
                    oldValue = pd.getReadMethod().invoke(entity, new Object[0]);
                }
                pd.getWriteMethod().invoke(entity, value);
                if (pd.getReadMethod() != null) {
                    PropertyChangeHelper.firePropertyChange(entity, name, oldValue, value);
                }
                found = true;
                break;
            }
            if (!found) {
                super.setPropertyValue(entity, name, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set property " + name + " on entity " + entity, e);
        }
    }

    @Override
    public void setTrackingHandler(DataManager.TrackingHandler trackingHandler) {
        this.trackingHandler = trackingHandler;
    }

    @Override
    public void startTracking(Object previous, Object parent) {
        if (previous == null || this.trackingListeners.containsKey(previous)) {
            return;
        }
        if (previous instanceof ObservableCollection && previous instanceof List) {
            if (parent != null) {
                ((ObservableCollection)previous).addCollectionChangeListener(this.entityListChangeListener);
                this.trackingListeners.put(previous, (Object)DataManager.TrackingType.ENTITY_LIST);
            } else {
                ((ObservableCollection)previous).addCollectionChangeListener(this.listChangeListener);
                this.trackingListeners.put(previous, (Object)DataManager.TrackingType.LIST);
            }
        } else if (previous instanceof ObservableCollection && previous instanceof Set) {
            if (parent != null) {
                ((ObservableCollection)previous).addCollectionChangeListener(this.entitySetChangeListener);
                this.trackingListeners.put(previous, (Object)DataManager.TrackingType.ENTITY_SET);
            } else {
                ((ObservableCollection)previous).addCollectionChangeListener(this.setChangeListener);
                this.trackingListeners.put(previous, (Object)DataManager.TrackingType.SET);
            }
        } else if (previous instanceof ObservableCollection && previous instanceof Map) {
            if (parent != null) {
                ((ObservableCollection)previous).addCollectionChangeListener(this.entityMapChangeListener);
                this.trackingListeners.put(previous, (Object)DataManager.TrackingType.ENTITY_MAP);
            } else {
                ((ObservableCollection)previous).addCollectionChangeListener(this.mapChangeListener);
                this.trackingListeners.put(previous, (Object)DataManager.TrackingType.MAP);
            }
        } else if (parent != null || this.isEntity(previous)) {
            PropertyChangeHelper.addPropertyChangeListener(previous, this.entityPropertyChangeListener);
            this.trackingListeners.put(previous, (Object)DataManager.TrackingType.ENTITY_PROPERTY);
        }
    }

    @Override
    public void stopTracking(Object previous, Object parent) {
        if (previous == null || !this.trackingListeners.containsKey(previous)) {
            return;
        }
        if (previous instanceof ObservableCollection && previous instanceof List) {
            if (parent != null) {
                ((ObservableCollection)previous).removeCollectionChangeListener(this.entityListChangeListener);
            } else {
                ((ObservableCollection)previous).removeCollectionChangeListener(this.listChangeListener);
            }
        } else if (previous instanceof ObservableCollection && previous instanceof Set) {
            if (parent != null) {
                ((ObservableCollection)previous).removeCollectionChangeListener(this.entitySetChangeListener);
            } else {
                ((ObservableCollection)previous).removeCollectionChangeListener(this.setChangeListener);
            }
        } else if (previous instanceof ObservableCollection && previous instanceof Map) {
            if (parent != null) {
                ((ObservableCollection)previous).removeCollectionChangeListener(this.entityMapChangeListener);
            } else {
                ((ObservableCollection)previous).removeCollectionChangeListener(this.mapChangeListener);
            }
        } else if (parent != null || this.isEntity(previous)) {
            PropertyChangeHelper.removePropertyChangeListener(previous, this.entityPropertyChangeListener);
        }
        this.trackingListeners.remove(previous);
    }

    @Override
    public void clear() {
        for (Object obj : this.trackingListeners.keySet()) {
            DataManager.TrackingType type = (DataManager.TrackingType)((Object)this.trackingListeners.get(obj));
            switch (type) {
                case LIST: {
                    ((ObservableCollection)obj).removeCollectionChangeListener(this.listChangeListener);
                    break;
                }
                case SET: {
                    ((ObservableCollection)obj).removeCollectionChangeListener(this.setChangeListener);
                    break;
                }
                case MAP: {
                    ((ObservableCollection)obj).removeCollectionChangeListener(this.mapChangeListener);
                    break;
                }
                case ENTITY_PROPERTY: {
                    PropertyChangeHelper.removePropertyChangeListener(obj, this.entityPropertyChangeListener);
                    break;
                }
                case ENTITY_LIST: {
                    ((ObservableCollection)obj).removeCollectionChangeListener(this.entityListChangeListener);
                    break;
                }
                case ENTITY_SET: {
                    ((ObservableCollection)obj).removeCollectionChangeListener(this.entitySetChangeListener);
                    break;
                }
                case ENTITY_MAP: {
                    ((ObservableCollection)obj).removeCollectionChangeListener(this.entityMapChangeListener);
                }
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void notifyDirtyChange(boolean oldDirty, boolean dirty) {
        this.dirty = dirty;
        this.pcs.firePropertyChange("dirty", oldDirty, dirty);
    }

    @Override
    public void notifyEntityDirtyChange(Object entity, boolean oldDirtyEntity, boolean newDirtyEntity) {
        this.pcs.firePropertyChange(new PropertyChangeEvent(entity, "dirtyEntity", oldDirtyEntity, newDirtyEntity));
        this.pcs.firePropertyChange(new PropertyChangeEvent(entity, "deepDirtyEntity", oldDirtyEntity, newDirtyEntity));
    }

    public class DefaultMapChangeListener
    implements CollectionChangeListener {
        @Override
        public void collectionChange(CollectionChangeEvent ce) {
            if (ce.getKind() == CollectionChangeEvent.Kind.ADD) {
                JavaBeanDataManager.this.trackingHandler.mapChangeHandler(DataManager.ChangeKind.ADD, ce.getCollection(), null, ce.getValues());
            } else if (ce.getKind() == CollectionChangeEvent.Kind.REMOVE) {
                JavaBeanDataManager.this.trackingHandler.mapChangeHandler(DataManager.ChangeKind.REMOVE, ce.getCollection(), null, ce.getValues());
            } else if (ce.getKind() == CollectionChangeEvent.Kind.REPLACE) {
                JavaBeanDataManager.this.trackingHandler.mapChangeHandler(DataManager.ChangeKind.REPLACE, ce.getCollection(), null, ce.getValues());
            }
        }
    }

    public class EntityMapChangeListener
    implements CollectionChangeListener {
        @Override
        public void collectionChange(CollectionChangeEvent ce) {
            if (ce.getKind() == CollectionChangeEvent.Kind.ADD) {
                JavaBeanDataManager.this.trackingHandler.entityMapChangeHandler(DataManager.ChangeKind.ADD, ce.getCollection(), null, ce.getValues());
            } else if (ce.getKind() == CollectionChangeEvent.Kind.REMOVE) {
                JavaBeanDataManager.this.trackingHandler.entityMapChangeHandler(DataManager.ChangeKind.REMOVE, ce.getCollection(), null, ce.getValues());
            } else if (ce.getKind() == CollectionChangeEvent.Kind.REPLACE) {
                JavaBeanDataManager.this.trackingHandler.entityMapChangeHandler(DataManager.ChangeKind.REPLACE, ce.getCollection(), null, ce.getValues());
            }
        }
    }

    public class DefaultCollectionChangeListener
    implements CollectionChangeListener {
        @Override
        public void collectionChange(CollectionChangeEvent ce) {
            if (ce.getKind() == CollectionChangeEvent.Kind.ADD) {
                JavaBeanDataManager.this.trackingHandler.collectionChangeHandler(DataManager.ChangeKind.ADD, ce.getCollection(), (Integer)ce.getKey(), ce.getValues());
            } else if (ce.getKind() == CollectionChangeEvent.Kind.REMOVE) {
                JavaBeanDataManager.this.trackingHandler.collectionChangeHandler(DataManager.ChangeKind.REMOVE, ce.getCollection(), (Integer)ce.getKey(), ce.getValues());
            } else if (ce.getKind() == CollectionChangeEvent.Kind.REPLACE) {
                JavaBeanDataManager.this.trackingHandler.collectionChangeHandler(DataManager.ChangeKind.REPLACE, ce.getCollection(), (Integer)ce.getKey(), ce.getValues());
            }
        }
    }

    public class EntityCollectionChangeListener
    implements CollectionChangeListener {
        @Override
        public void collectionChange(CollectionChangeEvent ce) {
            if (ce.getKind() == CollectionChangeEvent.Kind.ADD) {
                JavaBeanDataManager.this.trackingHandler.entityCollectionChangeHandler(DataManager.ChangeKind.ADD, ce.getCollection(), (Integer)ce.getKey(), ce.getValues());
            } else if (ce.getKind() == CollectionChangeEvent.Kind.REMOVE) {
                JavaBeanDataManager.this.trackingHandler.entityCollectionChangeHandler(DataManager.ChangeKind.REMOVE, ce.getCollection(), (Integer)ce.getKey(), ce.getValues());
            } else if (ce.getKind() == CollectionChangeEvent.Kind.REPLACE) {
                JavaBeanDataManager.this.trackingHandler.entityCollectionChangeHandler(DataManager.ChangeKind.REPLACE, ce.getCollection(), (Integer)ce.getKey(), ce.getValues());
            }
        }
    }

    public class EntityPropertyChangeListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            JavaBeanDataManager.this.trackingHandler.entityPropertyChangeHandler(pce.getSource(), pce.getPropertyName(), pce.getOldValue(), pce.getNewValue());
        }
    }
}

