/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.client.persistence.collection.PersistentCollection;
import org.granite.client.tide.data.Value;
import org.granite.client.tide.data.impl.ObjectUtil;
import org.granite.client.tide.data.spi.DataManager;
import org.granite.client.tide.data.spi.DirtyCheckContext;
import org.granite.client.tide.data.spi.MergeContext;
import org.granite.client.tide.data.spi.Wrapper;
import org.granite.client.util.PropertyHolder;
import org.granite.client.util.WeakIdentityHashMap;
import org.granite.logging.Logger;

public class DirtyCheckContextImpl
implements DirtyCheckContext {
    private static Logger log = Logger.getLogger(DirtyCheckContextImpl.class);
    private DataManager dataManager;
    private int dirtyCount = 0;
    private WeakIdentityHashMap<Object, Map<String, Object>> savedProperties = new WeakIdentityHashMap();
    private WeakIdentityHashMap<Object, Object> unsavedEntities = new WeakIdentityHashMap();

    public DirtyCheckContextImpl(DataManager dataManager) {
        this.dataManager = dataManager;
    }

    private boolean isEntity(Object obj) {
        return this.dataManager.isEntity(obj);
    }

    public boolean isDirty() {
        return this.dirtyCount > 0;
    }

    public void notifyDirtyChange(boolean oldDirty) {
        if (this.isDirty() == oldDirty) {
            return;
        }
        this.dataManager.notifyDirtyChange(oldDirty, this.isDirty());
    }

    public boolean notifyEntityDirtyChange(Object entity, boolean oldDirtyEntity) {
        boolean newDirtyEntity = this.isEntityChanged(entity);
        if (newDirtyEntity != oldDirtyEntity) {
            this.dataManager.notifyEntityDirtyChange(entity, oldDirtyEntity, newDirtyEntity);
        }
        return newDirtyEntity;
    }

    @Override
    public Map<Object, Map<String, Object>> getSavedProperties() {
        return this.savedProperties;
    }

    @Override
    public Map<String, Object> getSavedProperties(Object entity) {
        return (Map)this.savedProperties.get(entity);
    }

    public boolean isSaved(Object entity) {
        return this.savedProperties.containsKey(entity);
    }

    @Override
    public boolean isUnsaved(Object object) {
        return this.unsavedEntities.containsKey(object);
    }

    @Override
    public void addUnsaved(Object entity) {
        this.unsavedEntities.put(entity, (Object)true);
    }

    @Override
    public void clear(boolean notify) {
        boolean wasDirty = this.isDirty();
        this.dirtyCount = 0;
        this.savedProperties.clear();
        if (notify) {
            this.notifyDirtyChange(wasDirty);
        }
    }

    public boolean isEntityPropertyChanged(Object entity, String propertyName, Object value) {
        Map source = (Map)this.savedProperties.get(entity);
        if (source != null) {
            return source.containsKey(propertyName) && !this.isSame(source.get(propertyName), value);
        }
        return !this.isSame(this.dataManager.getPropertyValue(entity, propertyName), value);
    }

    @Override
    public boolean isEntityChanged(Object entity) {
        return this.isEntityChanged(entity, null, null, null);
    }

    public boolean isEntityChanged(Object entity, Object embedded, String propName, Object value) {
        if (!this.dataManager.isInitialized(entity)) {
            return false;
        }
        boolean dirty = false;
        Map<String, Object> pval = this.dataManager.getPropertyValues(entity, true, false);
        Map save = (Map)this.savedProperties.get(entity);
        if (embedded == null) {
            embedded = entity;
        }
        for (String p : pval.keySet()) {
            Object saveval;
            Object val = entity == embedded && p.equals(propName) ? value : pval.get(p);
            Object v0 = saveval = save != null ? save.get(p) : null;
            if (save != null && (val != null && (ObjectUtil.isSimple(val) || val instanceof byte[]) || saveval != null && (ObjectUtil.isSimple(saveval) || saveval instanceof byte[]))) {
                dirty = true;
                break;
            }
            if (save != null && (val instanceof Value || saveval instanceof Value || val instanceof Enum || saveval instanceof Enum)) {
                if (saveval == null || (val != null || saveval == null) && val.equals(saveval)) continue;
                dirty = true;
                break;
            }
            if (save != null && (this.isEntity(val) || this.isEntity(saveval))) {
                if (saveval == null || val == save.get(p)) continue;
                dirty = true;
                break;
            }
            if (val instanceof Collection || val instanceof Map) {
                List savedArray;
                if (!this.dataManager.isInitialized(val) || (savedArray = (List)saveval) == null || savedArray.isEmpty()) continue;
                dirty = true;
                break;
            }
            if (val == null || this.isEntity(val) || ObjectUtil.isSimple(val) || val instanceof Enum || val instanceof Value || val instanceof byte[] || !this.isEntityChanged(val)) continue;
            dirty = true;
            break;
        }
        return dirty;
    }

    @Override
    public boolean isEntityDeepChanged(Object entity) {
        return this.isEntityDeepChanged(entity, null, new IdentityHashMap<Object, Boolean>());
    }

    private boolean isEntityDeepChanged(Object entity, Object embedded, IdentityHashMap<Object, Boolean> cache) {
        if (cache == null) {
            cache = new IdentityHashMap();
        }
        if (cache.containsKey(entity)) {
            return false;
        }
        cache.put(entity, true);
        if (!this.dataManager.isInitialized(entity)) {
            return false;
        }
        Map<String, Object> pval = this.dataManager.getPropertyValues(entity, true, false);
        if (embedded == null) {
            embedded = entity;
        }
        Map save = (Map)this.savedProperties.get(entity);
        for (String p : pval.keySet()) {
            Object saveval;
            Object val = pval.get(p);
            Object v0 = saveval = save != null ? save.get(p) : null;
            if (save != null && (val != null && (ObjectUtil.isSimple(val) || val instanceof byte[]) || saveval != null && (ObjectUtil.isSimple(saveval) || saveval instanceof byte[]))) {
                return true;
            }
            if (save != null && (val instanceof Value || saveval instanceof Value || val instanceof Enum || saveval instanceof Enum)) {
                if (saveval == null || (val != null || saveval == null) && val.equals(saveval)) continue;
                return true;
            }
            if (this.isEntity(val) || this.isEntity(saveval)) {
                if (save != null && val != saveval) {
                    return true;
                }
                if (!this.isEntityDeepChanged(val, null, cache)) continue;
                return true;
            }
            if (val instanceof Collection || val instanceof Map) {
                if (!this.dataManager.isInitialized(val)) continue;
                List savedArray = saveval;
                if (savedArray != null && !savedArray.isEmpty()) {
                    return true;
                }
                if (val instanceof Collection) {
                    for (Object e : (Collection)val) {
                        if (!this.isEntityDeepChanged(e, null, cache)) continue;
                        return true;
                    }
                    continue;
                }
                if (!(val instanceof Map)) continue;
                for (Map.Entry entry : ((Map)val).entrySet()) {
                    if (this.isEntityDeepChanged(entry.getKey(), null, cache)) {
                        return true;
                    }
                    if (!this.isEntityDeepChanged(entry.getValue(), null, cache)) continue;
                    return true;
                }
                continue;
            }
            if (val == null || this.isEntity(val) || ObjectUtil.isSimple(val) || val instanceof Enum || val instanceof Value || val instanceof byte[] || !this.isEntityDeepChanged(val, embedded, cache)) continue;
            return true;
        }
        return false;
    }

    private boolean isSame(Object val1, Object val2) {
        Object o;
        if (val1 == null && ObjectUtil.isEmpty(val2)) {
            return true;
        }
        if (val2 == null && ObjectUtil.isEmpty(val1)) {
            return true;
        }
        if (ObjectUtil.isSimple(val1) && ObjectUtil.isSimple(val2)) {
            return val1.equals(val2);
        }
        if (val1 instanceof byte[] && val2 instanceof byte[]) {
            return Arrays.equals((byte[])val1, (byte[])val2);
        }
        if (val1 instanceof Value && val2 instanceof Value || val1 instanceof Enum && val2 instanceof Enum) {
            return val1.equals(val2);
        }
        Object n = val1 instanceof Wrapper ? ((Wrapper)val1).getWrappedObject() : val1;
        Object object = o = val2 instanceof Wrapper ? ((Wrapper)val2).getWrappedObject() : val2;
        if (this.isEntity(n) && this.isEntity(o)) {
            return this.dataManager.getUid(n) != null && this.dataManager.getUid(n).equals(this.dataManager.getUid(o));
        }
        return n == o;
    }

    private boolean isSameList(List<Object> save, Collection<?> coll) {
        if (save.size() != coll.size()) {
            return false;
        }
        if (coll instanceof List) {
            List list = (List)coll;
            for (int i = 0; i < save.size(); ++i) {
                if (this.isSame(save.get(i), list.get(i))) continue;
                return false;
            }
        } else {
            for (int i = 0; i < save.size(); ++i) {
                boolean found = false;
                for (Object obj : coll) {
                    if (!this.isSame(save.get(i), obj)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isSameMap(List<Object[]> save, Map<?, ?> map) {
        if (save.size() != map.size()) {
            return false;
        }
        for (int i = 0; i < save.size(); ++i) {
            Object[] entry = save.get(i);
            if (!map.containsKey(entry[0])) {
                return false;
            }
            if (this.isSame(entry[1], map.get(entry[0]))) continue;
            return false;
        }
        return true;
    }

    private boolean isSameExt(Object val1, Object val2) {
        Object o;
        if (val1 == null && ObjectUtil.isEmpty(val2)) {
            return true;
        }
        if (val2 == null && ObjectUtil.isEmpty(val1)) {
            return true;
        }
        if (ObjectUtil.isSimple(val1) && ObjectUtil.isSimple(val2)) {
            return val1.equals(val2);
        }
        if (val1 instanceof byte[] && val2 instanceof byte[]) {
            return Arrays.equals((byte[])val1, (byte[])val2);
        }
        if (val1 instanceof Value && val2 instanceof Value || val1 instanceof Enum && val2 instanceof Enum) {
            return val1.equals(val2);
        }
        if (val1 != null && val1.getClass().isArray() && val2 != null && val2.getClass().isArray()) {
            if (Array.getLength(val1) != Array.getLength(val2)) {
                return false;
            }
            for (int idx = 0; idx < Array.getLength(val1); ++idx) {
                if (this.isSameExt(Array.get(val1, idx), Array.get(val2, idx))) continue;
                return false;
            }
            return true;
        }
        if (val1 instanceof Set && val2 instanceof Set) {
            boolean found;
            if (val1 instanceof PersistentCollection && !((PersistentCollection)val1).wasInitialized() || val2 instanceof PersistentCollection && !((PersistentCollection)val2).wasInitialized()) {
                return false;
            }
            Collection coll1 = (Collection)val1;
            Collection coll2 = (Collection)val2;
            if (coll1.size() != coll2.size()) {
                return false;
            }
            for (Object e : coll1) {
                found = false;
                for (Object f : coll2) {
                    if (!this.isSameExt(e, f)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            for (Object e : coll2) {
                found = false;
                for (Object f : coll1) {
                    if (!this.isSameExt(e, f)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        if (val1 instanceof List && val2 instanceof List) {
            if (val1 instanceof PersistentCollection && !((PersistentCollection)val1).wasInitialized() || val2 instanceof PersistentCollection && !((PersistentCollection)val2).wasInitialized()) {
                return false;
            }
            List list1 = (List)val1;
            List list2 = (List)val2;
            if (list1.size() != list2.size()) {
                return false;
            }
            for (int idx = 0; idx < list1.size(); ++idx) {
                if (this.isSameExt(list1.get(idx), list2.get(idx))) continue;
                return false;
            }
            return true;
        }
        if (val1 instanceof Collection && val2 instanceof Collection) {
            boolean found;
            if (val1 instanceof PersistentCollection && !((PersistentCollection)val1).wasInitialized() || val2 instanceof PersistentCollection && !((PersistentCollection)val2).wasInitialized()) {
                return false;
            }
            Collection coll1 = (Collection)val1;
            Collection coll2 = (Collection)val2;
            if (coll1.size() != coll2.size()) {
                return false;
            }
            for (Object obj1 : coll1) {
                found = false;
                for (Object obj2 : coll2) {
                    if (!this.isSameExt(obj1, obj2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            for (Object obj2 : coll2) {
                found = false;
                for (Object obj1 : coll1) {
                    if (!this.isSameExt(obj1, obj2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        if (val1 instanceof Map && val2 instanceof Map) {
            Object key;
            if (val1 instanceof PersistentCollection && !((PersistentCollection)val1).wasInitialized() || val2 instanceof PersistentCollection && !((PersistentCollection)val2).wasInitialized()) {
                return false;
            }
            Map map1 = (Map)val1;
            Map map2 = (Map)val2;
            if (map1.size() != map2.size()) {
                return false;
            }
            for (Object e : map1.keySet()) {
                key = null;
                for (Object f : map2.keySet()) {
                    if (!this.isSameExt(e, f)) continue;
                    key = f;
                    break;
                }
                if (key == null) {
                    return false;
                }
                if (this.isSameExt(map1.get(e), map2.get(key))) continue;
                return false;
            }
            for (Object f : map2.keySet()) {
                key = null;
                for (Object e : map1.keySet()) {
                    if (!this.isSameExt(e, f)) continue;
                    key = e;
                    break;
                }
                if (key == null) {
                    return false;
                }
                if (this.isSameExt(map1.get(key), map2.get(f))) continue;
                return false;
            }
            return true;
        }
        Object n = val1 instanceof Wrapper ? ((Wrapper)val1).getWrappedObject() : val1;
        Object object = o = val2 instanceof Wrapper ? ((Wrapper)val2).getWrappedObject() : val2;
        if (this.isEntity(n) && this.isEntity(o)) {
            return this.dataManager.getUid(n).equals(this.dataManager.getUid(o));
        }
        return n == o;
    }

    @Override
    public void entityPropertyChangeHandler(Object entity, Object object, String propName, Object oldValue, Object newValue) {
        boolean diff;
        boolean oldDirty = this.isDirty();
        boolean bl = diff = !this.isSame(oldValue, newValue);
        if (diff) {
            boolean unsaved;
            boolean oldDirtyEntity = this.isEntityChanged(entity, object, propName, oldValue);
            String versionPropertyName = this.dataManager.isEntity(entity) ? this.dataManager.getVersionPropertyName(entity) : null;
            HashMap<String, Object> save = (HashMap<String, Object>)this.savedProperties.get(object);
            boolean bl2 = unsaved = save == null;
            if (unsaved || versionPropertyName != null && save.get(versionPropertyName) != this.dataManager.getVersion(entity) && (save.get(versionPropertyName) != null || this.dataManager.getVersion(entity) != null)) {
                save = new HashMap<String, Object>();
                if (versionPropertyName != null) {
                    save.put(versionPropertyName, this.dataManager.getVersion(entity));
                }
                this.savedProperties.put(object, save);
                save.put(propName, oldValue);
                if (unsaved) {
                    ++this.dirtyCount;
                }
            }
            if (save != null && (versionPropertyName == null || save.get(versionPropertyName) == this.dataManager.getVersion(entity) || save.get(versionPropertyName) == null && this.dataManager.getVersion(entity) == null)) {
                if (!save.containsKey(propName)) {
                    save.put(propName, oldValue);
                }
                if (this.isSame(save.get(propName), newValue)) {
                    save.remove(propName);
                    int count = 0;
                    for (String p : save.keySet()) {
                        if (p.equals(versionPropertyName)) continue;
                        ++count;
                    }
                    if (count == 0) {
                        this.savedProperties.remove(object);
                        --this.dirtyCount;
                    }
                }
            }
            this.notifyEntityDirtyChange(entity, oldDirtyEntity);
        }
        this.notifyDirtyChange(oldDirty);
    }

    @Override
    public void entityCollectionChangeHandler(Object owner, String propName, Collection<?> coll, DataManager.ChangeKind kind, Integer location, Object[] items) {
        ArrayList<Object> save;
        boolean unsaved;
        boolean oldDirty = this.isDirty();
        String versionPropertyName = this.dataManager.isEntity(owner) ? this.dataManager.getVersionPropertyName(owner) : null;
        boolean oldDirtyEntity = this.isEntityChanged(owner);
        HashMap<String, Object> esave = (HashMap<String, Object>)this.savedProperties.get(owner);
        boolean bl = unsaved = esave == null;
        if (unsaved || versionPropertyName != null && esave.get(versionPropertyName) != this.dataManager.getVersion(owner) && (esave.get(versionPropertyName) != null || this.dataManager.getVersion(owner) != null)) {
            esave = new HashMap<String, Object>();
            if (versionPropertyName != null) {
                esave.put(versionPropertyName, this.dataManager.getVersion(owner));
            }
            this.savedProperties.put(owner, esave);
            if (unsaved) {
                ++this.dirtyCount;
            }
        }
        if ((save = (ArrayList<Object>)esave.get(propName)) == null) {
            save = new ArrayList<Object>();
            esave.put(propName, save);
            for (Object e : coll) {
                save.add(e);
            }
            if (kind == DataManager.ChangeKind.ADD) {
                if (location != null) {
                    for (int i = 0; i < items.length; ++i) {
                        save.remove(location);
                    }
                } else {
                    for (Object item : items) {
                        save.remove(item);
                    }
                }
            } else if (kind == DataManager.ChangeKind.REMOVE) {
                if (location != null) {
                    for (int i = 0; i < items.length; ++i) {
                        save.add(location + i, items[i]);
                    }
                } else {
                    for (Object item : items) {
                        save.add(item);
                    }
                }
            } else if (kind == DataManager.ChangeKind.REPLACE) {
                if (location != null) {
                    save.set(location, ((Object[])items[0])[0]);
                } else {
                    save.remove(((Object[])items[0])[1]);
                    save.add(((Object[])items[0])[0]);
                }
            }
        } else if (this.isSameList(save, coll)) {
            esave.remove(propName);
            int count = 0;
            for (Object p : esave.keySet()) {
                if (p.equals(versionPropertyName)) continue;
                ++count;
            }
            if (count == 0) {
                this.savedProperties.remove(owner);
                --this.dirtyCount;
            }
        }
        this.notifyEntityDirtyChange(owner, oldDirtyEntity);
        this.notifyDirtyChange(oldDirty);
    }

    @Override
    public void entityMapChangeHandler(Object owner, String propName, Map<?, ?> map, DataManager.ChangeKind kind, Object[] items) {
        ArrayList<Object[]> save;
        boolean unsaved;
        boolean oldDirty = this.isDirty();
        String versionPropertyName = this.dataManager.isEntity(owner) ? this.dataManager.getVersionPropertyName(owner) : null;
        boolean oldDirtyEntity = this.isEntityChanged(owner);
        HashMap<String, Object> esave = (HashMap<String, Object>)this.savedProperties.get(owner);
        boolean bl = unsaved = esave == null;
        if (unsaved || versionPropertyName != null && esave.get(versionPropertyName) != this.dataManager.getVersion(owner) && (esave.get(versionPropertyName) != null || this.dataManager.getVersion(owner) != null)) {
            esave = new HashMap<String, Object>();
            if (versionPropertyName != null) {
                esave.put(versionPropertyName, this.dataManager.getVersion(owner));
            }
            this.savedProperties.put(owner, esave);
            if (unsaved) {
                ++this.dirtyCount;
            }
        }
        if ((save = (ArrayList<Object[]>)esave.get(propName)) == null) {
            save = new ArrayList<Object[]>();
            esave.put(propName, save);
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                boolean found = false;
                if (kind == DataManager.ChangeKind.ADD) {
                    for (Object item : items) {
                        if (!this.isSame(entry.getKey(), ((Object[])item)[0])) continue;
                        found = true;
                        break;
                    }
                } else if (kind == DataManager.ChangeKind.REPLACE) {
                    for (Object item : items) {
                        if (!this.isSame(entry.getKey(), ((Object[])item)[0])) continue;
                        save.add(new Object[]{entry.getKey(), ((Object[])item)[1]});
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                save.add(new Object[]{entry.getKey(), entry.getValue()});
            }
            if (kind == DataManager.ChangeKind.REMOVE) {
                for (Object item : items) {
                    save.add(new Object[]{((Object[])item)[0], ((Object[])item)[1]});
                }
            }
        } else if (this.isSameMap(save, map)) {
            esave.remove(propName);
            int count = 0;
            for (Object p : esave.keySet()) {
                if (p.equals(versionPropertyName)) continue;
                ++count;
            }
            if (count == 0) {
                this.savedProperties.remove(owner);
                --this.dirtyCount;
            }
        }
        this.notifyEntityDirtyChange(owner, oldDirtyEntity);
        this.notifyDirtyChange(oldDirty);
    }

    @Override
    public void markNotDirty(Object object, Object entity) {
        if (entity != null) {
            this.unsavedEntities.remove(entity);
        }
        if (!this.savedProperties.containsKey(object)) {
            return;
        }
        boolean oldDirty = this.isDirty();
        boolean oldDirtyEntity = false;
        if (entity == null && this.isEntity(object)) {
            entity = object;
        }
        if (entity != null) {
            oldDirtyEntity = this.isEntityChanged(entity);
        }
        this.savedProperties.remove(object);
        if (entity != null) {
            this.notifyEntityDirtyChange(entity, oldDirtyEntity);
        }
        --this.dirtyCount;
        this.notifyDirtyChange(oldDirty);
    }

    @Override
    public boolean checkAndMarkNotDirty(MergeContext mergeContext, Object entity, Object source, Object parent) {
        Map save;
        if (entity != null) {
            this.unsavedEntities.remove(entity);
        }
        if ((save = (Map)this.savedProperties.get(entity)) == null) {
            return false;
        }
        Object owner = this.isEntity(entity) ? entity : parent;
        boolean oldDirty = this.isDirty();
        boolean oldDirtyEntity = this.isEntityChanged(owner);
        ArrayList<String> merged = new ArrayList<String>();
        String versionPropertyName = this.dataManager.getVersionPropertyName(owner);
        if (this.isEntity(source) && versionPropertyName != null) {
            save.put(versionPropertyName, this.dataManager.getVersion(source));
        }
        Map<String, Object> pval = this.dataManager.getPropertyValues(entity, false, false);
        for (String propName : pval.keySet()) {
            Object sourceValue;
            if (propName.equals(versionPropertyName) || propName.equals("dirty") || !this.dataManager.hasProperty(source, propName)) continue;
            Object localValue = pval.get(propName);
            if (localValue instanceof PropertyHolder) {
                localValue = ((PropertyHolder)localValue).getObject();
            }
            if (this.isSameExt(sourceValue = this.dataManager.getPropertyValue(source, propName), localValue)) {
                merged.add(propName);
                continue;
            }
            if (sourceValue == null || ObjectUtil.isSimple(sourceValue) || sourceValue instanceof Value || sourceValue instanceof Enum) {
                save.put(propName, sourceValue);
                continue;
            }
            if (this.isEntity(sourceValue)) {
                save.put(propName, mergeContext.getFromCache(sourceValue));
                continue;
            }
            if (sourceValue instanceof Collection && (!(sourceValue instanceof PersistentCollection) || ((PersistentCollection)sourceValue).wasInitialized())) {
                ArrayList snapshot = new ArrayList((Collection)sourceValue);
                save.put(propName, snapshot);
                continue;
            }
            if (!(sourceValue instanceof Map) || sourceValue instanceof PersistentCollection && !((PersistentCollection)sourceValue).wasInitialized()) continue;
            Map map = (Map)sourceValue;
            ArrayList<Object[]> snapshot = new ArrayList<Object[]>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                snapshot.add(new Object[]{entry.getKey(), entry.getValue()});
            }
            save.put(propName, snapshot);
        }
        for (String propName : merged) {
            save.remove(propName);
        }
        int count = 0;
        for (String propName : save.keySet()) {
            if (propName.equals(versionPropertyName)) continue;
            ++count;
        }
        if (count == 0) {
            this.savedProperties.remove(entity);
            --this.dirtyCount;
        }
        boolean newDirtyEntity = this.notifyEntityDirtyChange(owner, oldDirtyEntity);
        this.notifyDirtyChange(oldDirty);
        return newDirtyEntity;
    }

    @Override
    public void fixRemovalsAndPersists(MergeContext mergeContext, List<Object> removals, List<Object> persists) {
        boolean oldDirty = this.dirtyCount > 0;
        for (Object object : this.savedProperties.keySet()) {
            Object owner = null;
            if (this.isEntity(object)) {
                owner = object;
            } else {
                Object[] ownerEntity = mergeContext.getOwnerEntity(object);
                if (ownerEntity != null && this.isEntity(ownerEntity[0])) {
                    owner = ownerEntity[0];
                }
            }
            String versionPropertyName = this.dataManager.getVersionPropertyName(owner);
            boolean oldDirtyEntity = this.isEntityChanged(object);
            Map save = (Map)this.savedProperties.get(object);
            Iterator ip = save.keySet().iterator();
            while (ip.hasNext()) {
                Object sne;
                Iterator isne;
                List snapshot;
                String p = (String)ip.next();
                Object sn = save.get(p);
                if (!(sn instanceof List)) continue;
                Object value = this.dataManager.getPropertyValue(object, p);
                if (value instanceof Collection) {
                    if (value instanceof PersistentCollection && !((PersistentCollection)value).wasInitialized()) continue;
                    snapshot = (List)sn;
                    Collection coll = (Collection)value;
                    if (removals != null) {
                        isne = snapshot.iterator();
                        while (isne.hasNext()) {
                            sne = isne.next();
                            for (Object removal : removals) {
                                if (!this.isEntity(sne) || !ObjectUtil.objectEquals(this.dataManager, sne, removal)) continue;
                                isne.remove();
                            }
                        }
                    }
                    if (persists != null) {
                        for (Object persist : persists) {
                            if (coll instanceof List) {
                                int j;
                                List list = (List)coll;
                                ArrayList<Integer> found = new ArrayList<Integer>();
                                for (j = 0; j < list.size(); ++j) {
                                    if (!ObjectUtil.objectEquals(this.dataManager, list.get(j), persist)) continue;
                                    found.add(j);
                                }
                                for (j = 0; j < snapshot.size(); ++j) {
                                    if (!ObjectUtil.objectEquals(this.dataManager, persist, snapshot.get(j))) continue;
                                    snapshot.remove(j);
                                    --j;
                                }
                                Iterator i$ = found.iterator();
                                while (i$.hasNext()) {
                                    int idx = (Integer)i$.next();
                                    snapshot.add(idx, persist);
                                }
                                continue;
                            }
                            if (!coll.contains(persist) || snapshot.contains(persist)) continue;
                            snapshot.add(persist);
                        }
                    }
                    if (!this.isSameList(snapshot, coll)) continue;
                    ip.remove();
                    continue;
                }
                if (!(value instanceof Map) || value instanceof PersistentCollection && !((PersistentCollection)value).wasInitialized()) continue;
                snapshot = (List)sn;
                Map map = (Map)value;
                if (removals != null) {
                    isne = snapshot.iterator();
                    while (isne.hasNext()) {
                        sne = (Object[])isne.next();
                        for (Object removal : removals) {
                            if (this.isEntity(sne[0]) && ObjectUtil.objectEquals(this.dataManager, sne[0], removal)) {
                                isne.remove();
                                continue;
                            }
                            if (!this.isEntity(sne[1]) || !ObjectUtil.objectEquals(this.dataManager, sne[1], removal)) continue;
                            isne.remove();
                        }
                    }
                }
                if (!this.isSameMap(snapshot, map)) continue;
                ip.remove();
            }
            int count = 0;
            for (Object p : save.keySet()) {
                if (p.equals(versionPropertyName)) continue;
                ++count;
            }
            if (count == 0) {
                this.savedProperties.remove(object);
                --this.dirtyCount;
            }
            this.notifyEntityDirtyChange(object, oldDirtyEntity);
        }
        this.notifyDirtyChange(oldDirty);
    }

    @Override
    public void resetEntity(MergeContext mergeContext, Object entity, Object parent, Set<Object> cache) {
        if (!this.dataManager.isInitialized(entity)) {
            return;
        }
        if (cache.contains(entity)) {
            return;
        }
        cache.add(entity);
        Map save = (Map)this.savedProperties.get(entity);
        Map<String, Object> pval = this.dataManager.getPropertyValues(entity, true, false);
        for (String p : pval.keySet()) {
            List savedArray;
            Object val = pval.get(p);
            if (val instanceof Collection) {
                if (!this.dataManager.isInitialized(val)) continue;
                Collection coll = (Collection)val;
                List list = savedArray = save != null ? (List)save.get(p) : null;
                if (savedArray != null) {
                    for (Object e : coll) {
                        if (!this.isEntity(e)) continue;
                        this.resetEntity(mergeContext, e, parent, cache);
                    }
                    coll.clear();
                    for (Object object : savedArray) {
                        coll.add(object);
                    }
                    this.markNotDirty(val, parent);
                }
                for (Object e : coll) {
                    if (!this.isEntity(e)) continue;
                    this.resetEntity(mergeContext, e, e, cache);
                }
                continue;
            }
            if (val instanceof Map) {
                if (!this.dataManager.isInitialized(val)) continue;
                Map map = (Map)val;
                List list = savedArray = save != null ? (List)save.get(p) : null;
                if (savedArray != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (this.isEntity(entry.getKey())) {
                            this.resetEntity(mergeContext, entry.getKey(), parent, cache);
                        }
                        if (!this.isEntity(entry.getValue())) continue;
                        this.resetEntity(mergeContext, entry.getValue(), parent, cache);
                    }
                    map.clear();
                    for (Object[] objectArray : savedArray) {
                        map.put(objectArray[0], objectArray[1]);
                    }
                    this.markNotDirty(val, parent);
                }
                for (Map.Entry entry : map.entrySet()) {
                    if (this.isEntity(entry.getKey())) {
                        this.resetEntity(mergeContext, entry.getKey(), entry.getKey(), cache);
                    }
                    if (!this.isEntity(entry.getValue())) continue;
                    this.resetEntity(mergeContext, entry.getValue(), entry.getValue(), cache);
                }
                continue;
            }
            if (save != null && (ObjectUtil.isSimple(val) || ObjectUtil.isSimple(save.get(p)))) {
                if (!save.containsKey(p)) continue;
                this.dataManager.setPropertyValue(entity, p, save.get(p));
                continue;
            }
            if (save != null && (val instanceof Enum || save.get(p) instanceof Enum || val instanceof Value || save.get(p) instanceof Value)) {
                if (!save.containsKey(p)) continue;
                this.dataManager.setPropertyValue(entity, p, save.get(p));
                continue;
            }
            if (save != null && save.containsKey(p)) {
                if (ObjectUtil.objectEquals(this.dataManager, val, save.get(p))) continue;
                this.dataManager.setPropertyValue(entity, p, save.get(p));
                continue;
            }
            if (this.isEntity(val)) {
                this.resetEntity(mergeContext, val, val, cache);
                continue;
            }
            if (val == null || parent == null || ObjectUtil.isSimple(val) || val instanceof Enum) continue;
            this.resetEntity(mergeContext, val, parent, cache);
        }
        this.markNotDirty(entity, null);
    }

    @Override
    public void resetAllEntities(MergeContext mergeContext, Set<Object> cache) {
        boolean found = false;
        block0: do {
            found = false;
            for (Object entity : this.savedProperties.keySet()) {
                if (!this.isEntity(entity)) continue;
                found = true;
                this.resetEntity(mergeContext, entity, entity, cache);
                continue block0;
            }
        } while (found);
        if (this.dirtyCount > 0) {
            log.error("Incomplete reset of context, could be a bug", new Object[0]);
        }
    }

    public static class Change {
        private DataManager.ChangeKind kind;
        private int location;
        private Object[] items;

        public Change(DataManager.ChangeKind kind, int location, Object[] items) {
            this.kind = kind;
            this.location = location;
            this.items = items;
        }

        public DataManager.ChangeKind getKind() {
            return this.kind;
        }

        public int getLocation() {
            return this.location;
        }

        public Object[] getItems() {
            return this.items;
        }

        public void moveLocation(int offset) {
            this.location += offset;
        }
    }
}

