/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.granite.client.persistence.Persistence;
import org.granite.client.platform.Platform;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.data.EntityProxy;
import org.granite.client.tide.data.PersistenceManager;
import org.granite.client.tide.data.impl.ObjectUtil;
import org.granite.client.tide.data.spi.DataManager;
import org.granite.logging.Logger;
import org.granite.messaging.reflect.Property;
import org.granite.util.TypeUtil;
import org.granite.util.UUIDUtil;

public abstract class AbstractDataManager
implements DataManager {
    private static final Logger log = Logger.getLogger(AbstractDataManager.class);
    private static ConcurrentMap<Class<?>, Set<String>> lazyPropertiesByClass = new ConcurrentHashMap(50);
    protected Persistence persistence = null;

    public AbstractDataManager() {
        this.initPersistence();
    }

    protected void initPersistence() {
        this.persistence = Platform.persistence();
    }

    @Override
    public boolean isEntity(Object entity) {
        return entity != null && this.persistence.isEntity(entity instanceof Class ? (Class<?>)entity : entity.getClass());
    }

    @Override
    public Object getId(Object entity) {
        return this.persistence.getId(entity);
    }

    @Override
    public boolean hasIdProperty(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("entity should not be null");
        }
        return this.persistence.hasIdProperty(entity instanceof Class ? (Class<?>)entity : entity.getClass());
    }

    @Override
    public String getIdPropertyName(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("entity should not be null");
        }
        Property property = this.persistence.getIdProperty(entity instanceof Class ? (Class<?>)entity : entity.getClass());
        return property != null ? property.getName() : null;
    }

    @Override
    public String getDetachedState(Object entity) {
        return this.persistence.getDetachedState(entity);
    }

    @Override
    public Object getVersion(Object entity) {
        return this.persistence.getVersion(entity);
    }

    @Override
    public boolean hasVersionProperty(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("entity should not be null");
        }
        return this.persistence.hasVersionProperty(entity instanceof Class ? (Class<?>)entity : entity.getClass());
    }

    @Override
    public String getVersionPropertyName(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("entity should not be null");
        }
        Property property = this.persistence.getVersionProperty(entity instanceof Class ? (Class<?>)entity : entity.getClass());
        return property != null ? property.getName() : null;
    }

    @Override
    public boolean hasProperty(Object entity, String name) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof EntityProxy) {
            return ((EntityProxy)entity).hasProperty(name);
        }
        return true;
    }

    @Override
    public Object getPropertyValue(Object entity, String name) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityProxy) {
            return ((EntityProxy)entity).getProperty(name);
        }
        return this.persistence.getPropertyValue(entity, name, true);
    }

    @Override
    public void setPropertyValue(Object entity, String name, Object value) {
        if (entity == null) {
            return;
        }
        this.persistence.setPropertyValue(entity, name, value);
    }

    @Override
    public String getUid(Object entity) {
        if (entity == null) {
            return null;
        }
        if (this.persistence.hasUidProperty(entity.getClass())) {
            String uid = this.persistence.getUid(entity);
            if (uid == null) {
                uid = UUIDUtil.randomUUID();
                this.persistence.setUid(entity, uid);
            }
            return uid;
        }
        Object id = this.persistence.getId(entity);
        if (id != null) {
            return entity.getClass().getSimpleName() + ":" + id.toString();
        }
        return entity.getClass().getSimpleName() + "::" + System.identityHashCode(entity);
    }

    @Override
    public String getUidPropertyName(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("entity should not be null");
        }
        Property property = this.persistence.getUidProperty(entity instanceof Class ? (Class<?>)entity : entity.getClass());
        return property != null ? property.getName() : null;
    }

    @Override
    public String getCacheKey(Object entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityProxy) {
            return ((EntityProxy)entity).getClassName() + ":" + ((EntityProxy)entity).getUid();
        }
        return entity.getClass().getName() + ":" + this.getUid(entity);
    }

    @Override
    public boolean isInitialized(Object object) {
        if (object == null) {
            return true;
        }
        return this.persistence.isInitialized(object);
    }

    public void setInitialized(Object object, boolean initialized) {
        this.persistence.setInitialized(object, initialized);
    }

    @Override
    public void copyUid(Object dest, Object obj) {
        if (this.isEntity(obj) && this.persistence.hasUidProperty(obj.getClass())) {
            this.persistence.setUid(dest, this.persistence.getUid(obj));
        }
    }

    @Override
    public void initProxy(Object dest, Object id, boolean initialized, String detachedState) {
        this.persistence.setId(dest, id);
        this.persistence.setInitialized(dest, initialized);
        this.persistence.setDetachedState(dest, detachedState);
    }

    @Override
    public boolean defineProxy(Object dest, Object obj) {
        if (!this.isEntity(dest)) {
            return false;
        }
        try {
            if (obj != null) {
                if (this.persistence.getDetachedState(obj) == null) {
                    return false;
                }
                this.persistence.setId(dest, this.persistence.getId(obj));
                this.persistence.setDetachedState(dest, this.persistence.getDetachedState(obj));
            }
            this.persistence.setInitialized(dest, false);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not proxy class " + obj.getClass());
        }
    }

    @Override
    public void copyProxyState(Object dest, Object obj) {
        if (obj instanceof EntityProxy) {
            return;
        }
        try {
            this.persistence.setInitialized(dest, this.persistence.isInitialized(obj));
            this.persistence.setDetachedState(dest, this.persistence.getDetachedState(obj));
        }
        catch (Exception e) {
            log.error((Throwable)e, "Could not copy internal state of object " + ObjectUtil.toString(obj), new Object[0]);
        }
    }

    @Override
    public Map<String, Object> getPropertyValues(Object entity, boolean excludeVersion, boolean includeReadOnly) {
        return this.getPropertyValues(entity, false, excludeVersion, includeReadOnly);
    }

    @Override
    public Map<String, Object> getPropertyValues(Object entity, boolean excludeIdUid, boolean excludeVersion, boolean includeReadOnly) {
        Object object = entity instanceof EntityProxy ? ((EntityProxy)entity).getWrappedObject() : entity;
        Map propertyValues = this.persistence.getPropertyValues(object, true, excludeIdUid, excludeVersion, includeReadOnly);
        if (entity instanceof EntityProxy) {
            Iterator ipval = propertyValues.entrySet().iterator();
            while (ipval.hasNext()) {
                Map.Entry pval = ipval.next();
                if (!((EntityProxy)entity).hasProperty((String)pval.getKey())) {
                    ipval.remove();
                    continue;
                }
                pval.setValue(((EntityProxy)entity).getProperty((String)pval.getKey()));
            }
        }
        return propertyValues;
    }

    private Set<String> getLazyPropertyNames(Class<?> entityClass) {
        HashSet<String> lazyPropertyNames = (HashSet<String>)lazyPropertiesByClass.get(entityClass);
        if (lazyPropertyNames == null) {
            List lazyProperties = this.persistence.getLazyProperties(entityClass);
            lazyPropertyNames = new HashSet<String>();
            for (Property lazyProperty : lazyProperties) {
                lazyPropertyNames.add(lazyProperty.getName());
            }
            lazyPropertiesByClass.putIfAbsent(entityClass, lazyPropertyNames);
        }
        return lazyPropertyNames;
    }

    @Override
    public boolean isLazyProperty(Object entity, String propertyName) {
        return this.getLazyPropertyNames(entity.getClass()).contains(propertyName);
    }

    @Override
    public void setLazyProperty(Object entity, String propertyName) {
        this.getLazyPropertyNames(entity.getClass()).add(propertyName);
    }

    @Override
    public <T> T newInstance(Object source, Class<T> cast) throws IllegalAccessException, InstantiationException {
        return (T)TypeUtil.newInstance(source.getClass(), cast);
    }

    @Override
    public boolean isDirtyEntity(Object entity) {
        EntityManager entityManager = PersistenceManager.getEntityManager(entity);
        if (entityManager == null) {
            throw new IllegalStateException("Non managed entity: " + entity);
        }
        return entityManager.isDirtyEntity(entity);
    }

    @Override
    public boolean isDeepDirtyEntity(Object entity) {
        EntityManager entityManager = PersistenceManager.getEntityManager(entity);
        if (entityManager == null) {
            throw new IllegalStateException("Non managed entity: " + entity);
        }
        return entityManager.isDeepDirtyEntity(entity);
    }
}

