/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.granite.binding.PropertyChangeHelper;
import org.granite.client.tide.Context;
import org.granite.client.tide.ContextAware;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.data.PersistenceManager;
import org.granite.client.tide.data.impl.JavaBeanDataManager;
import org.granite.client.tide.data.spi.EntityRef;

public class ManagedEntity<T>
implements ContextAware {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private T instance = null;
    private EntityManager entityManager;
    private JavaBeanDataManager dataManager;
    private boolean dirty = false;
    private boolean saved = false;
    private PropertyChangeListener versionChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ManagedEntity.this.updateSaved();
        }
    };

    public ManagedEntity() {
    }

    public ManagedEntity(EntityManager entityManager) {
        this.init(entityManager);
    }

    public ManagedEntity(EntityManager entityManager, T value) {
        this.init(entityManager);
        this.setInstance(value);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public T getInstance() {
        return this.instance;
    }

    public void setInstance(T instance) {
        if (instance == this.instance) {
            return;
        }
        T oldInstance = this.instance;
        this.instance = instance;
        this.instanceChanged(oldInstance, instance);
        this.pcs.firePropertyChange("instance", oldInstance, instance);
    }

    public void setInstance(EntityRef ref) {
        Object instance = this.entityManager.getCachedObject(ref, true);
        this.setInstance(instance);
    }

    public boolean isSaved() {
        return this.saved;
    }

    private void updateSaved() {
        boolean saved;
        boolean bl = this.getInstance() != null ? this.getVersion(this.getInstance()) != null : (saved = false);
        if (saved == this.saved) {
            return;
        }
        boolean oldSaved = this.saved;
        this.saved = saved;
        this.pcs.firePropertyChange("saved", oldSaved, saved);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void updateDirty() {
        boolean dirty;
        boolean bl = dirty = this.getInstance() != null ? this.entityManager.isDeepDirtyEntity(this.getInstance()) : false;
        if (dirty == this.dirty) {
            return;
        }
        boolean oldDirty = this.dirty;
        this.dirty = dirty;
        this.pcs.firePropertyChange("dirty", oldDirty, dirty);
    }

    private void instanceChanged(T oldValue, T newValue) {
        String versionPropertyName;
        if (oldValue != null) {
            this.entityManager.resetEntity(oldValue);
            versionPropertyName = this.getVersionPropertyName(oldValue);
            PropertyChangeHelper.removePropertyChangeListener(oldValue, versionPropertyName, this.versionChangeListener);
        }
        if (newValue == null) {
            return;
        }
        versionPropertyName = this.getVersionPropertyName(newValue);
        PropertyChangeHelper.addPropertyChangeListener(newValue, versionPropertyName, this.versionChangeListener);
        this.updateDirty();
        this.updateSaved();
        EntityManager entityManager = PersistenceManager.getEntityManager(newValue);
        if (entityManager == null) {
            this.entityManager.mergeExternalData(newValue);
        } else if (entityManager != this.entityManager) {
            throw new RuntimeException("Entity " + newValue + " cannot be attached: already attached to another entity manager");
        }
    }

    @Override
    public void setContext(Context context) {
        this.init(context.getEntityManager());
    }

    private void init(EntityManager entityManager) {
        if (this.entityManager == null) {
            this.entityManager = entityManager;
        }
        this.dataManager = (JavaBeanDataManager)this.entityManager.getDataManager();
        this.dataManager.addPropertyChangeListener("deepDirtyEntity", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getSource() == ManagedEntity.this.getInstance()) {
                    ManagedEntity.this.updateDirty();
                }
            }
        });
    }

    public void reset() {
        if (this.instance == null) {
            return;
        }
        this.entityManager.resetEntity(this.instance);
    }

    private String getVersionPropertyName(Object value) {
        String versionPropertyName = this.dataManager.getVersionPropertyName(value);
        if (versionPropertyName == null) {
            throw new RuntimeException("No version property found on entity " + value);
        }
        return versionPropertyName;
    }

    private Object getVersion(Object value) {
        return this.dataManager.getVersion(value);
    }
}

