/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.client.persistence.collection.PersistentCollection;
import org.granite.client.tide.data.DataMerger;
import org.granite.client.tide.data.Value;
import org.granite.client.tide.data.impl.ChangeEntityRef;
import org.granite.client.tide.data.impl.ChangeProxy;
import org.granite.client.tide.data.impl.ObjectUtil;
import org.granite.client.tide.data.spi.EntityRef;
import org.granite.client.tide.data.spi.MergeContext;
import org.granite.client.util.PropertyHolder;
import org.granite.logging.Logger;
import org.granite.tide.data.Change;
import org.granite.tide.data.ChangeRef;
import org.granite.tide.data.ChangeSet;
import org.granite.tide.data.CollectionChange;
import org.granite.tide.data.CollectionChanges;
import org.granite.util.TypeUtil;

public class ChangeMerger
implements DataMerger {
    private static Logger log = Logger.getLogger(ChangeMerger.class);

    @Override
    public boolean accepts(Object obj) {
        return obj instanceof ChangeSet || obj instanceof Change;
    }

    private boolean isForEntity(MergeContext mergeContext, Change change, Object entity) {
        String className = mergeContext.getServerSession().getAliasRegistry().getTypeForAlias(change.getClassName());
        return entity.getClass().getName().equals(className) && change.getUid().equals(mergeContext.getDataManager().getUid(entity));
    }

    private boolean isForEntity(MergeContext mergeContext, ChangeRef changeRef, Object entity) {
        String className = mergeContext.getServerSession().getAliasRegistry().getTypeForAlias(changeRef.getClassName());
        return entity.getClass().getName().equals(className) && changeRef.getUid().equals(mergeContext.getDataManager().getUid(entity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object merge(MergeContext mergeContext, Object changeSet, Object previous, Object parent, String propertyName) {
        Change[] changeArray;
        if (changeSet != null || previous != null) {
            log.debug("merge Change: %s previous %s (change)", new Object[]{ObjectUtil.toString(changeSet), ObjectUtil.toString(previous)});
        }
        Object next = null;
        if (changeSet instanceof ChangeSet && ((ChangeSet)changeSet).isLocal()) {
            next = changeSet;
        }
        if (changeSet instanceof ChangeSet) {
            changeArray = ((ChangeSet)changeSet).getChanges();
        } else {
            Change[] changeArray2 = new Change[1];
            changeArray = changeArray2;
            changeArray2[0] = (Change)changeSet;
        }
        Change[] changes = changeArray;
        boolean local = changeSet instanceof ChangeSet ? ((ChangeSet)changeSet).isLocal() : ((Change)changeSet).isLocal();
        for (Change change : changes) {
            boolean saveUninitAllowed;
            ChangeEntityRef changeEntityRef;
            Object dest;
            if (change.isLocal() && next == null) {
                next = change;
            }
            if ((dest = mergeContext.getCachedObject(changeEntityRef = new ChangeEntityRef(change, mergeContext.getServerSession().getAliasRegistry()))) == null) {
                log.warn("Incoming change received for unknown entity %s: %s", new Object[]{change.getClassName(), change.getUid()});
                continue;
            }
            if (dest != previous && previous != null && !this.isForEntity(mergeContext, change, previous)) continue;
            if (local) {
                boolean saveSkipDirtyCheck = mergeContext.isSkipDirtyCheck();
                saveUninitAllowed = mergeContext.isUninitializeAllowed();
                try {
                    mergeContext.setSkipDirtyCheck(true);
                    mergeContext.setUninitializeAllowed(false);
                    for (Map.Entry me : change.getChanges().entrySet()) {
                        String p = (String)me.getKey();
                        Object val = me.getValue();
                        if (val instanceof CollectionChanges) {
                            for (CollectionChange cc : ((CollectionChanges)val).getChanges()) {
                                if (cc.getKey() != null && !(cc.getKey() instanceof EntityRef)) {
                                    mergeContext.mergeExternal(cc.getKey(), null, dest, p);
                                }
                                if (cc.getValue() == null || cc.getValue() instanceof EntityRef) continue;
                                mergeContext.mergeExternal(cc.getValue(), null, dest, p);
                            }
                            continue;
                        }
                        mergeContext.mergeExternal(val, null, dest, p);
                    }
                    continue;
                }
                finally {
                    mergeContext.setUninitializeAllowed(saveUninitAllowed);
                    mergeContext.setSkipDirtyCheck(saveSkipDirtyCheck);
                }
            }
            if (next == null) {
                next = dest;
            }
            saveUninitAllowed = mergeContext.isUninitializeAllowed();
            try {
                mergeContext.setUninitializeAllowed(false);
                HashMap<String, Object> mergedChanges = new HashMap<String, Object>();
                Object templateObject = TypeUtil.newInstance(dest.getClass(), dest.getClass());
                Object incomingEntity = this.lookupEntity(mergeContext, change.getChanges(), dest, null);
                for (Map.Entry me : change.getChanges().entrySet()) {
                    String p = (String)me.getKey();
                    Object val = me.getValue();
                    if (val instanceof CollectionChanges) {
                        Object target;
                        Object receivedEntity;
                        Collection mergedColl;
                        Object coll = mergeContext.getDataManager().getPropertyValue(dest, p);
                        if (coll instanceof PersistentCollection && !((PersistentCollection)coll).wasInitialized()) {
                            log.debug("Incoming change for uninitialized collection %s:%s.%s", new Object[]{change.getClassName(), change.getUid(), p});
                            continue;
                        }
                        String cacheKey = "CollChange::" + dest.getClass().getName() + ":" + mergeContext.getDataManager().getUid(dest) + "." + p;
                        if (mergeContext.getCachedMerge(cacheKey) != null) {
                            log.warn("Incoming change skipped %s:%s.%s, already processed", new Object[]{change.getClassName(), change.getUid(), p});
                            continue;
                        }
                        mergeContext.pushMerge(cacheKey, coll, false);
                        Map<String, Object> saved = mergeContext.getSavedProperties(dest);
                        boolean unsaved = mergeContext.isUnsaved(dest);
                        if (coll instanceof List) {
                            mergedColl = null;
                            receivedEntity = this.lookupEntity(mergeContext, val, dest, null);
                            if (receivedEntity != null && mergeContext.getDataManager().getPropertyValue(receivedEntity, p) instanceof PersistentCollection && ((PersistentCollection)mergeContext.getDataManager().getPropertyValue(receivedEntity, p)).wasInitialized()) {
                                mergedColl = (List)mergeContext.getDataManager().getPropertyValue(receivedEntity, p);
                            } else {
                                target = coll instanceof PropertyHolder ? ((PropertyHolder)coll).getObject() : coll;
                                mergedColl = mergeContext.getDataManager().newInstance(target, List.class);
                                if (!unsaved) {
                                    mergedColl.addAll((List)coll);
                                }
                                this.applyListChanges(mergeContext, (List<Object>)mergedColl, (CollectionChanges)val, saved != null && saved.get(p) instanceof List ? (List)saved.get(p) : null);
                            }
                            mergedChanges.put(p, mergedColl);
                            continue;
                        }
                        if (coll instanceof Set) {
                            mergedColl = null;
                            receivedEntity = this.lookupEntity(mergeContext, val, dest, null);
                            if (receivedEntity != null && mergeContext.getDataManager().getPropertyValue(receivedEntity, p) instanceof PersistentCollection && ((PersistentCollection)mergeContext.getDataManager().getPropertyValue(receivedEntity, p)).wasInitialized()) {
                                mergedColl = (Set)mergeContext.getDataManager().getPropertyValue(receivedEntity, p);
                            } else {
                                target = coll instanceof PropertyHolder ? ((PropertyHolder)coll).getObject() : coll;
                                mergedColl = mergeContext.getDataManager().newInstance(target, Set.class);
                                if (!unsaved) {
                                    mergedColl.addAll((Set)coll);
                                }
                                this.applySetChanges(mergeContext, (Set<Object>)mergedColl, (CollectionChanges)val, saved != null && saved.get(p) instanceof List ? (List)saved.get(p) : null);
                            }
                            mergedChanges.put(p, mergedColl);
                            continue;
                        }
                        if (!(coll instanceof Map)) continue;
                        Map mergedMap = null;
                        receivedEntity = this.lookupEntity(mergeContext, val, dest, null);
                        if (receivedEntity != null && mergeContext.getDataManager().getPropertyValue(receivedEntity, p) instanceof PersistentCollection && ((PersistentCollection)mergeContext.getDataManager().getPropertyValue(receivedEntity, p)).wasInitialized()) {
                            mergedMap = (Map)mergeContext.getDataManager().getPropertyValue(receivedEntity, p);
                        } else {
                            target = coll instanceof PropertyHolder ? ((PropertyHolder)coll).getObject() : coll;
                            mergedMap = mergeContext.getDataManager().newInstance(target, Map.class);
                            if (!unsaved) {
                                mergedMap.putAll((Map)coll);
                            }
                            this.applyMapChanges(mergeContext, mergedMap, (CollectionChanges)val, saved != null && saved.get(p) instanceof List ? (List)saved.get(p) : null);
                        }
                        mergedChanges.put(p, mergedMap);
                        continue;
                    }
                    mergedChanges.put(p, val);
                }
                Class changeClass = TypeUtil.forName((String)changeEntityRef.getClassName());
                Number version = change.getVersion();
                if (incomingEntity != null && mergeContext.getDataManager().getVersion(incomingEntity) != null && (version == null || ((Number)mergeContext.getDataManager().getVersion(incomingEntity)).longValue() > version.longValue())) {
                    version = (Number)mergeContext.getDataManager().getVersion(incomingEntity);
                }
                ChangeProxy changeProxy = new ChangeProxy(mergeContext.getDataManager().getUidPropertyName(changeClass), change.getUid(), mergeContext.getDataManager().getIdPropertyName(changeClass), change.getId(), mergeContext.getDataManager().getVersionPropertyName(changeClass), version, mergedChanges, templateObject);
                mergeContext.mergeExternal(changeProxy, dest, parent, propertyName);
                for (String p : mergedChanges.keySet()) {
                    Object v = mergeContext.getDataManager().getPropertyValue(dest, p);
                    if (!(v instanceof Collection) && !(v instanceof Map)) continue;
                    mergeContext.pushMerge(v, v, false);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Received Change for unknown class", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error instantiating class", e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Error instantiating class", e);
            }
            finally {
                mergeContext.setUninitializeAllowed(saveUninitAllowed);
            }
            if (dest == null) continue;
            log.debug("merge change result: %s", new Object[]{ObjectUtil.toString(dest)});
        }
        return next;
    }

    /*
     * WARNING - void declaration
     */
    private void applyListChanges(MergeContext mergeContext, List<Object> coll, CollectionChanges ccs, List<Object> savedArray) {
        if (savedArray != null) {
            void var8_14;
            ArrayList<Object> savedList = new ArrayList<Object>(savedArray);
            CollectionChange[] arr$ = ccs.getChanges();
            int len$ = arr$.length;
            boolean bl = false;
            while (var8_14 < len$) {
                CollectionChange cc = arr$[var8_14];
                if (cc.getType() == -1) {
                    int i;
                    if (cc.getKey() != null && (Integer)cc.getKey() >= 0 && cc.getValue() instanceof ChangeRef && this.isForEntity(mergeContext, (ChangeRef)cc.getValue(), savedList.get((Integer)cc.getKey()))) {
                        savedList.remove((Integer)cc.getKey());
                    } else if (cc.getKey() != null && (Integer)cc.getKey() >= 0 && mergeContext.objectEquals(cc.getValue(), savedList.get((Integer)cc.getKey()))) {
                        savedList.remove((Integer)cc.getKey());
                    } else if (cc.getKey() == null && cc.getValue() instanceof ChangeRef) {
                        for (i = 0; i < savedList.size(); ++i) {
                            if (!this.isForEntity(mergeContext, (ChangeRef)cc.getValue(), savedList.get(i))) continue;
                            savedList.remove(i);
                            --i;
                        }
                    } else if (cc.getKey() == null) {
                        for (i = 0; i < savedList.size(); ++i) {
                            if (!mergeContext.objectEquals(cc.getValue(), savedList.get(i))) continue;
                            savedList.remove(i);
                            --i;
                        }
                    }
                } else if (cc.getType() == 1) {
                    if (cc.getKey() != null && (Integer)cc.getKey() >= 0) {
                        int key = (Integer)cc.getKey();
                        if (key > savedList.size()) {
                            log.warn("Could not add received element at index %d", new Object[]{key});
                        } else {
                            savedList.add(key, cc.getValue());
                        }
                    } else if (cc.getKey() != null) {
                        savedList.add(cc.getValue());
                    } else {
                        savedList.add(cc.getValue());
                    }
                } else if (cc.getType() == 0 && cc.getKey() != null && (Integer)cc.getKey() >= 0) {
                    savedList.set((Integer)cc.getKey(), cc.getValue());
                }
                ++var8_14;
            }
            block3: for (int i = 0; i < coll.size(); ++i) {
                for (Object e : savedList) {
                    if (!mergeContext.objectEquals(coll.get(i), e) || coll.get(i) == e) continue;
                    coll.set(i, e);
                    continue block3;
                }
            }
            savedArray.clear();
            savedArray.addAll(savedList);
        } else {
            for (CollectionChange collectionChange : ccs.getChanges()) {
                if (collectionChange.getType() == -1) {
                    int i;
                    if (collectionChange.getKey() != null && (Integer)collectionChange.getKey() >= 0 && collectionChange.getValue() instanceof ChangeRef && this.isForEntity(mergeContext, (ChangeRef)collectionChange.getValue(), coll.get((Integer)collectionChange.getKey()))) {
                        coll.remove((Integer)collectionChange.getKey());
                        continue;
                    }
                    if (collectionChange.getKey() != null && (Integer)collectionChange.getKey() >= 0 && mergeContext.objectEquals(collectionChange.getValue(), coll.get((Integer)collectionChange.getKey()))) {
                        coll.remove((Integer)collectionChange.getKey());
                        continue;
                    }
                    if (collectionChange.getKey() == null && collectionChange.getValue() instanceof ChangeRef) {
                        for (i = 0; i < coll.size(); ++i) {
                            if (!this.isForEntity(mergeContext, (ChangeRef)collectionChange.getValue(), coll.get(i))) continue;
                            coll.remove(i);
                            --i;
                        }
                        continue;
                    }
                    if (collectionChange.getKey() != null) continue;
                    for (i = 0; i < coll.size(); ++i) {
                        if (!this.isForEntity(mergeContext, (ChangeRef)collectionChange.getValue(), coll.get(i))) continue;
                        coll.remove(i);
                        --i;
                    }
                    continue;
                }
                if (collectionChange.getType() == 1) {
                    if (collectionChange.getKey() != null && (Integer)collectionChange.getKey() >= 0) {
                        int key = (Integer)collectionChange.getKey();
                        if (key > coll.size()) {
                            log.warn("Could not add received element at index %d", new Object[]{key});
                            continue;
                        }
                        coll.add(key, collectionChange.getValue());
                        continue;
                    }
                    if (collectionChange.getKey() != null) {
                        coll.add(collectionChange.getValue());
                        continue;
                    }
                    coll.add(collectionChange.getValue());
                    continue;
                }
                if (collectionChange.getType() != 0 || collectionChange.getKey() == null || (Integer)collectionChange.getKey() < 0) continue;
                coll.set((Integer)collectionChange.getKey(), collectionChange.getValue());
            }
        }
    }

    private void applySetChanges(MergeContext mergeContext, Set<Object> coll, CollectionChanges ccs, List<Object> savedArray) {
        if (savedArray != null) {
            ArrayList<Object> savedList = new ArrayList<Object>(savedArray);
            for (CollectionChange cc : ccs.getChanges()) {
                if (cc.getType() == -1) {
                    int n;
                    if (cc.getValue() instanceof ChangeRef) {
                        for (n = 0; n < savedList.size(); ++n) {
                            if (!this.isForEntity(mergeContext, (ChangeRef)cc.getValue(), savedList.get(n))) continue;
                            savedList.remove(n);
                            --n;
                        }
                        continue;
                    }
                    for (n = 0; n < savedList.size(); ++n) {
                        if (!mergeContext.objectEquals(cc.getValue(), savedList.get(n))) continue;
                        savedList.remove(n);
                        --n;
                    }
                    continue;
                }
                if (cc.getType() != 1) continue;
                savedList.add(cc.getValue());
            }
            ArrayList toAdd = new ArrayList();
            Iterator<Object> ic = coll.iterator();
            block3: while (ic.hasNext()) {
                Object c = ic.next();
                for (Object e : savedList) {
                    if (!mergeContext.objectEquals(c, e) || c == e) continue;
                    ic.remove();
                    toAdd.add(e);
                    continue block3;
                }
            }
            coll.addAll(toAdd);
            savedArray.clear();
            savedArray.addAll(savedList);
        } else {
            for (CollectionChange cc : ccs.getChanges()) {
                if (cc.getType() == -1) {
                    Iterator<Object> ic;
                    if (cc.getKey() == null && cc.getValue() instanceof ChangeRef) {
                        ic = coll.iterator();
                        while (ic.hasNext()) {
                            Object object = ic.next();
                            if (!this.isForEntity(mergeContext, (ChangeRef)cc.getValue(), object)) continue;
                            ic.remove();
                        }
                        continue;
                    }
                    if (cc.getKey() != null) continue;
                    ic = coll.iterator();
                    while (ic.hasNext()) {
                        Object object = ic.next();
                        if (!this.isForEntity(mergeContext, (ChangeRef)cc.getValue(), object)) continue;
                        ic.remove();
                    }
                    continue;
                }
                if (cc.getType() != 1) continue;
                coll.add(cc.getValue());
            }
        }
    }

    private void applyMapChanges(MergeContext mergeContext, Map<Object, Object> map, CollectionChanges ccs, List<Object[]> savedArray) {
        if (savedArray != null) {
            HashMap<Object, Object> savedMap = new HashMap<Object, Object>();
            for (Object[] se : savedArray) {
                savedMap.put(se[0], se[1]);
            }
            for (CollectionChange cc : ccs.getChanges()) {
                Object key;
                Object object = key = cc.getKey() instanceof ChangeRef ? mergeContext.getCachedObject(cc.getKey()) : cc.getKey();
                if (cc.getType() == -1) {
                    if (key != null && cc.getValue() instanceof ChangeRef && this.isForEntity(mergeContext, (ChangeRef)cc.getValue(), savedMap.get(key))) {
                        savedMap.remove(key);
                        continue;
                    }
                    if (key == null || !mergeContext.objectEquals(cc.getValue(), savedMap.get(key))) continue;
                    savedMap.remove(key);
                    continue;
                }
                if (cc.getType() != 0 && cc.getType() != 1) continue;
                savedMap.put(key, cc.getValue());
            }
            HashMap<Object, Object> toAdd = new HashMap<Object, Object>();
            Iterator<Map.Entry<Object, Object>> ime = map.entrySet().iterator();
            while (ime.hasNext()) {
                Map.Entry<Object, Object> me = ime.next();
                Object key = me.getKey();
                Object value = me.getValue();
                for (Object k : savedMap.keySet()) {
                    Object v;
                    if (mergeContext.objectEquals(key, k) && key != k) {
                        ime.remove();
                        key = k;
                        toAdd.put(key, value);
                    }
                    if (mergeContext.objectEquals(value, k) && value != k) {
                        value = k;
                        toAdd.put(key, value);
                    }
                    if (mergeContext.objectEquals(key, v = savedMap.get(k)) && key != v) {
                        ime.remove();
                        key = v;
                        toAdd.put(key, value);
                    }
                    if (!mergeContext.objectEquals(value, v) || value == v) continue;
                    value = v;
                    toAdd.put(key, value);
                }
            }
            map.putAll(toAdd);
            savedArray.clear();
            for (Map.Entry me : savedMap.entrySet()) {
                savedArray.add(new Object[]{me.getKey(), me.getValue()});
            }
        } else {
            for (CollectionChange cc : ccs.getChanges()) {
                Object key;
                Object object = key = cc.getKey() instanceof ChangeRef ? mergeContext.getCachedObject(cc.getKey()) : cc.getKey();
                if (cc.getType() == -1) {
                    if (key != null && cc.getValue() instanceof ChangeRef && this.isForEntity(mergeContext, (ChangeRef)cc.getValue(), map.get(key))) {
                        map.remove(key);
                        continue;
                    }
                    if (key == null || !mergeContext.objectEquals(cc.getValue(), map.get(key))) continue;
                    map.remove(key);
                    continue;
                }
                if (cc.getType() != 0 && cc.getType() != 1) continue;
                map.put(key, cc.getValue());
            }
        }
    }

    private Object lookupEntity(MergeContext mergeContext, Object graph, Object obj, IdentityHashMap<Object, Boolean> cache) {
        if (graph == null) {
            return null;
        }
        if (!graph.getClass().isArray() && (ObjectUtil.isSimple(graph) || graph instanceof Value || graph instanceof byte[] || graph instanceof Enum)) {
            return null;
        }
        if (cache == null) {
            cache = new IdentityHashMap();
        }
        if (cache.containsKey(graph)) {
            return null;
        }
        cache.put(graph, true);
        if (mergeContext.getDataManager().isEntity(graph) && !mergeContext.getDataManager().isInitialized(graph)) {
            return null;
        }
        if (mergeContext.objectEquals(graph, obj) && graph != obj) {
            return graph;
        }
        Object found = null;
        if (graph instanceof CollectionChanges) {
            for (CollectionChange cc : ((CollectionChanges)graph).getChanges()) {
                found = this.lookupEntity(mergeContext, cc, obj, cache);
                if (found == null) continue;
                return found;
            }
        } else if (graph instanceof CollectionChange) {
            if (((CollectionChange)graph).getKey() != null && (found = this.lookupEntity(mergeContext, ((CollectionChange)graph).getKey(), obj, cache)) != null) {
                return found;
            }
            if (((CollectionChange)graph).getValue() != null && (found = this.lookupEntity(mergeContext, ((CollectionChange)graph).getValue(), obj, cache)) != null) {
                return found;
            }
            return null;
        }
        if (graph instanceof PersistentCollection && !((PersistentCollection)graph).wasInitialized()) {
            return null;
        }
        if (graph.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(graph); ++i) {
                found = this.lookupEntity(mergeContext, Array.get(graph, i), obj, cache);
                if (found == null) continue;
                return found;
            }
        } else {
            if (graph instanceof Collection) {
                for (Object e : (Collection)graph) {
                    found = this.lookupEntity(mergeContext, e, obj, cache);
                    if (found == null) continue;
                    return found;
                }
                return null;
            }
            if (graph instanceof Map) {
                for (Map.Entry entry : ((Map)graph).entrySet()) {
                    found = this.lookupEntity(mergeContext, entry.getKey(), obj, cache);
                    if (found != null) {
                        return found;
                    }
                    found = this.lookupEntity(mergeContext, entry.getValue(), obj, cache);
                    if (found == null) continue;
                    return found;
                }
                return null;
            }
            for (Object object : mergeContext.getDataManager().getPropertyValues(graph, true, false, true).values()) {
                found = this.lookupEntity(mergeContext, object, obj, cache);
                if (found == null) continue;
                return found;
            }
            return null;
        }
        return null;
    }
}

