/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.data;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.granite.client.persistence.Lazy;
import org.granite.client.tide.data.ChangeSetBuilder;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.data.PersistenceManager;
import org.granite.client.tide.data.impl.ObjectUtil;
import org.granite.client.tide.server.ArgumentPreprocessor;
import org.granite.client.tide.server.ServerSession;
import org.granite.logging.Logger;

public class ChangeArgumentPreprocessor
implements ArgumentPreprocessor {
    private static final Logger log = Logger.getLogger(ChangeArgumentPreprocessor.class);

    @Override
    public Object[] preprocess(ServerSession serverSession, Method method, Object[] args) {
        if (method == null) {
            return args;
        }
        EntityManager entityManager = null;
        ChangeSetBuilder csb = null;
        for (int idx = 0; idx < args.length; ++idx) {
            Object entity;
            Annotation[] annotations = method.getParameterAnnotations()[idx];
            if (annotations == null) continue;
            boolean found = false;
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().equals(Lazy.class)) continue;
                found = true;
                break;
            }
            if (!found || (entity = args[idx]) == null) continue;
            if (entityManager == null) {
                entityManager = PersistenceManager.getEntityManager(entity);
                csb = new ChangeSetBuilder(entityManager, serverSession);
            } else if (PersistenceManager.getEntityManager(entity) != entityManager) {
                throw new IllegalArgumentException("All arguments passed to remote call must be in the same entity manager");
            }
            if (entityManager == null || !entityManager.getDataManager().hasVersionProperty(entity) || entityManager.getDataManager().getVersion(entity) == null) continue;
            log.debug("Building ChangeSet for argument %d: %s", new Object[]{idx, ObjectUtil.toString(entity)});
            args[idx] = csb.buildEntityChangeSet(entity);
        }
        return args;
    }
}

