/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.collection;

import org.granite.client.persistence.Loader;
import org.granite.client.persistence.collection.PersistentCollection;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.data.PersistenceManager;
import org.granite.client.tide.server.ServerSession;

public class CollectionLoader<C>
implements Loader<C> {
    private final ServerSession serverSession;
    private final Object entity;
    private final String propertyName;
    private boolean localInitializing = false;
    private boolean initializing = false;
    private PersistentCollection.InitializationCallback<C> initializationCallback = null;

    public CollectionLoader(ServerSession serverSession, Object entity, String propertyName) {
        this.serverSession = serverSession;
        this.entity = entity;
        this.propertyName = propertyName;
    }

    public boolean isInitializing() {
        return this.initializing;
    }

    public void onInitializing() {
        this.localInitializing = true;
    }

    public void onInitialize() {
        this.localInitializing = false;
    }

    public void onUninitialize() {
        this.initializing = false;
        this.localInitializing = false;
        this.initializationCallback = null;
    }

    public void load(PersistentCollection<C> collection, PersistentCollection.InitializationCallback<C> callback) {
        if (this.localInitializing) {
            return;
        }
        this.initializationCallback = callback;
        EntityManager entityManager = PersistenceManager.getEntityManager(this.entity);
        if (!this.initializing && entityManager.initializeObject(this.serverSession, this.entity, this.propertyName, collection)) {
            this.initializing = true;
        }
    }
}

