/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide.collection;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.PreDestroy;
import org.granite.client.tide.Context;
import org.granite.client.tide.ContextAware;
import org.granite.client.tide.Initializable;
import org.granite.client.tide.NameAware;
import org.granite.client.tide.collection.PageFilterFinder;
import org.granite.client.tide.collection.SimpleFilterFinder;
import org.granite.client.tide.collection.SortAdapter;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.events.TideEvent;
import org.granite.client.tide.events.TideEventObserver;
import org.granite.client.tide.impl.ComponentImpl;
import org.granite.client.tide.server.Component;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.tide.server.TideFaultEvent;
import org.granite.client.tide.server.TideResponder;
import org.granite.client.tide.server.TideResultEvent;
import org.granite.client.tide.server.TideRpcEvent;
import org.granite.client.util.PropertyHolder;
import org.granite.logging.Logger;
import org.granite.tide.data.model.Page;
import org.granite.tide.data.model.PageInfo;
import org.granite.tide.data.model.SortInfo;
import org.granite.util.TypeUtil;

public abstract class AbstractPagedCollection<E, F>
implements List<E>,
Component,
PropertyHolder,
NameAware,
ContextAware,
Initializable,
TideEventObserver {
    private static final Logger log = Logger.getLogger(AbstractPagedCollection.class);
    private final ServerSession serverSession;
    private String componentName = null;
    private String remoteComponentName = null;
    private Class<? extends Component> remoteComponentClass = null;
    private Component component = null;
    private Context context = null;
    private String methodName = "find";
    private boolean usePage = false;
    private PageFilterFinder<E> pageFilterFinder = null;
    private SimpleFilterFinder<E> simpleFilterFinder = null;
    protected SortAdapter sortAdapter = null;
    private SortInfo sortInfo = new SortInfo();
    private Class<F> filterClass = null;
    protected boolean initializing = false;
    private boolean initSent = false;
    protected int first;
    protected int last;
    protected int max;
    protected int count;
    private E[] localIndex = null;
    protected boolean fullRefresh = false;
    protected boolean filterRefresh = false;
    private boolean cancelPendingCalls = false;
    private Class<? extends E> elementClass;
    private String elementName;
    private Set<String> entityNames = new HashSet<String>();
    private List<Integer[]> pendingRanges = new ArrayList<Integer[]>();
    private List<Future<?>> pendingCalls = new ArrayList();

    public AbstractPagedCollection() {
        this.serverSession = null;
        this.initCollection();
    }

    public AbstractPagedCollection(ServerSession serverSession) {
        this.serverSession = serverSession;
        this.initFilter();
        this.initCollection();
    }

    public AbstractPagedCollection(Component remoteComponent, String methodName, int maxResults) {
        this.component = remoteComponent;
        this.methodName = methodName;
        this.max = maxResults;
        this.serverSession = null;
        this.initFilter();
        this.initCollection();
        this.initFilterFinder();
    }

    public AbstractPagedCollection(Component remoteComponent, PageFilterFinder<E> finder, int maxResults) {
        this.component = remoteComponent;
        this.pageFilterFinder = finder;
        this.max = maxResults;
        this.serverSession = null;
        this.initFilter();
        this.initCollection();
    }

    public AbstractPagedCollection(Component remoteComponent, SimpleFilterFinder<E> finder, int maxResults) {
        this.component = remoteComponent;
        this.simpleFilterFinder = finder;
        this.max = maxResults;
        this.serverSession = null;
        this.initFilter();
        this.initCollection();
    }

    private void initCollection() {
        log.debug("create collection", new Object[0]);
        this.first = 0;
        this.last = 0;
        this.count = 0;
        this.initializing = true;
        this.initComponent();
    }

    private void initComponent() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            ParameterizedType supertype = (ParameterizedType)superclass;
            if (supertype.getActualTypeArguments()[0] instanceof Class) {
                this.setElementClass((Class)supertype.getActualTypeArguments()[0]);
            }
            if (supertype.getActualTypeArguments()[1] instanceof Class) {
                try {
                    this.setFilterClass((Class)supertype.getActualTypeArguments()[1]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not init filter for type " + supertype.getActualTypeArguments()[1], e);
                }
            }
        }
    }

    protected abstract void initFilter();

    @Override
    public int size() {
        this.initialFind();
        if (this.localIndex != null) {
            return this.count;
        }
        return 0;
    }

    protected void updateCount(int cnt) {
        this.count = cnt;
    }

    public void setMaxResults(int max) {
        this.max = max;
    }

    public void setElementClass(Class<? extends E> elementClass) {
        this.elementClass = elementClass;
        if (this.elementName != null) {
            this.entityNames.remove(this.elementName);
        }
        String string = this.elementName = elementClass != null ? elementClass.getSimpleName() : null;
        if (this.elementName != null) {
            this.entityNames.add(this.elementName);
        }
    }

    public Class<? extends E> getElementClass() {
        return this.elementClass;
    }

    public void setCancelPendingCalls(boolean cancel) {
        this.cancelPendingCalls = cancel;
    }

    @Override
    public void setName(String componentName) {
        this.componentName = componentName;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
        if (this.remoteComponentName != null) {
            this.setRemoteComponentName(this.remoteComponentName);
        }
        if (this.remoteComponentClass != null) {
            try {
                this.setRemoteComponentClass(this.remoteComponentClass);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not init context", e);
            }
        }
        if (this.component instanceof ContextAware) {
            ((ContextAware)((Object)this.component)).setContext(context);
        }
    }

    @Override
    public String getName() {
        return this.remoteComponentName;
    }

    public void setRemoteComponentName(String remoteComponentName) {
        if (remoteComponentName == null) {
            throw new IllegalArgumentException("remoteComponentName cannot be null");
        }
        this.remoteComponentName = remoteComponentName;
        if (this.context == null) {
            this.component = null;
            return;
        }
        this.component = (Component)this.context.byName(remoteComponentName);
        if (this.component == null || !(this.component instanceof ComponentImpl)) {
            this.component = new ComponentImpl(this.serverSession);
            this.context.set(remoteComponentName, this.component);
        }
    }

    public void setRemoteComponentClass(Class<? extends Component> remoteComponentClass) throws IllegalAccessException, InstantiationException {
        if (remoteComponentClass == null) {
            throw new IllegalArgumentException("remoteComponentClass cannot be null");
        }
        this.remoteComponentClass = remoteComponentClass;
        if (this.context == null) {
            this.component = null;
            return;
        }
        this.component = this.context.byType(remoteComponentClass);
        if (this.component == null) {
            this.component = (Component)TypeUtil.newInstance(remoteComponentClass, (Class[])new Class[]{ServerSession.class}, (Object[])new Object[]{this.serverSession});
            this.context.set(this.component);
        }
    }

    public void setRemoteComponent(Component remoteComponent) {
        if (remoteComponent == null) {
            throw new IllegalArgumentException("remoteComponent cannot be null");
        }
        this.component = remoteComponent;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setPageFilterFinder(PageFilterFinder<E> finder) {
        this.pageFilterFinder = finder;
    }

    public void setSimpleFilterFinder(SimpleFilterFinder<E> finder) {
        this.simpleFilterFinder = finder;
    }

    public void setUsePage(boolean usePage) {
        this.usePage = usePage;
    }

    @Override
    public void init() {
        if (this.component != null) {
            return;
        }
        this.component = new ComponentImpl(this.serverSession);
        ((ComponentImpl)this.component).setName(this.componentName);
        ((ComponentImpl)this.component).setContext(this.context);
    }

    public void setSortAdapter(SortAdapter sortAdapter) {
        this.sortAdapter = sortAdapter;
        if (sortAdapter != null) {
            sortAdapter.retrieve(this.sortInfo);
        }
    }

    public SortAdapter getSortAdapter() {
        return this.sortAdapter;
    }

    public void resetSort() {
        this.sortAdapter = null;
        this.sortInfo.setOrder(null);
        this.sortInfo.setDesc(null);
    }

    public void setFilterClass(Class<F> filterClass) throws IllegalAccessException, InstantiationException {
        if (Map.class.isAssignableFrom(filterClass)) {
            this.setFilter(null);
            return;
        }
        this.filterClass = filterClass;
        this.setFilter(TypeUtil.newInstance(filterClass, filterClass));
    }

    public void resetFilter() {
        if (this.filterClass == null) {
            this.setFilter(null);
            return;
        }
        try {
            this.setFilter(TypeUtil.newInstance(this.filterClass, this.filterClass));
        }
        catch (Exception e) {
            log.error((Throwable)e, "Could not reset typed filter for PagedQuery %s", new Object[]{this.getName()});
        }
    }

    public abstract void setFilter(F var1);

    public void reset() {
        this.resetFilter();
        this.resetSort();
        this.clear();
    }

    @Override
    public void handleEvent(TideEvent event) {
        String entityName;
        if (event.getType().startsWith(EntityManager.UpdateKind.REFRESH.eventName() + ".") && this.entityNames.contains(entityName = event.getType().substring(EntityManager.UpdateKind.REFRESH.eventName().length() + 1))) {
            this.fullRefresh();
        }
    }

    @Override
    @PreDestroy
    public void clear() {
        this.clearLocalIndex();
        this.first = 0;
        this.last = this.first + this.max;
        this.updateCount(0);
        this.getWrappedList().clear();
        this.initializing = true;
        this.initSent = false;
        this.fullRefresh = false;
        this.filterRefresh = false;
    }

    private void executeFind(int first, int last) {
        log.debug("find from %d to %d", new Object[]{first, last});
        if (this.cancelPendingCalls) {
            for (Future<?> pendingCall : this.pendingCalls) {
                pendingCall.cancel(true);
            }
        }
        this.pendingRanges.add(0, new Integer[]{first, last});
        this.pendingCalls.add(0, this.find(first, last));
    }

    protected Future<?> find(int first, int last) {
        int max = 0;
        if (this.initializing && this.max > 0) {
            max = this.max;
        } else if (!this.initializing) {
            max = last - first;
        }
        Object filter = this.cloneFilter();
        return this.doFind(filter, first, max);
    }

    protected synchronized Future<?> doFind(Object filter, int first, int max) {
        boolean[] desc;
        String[] order;
        if (this.sortAdapter != null) {
            this.sortAdapter.retrieve(this.sortInfo);
        }
        if ((order = this.sortInfo.getOrder()) != null && order.length == 0) {
            order = null;
        }
        if ((desc = this.sortInfo.getDesc()) != null && desc.length == 0) {
            desc = null;
        }
        this.initFilterFinder();
        if (this.pageFilterFinder != null) {
            PageInfo pageInfo = new PageInfo(first, max, order, desc);
            PagedCollectionResponder findResponder = new PagedCollectionResponder(first, max);
            return this.pageFilterFinder.find(filter, pageInfo, findResponder);
        }
        PagedCollectionResponder<Map<String, Object>> findResponder = new PagedCollectionResponder<Map<String, Object>>(first, max);
        return this.simpleFilterFinder.find(filter, first, max, order, desc, findResponder);
    }

    public abstract F getFilter();

    protected abstract Object cloneFilter();

    private void initFilterFinder() {
        if (this.pageFilterFinder != null || this.simpleFilterFinder != null) {
            return;
        }
        boolean usePage = this.usePage;
        try {
            for (Method m : this.component.getClass().getMethods()) {
                if (!m.getName().equals(this.methodName) || m.getParameterTypes().length < 2 || !PageInfo.class.isAssignableFrom(m.getParameterTypes()[1])) continue;
                usePage = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (usePage) {
            this.pageFilterFinder = new ComponentPageFilterFinder(this.component, this.methodName);
        } else {
            this.simpleFilterFinder = new ComponentSimpleFilterFinder(this.component, this.methodName);
        }
    }

    protected Page<E> getResult(TideResultEvent<?> event, int first, int max) {
        if (event.getResult() instanceof Page) {
            return (Page)event.getResult();
        }
        Map result = (Map)event.getResult();
        Page page = new Page(result.containsKey("firstResult") ? (Integer)result.get("firstResult") : first, result.containsKey("maxResults") ? (Integer)result.get("maxResults") : max, ((Number)result.get("resultCount")).intValue(), (List)result.get("resultList"));
        return page;
    }

    public boolean fullRefresh() {
        this.fullRefresh = true;
        return this.refresh();
    }

    public boolean refresh() {
        F filter = this.getFilter();
        if (filter != null && this.context.getEntityManager().isDeepDirtyEntity(filter)) {
            this.filterRefresh = true;
            this.fullRefresh = true;
        }
        this.pendingRanges.clear();
        this.pendingCalls.clear();
        if (this.fullRefresh) {
            log.debug("full refresh", new Object[0]);
            this.clearLocalIndex();
            this.fullRefresh = false;
            if (this.filterRefresh) {
                this.first = 0;
                this.last = this.first + this.max;
                this.filterRefresh = false;
            }
        } else {
            log.debug("refresh", new Object[0]);
        }
        if (this.initSent || !this.initialFind()) {
            this.executeFind(this.first, this.last);
        }
        return true;
    }

    private boolean initialFind() {
        if (this.max > 0 && !this.initializing) {
            return false;
        }
        if (!this.initSent) {
            log.debug("initial find", new Object[0]);
            this.executeFind(0, this.max);
            this.initSent = true;
        }
        return true;
    }

    private void clearLocalIndex() {
        this.localIndex = null;
    }

    protected abstract void firePageChange(TideRpcEvent var1, int var2, int var3, List<E> var4);

    protected void initialize(TideResultEvent<?> event) {
    }

    protected void findResult(TideResultEvent<?> event, int first, int max) {
        Page<E> page = this.getResult(event, first, max);
        this.handleResult(page, event, first, max);
    }

    private String pendingRangesString() {
        if (this.pendingRanges == null || this.pendingRanges.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.pendingRanges.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.pendingRanges.get(i)[0]).append("-").append(this.pendingRanges.get(i)[1]);
        }
        return sb.toString();
    }

    protected void handleResult(Page<E> page, TideResultEvent<?> event, int first, int max) {
        List list = page.getResultList();
        if (log.isDebugEnabled()) {
            log.debug("handle result %d - %d (%s)", new Object[]{first, max, this.pendingRangesString()});
        }
        int pendingIndex = -1;
        Iterator<Integer[]> ipr = this.pendingRanges.iterator();
        while (ipr.hasNext()) {
            Integer[] pr = ipr.next();
            ++pendingIndex;
            if (pr[0] != first || pr[1] != first + max) continue;
            ipr.remove();
            this.pendingCalls.remove(pendingIndex);
            break;
        }
        if (this.initializing && event != null) {
            if (this.max == 0 && page.getMaxResults() > 0) {
                this.max = page.getMaxResults();
            }
            this.initialize(event);
        }
        if (pendingIndex > 0) {
            return;
        }
        int nextFirst = page.getFirstResult();
        int nextLast = nextFirst + page.getMaxResults();
        int pageNum = max > 0 ? nextFirst / max : 0;
        log.debug("handle result page %d (%d - %d)", new Object[]{pageNum, nextFirst, nextLast});
        this.updateCount(page.getResultCount());
        if (this.localIndex != null) {
            ArrayList entityNames = new ArrayList();
            for (int i = 0; i < this.localIndex.length; ++i) {
                String entityName;
                if (this.localIndex[i] == null || (entityName = this.localIndex[i].getClass().getSimpleName()).equals(this.elementName)) continue;
                entityNames.remove(entityName);
            }
        }
        for (Object o : list) {
            if (this.elementClass != null && (o == null || !o.getClass().isAssignableFrom(this.elementClass))) continue;
            this.elementClass = o.getClass();
        }
        if (this.elementClass == null) {
            this.localIndex = new Object[0];
            log.warn("Cannot determine elementClass from empty content, consider calling setElementClass manually", new Object[0]);
        } else {
            this.localIndex = (Object[])Array.newInstance(this.elementClass, list.size());
            this.localIndex = list.toArray(this.localIndex);
            if (this.localIndex != null) {
                for (int i = 0; i < this.localIndex.length; ++i) {
                    String entityName;
                    if (this.localIndex[i] == null || (entityName = this.localIndex[i].getClass().getSimpleName()).equals(this.elementName)) continue;
                    this.entityNames.add(entityName);
                }
            }
        }
        int previousFirst = this.first;
        int previousLast = this.last;
        this.first = nextFirst;
        this.last = nextLast;
        ArrayList<E> savedSnapshot = null;
        if (this.initializing) {
            this.initializing = false;
            this.getWrappedList().addAll(list);
        } else {
            log.debug("Adjusting from %d-%d to %d-%d size %d", new Object[]{previousFirst, previousLast, nextFirst, nextLast, list.size()});
            if (nextFirst > previousFirst && nextFirst < previousLast) {
                this.getInternalWrappedList().subList(0, Math.min(this.getInternalWrappedList().size(), nextFirst - previousFirst)).clear();
                for (int i = 0; i < nextFirst - previousFirst && previousLast - nextFirst + i < list.size(); ++i) {
                    Object elt = list.get(previousLast - nextFirst + i);
                    this.getInternalWrappedList().add(elt);
                }
            } else if (nextFirst == previousFirst && nextLast > previousLast) {
                for (int i = 0; i < nextLast - nextFirst - (previousLast - previousFirst) && previousLast + i < list.size(); ++i) {
                    Object elt = list.get(previousLast + i);
                    this.getInternalWrappedList().add(elt);
                }
            } else if (nextLast > previousFirst && nextLast < previousLast) {
                if (nextLast - previousFirst < this.getInternalWrappedList().size()) {
                    this.getInternalWrappedList().subList(nextLast - previousFirst, this.getInternalWrappedList().size()).clear();
                } else {
                    this.getInternalWrappedList().clear();
                }
                for (int i = 0; i < previousFirst - nextFirst && i < list.size(); ++i) {
                    Object elt = list.get(i);
                    this.getInternalWrappedList().add(i, elt);
                }
            } else if (nextFirst >= this.last || nextLast <= previousFirst) {
                this.getInternalWrappedList().clear();
                for (int i = 0; i < list.size(); ++i) {
                    Object elt = list.get(i);
                    this.getInternalWrappedList().add(i, elt);
                }
            } else {
                savedSnapshot = new ArrayList<E>(this.getInternalWrappedList());
                this.getInternalWrappedList().clear();
                this.getInternalWrappedList().addAll(list);
            }
        }
        this.firePageChange(event, previousFirst, previousLast, savedSnapshot);
    }

    protected void findFault(TideFaultEvent event, int first, int max) {
        this.handleFault(event, first, max);
    }

    protected void handleFault(TideFaultEvent event, int first, int max) {
        log.debug("findFault: %s", new Object[]{event});
        int pendingIndex = -1;
        Iterator<Integer[]> ipr = this.pendingRanges.iterator();
        while (ipr.hasNext()) {
            Integer[] pr = ipr.next();
            ++pendingIndex;
            if (pr[0] != first || pr[1] != first + max) continue;
            ipr.remove();
            this.pendingCalls.remove(pendingIndex);
            break;
        }
        if (this.initializing) {
            this.initSent = false;
        }
        this.firePageChange(event, this.first, this.last, Collections.EMPTY_LIST);
    }

    protected abstract List<E> getInternalWrappedList();

    protected abstract List<E> getWrappedList();

    @Override
    public E get(int index) {
        if (index < 0) {
            return null;
        }
        if (this.initialFind()) {
            return null;
        }
        if (this.localIndex != null && index >= this.first && index < this.last) {
            int j = index - this.first;
            if (j >= 0 && j < this.localIndex.length) {
                return this.localIndex[j];
            }
            return null;
        }
        for (Integer[] pendingRange : this.pendingRanges) {
            if (index < pendingRange[0] || index >= pendingRange[1]) continue;
            return null;
        }
        int page = index / this.max;
        int nfi = 0;
        int nla = 0;
        int idx = page * this.max;
        if (index >= this.last && index < this.last + this.max) {
            nla = this.last + this.max;
            nfi = this.first;
            if (nla > nfi + 2 * this.max) {
                nfi = nla - 2 * this.max;
            }
            if (nfi < 0) {
                nfi = 0;
            }
            if (nla > this.count) {
                nla = this.count;
            }
        } else if (index < this.first && index >= this.first - this.max) {
            nfi = this.first - this.max;
            if (nfi < 0) {
                nfi = 0;
            }
            if ((nla = this.last) > nfi + 2 * this.max) {
                nla = nfi + 2 * this.max;
            }
            if (nla > this.count) {
                nla = this.count;
            }
        } else {
            nfi = index - this.max;
            nla = nfi + 2 * this.max;
            if (nfi < 0) {
                nfi = 0;
            }
            if (nla > this.count) {
                nla = this.count;
            }
        }
        log.debug("request find for index " + index, new Object[0]);
        this.executeFind(nfi, nla);
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        if (this.localIndex != null) {
            for (E obj : this.localIndex) {
                if (!o.equals(obj)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return false;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            return -1;
        }
        if (this.localIndex != null) {
            for (int i = 0; i < this.localIndex.length; ++i) {
                if (!o.equals(this.localIndex[i])) continue;
                return this.first + i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            return -1;
        }
        if (this.localIndex != null) {
            int index = -1;
            for (int i = 0; i < this.localIndex.length; ++i) {
                if (!o.equals(this.localIndex[i])) continue;
                index = this.first + i;
            }
            return index;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new PagedCollectionIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new PagedCollectionIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new PagedCollectionIterator();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public Object getObject() {
        if (this.component instanceof PropertyHolder) {
            return ((PropertyHolder)this.component).getObject();
        }
        return null;
    }

    public void setProperty(String propName, Object value) {
        if (this.component instanceof PropertyHolder) {
            ((PropertyHolder)this.component).setProperty(propName, value);
        }
    }

    @Override
    public <T> Future<T> call(String operation, Object ... args) {
        throw new UnsupportedOperationException();
    }

    private class PagedCollectionResponder<R>
    implements TideResponder<R> {
        private int first;
        private int max;

        public PagedCollectionResponder(int first, int max) {
            this.first = first;
            this.max = max;
        }

        @Override
        public void result(TideResultEvent<R> event) {
            AbstractPagedCollection.this.findResult(event, this.first, this.max);
        }

        @Override
        public void fault(TideFaultEvent event) {
            AbstractPagedCollection.this.findFault(event, this.first, this.max);
        }
    }

    public class PagedCollectionIterator
    implements ListIterator<E> {
        private ListIterator<E> wrappedListIterator;

        public PagedCollectionIterator() {
            this.wrappedListIterator = AbstractPagedCollection.this.getWrappedList().listIterator();
        }

        public PagedCollectionIterator(int index) {
            this.wrappedListIterator = AbstractPagedCollection.this.getWrappedList().listIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.wrappedListIterator.hasNext();
        }

        @Override
        public E next() {
            return this.wrappedListIterator.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.wrappedListIterator.hasPrevious();
        }

        @Override
        public E previous() {
            return this.wrappedListIterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.wrappedListIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.wrappedListIterator.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    private final class ComponentSimpleFilterFinder
    implements SimpleFilterFinder<E> {
        private final Component component;
        private final String methodName;

        public ComponentSimpleFilterFinder(Component component, String methodName) {
            this.component = component;
            this.methodName = methodName;
        }

        @Override
        public Future<Map<String, Object>> find(Object filter, int first, int max, String[] order, boolean[] desc, TideResponder<Map<String, Object>> responder) {
            return this.component.call(this.methodName, filter, first, max, order, desc, responder);
        }
    }

    private final class ComponentPageFilterFinder
    implements PageFilterFinder<E> {
        private final Component component;
        private final String methodName;

        public ComponentPageFilterFinder(Component component, String methodName) {
            this.component = component;
            this.methodName = methodName;
        }

        @Override
        public Future<Page<E>> find(Object filter, PageInfo pageInfo, TideResponder<Page<E>> responder) {
            return this.component.call(this.methodName, filter, pageInfo, responder);
        }
    }
}

