/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.granite.client.tide.Application;
import org.granite.client.tide.ApplicationConfigurable;
import org.granite.client.tide.ContextAware;
import org.granite.client.tide.ContextManager;
import org.granite.client.tide.EventBus;
import org.granite.client.tide.Initializable;
import org.granite.client.tide.InstanceStore;
import org.granite.client.tide.InvalidContextException;
import org.granite.client.tide.NameAware;
import org.granite.client.tide.data.EntityManager;
import org.granite.client.tide.data.impl.EntityManagerImpl;
import org.granite.client.tide.data.impl.JavaBeanDataManager;
import org.granite.client.tide.data.impl.RemoteInitializerImpl;
import org.granite.client.tide.data.spi.DataManager;
import org.granite.client.tide.impl.DefaultApplication;
import org.granite.client.tide.impl.SimpleEventBus;
import org.granite.client.tide.impl.SimpleInstanceStore;
import org.granite.logging.Logger;

public class Context {
    static final Logger log = Logger.getLogger(Context.class);
    private String contextId = null;
    private boolean isContextIdFromServer = false;
    private boolean finished = false;
    private ContextManager contextManager = null;
    private Object platformContext = null;
    private InstanceStore instanceStore = new SimpleInstanceStore(this, null);
    private Map<String, Object> initialBeans = new HashMap<String, Object>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Application application = new DefaultApplication();
    private EventBus eventBus = new SimpleEventBus();
    private DataManager dataManager = new JavaBeanDataManager();
    private EntityManager entityManager;

    protected Context() {
    }

    public Context(ContextManager contextManager, Context parentCtx, String contextId) {
        this.contextManager = contextManager;
        this.contextId = contextId;
    }

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public void setPlatformContext(Object context) {
        this.platformContext = context;
    }

    public Object getPlatformContext() {
        return this.platformContext;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setDataManager(DataManager dataManager) {
        this.dataManager = dataManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public Map<String, Object> getInitialBeans() {
        return Collections.unmodifiableMap(this.initialBeans);
    }

    public boolean isGlobal() {
        return this.contextManager.isGlobal(this);
    }

    public void initContext(Application application, EventBus eventBus, InstanceStore instanceStore) {
        this.application = application;
        if (eventBus != null) {
            this.eventBus = eventBus;
        }
        if (instanceStore != null) {
            this.instanceStore = instanceStore;
        }
        application.initContext(this, this.initialBeans);
        this.entityManager = new EntityManagerImpl("", this.dataManager);
        this.entityManager.setRemoteInitializer(new RemoteInitializerImpl(this));
        instanceStore.init();
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void postInit() {
    }

    public Context getParentContext() {
        return null;
    }

    public String getContextId() {
        return this.contextId;
    }

    public boolean isContextIdFromServer() {
        return this.isContextIdFromServer;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setContextId(String contextId, boolean fromServer) {
        String previousContextId = this.contextId;
        this.contextId = contextId;
        this.isContextIdFromServer = fromServer;
        this.contextManager.updateContextId(previousContextId, this);
    }

    public <T> T byName(String name) {
        return this.instanceStore.byName(name, this);
    }

    public <T> T byNameNoProxy(String name) {
        return this.instanceStore.getNoProxy(name, this);
    }

    public <T> T byType(Class<T> type) {
        return this.instanceStore.byType(type, this);
    }

    public <T> T[] allByType(Class<T> type) {
        return this.instanceStore.allByType(type, this, true);
    }

    public <T> T[] allByType(Class<T> type, boolean create) {
        return this.instanceStore.allByType(type, this, create);
    }

    public Map<String, Object> allByAnnotatedWith(Class<? extends Annotation> annotationClass) {
        return this.instanceStore.allByAnnotatedWith(annotationClass, this);
    }

    public List<String> allNames() {
        return this.instanceStore.allNames();
    }

    public <T> T set(String name, T instance) {
        return this.instanceStore.set(name, instance);
    }

    public <T> T set(T instance) {
        return this.instanceStore.set(instance);
    }

    public void remove(String name) {
        this.instanceStore.remove(name);
    }

    public void remove(Object instance) {
        this.instanceStore.remove(instance);
    }

    public void clear() {
        this.entityManager.clear();
        this.instanceStore.clear();
    }

    public void initInstance(Object instance, String name) {
        if (name != null && instance instanceof NameAware) {
            ((NameAware)instance).setName(name);
        }
        if (instance instanceof ContextAware) {
            ((ContextAware)instance).setContext(this);
        }
        if (instance instanceof Initializable) {
            ((Initializable)instance).init();
        }
        if (instance.getClass().isAnnotationPresent(ApplicationConfigurable.class)) {
            this.application.configure(instance);
        }
        this.instanceStore.inject(instance, name, this.properties);
    }

    public void destroyInstance(Object instance) {
    }

    public void defineProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        for (String key : properties.keySet()) {
            Object instance;
            int idx;
            if (!key.startsWith("$") || (idx = key.indexOf(".", 1)) < 0) continue;
            this.properties.put(key.substring(1), properties.get(key));
            String componentName = key.substring(1, idx);
            if (!this.instanceStore.exists(componentName) || (instance = this.instanceStore.byName(componentName, this)) == null) continue;
            String propertyName = key.substring(idx + 1);
            Object value = properties.get(key);
            String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            Method setter = null;
            for (Method s : instance.getClass().getMethods()) {
                if (!s.getName().equals(setterName)) continue;
                setter = s;
                break;
            }
            if (setter == null) {
                log.warn("No setter found for %s", new Object[]{key});
                continue;
            }
            try {
                setter.invoke(instance, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set value for bundle property " + key);
            }
        }
    }

    public void checkValid() {
        if (this.finished) {
            throw new InvalidContextException(this.contextId, "Invalid context");
        }
    }

    public void callLater(Runnable runnable) {
        this.application.execute(this.platformContext, runnable);
    }

    public void markAsFinished() {
        this.finished = true;
    }

    public static interface Properties {
        public Set<String> keySet();

        public Object get(String var1);
    }
}

