/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.tide;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.nio.charset.Charset;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Future;
import org.granite.client.messaging.RemoteAlias;
import org.granite.client.messaging.messages.responses.FaultMessage;
import org.granite.client.tide.Context;
import org.granite.client.tide.Identity;
import org.granite.client.tide.impl.ComponentImpl;
import org.granite.client.tide.server.ExceptionHandler;
import org.granite.client.tide.server.ServerSession;
import org.granite.client.tide.server.SimpleTideResponder;
import org.granite.client.tide.server.TideFaultEvent;
import org.granite.client.tide.server.TideResponder;
import org.granite.client.tide.server.TideResultEvent;

@RemoteAlias(value="org.granite.tide.security.ServerIdentity")
public class BaseIdentity
extends ComponentImpl
implements Identity,
ExceptionHandler {
    private boolean loggedIn;
    private String username;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public BaseIdentity() {
    }

    public BaseIdentity(ServerSession serverSession) {
        super(serverSession);
        this.loggedIn = false;
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void setLoggedIn(boolean loggedIn) {
        if (loggedIn == this.loggedIn) {
            return;
        }
        this.loggedIn = loggedIn;
        if (loggedIn) {
            this.getServerSession().afterLogin();
        } else {
            this.setUsername(null);
        }
        this.pcs.firePropertyChange("loggedIn", !loggedIn, loggedIn);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    protected void setUsername(String username) {
        String oldUsername = this.username;
        this.username = username;
        if (username == null && oldUsername != null || username != null && !username.equals(oldUsername)) {
            this.pcs.firePropertyChange("username", oldUsername, username);
        }
    }

    @Override
    public Future<String> checkLoggedIn(final TideResponder<String> tideResponder) {
        return super.call("isLoggedIn", new SimpleTideResponder<String>(){

            @Override
            public void result(TideResultEvent<String> event) {
                if (event.getResult() != null) {
                    BaseIdentity.this.setUsername(event.getResult());
                    BaseIdentity.this.setLoggedIn(true);
                } else if (BaseIdentity.this.isLoggedIn()) {
                    BaseIdentity.this.setLoggedIn(false);
                    BaseIdentity.this.getServerSession().sessionExpired();
                }
                if (tideResponder != null) {
                    tideResponder.result(event);
                }
            }

            @Override
            public void fault(TideFaultEvent event) {
                if (event.getFault().getCode() == FaultMessage.Code.ACCESS_DENIED) {
                    BaseIdentity.this.setLoggedIn(false);
                    BaseIdentity.this.getServerSession().logout(null);
                }
                if (tideResponder != null) {
                    tideResponder.fault(event);
                }
            }
        });
    }

    @Override
    public Future<String> login(String username, String password, TideResponder<String> tideResponder) {
        this.getServerSession().login(username, password);
        this.clearSecurityCache();
        Future<String> loggedIn = null;
        try {
            loggedIn = this.checkLoggedIn(tideResponder);
            loggedIn.get();
        }
        catch (Exception e) {
            // empty catch block
        }
        return loggedIn;
    }

    public Future<String> login(String username, String password, Charset charset, TideResponder<String> tideResponder) {
        this.getServerSession().login(username, password, charset);
        this.clearSecurityCache();
        Future<String> loggedIn = null;
        try {
            loggedIn = this.checkLoggedIn(tideResponder);
            loggedIn.get();
        }
        catch (Exception e) {
            // empty catch block
        }
        return loggedIn;
    }

    @Override
    public void logout() {
        this.logout(null);
    }

    @Override
    public void logout(final TideResponder<Void> tideResponder) {
        Observer observer = new Observer(){

            @Override
            public void update(Observable logout, Object event) {
                BaseIdentity.this.setLoggedIn(false);
                if (tideResponder != null) {
                    if (event instanceof TideResultEvent) {
                        tideResponder.result((TideResultEvent)event);
                    } else if (event instanceof TideFaultEvent) {
                        tideResponder.fault((TideFaultEvent)event);
                    }
                }
            }
        };
        this.getServerSession().logout(observer);
    }

    @Override
    public boolean accepts(FaultMessage emsg) {
        return emsg.getCode() == FaultMessage.Code.NOT_LOGGED_IN;
    }

    @Override
    public void handle(Context context, FaultMessage emsg, TideFaultEvent faultEvent) {
        if (this.isLoggedIn()) {
            this.setLoggedIn(false);
            this.getServerSession().sessionExpired();
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void clearSecurityCache() {
    }
}

