/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.android.tide;

import org.granite.binding.android.BeanSetter;
import org.granite.binding.android.Binder;
import org.granite.client.tide.Context;
import org.granite.client.tide.data.impl.JavaBeanDataManager;
import org.granite.util.TypeUtil;

public class TideBeanResolver
implements Binder.BeanResolver {
    private final Context context;
    private final JavaBeanDataManager dataManager;
    private final BeanSetter<Object> beanSetter = new DataManagerBeanSetter();

    public TideBeanResolver(Context context) {
        this.context = context;
        this.dataManager = (JavaBeanDataManager)context.getEntityManager().getDataManager();
    }

    @Override
    public <T> T resolveBean(Object ref) {
        if (ref instanceof String) {
            String[] path = ((String)ref).split("\\.");
            Object bean = this.context.byName(path[0]);
            if (path.length > 0) {
                for (int i = 1; i < path.length; ++i) {
                    bean = TypeUtil.getProperty(bean, (String)path[i]);
                }
            }
            return bean;
        }
        if (ref instanceof Class) {
            return this.context.byType((Class)ref);
        }
        return (T)ref;
    }

    @Override
    public <T> BeanSetter<T> getBeanSetter(T bean, String propertyName) {
        return this.beanSetter;
    }

    private class DataManagerBeanSetter
    implements BeanSetter<Object> {
        private DataManagerBeanSetter() {
        }

        @Override
        public void setValue(Object instance, String propertyName, Object value) throws Exception {
            TideBeanResolver.this.dataManager.setPropertyValue(instance, propertyName, value);
        }
    }
}

