/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.android.tide;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.granite.binding.android.Binder;
import org.granite.client.android.tide.AndroidApplication;
import org.granite.client.android.tide.TideBeanResolver;
import org.granite.client.tide.Context;
import org.granite.client.tide.Factory;
import org.granite.client.tide.impl.SimpleContextManager;

public class AndroidContextManager
extends SimpleContextManager {
    private static WeakHashMap<Application, AndroidContextManager> instances = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidContextManager getInstance(Application application) {
        AndroidContextManager contextManager = instances.get(application);
        if (contextManager == null) {
            Application application2 = application;
            synchronized (application2) {
                String modules;
                contextManager = new AndroidContextManager(application);
                String[] moduleClassNames = null;
                Bundle appMetaData = application.getApplicationInfo().metaData;
                if (appMetaData != null && (modules = appMetaData.getString("tide.modules")) != null) {
                    moduleClassNames = modules.split("[\\s,]");
                }
                contextManager.registerFactory(Binder.class, new BinderFactory());
                if (moduleClassNames != null) {
                    contextManager.initModules(moduleClassNames);
                } else {
                    contextManager.scanModules(application.getPackageName());
                }
                instances.put(application, contextManager);
            }
        }
        return contextManager;
    }

    public static Context getContext(Application application) {
        return AndroidContextManager.getInstance(application).getContext();
    }

    public static Context getContext(Activity activity) {
        return AndroidContextManager.getInstance(activity.getApplication()).getActivityContext(activity);
    }

    public static Context getContext(Activity activity, Bundle bundle) {
        Context context = AndroidContextManager.getInstance(activity.getApplication()).getActivityContext(activity);
        context.defineProperties(new BundleAdapter(bundle));
        return context;
    }

    public static void releaseContext(Activity activity) {
        AndroidContextManager.getInstance(activity.getApplication()).destroyActivityContext(activity);
    }

    public AndroidContextManager(Application application) {
        super(new AndroidApplication(application));
    }

    protected Context getActivityContext(Activity activity) {
        Context context = this.getContext(activity.getComponentName().flattenToString());
        context.setPlatformContext(activity);
        return context;
    }

    protected void destroyActivityContext(Activity activity) {
        this.destroyContext(activity.getComponentName().flattenToString());
    }

    private static final class BundleAdapter
    implements Context.Properties {
        private final Bundle bundle;

        public BundleAdapter(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public Object get(String key) {
            return this.bundle.get(key);
        }

        @Override
        public Set<String> keySet() {
            if (this.bundle == null) {
                return Collections.emptySet();
            }
            return this.bundle.keySet();
        }
    }

    private static final class BinderFactory
    implements Factory<Binder> {
        private BinderFactory() {
        }

        @Override
        public Binder create(Context context) {
            Binder binder = new Binder((Activity)context.getPlatformContext());
            binder.setBeanResolver(new TideBeanResolver(context));
            return binder;
        }

        @Override
        public boolean isSingleton() {
            return false;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Set<Class<?>> getTargetTypes() {
            return Collections.singleton(Binder.class);
        }
    }
}

