/*
 * Decompiled with CFR 0.152.
 */
package org.granite.client.android.adapter;

import android.widget.BaseExpandableListAdapter;
import java.util.Collection;
import java.util.List;
import org.granite.client.persistence.collection.PersistentCollection;

public abstract class BaseExpandablePersistentListAdapter<E>
extends BaseExpandableListAdapter {
    private final List<E> list;
    private PersistentCollection.ChangeListener listChangeListener = new PersistentCollection.ChangeListener(){

        public void changed(PersistentCollection coll) {
            BaseExpandablePersistentListAdapter.this.notifyDataSetChanged();
        }
    };

    public BaseExpandablePersistentListAdapter(List<E> list) {
        this.list = list;
        if (list instanceof PersistentCollection) {
            ((PersistentCollection)list).addListener(this.listChangeListener);
        }
    }

    public void onGroupCollapsed(int groupPosition) {
        super.onGroupCollapsed(groupPosition);
        Object group = this.getGroup(groupPosition);
        if (group instanceof PersistentCollection) {
            ((PersistentCollection)group).removeListener(this.listChangeListener);
        }
    }

    public void onGroupExpanded(int groupPosition) {
        super.onGroupExpanded(groupPosition);
        Object group = this.getGroup(groupPosition);
        if (group instanceof PersistentCollection) {
            ((PersistentCollection)group).addListener(this.listChangeListener);
        }
    }

    public int getGroupCount() {
        return this.list.size();
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public int getChildrenCount(int groupPosition) {
        Object group = this.getGroup(groupPosition);
        if (group instanceof Collection) {
            return ((Collection)group).size();
        }
        throw new RuntimeException("Cannot determine group type, must override getChildrenCount");
    }

    public Object getChild(int groupPosition, int childPosition) {
        Object group = this.getGroup(groupPosition);
        if (group instanceof Collection) {
            int i = 0;
            for (Object element : (Collection)group) {
                if (i == childPosition) {
                    return element;
                }
                ++i;
            }
        }
        throw new RuntimeException("Cannot determine group type, must override getChild");
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean hasStableIds() {
        return true;
    }
}

