/*
 * Decompiled with CFR 0.152.
 */
package org.granite.binding.collection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.granite.binding.collection.CollectionChangeEvent;
import org.granite.binding.collection.CollectionChangeListener;
import org.granite.binding.collection.CollectionChangeSupport;
import org.granite.binding.collection.ObservableList;

public class ObservableListWrapper<E>
implements ObservableList<E> {
    protected CollectionChangeSupport ccs = new CollectionChangeSupport(this);
    private final List<E> wrappedList;
    private PropertyChangeListener trackingListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            ObservableListWrapper.this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.UPDATE, null, new Object[]{event});
        }
    };

    public ObservableListWrapper(List<E> list) {
        this.wrappedList = list;
    }

    public List<E> getWrappedObservable() {
        return this.wrappedList;
    }

    @Override
    public void addCollectionChangeListener(CollectionChangeListener listener) {
        this.ccs.addCollectionChangeListener(listener);
    }

    @Override
    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        this.ccs.removeCollectionChangeListener(listener);
    }

    @Override
    public boolean add(E element) {
        int index = this.wrappedList.size();
        boolean added = this.wrappedList.add(element);
        if (added) {
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.ADD, index, new Object[]{element});
            this.trackElement(element);
        }
        return added;
    }

    @Override
    public void add(int index, E element) {
        this.wrappedList.add(index, element);
        this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.ADD, index, new Object[]{element});
        this.trackElement(element);
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        int index = this.wrappedList.size();
        boolean added = this.wrappedList.addAll(elements);
        if (added) {
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.ADD, index, elements.toArray());
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> elements) {
        boolean added = this.wrappedList.addAll(index, elements);
        if (added) {
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.ADD, index, elements.toArray());
            for (E element : elements) {
                this.trackElement(element);
            }
        }
        return added;
    }

    @Override
    public E remove(int index) {
        E element = this.wrappedList.remove(index);
        this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REMOVE, index, new Object[]{element});
        this.untrackElement(element);
        return element;
    }

    @Override
    public boolean remove(Object element) {
        int index = this.wrappedList.indexOf(element);
        boolean removed = this.wrappedList.remove(element);
        if (removed) {
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REMOVE, index, new Object[]{element});
            this.untrackElement(element);
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean removed = false;
        ArrayList removedElements = new ArrayList();
        int index = 0;
        for (Object element : collection) {
            if (this.remove(element)) {
                removed = true;
                removedElements.add(element);
                this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REMOVE, index, new Object[]{element});
                this.untrackElement(element);
            }
            ++index;
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        int index = 0;
        for (Object element : collection) {
            if (!this.wrappedList.contains(element) && this.remove(element)) {
                changed = true;
                this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REMOVE, index, new Object[]{element});
                this.untrackElement(element);
            }
            ++index;
        }
        return changed;
    }

    @Override
    public E set(int index, E element) {
        E oldElement = this.wrappedList.set(index, element);
        if (element != oldElement) {
            this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REPLACE, index, new Object[]{oldElement, element});
            this.untrackElement(oldElement);
            this.trackElement(element);
        }
        return oldElement;
    }

    @Override
    public void clear() {
        if (this.wrappedList.size() == 0) {
            return;
        }
        Object[] elements = this.wrappedList.toArray();
        this.wrappedList.clear();
        this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.CLEAR, null, elements);
        for (Object element : elements) {
            this.untrackElement(element);
        }
    }

    @Override
    public boolean contains(Object element) {
        return this.wrappedList.contains(element);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.wrappedList.containsAll(collection);
    }

    @Override
    public E get(int index) {
        return this.wrappedList.get(index);
    }

    @Override
    public int indexOf(Object element) {
        return this.wrappedList.indexOf(element);
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.wrappedList.lastIndexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedList.isEmpty();
    }

    @Override
    public int size() {
        return this.wrappedList.size();
    }

    @Override
    public Object[] toArray() {
        return this.wrappedList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.wrappedList.toArray(array);
    }

    @Override
    public List<E> subList(int start, int end) {
        return new ObservableListWrapper<E>(this.wrappedList.subList(start, end));
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorWrapper(this.wrappedList.iterator());
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIteratorWrapper(this.wrappedList.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListIteratorWrapper(this.wrappedList.listIterator(index), index);
    }

    private void trackElement(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            Method m = obj.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            m.invoke(obj, this.trackingListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void untrackElement(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            Method m = obj.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
            m.invoke(obj, this.trackingListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ListIteratorWrapper
    implements ListIterator<E> {
        private final ListIterator<E> wrappedIterator;
        private int index = -1;
        private E element;

        public ListIteratorWrapper(ListIterator<E> iterator) {
            this.wrappedIterator = iterator;
        }

        public ListIteratorWrapper(ListIterator<E> iterator, int index) {
            this.wrappedIterator = iterator;
            this.index = index;
        }

        @Override
        public void add(E element) {
            this.wrappedIterator.add(element);
            ObservableListWrapper.this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.ADD, this.index, new Object[]{element});
        }

        @Override
        public void remove() {
            this.wrappedIterator.remove();
            ObservableListWrapper.this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REMOVE, this.index, new Object[]{this.element});
        }

        @Override
        public void set(E element) {
            Object oldElement = this.element;
            this.wrappedIterator.set(element);
            if (element != oldElement) {
                ObservableListWrapper.this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REPLACE, this.index, new Object[]{oldElement, element});
            }
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.wrappedIterator.hasPrevious();
        }

        @Override
        public E next() {
            ++this.index;
            this.element = this.wrappedIterator.next();
            return this.element;
        }

        @Override
        public int nextIndex() {
            return this.wrappedIterator.nextIndex();
        }

        @Override
        public E previous() {
            --this.index;
            this.element = this.wrappedIterator.previous();
            return this.element;
        }

        @Override
        public int previousIndex() {
            return this.wrappedIterator.previousIndex();
        }
    }

    private class IteratorWrapper
    implements Iterator<E> {
        private final Iterator<E> wrappedIterator;
        private int index = -1;
        private E element;

        public IteratorWrapper(Iterator<E> iterator) {
            this.wrappedIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public E next() {
            ++this.index;
            this.element = this.wrappedIterator.next();
            return this.element;
        }

        @Override
        public void remove() {
            this.wrappedIterator.remove();
            ObservableListWrapper.this.ccs.fireCollectionChangeEvent(CollectionChangeEvent.Kind.REMOVE, this.index, new Object[]{this.element});
        }
    }
}

