/*
 * Decompiled with CFR 0.152.
 */
package org.granite.binding.collection;

import org.granite.binding.collection.CollectionChangeEvent;
import org.granite.binding.collection.CollectionChangeListener;

public class CollectionChangeSupport {
    private final Object collection;
    private CollectionChangeListener[] listeners = null;

    public CollectionChangeSupport(Object collection) {
        this.collection = collection;
    }

    public void addCollectionChangeListener(CollectionChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new CollectionChangeListener[]{listener};
        } else {
            CollectionChangeListener[] newListeners = new CollectionChangeListener[this.listeners.length + 1];
            System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
            newListeners[this.listeners.length] = listener;
            this.listeners = newListeners;
        }
    }

    public void fireCollectionChangeEvent(CollectionChangeEvent.Kind kind, Object key, Object[] values) {
        if (this.listeners == null) {
            return;
        }
        CollectionChangeEvent event = new CollectionChangeEvent(this.collection, kind, key, values);
        for (CollectionChangeListener listener : this.listeners) {
            listener.collectionChange(event);
        }
    }

    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        if (this.listeners.length == 1) {
            if (this.listeners[0] == listener) {
                this.listeners = null;
            }
        } else {
            int index = -1;
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != listener) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                CollectionChangeListener[] newListeners = new CollectionChangeListener[this.listeners.length - 1];
                if (index > 0) {
                    System.arraycopy(this.listeners, 0, newListeners, 0, index);
                }
                if (index < this.listeners.length - 1) {
                    System.arraycopy(this.listeners, index + 1, newListeners, index, this.listeners.length - index - 1);
                }
                this.listeners = newListeners;
            }
        }
    }
}

