/*
 * Decompiled with CFR 0.152.
 */
package org.granite.binding.android.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import org.granite.binding.android.Binder;
import org.granite.binding.android.adapter.DataBinder;
import org.granite.binding.collection.CollectionChangeEvent;
import org.granite.binding.collection.CollectionChangeListener;
import org.granite.binding.collection.ObservableList;

public class ObservableListAdapter<E>
extends BaseAdapter {
    private CollectionChangeListener collChangeListener = new CollectionChangeListener(){

        @Override
        public void collectionChange(CollectionChangeEvent event) {
            ObservableListAdapter.this.notifyDataSetChanged();
        }
    };
    private final LayoutInflater inflater;
    private final Binder binder;
    private final ObservableList<E> list;
    private final int rowViewId;
    private final DataBinder<E> rowBinder;

    public ObservableListAdapter(Context context, ObservableList<E> list, int rowViewId, DataBinder<E> rowBinder) {
        this.inflater = LayoutInflater.from((Context)context);
        this.binder = null;
        this.list = list;
        this.rowViewId = rowViewId;
        this.rowBinder = rowBinder;
        list.addCollectionChangeListener(this.collChangeListener);
    }

    public ObservableListAdapter(Context context, ObservableList<E> list, int rowViewId, Binder binder) {
        this.inflater = LayoutInflater.from((Context)context);
        this.binder = binder;
        this.list = list;
        this.rowViewId = rowViewId;
        this.rowBinder = null;
        list.addCollectionChangeListener(this.collChangeListener);
    }

    public int getCount() {
        return this.list.size();
    }

    public E getItem(int position) {
        return this.list.get(position);
    }

    public long getItemId(int position) {
        E item = this.getItem(position);
        if (this.rowBinder != null) {
            return this.rowBinder.getItemId(item);
        }
        return this.binder.getId(item);
    }

    public boolean hasStableIds() {
        return true;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        E item = this.getItem(position);
        if (this.rowBinder != null) {
            if (convertView == null) {
                convertView = this.inflater.inflate(this.rowViewId, null);
            } else {
                this.rowBinder.unbind(convertView, item);
            }
            this.rowBinder.bind(convertView, item);
        } else if (this.binder != null) {
            if (convertView == null) {
                convertView = this.inflater.inflate(this.rowViewId, null);
            } else {
                this.binder.unbind(convertView);
            }
            this.binder.bind(convertView, item);
        }
        return convertView;
    }
}

