/*
 * Decompiled with CFR 0.152.
 */
package org.granite.binding.android;

import android.view.View;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ViewWatcher<V extends View> {
    private final WeakReference<V> view;
    protected final Map<String, Object> currentValues = new HashMap<String, Object>();
    protected PropertyChangeSupport pcs;

    public ViewWatcher(V view) {
        this.view = new WeakReference<V>(view);
        this.pcs = new PropertyChangeSupport(view);
    }

    protected V getView() {
        if (this.view.get() == null) {
            this.clear();
        }
        return (V)((View)this.view.get());
    }

    protected void clear() {
        this.currentValues.clear();
        this.pcs = null;
    }

    public boolean isEmpty() {
        return this.currentValues.isEmpty();
    }

    protected void setCurrentValue(String property, Object value) {
        if (value instanceof CharSequence) {
            value = ((CharSequence)value).toString();
        }
        this.currentValues.put(property, value);
    }

    protected Object getCurrentValue(String property) {
        return this.currentValues.get(property);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.setCurrentValue(property, this.evaluate(property));
        this.pcs.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(property, listener);
        this.currentValues.remove(property);
    }

    protected Object evaluate(String property) {
        try {
            Method getter = this.getView().getClass().getMethod("get" + property.substring(0, 1).toUpperCase() + property.substring(1), new Class[0]);
            Object value = getter.invoke(this.getView(), new Object[0]);
            if (value instanceof CharSequence) {
                value = ((CharSequence)value).toString();
            }
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not evaluate " + this.view + "." + property);
        }
    }

    public void apply() {
        for (Map.Entry<String, Object> entry : this.currentValues.entrySet()) {
            String property = entry.getKey();
            Object newValue = this.evaluate(property);
            if (newValue != entry.getValue()) {
                this.pcs.firePropertyChange(new PropertyChangeEvent(this.view, property, entry.getValue(), newValue));
            }
            entry.setValue(newValue);
        }
    }
}

