/*
 * Decompiled with CFR 0.152.
 */
package org.granite.binding.android;

import android.view.View;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.granite.binding.android.Setter;

public class ViewSetter<V extends View> {
    private final Class<V> viewClass;
    private final String property;
    private final List<Setter<V>> setters = new ArrayList<Setter<V>>();

    public ViewSetter(Class<V> viewClass, String property) {
        this.viewClass = viewClass;
        this.property = property;
        this.initMethodSetters(this.setters);
    }

    private void initMethodSetters(List<Setter<V>> setters) {
        for (Method s : this.viewClass.getMethods()) {
            if (s.getParameterTypes().length != 1 || !s.getName().equals("set" + this.property.substring(0, 1).toUpperCase() + this.property.substring(1))) continue;
            setters.add(new MethodSetter(s));
        }
    }

    public void registerSetter(Setter<V> setter) {
        this.setters.add(setter);
    }

    public void setValue(V view, Object newValue) {
        try {
            for (Setter<V> setter : this.setters) {
                if (!setter.accepts(newValue)) continue;
                setter.setValue(view, newValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set view value", e);
        }
    }

    private static final class MethodSetter<V extends View>
    implements Setter<V> {
        private final Method method;
        private final Class<?> type;

        public MethodSetter(Method method) {
            this.method = method;
            Class<Object> type = method.getParameterTypes()[0];
            if (type.isPrimitive()) {
                if (type == Boolean.TYPE) {
                    type = Boolean.class;
                } else if (type == Short.TYPE) {
                    type = Short.class;
                } else if (type == Integer.TYPE) {
                    type = Integer.class;
                } else if (type == Long.TYPE) {
                    type = Long.class;
                } else if (type == Byte.TYPE) {
                    type = Byte.class;
                } else if (type == Character.TYPE) {
                    type = Character.class;
                }
            }
            this.type = type;
        }

        @Override
        public boolean accepts(Object value) {
            return this.type.isInstance(value);
        }

        @Override
        public void setValue(V view, Object value) throws Exception {
            this.method.invoke(view, value);
        }
    }
}

