/*
 * Decompiled with CFR 0.152.
 */
package org.granite.binding.android;

import android.view.View;
import android.widget.TextView;
import java.util.HashMap;
import java.util.Map;
import org.granite.binding.android.Setter;
import org.granite.binding.android.TextViewWatcher;
import org.granite.binding.android.ViewSetter;
import org.granite.binding.android.ViewWatcher;

public class ViewBindingRegistry {
    private static Map<Class<? extends View>, ViewBinding<? extends View>> viewBindingsMap = new HashMap<Class<? extends View>, ViewBinding<? extends View>>();

    private static <V extends View> ViewBinding<V> internalGetViewBinding(Class<V> viewClass) {
        ViewBinding<Object> viewBinding = viewBindingsMap.get(viewClass);
        if (viewBinding == null) {
            viewBinding = new ViewBinding<V>(viewClass);
            viewBindingsMap.put(viewClass, viewBinding);
        }
        return viewBinding;
    }

    public static <V extends View> ViewSetter<V> getViewSetter(Class<V> viewClass, String property) {
        return ViewBindingRegistry.internalGetViewBinding(viewClass).getViewSetter(property);
    }

    public static <V extends View> ViewWatcher<V> newWatcher(V view) {
        Class<?> viewClass = view.getClass();
        Object viewWatcherClass = null;
        while (viewWatcherClass == null && !viewClass.equals(Object.class) && !viewClass.equals(View.class)) {
            ViewWatcher<?> viewWatcher = ViewBindingRegistry.internalGetViewBinding(viewClass).newWatcher(view);
            if (viewWatcher != null) {
                return viewWatcher;
            }
            viewClass = viewClass.getSuperclass();
        }
        return new ViewWatcher<V>(view);
    }

    public static <V extends View> void registerPropertySetter(Class<V> viewClass, String property, Setter<V> setter) {
        ViewBindingRegistry.internalGetViewBinding(viewClass).registerPropertySetter(property, setter);
    }

    public static <V extends View, W extends ViewWatcher<V>> void registerViewWatcherClass(Class<V> viewClass, Class<W> viewWatcherClass) {
        ViewBindingRegistry.internalGetViewBinding(viewClass).registerWatcherClass(viewWatcherClass);
    }

    static {
        ViewBindingRegistry.registerViewWatcherClass(TextView.class, TextViewWatcher.class);
    }

    private static class ViewBinding<V extends View> {
        private Class<V> viewClass;
        private Class<? extends ViewWatcher<V>> watcherClass;
        private Map<String, ViewSetter<V>> viewSettersMap = new HashMap<String, ViewSetter<V>>();

        public ViewBinding(Class<V> viewClass) {
            this.viewClass = viewClass;
        }

        public ViewWatcher<V> newWatcher(V view) {
            if (this.watcherClass == null) {
                return null;
            }
            try {
                return this.watcherClass.getConstructor(this.viewClass).newInstance(view);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not build watcher for view " + this.viewClass);
            }
        }

        private ViewSetter<V> internalGetViewSetter(String property) {
            ViewSetter<V> viewSetter = this.viewSettersMap.get(property);
            if (viewSetter == null) {
                viewSetter = new ViewSetter<V>(this.viewClass, property);
                this.viewSettersMap.put(property, viewSetter);
            }
            return viewSetter;
        }

        public ViewSetter<V> getViewSetter(String property) {
            return this.internalGetViewSetter(property);
        }

        public void registerWatcherClass(Class<? extends ViewWatcher<V>> watcherClass) {
            this.watcherClass = watcherClass;
        }

        public void registerPropertySetter(String property, Setter<V> setter) {
            this.internalGetViewSetter(property).registerSetter(setter);
        }
    }
}

