/*
 * Decompiled with CFR 0.152.
 */
package org.granite.binding.android;

import android.app.Activity;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.granite.binding.ObservableValue;
import org.granite.binding.PropertyChangeHelper;
import org.granite.binding.WritableObservableValue;
import org.granite.binding.android.BeanSetter;
import org.granite.binding.android.Getter;
import org.granite.binding.android.IdGetter;
import org.granite.binding.android.ViewBindingRegistry;
import org.granite.binding.android.ViewSetter;
import org.granite.binding.android.ViewWatcher;

public class Binder {
    private final Map<View, ViewWatcher<? extends View>> viewWatchers = new WeakHashMap<View, ViewWatcher<? extends View>>();
    private final List<Binding> bindings = new ArrayList<Binding>();
    private final Activity activity;
    private BeanResolver beanResolver = new DefaultBeanResolver();
    private List<IdGetter> idGetters = new ArrayList<IdGetter>();
    private final Map<Class<?>, IdGetter> idGettersByClass = new HashMap();
    private int ACTION_BINDING_TAG = 348623214;
    private Map<Class<?>, Object> listenersMap = new HashMap();
    private InvocationHandler listenerInvocationHandler = new InvocationHandler(){

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class || !method.getName().startsWith("on")) {
                return method.invoke(proxy, args);
            }
            View v = (View)args[0];
            MethodAction action = (MethodAction)v.getTag(Binder.this.ACTION_BINDING_TAG);
            if (action != null && method.getName().equals(action.getListenerMethod())) {
                Binder.this.applyBindings();
                Object[] args2 = new Object[args.length - 1];
                if (args.length > 1) {
                    System.arraycopy(args, 1, args2, 0, args.length - 1);
                }
                return action.invokeAction(args2);
            }
            return null;
        }
    };

    public Binder(Activity activity) {
        this.activity = activity;
        this.initListeners();
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        this.beanResolver = beanResolver;
    }

    public void registerIdGetter(IdGetter idGetter) {
        this.idGetters.add(idGetter);
    }

    public long getId(Object instance) {
        if (instance == null) {
            return 0L;
        }
        IdGetter idGetter = this.idGettersByClass.get(instance.getClass());
        if (idGetter == null) {
            for (IdGetter g : this.idGetters) {
                if (!g.accepts(instance)) continue;
                idGetter = g;
                break;
            }
            if (idGetter != null) {
                this.idGettersByClass.put(instance.getClass(), idGetter);
            }
        }
        if (idGetter == null) {
            throw new RuntimeException("Cannot get id for object " + instance + ", register an IdGetter implementation");
        }
        return idGetter.getId(instance);
    }

    public void bind(View view, String viewPropertyName, Object ref, String beanPropertyName) {
        this.bindings.add(new UnidirectionalBinding(view, viewPropertyName, this.beanResolver.resolveBean(ref), beanPropertyName));
    }

    public <T> void bind(View view, String viewPropertyName, Object ref, String beanProperty, Getter<T, ?> beanPropertyGetter) {
        this.bindings.add(new UnidirectionalBinding(view, viewPropertyName, this.beanResolver.resolveBean(ref), beanProperty, beanPropertyGetter));
    }

    public <T> void bind(View view, String viewPropertyName, ObservableValue observableValue) {
        this.bindings.add(new UnidirectionalBinding(view, viewPropertyName, observableValue));
    }

    public void unbind(View view, String viewPropertyName) {
        this.unbind(UnidirectionalBinding.class, view, viewPropertyName);
    }

    public void bind(int viewId, String viewPropertyName, Object ref, String beanPropertyName) {
        this.bindings.add(new UnidirectionalBinding(this.activity.findViewById(viewId), viewPropertyName, this.beanResolver.resolveBean(ref), beanPropertyName));
    }

    public <T> void bind(int viewId, String viewPropertyName, Object ref, String beanPropertyName, Getter<T, ?> beanPropertyGetter) {
        this.bindings.add(new UnidirectionalBinding(this.activity.findViewById(viewId), viewPropertyName, this.beanResolver.resolveBean(ref), beanPropertyName, beanPropertyGetter));
    }

    public <T> void bind(int viewId, String viewPropertyName, ObservableValue observableValue) {
        this.bindings.add(new UnidirectionalBinding(this.activity.findViewById(viewId), viewPropertyName, observableValue));
    }

    public void unbind(int viewId, String viewPropertyName) {
        this.unbind(UnidirectionalBinding.class, this.activity.findViewById(viewId), viewPropertyName);
    }

    public void bind(View rootView, int viewId, String viewPropertyName, Object ref, String beanPropertyName) {
        this.bindings.add(new UnidirectionalBinding(rootView.findViewById(viewId), viewPropertyName, this.beanResolver.resolveBean(ref), beanPropertyName));
    }

    public <T> void bind(View rootView, int viewId, String viewPropertyName, Object ref, String beanPropertyName, Getter<T, ?> beanPropertyGetter) {
        this.bindings.add(new UnidirectionalBinding(rootView.findViewById(viewId), viewPropertyName, this.beanResolver.resolveBean(ref), beanPropertyName, beanPropertyGetter));
    }

    public <T> void bind(View rootView, int viewId, String viewPropertyName, ObservableValue observableValue) {
        this.bindings.add(new UnidirectionalBinding(rootView.findViewById(viewId), viewPropertyName, observableValue));
    }

    public void unbind(View rootView, int viewId, String viewPropertyName) {
        this.unbind(UnidirectionalBinding.class, rootView.findViewById(viewId), viewPropertyName);
    }

    public void bindBidirectional(View view, String viewPropertyName, Object ref, String beanPropertyName) {
        this.bindings.add(new BidirectionalBinding(view, viewPropertyName, this.beanResolver.resolveBean(ref), beanPropertyName));
    }

    public void unbindBidirectional(View view, String viewPropertyName) {
        this.unbind(BidirectionalBinding.class, view, viewPropertyName);
    }

    public void bindBidirectional(int viewId, String viewPropertyName, Object ref, String beanPropertyName) {
        this.bindings.add(new BidirectionalBinding(this.activity.findViewById(viewId), viewPropertyName, this.beanResolver.resolveBean(ref), beanPropertyName));
    }

    public void unbindBidirectional(int viewId, String viewPropertyName) {
        this.unbind(BidirectionalBinding.class, this.activity.findViewById(viewId), viewPropertyName);
    }

    public void bindBidirectional(View rootView, int viewId, String viewPropertyName, Object ref, String beanPropertyName) {
        this.bindings.add(new BidirectionalBinding(rootView.findViewById(viewId), viewPropertyName, this.beanResolver.resolveBean(ref), beanPropertyName));
    }

    public void unbindBidirectional(View rootView, int viewId, String viewPropertyName) {
        this.unbind(BidirectionalBinding.class, rootView.findViewById(viewId), viewPropertyName);
    }

    public void unbindAll(View view) {
        Iterator<Binding> ibinding = this.bindings.iterator();
        while (ibinding.hasNext()) {
            Binding binding = ibinding.next();
            if (!binding.isFor(view)) continue;
            binding.unbind();
            ibinding.remove();
        }
    }

    private void unbind(Class<? extends Binding> type, View view, String viewProperty) {
        Iterator<Binding> ibinding = this.bindings.iterator();
        while (ibinding.hasNext()) {
            Binding binding = ibinding.next();
            if (binding.getClass() != type || !binding.isFor(view, viewProperty)) continue;
            binding.unbind();
            ibinding.remove();
        }
    }

    public void applyBindings() {
        for (Map.Entry<View, ViewWatcher<? extends View>> entry : this.viewWatchers.entrySet()) {
            entry.getValue().apply();
        }
    }

    public void bind(View rootView) {
        this.bind(rootView, null);
    }

    public void bind(View rootView, Object item) {
        if (rootView == null) {
            return;
        }
        if (rootView.getTag() instanceof String) {
            this.internalBind(rootView, item);
        }
        if (rootView instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)rootView;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                this.bind(viewGroup.getChildAt(i), item);
            }
        }
    }

    public void bind(Menu menu) {
        for (int i = 0; i < menu.size(); ++i) {
            MenuItem menuItem = menu.getItem(i);
            if (menuItem.getSubMenu() != null) {
                this.bind((Menu)menuItem.getSubMenu());
            }
            if (menuItem.getActionView() == null) continue;
            this.bind(menuItem.getActionView());
        }
    }

    public void unbind(View rootView) {
        if (rootView.getTag() instanceof String) {
            this.internalUnbind(rootView);
        }
        if (rootView instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)rootView;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                this.unbind(viewGroup.getChildAt(i));
            }
        }
    }

    public void unbind(Menu menu) {
        for (int i = 0; i < menu.size(); ++i) {
            MenuItem menuItem = menu.getItem(i);
            if (menuItem.getSubMenu() != null) {
                this.unbind((Menu)menuItem.getSubMenu());
            }
            if (menuItem.getActionView() == null) continue;
            this.unbind(menuItem.getActionView());
        }
    }

    private void internalBind(View view, Object item) {
        String[] bindings;
        for (String binding : bindings = ((String)view.getTag()).split("\\,")) {
            int idx = binding.indexOf("=");
            if (idx < 0) continue;
            String viewProperty = binding.substring(0, idx);
            if (binding.charAt(idx + 1) == '#' || binding.charAt(idx + 1) == '$') {
                boolean bidir = binding.charAt(idx + 1) == '#';
                binding = binding.substring(idx + 2);
                int idx2 = binding.lastIndexOf(".");
                Object beanRef = binding.substring(0, idx2);
                String beanProperty = binding.substring(idx2 + 1);
                if ("item".equals(beanRef) && item != null) {
                    beanRef = item;
                }
                if (bidir) {
                    this.bindBidirectional(view, viewProperty, beanRef, beanProperty);
                    continue;
                }
                this.bind(view, viewProperty, beanRef, beanProperty);
                continue;
            }
            binding = binding.substring(idx + 1);
            int idx2 = binding.lastIndexOf(".");
            String beanRef = binding.substring(0, idx2);
            String beanMethodName = binding.substring(idx2 + 1);
            this.bindListener(view, viewProperty, (Object)beanRef, beanMethodName);
        }
    }

    private void internalUnbind(View view) {
        String[] bindings;
        for (String binding : bindings = ((String)view.getTag()).split("\\,")) {
            int idx = binding.indexOf("=");
            if (idx < 0) continue;
            String viewProperty = binding.substring(0, idx);
            if (binding.charAt(idx + 1) == '#' || binding.charAt(idx + 1) == '$') {
                this.unbind(view, viewProperty);
                continue;
            }
            this.unbindListener(view, viewProperty);
        }
    }

    private void initListeners() {
        this.listenersMap.put(View.OnClickListener.class, new View.OnClickListener(){

            public void onClick(View v) {
                Binder.this.applyBindings();
                MethodAction action = (MethodAction)v.getTag(Binder.this.ACTION_BINDING_TAG);
                if (action != null) {
                    action.invokeAction(new Object[0]);
                }
            }
        });
    }

    public void bindListener(int viewId, String viewEvent, Object ref, String beanMethodName) {
        this.bindListener(this.activity.findViewById(viewId), viewEvent, ref, beanMethodName);
    }

    public void bindListener(View rootView, int viewId, String viewEvent, Object ref, String beanMethodName) {
        this.bindListener(rootView.findViewById(viewId), viewEvent, ref, beanMethodName);
    }

    public void bindListener(View view, String viewEvent, Object ref, String beanMethodName) {
        String listenerMethodName = viewEvent;
        int idx = viewEvent.indexOf(".");
        if (idx > 0) {
            listenerMethodName = viewEvent.substring(0, idx) + viewEvent.substring(idx + 1, idx + 2).toUpperCase() + viewEvent.substring(idx + 2);
            viewEvent = viewEvent.substring(0, idx);
        }
        listenerMethodName = "on" + listenerMethodName.substring(0, 1).toUpperCase() + listenerMethodName.substring(1);
        String methodName = "setOn" + viewEvent.substring(0, 1).toUpperCase() + viewEvent.substring(1) + "Listener";
        Method method = null;
        for (Method m : view.getClass().getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new RuntimeException("Not setter found for event " + viewEvent + " on view " + view);
        }
        Object listener = null;
        MethodAction methodAction = new MethodAction(this.beanResolver.resolveBean(ref), beanMethodName, listenerMethodName);
        boolean withView = false;
        Class<?> listenerClass = method.getParameterTypes()[0];
        for (Method m : listenerClass.getMethods()) {
            if (!m.getName().equals(listenerMethodName)) continue;
            withView = m.getParameterTypes().length > 0 && View.class.isAssignableFrom(m.getParameterTypes()[0]);
            break;
        }
        if (withView) {
            view.setTag(this.ACTION_BINDING_TAG, (Object)methodAction);
            listener = this.listenersMap.get(method.getParameterTypes()[0]);
            if (listener == null) {
                listener = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{method.getParameterTypes()[0]}, this.listenerInvocationHandler);
                this.listenersMap.put(method.getParameterTypes()[0], listener);
            }
        } else {
            listener = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{method.getParameterTypes()[0]}, (InvocationHandler)methodAction);
        }
        try {
            method.invoke((Object)view, listener);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set listener for event " + viewEvent + " on view " + view.getClass().getSimpleName(), e);
        }
    }

    public void unbindListener(int viewId, String viewEvent) {
        this.unbindListener(this.activity.findViewById(viewId), viewEvent);
    }

    public void unbindListener(View rootView, int viewId, String viewEvent) {
        this.unbindListener(rootView.findViewById(viewId), viewEvent);
    }

    public void unbindListener(View view, String viewEvent) {
        String methodName = "setOn" + viewEvent.substring(0, 1).toUpperCase() + viewEvent.substring(1) + "Listener";
        Method method = null;
        for (Method m : view.getClass().getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new RuntimeException("Not setter found for event " + viewEvent + " on view " + view);
        }
        view.setTag(this.ACTION_BINDING_TAG, null);
        try {
            method.invoke((Object)view, new Object[]{null});
        }
        catch (Exception e) {
            throw new RuntimeException("Could not unset listener for event " + viewEvent + " on view " + view.getClass().getSimpleName(), e);
        }
    }

    private class BeanProperty<B>
    extends ObservableBeanProperty<B>
    implements WritableObservableValue {
        private final BeanSetter<B> beanSetter;

        public BeanProperty(B bean, String beanPropertyName) {
            super(bean, beanPropertyName);
            this.beanSetter = bean instanceof Map ? null : Binder.this.beanResolver.getBeanSetter(bean, beanPropertyName);
        }

        @Override
        public void setValue(Object value) {
            if (this.beanRef.get() != null) {
                try {
                    if (this.beanSetter == null) {
                        ((Map)this.beanRef.get()).put(this.beanPropertyName, value);
                    } else {
                        this.beanSetter.setValue(this.beanRef.get(), this.beanPropertyName, value);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not set bean property value " + this.beanPropertyName, e);
                }
            }
        }
    }

    private class ObservableBeanProperty<B>
    implements ObservableValue {
        protected final WeakReference<B> beanRef;
        protected final String beanPropertyName;
        private final Getter<B, ?> beanGetter;

        public ObservableBeanProperty(B bean, String beanPropertyName) {
            this.beanRef = new WeakReference<B>(bean);
            this.beanPropertyName = beanPropertyName;
            this.beanGetter = bean instanceof Map ? null : new MethodGetter(bean, beanPropertyName);
        }

        public ObservableBeanProperty(B bean, String beanPropertyName, Getter<B, ?> beanGetter) {
            this.beanRef = new WeakReference<B>(bean);
            this.beanPropertyName = beanPropertyName;
            this.beanGetter = beanGetter;
        }

        @Override
        public void addChangeListener(PropertyChangeListener listener) {
            if (this.beanRef.get() != null) {
                PropertyChangeHelper.addPropertyChangeListener(this.beanRef.get(), this.beanPropertyName, listener);
            }
        }

        @Override
        public void removeChangeListener(PropertyChangeListener listener) {
            if (this.beanRef.get() != null) {
                PropertyChangeHelper.removePropertyChangeListener(this.beanRef.get(), this.beanPropertyName, listener);
            }
        }

        @Override
        public Object getValue() {
            if (this.beanRef.get() != null) {
                try {
                    if (this.beanGetter == null) {
                        return ((Map)this.beanRef.get()).get(this.beanPropertyName);
                    }
                    return this.beanGetter.getValue(this.beanRef.get());
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not get bean property value " + this.beanPropertyName, e);
                }
            }
            return null;
        }
    }

    private class BidirectionalBinding
    implements Binding {
        private final WeakReference<View> viewRef;
        private final ViewSetter<View> viewSetter;
        private final String viewPropertyName;
        private final WritableObservableValue beanProperty;
        private boolean changing = false;
        private PropertyChangeListener viewPropertyChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (BidirectionalBinding.this.changing) {
                    return;
                }
                try {
                    BidirectionalBinding.this.changing = true;
                    Object newValue = event.getNewValue();
                    BidirectionalBinding.this.beanProperty.setValue(newValue);
                }
                finally {
                    BidirectionalBinding.this.changing = false;
                }
            }
        };
        private PropertyChangeListener beanPropertyChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (BidirectionalBinding.this.changing) {
                    return;
                }
                try {
                    BidirectionalBinding.this.changing = true;
                    Object newValue = event.getNewValue();
                    BidirectionalBinding.this.setViewValue(newValue);
                }
                finally {
                    BidirectionalBinding.this.changing = false;
                }
            }
        };

        public BidirectionalBinding(View view, String viewPropertyName, Object bean, String beanPropertyName) {
            if (view == null) {
                throw new NullPointerException("Cannot bind on null view");
            }
            if (viewPropertyName == null) {
                throw new NullPointerException("Cannot bind on null viewPropertyName");
            }
            if (bean == null) {
                throw new NullPointerException("Cannot bind on null bean");
            }
            if (beanPropertyName == null) {
                throw new NullPointerException("Cannot bind on null beanPropertyName");
            }
            this.viewRef = new WeakReference<View>(view);
            this.viewSetter = ViewBindingRegistry.getViewSetter(view.getClass(), viewPropertyName);
            this.beanProperty = new BeanProperty<Object>(bean, beanPropertyName);
            this.beanProperty.addChangeListener(this.beanPropertyChangeListener);
            this.setViewValue(this.beanProperty.getValue());
            ViewWatcher<View> viewWatcher = (ViewWatcher<View>)Binder.this.viewWatchers.get(view);
            if (viewWatcher == null) {
                viewWatcher = ViewBindingRegistry.newWatcher(view);
                Binder.this.viewWatchers.put(view, viewWatcher);
            }
            viewWatcher.addPropertyChangeListener(viewPropertyName, this.viewPropertyChangeListener);
            this.viewPropertyName = viewPropertyName;
        }

        @Override
        public void unbind() {
            this.beanProperty.removeChangeListener(this.beanPropertyChangeListener);
            View view = (View)this.viewRef.get();
            if (view != null) {
                ViewWatcher viewWatcher = (ViewWatcher)Binder.this.viewWatchers.get(view);
                if (viewWatcher != null) {
                    viewWatcher.removePropertyChangeListener(this.viewPropertyName, this.viewPropertyChangeListener);
                }
                if (viewWatcher.isEmpty()) {
                    Binder.this.viewWatchers.remove(view);
                }
            }
        }

        private void setViewValue(Object newValue) {
            if (this.viewRef.get() != null) {
                this.viewSetter.setValue((View)this.viewRef.get(), newValue);
            }
        }

        @Override
        public boolean isFor(View view, String viewPropertyName) {
            return this.viewRef.get() == view && viewPropertyName.equals(this.viewPropertyName);
        }

        @Override
        public boolean isFor(View view) {
            return this.viewRef.get() == view;
        }
    }

    private class UnidirectionalBinding<B>
    implements Binding {
        private final WeakReference<View> viewRef;
        private final String viewPropertyName;
        private final ViewSetter<View> viewSetter;
        private final ObservableValue observableValue;
        private PropertyChangeListener observableValueChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Object newValue = event.getNewValue();
                UnidirectionalBinding.this.setViewValue(newValue);
            }
        };

        public UnidirectionalBinding(View view, String viewPropertyName, B bean, String beanPropertyName) {
            this(view, viewPropertyName, bean, beanPropertyName, null);
        }

        public UnidirectionalBinding(View view, String viewPropertyName, B bean, String beanPropertyName, Getter<B, ?> beanPropertyGetter) {
            this(view, viewPropertyName, beanPropertyGetter != null ? binder.new ObservableBeanProperty<B>(bean, beanPropertyName, beanPropertyGetter) : binder.new ObservableBeanProperty<B>(bean, beanPropertyName));
        }

        public UnidirectionalBinding(View view, String viewPropertyName, ObservableValue observableValue) {
            if (view == null) {
                throw new NullPointerException("Cannot bind on null view");
            }
            if (viewPropertyName == null) {
                throw new NullPointerException("Cannot bind on null viewPropertyName");
            }
            if (observableValue == null) {
                throw new NullPointerException("Cannot bind on null observableValue");
            }
            this.viewRef = new WeakReference<View>(view);
            this.viewSetter = ViewBindingRegistry.getViewSetter(view.getClass(), viewPropertyName);
            this.viewPropertyName = viewPropertyName;
            this.observableValue = observableValue;
            this.observableValue.addChangeListener(this.observableValueChangeListener);
            this.setViewValue(this.observableValue.getValue());
        }

        @Override
        public void unbind() {
            this.observableValue.removeChangeListener(this.observableValueChangeListener);
        }

        private void setViewValue(Object newValue) {
            View view = (View)this.viewRef.get();
            if (view != null) {
                this.viewSetter.setValue(view, newValue);
            }
        }

        @Override
        public boolean isFor(View view, String viewPropertyName) {
            return this.viewRef.get() == view && viewPropertyName.equals(this.viewPropertyName);
        }

        @Override
        public boolean isFor(View view) {
            return this.viewRef.get() == view;
        }
    }

    public static interface Binding {
        public boolean isFor(View var1, String var2);

        public boolean isFor(View var1);

        public void unbind();
    }

    private static class MethodBeanSetter<B>
    implements BeanSetter<B> {
        private final Method setter;

        public MethodBeanSetter(B bean, String beanPropertyName) {
            Method beanSetter = null;
            try {
                for (Method m : bean.getClass().getMethods()) {
                    if (!m.getName().equals("set" + beanPropertyName.substring(0, 1).toUpperCase() + beanPropertyName.substring(1)) || m.getParameterTypes().length != 1) continue;
                    beanSetter = m;
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find setter on bean " + bean.getClass().getName() + "." + beanPropertyName, e);
            }
            if (beanSetter == null) {
                throw new RuntimeException("Could not find setter on bean " + bean.getClass().getName() + "." + beanPropertyName);
            }
            this.setter = beanSetter;
        }

        @Override
        public void setValue(B instance, String beanPropertyName, Object value) throws Exception {
            this.setter.invoke(instance, value);
        }
    }

    private static class MethodGetter<B, V>
    implements Getter<B, V> {
        private final Method getter;

        public MethodGetter(B bean, String beanPropertyName) {
            Method getter = null;
            try {
                getter = bean.getClass().getMethod("get" + beanPropertyName.substring(0, 1).toUpperCase() + beanPropertyName.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    getter = bean.getClass().getMethod("is" + beanPropertyName.substring(0, 1).toUpperCase() + beanPropertyName.substring(1), new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    throw new RuntimeException("Could not find getter on bean " + bean.getClass().getName() + "." + beanPropertyName, e);
                }
            }
            this.getter = getter;
        }

        @Override
        public V getValue(B instance) throws Exception {
            return (V)this.getter.invoke(instance, new Object[0]);
        }
    }

    private class MethodAction
    implements InvocationHandler {
        private final Object bean;
        private final String beanMethod;
        private final String listenerMethod;

        public MethodAction(Object bean, String beanMethod, String listenerMethod) {
            this.bean = bean;
            this.beanMethod = beanMethod;
            this.listenerMethod = listenerMethod;
        }

        public String getListenerMethod() {
            return this.listenerMethod;
        }

        public Object invokeAction(Object ... args) {
            try {
                for (Method m : this.bean.getClass().getMethods()) {
                    if (!m.getName().equals(this.beanMethod)) continue;
                    if (m.getParameterTypes().length == args.length) {
                        return m.invoke(this.bean, args);
                    }
                    if (m.getParameterTypes().length >= args.length) continue;
                    Object[] args2 = new Object[m.getParameterTypes().length];
                    if (args2.length > 0) {
                        System.arraycopy(args, 0, args2, 0, args2.length);
                    }
                    return m.invoke(this.bean, args2);
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot invoke method action " + this.beanMethod, e);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            if (!method.getName().equals(this.listenerMethod)) {
                return false;
            }
            Binder.this.applyBindings();
            Object ret = this.invokeAction(args);
            if (ret == null) {
                return true;
            }
            return ret;
        }
    }

    private static final class DefaultBeanResolver
    implements BeanResolver {
        private DefaultBeanResolver() {
        }

        @Override
        public <T> T resolveBean(Object ref) {
            return (T)ref;
        }

        @Override
        public <T> BeanSetter<T> getBeanSetter(T bean, String propertyName) {
            return new MethodBeanSetter<T>(bean, propertyName);
        }
    }

    public static interface BeanResolver {
        public <T> T resolveBean(Object var1);

        public <T> BeanSetter<T> getBeanSetter(T var1, String var2);
    }
}

