/*
 * Decompiled with CFR 0.152.
 */
package org.granite.binding;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.granite.binding.util.WeakIdentityHashMap;

public class PropertyChangeHelper {
    private static final ConcurrentHashMap<Class<?>, Method[]> changeListenerMethodsMap = new ConcurrentHashMap();
    private static final WeakIdentityHashMap<Object, PropertyChangeSupport> pcsMap = new WeakIdentityHashMap();

    private static Method[] getPropertyChangeListeners(Class<?> clazz) {
        Method[] m = changeListenerMethodsMap.get(clazz);
        if (m == null) {
            try {
                Method add1 = clazz.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                Method rem1 = clazz.getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                try {
                    Method add2 = clazz.getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                    Method rem2 = clazz.getMethod("removePropertyChangeListener", String.class, PropertyChangeListener.class);
                    m = new Method[]{add1, rem1, add2, rem2};
                }
                catch (NoSuchMethodException e) {
                    m = new Method[]{add1, rem1};
                }
            }
            catch (NoSuchMethodException e) {
                m = new Method[]{};
            }
            changeListenerMethodsMap.put(clazz, m);
        }
        return m;
    }

    private static PropertyChangeSupport getPropertyChangeSupport(Object bean) {
        PropertyChangeSupport pcs = pcsMap.get(bean);
        if (pcs == null) {
            pcs = new PropertyChangeSupport(bean);
            pcsMap.put(bean, pcs);
        }
        return pcs;
    }

    public static void firePropertyChange(Object bean, String propertyName, Object oldValue, Object newValue) {
        if (PropertyChangeHelper.getPropertyChangeListeners(bean.getClass()).length > 0) {
            return;
        }
        PropertyChangeHelper.getPropertyChangeSupport(bean).firePropertyChange(propertyName, oldValue, newValue);
    }

    public static void addPropertyChangeListener(Object bean, PropertyChangeListener listener) {
        try {
            Method[] m = PropertyChangeHelper.getPropertyChangeListeners(bean.getClass());
            if (m.length > 0) {
                m[0].invoke(bean, listener);
            } else {
                PropertyChangeHelper.getPropertyChangeSupport(bean).addPropertyChangeListener(listener);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add property change listener on " + bean);
        }
    }

    public static void addPropertyChangeListener(Object bean, String propertyName, PropertyChangeListener listener) {
        try {
            Method[] m = PropertyChangeHelper.getPropertyChangeListeners(bean.getClass());
            if (m.length > 2) {
                m[2].invoke(bean, propertyName, listener);
            } else {
                PropertyChangeHelper.getPropertyChangeSupport(bean).addPropertyChangeListener(propertyName, listener);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add property change listener " + propertyName + " on " + bean);
        }
    }

    public static void removePropertyChangeListener(Object bean, PropertyChangeListener listener) {
        try {
            Method[] m = PropertyChangeHelper.getPropertyChangeListeners(bean.getClass());
            if (m.length > 0) {
                m[1].invoke(bean, listener);
            } else {
                PropertyChangeHelper.getPropertyChangeSupport(bean).removePropertyChangeListener(listener);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not remove property change listener on " + bean);
        }
    }

    public static void removePropertyChangeListener(Object bean, String propertyName, PropertyChangeListener listener) {
        try {
            Method[] m = PropertyChangeHelper.getPropertyChangeListeners(bean.getClass());
            if (m.length > 2) {
                m[3].invoke(bean, propertyName, listener);
            } else {
                PropertyChangeHelper.getPropertyChangeSupport(bean).removePropertyChangeListener(propertyName, listener);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not remove property change listener " + propertyName + " on " + bean);
        }
    }
}

