/*
 * Decompiled with CFR 0.152.
 */
package org.granite.binding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.granite.binding.ObservableValue;

public class Bindings {
    public static ObservableValue not(ObservableValue source) {
        return new UniOperatorBinding<Boolean>(source){

            @Override
            protected Boolean evaluate(Object val) {
                return val != null ? Boolean.valueOf((Boolean)val == false) : null;
            }
        };
    }

    public static ObservableValue and(ObservableValue value1, ObservableValue value2) {
        return new BiOperatorBinding<Boolean>(value1, value2){

            @Override
            protected Boolean evaluate(Object val1, Object val2) {
                return val1 == null || val2 == null ? null : Boolean.valueOf(Boolean.TRUE.equals(val1) && Boolean.TRUE.equals(val2));
            }
        };
    }

    public static ObservableValue or(ObservableValue value1, ObservableValue value2) {
        return new BiOperatorBinding<Boolean>(value1, value2){

            @Override
            protected Boolean evaluate(Object val1, Object val2) {
                return val1 == null || val2 == null ? null : Boolean.valueOf(Boolean.TRUE.equals(val1) || Boolean.TRUE.equals(val2));
            }
        };
    }

    public static ObservableValue equals(ObservableValue value1, ObservableValue value2) {
        return new BiOperatorBinding<Boolean>(value1, value2){

            @Override
            protected Boolean evaluate(Object val1, Object val2) {
                return val1 == null || val2 == null ? false : val1.equals(val2);
            }
        };
    }

    private static abstract class BiOperatorBinding<T>
    implements ObservableValue {
        private final ObservableValue value1;
        private final ObservableValue value2;
        private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private T currentValue;
        private final PropertyChangeListener value1ChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                Object oldValue = BiOperatorBinding.this.currentValue;
                BiOperatorBinding.this.currentValue = BiOperatorBinding.this.evaluate(pce.getNewValue(), BiOperatorBinding.this.value2.getValue());
                if (BiOperatorBinding.this.currentValue != oldValue) {
                    BiOperatorBinding.this.pcs.firePropertyChange(pce.getPropertyName(), oldValue, BiOperatorBinding.this.currentValue);
                }
            }
        };
        private final PropertyChangeListener value2ChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                Object oldValue = BiOperatorBinding.this.currentValue;
                BiOperatorBinding.this.currentValue = BiOperatorBinding.this.evaluate(BiOperatorBinding.this.value1.getValue(), pce.getNewValue());
                if (BiOperatorBinding.this.currentValue != oldValue) {
                    BiOperatorBinding.this.pcs.firePropertyChange(pce.getPropertyName(), oldValue, BiOperatorBinding.this.currentValue);
                }
            }
        };

        public BiOperatorBinding(ObservableValue value1, ObservableValue value2) {
            this.value1 = value1;
            this.value2 = value2;
            this.currentValue = this.evaluate(value1.getValue(), value2.getValue());
            value1.addChangeListener(this.value1ChangeListener);
            value2.addChangeListener(this.value2ChangeListener);
        }

        @Override
        public Object getValue() {
            return this.currentValue;
        }

        protected abstract T evaluate(Object var1, Object var2);

        @Override
        public void addChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        @Override
        public void removeChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }
    }

    private static abstract class UniOperatorBinding<T>
    implements ObservableValue {
        private final ObservableValue source;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private T currentValue;
        private final PropertyChangeListener notChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                Object oldValue = UniOperatorBinding.this.currentValue;
                UniOperatorBinding.this.currentValue = UniOperatorBinding.this.evaluate(pce.getNewValue());
                UniOperatorBinding.this.pcs.firePropertyChange(pce.getPropertyName(), oldValue, UniOperatorBinding.this.currentValue);
            }
        };

        public UniOperatorBinding(ObservableValue source) {
            this.source = source;
            this.currentValue = this.evaluate(source.getValue());
            this.source.addChangeListener(this.notChangeListener);
        }

        @Override
        public Object getValue() {
            return this.currentValue;
        }

        protected abstract T evaluate(Object var1);

        @Override
        public void addChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        @Override
        public void removeChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }
    }
}

