/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gradle.plugin.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.gradle.api.Action;
import org.gradle.process.JavaExecSpec;
import org.grails.launcher.ForkedGrailsLauncher;
import org.grails.launcher.Main;
import org.grails.launcher.context.GrailsLaunchContext;

public class GrailsLaunchConfigureAction
implements Action<JavaExecSpec> {
    private final GrailsLaunchContext launchContext;
    private final File springloadedJar;
    private final File contextDestination;

    public GrailsLaunchConfigureAction(GrailsLaunchContext launchContext, File springloadedJar, File contextDestination) {
        this.launchContext = launchContext;
        this.springloadedJar = springloadedJar;
        this.contextDestination = contextDestination;
    }

    public void execute(JavaExecSpec javaExec) {
        this.configureReloadAgent(javaExec);
        FileOutputStream fileOut = null;
        ObjectOutputStream oos = null;
        try {
            fileOut = new FileOutputStream(this.contextDestination);
            oos = new ObjectOutputStream(fileOut);
            oos.writeObject(this.launchContext);
            javaExec.setWorkingDir((Object)this.launchContext.getBaseDir());
            if (this.launchContext.getGrailsHome() != null) {
                javaExec.systemProperty("grails.home", (Object)this.launchContext.getGrailsHome().getAbsolutePath());
            }
            File launcherJar = this.findJarFile(ForkedGrailsLauncher.class);
            javaExec.classpath(new Object[]{launcherJar});
            javaExec.setMain(Main.class.getName());
            javaExec.args(new Object[]{this.contextDestination.getAbsolutePath()});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (fileOut != null) {
                    ((OutputStream)fileOut).close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    public void configureReloadAgent(JavaExecSpec exec) {
        if (this.springloadedJar == null) {
            return;
        }
        String agentJarFilePath = this.springloadedJar.getAbsolutePath();
        Boolean isDebug = exec.getDebug();
        exec.jvmArgs(new Object[]{String.format("-javaagent:%s", agentJarFilePath), "-noverify"});
        if (isDebug.booleanValue()) {
            exec.setDebug(true);
        }
        exec.systemProperty("springloaded", (Object)"profile=grails");
    }

    private File findJarFile(Class targetClass) {
        String absolutePath = targetClass.getResource('/' + targetClass.getName().replace(".", "/") + ".class").getPath();
        String jarPath = absolutePath.substring("file:".length(), absolutePath.lastIndexOf("!"));
        return new File(jarPath);
    }
}

