/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.cypher.capf.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.calcite.CalciteConfig;
import org.apache.flink.table.calcite.CalciteConfigBuilder;
import org.apache.flink.types.Row;
import org.gradoop.common.model.api.entities.GraphHeadFactory;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.api.epgm.BaseGraphCollectionFactory;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.operators.cypher.capf.result.functions.AddGradoopIdToRow;
import org.gradoop.flink.model.impl.operators.cypher.capf.result.functions.AddNewGraphs;
import org.gradoop.flink.model.impl.operators.cypher.capf.result.functions.AggregateGraphs;
import org.gradoop.flink.model.impl.operators.cypher.capf.result.functions.CreateGraphHeadWithProperties;
import org.gradoop.flink.model.impl.operators.cypher.capf.result.functions.PropertyDecoder;
import org.gradoop.flink.model.impl.operators.cypher.capf.result.functions.SplitRow;
import org.opencypher.flink.api.CAPFSession;
import org.opencypher.flink.impl.CAPFRecords;
import org.opencypher.okapi.api.graph.CypherResult;
import org.opencypher.okapi.ir.api.expr.Expr;
import org.opencypher.okapi.ir.api.expr.Var;
import scala.collection.Iterator;

public class CAPFQueryResult {
    private static final List<String> DISABLED_RULES = Collections.singletonList("ProjectMergeRule:force_mode");
    private CAPFRecords records;
    private boolean isGraph;
    private CAPFSession session;
    private org.apache.flink.api.java.DataSet<Tuple2<Long, EPGMVertex>> verticesWithIds;
    private org.apache.flink.api.java.DataSet<Tuple2<Long, EPGMEdge>> edgesWithIds;
    private BaseGraphCollectionFactory<EPGMGraphHead, EPGMVertex, EPGMEdge, LogicalGraph, GraphCollection> factory;

    public CAPFQueryResult(CypherResult result, org.apache.flink.api.java.DataSet<Tuple2<Long, EPGMVertex>> verticesWithIds, org.apache.flink.api.java.DataSet<Tuple2<Long, EPGMEdge>> edgesWithIds, BaseGraphCollectionFactory<EPGMGraphHead, EPGMVertex, EPGMEdge, LogicalGraph, GraphCollection> factory) {
        this.records = (CAPFRecords)result.records();
        this.verticesWithIds = verticesWithIds;
        this.edgesWithIds = edgesWithIds;
        this.factory = factory;
        this.session = ((CAPFRecords)result.records()).capf();
        this.isGraph = !this.records.header().elementVars().isEmpty();
    }

    public boolean containsGraphs() {
        return this.isGraph;
    }

    public GraphCollection getGraphs() {
        if (!this.isGraph) {
            return null;
        }
        HashSet<Var> nodeVars = new HashSet<Var>();
        HashSet<Var> relVars = new HashSet<Var>();
        HashSet<Object> otherVars = new HashSet<Object>();
        Iterator varIt = this.records.header().vars().iterator();
        while (varIt.hasNext()) {
            otherVars.add(varIt.next());
        }
        for (Var nodeVar : this.records.header().nodeElements()) {
            nodeVars.add(nodeVar);
            otherVars.remove(nodeVar);
        }
        for (Var relVar : this.records.header().relationshipElements()) {
            relVars.add(relVar);
            otherVars.remove(relVar);
        }
        StringBuilder entityFieldsBuilder = new StringBuilder();
        for (Var var : nodeVars) {
            entityFieldsBuilder.append(this.records.header().column((Expr)var)).append(",");
        }
        for (Var var : relVars) {
            entityFieldsBuilder.append(this.records.header().column((Expr)var)).append(",");
        }
        StringBuilder otherFieldsBuilder = new StringBuilder();
        ArrayList<String> otherVarNames = new ArrayList<String>();
        for (Var var : otherVars) {
            otherVarNames.add(var.name());
            otherFieldsBuilder.append((String)this.records.header().getColumn((Expr)var).get()).append(", ");
        }
        String fieldString = entityFieldsBuilder.toString() + otherFieldsBuilder.toString();
        if (fieldString.length() > 0) {
            fieldString = fieldString.substring(0, fieldString.length() - 1);
        }
        TypeInformation typeInformation = TypeInformation.of(Row.class);
        this.removeSlowOptimizationRule();
        DataSet scalarowsWithNewIds = this.session.tableEnv().toDataSet(this.records.table().table().select(fieldString), typeInformation);
        MapOperator rowsWithNewIds = scalarowsWithNewIds.javaSet().map((MapFunction)new AddGradoopIdToRow());
        int entityFieldsCount = nodeVars.size() + relVars.size();
        int otherFieldsCount = otherVars.size();
        MapOperator graphHeads = rowsWithNewIds.map((MapFunction)new CreateGraphHeadWithProperties(entityFieldsCount, entityFieldsCount + otherFieldsCount, (GraphHeadFactory<EPGMGraphHead>)this.factory.getGraphHeadFactory(), otherVarNames));
        GroupReduceOperator rowsWithGraphIdSets = rowsWithNewIds.flatMap((FlatMapFunction)new SplitRow(0, entityFieldsCount)).groupBy(new int[]{0}).reduceGroup(new AggregateGraphs());
        JoinOperator.EquiJoin vertices = rowsWithGraphIdSets.join(this.verticesWithIds).where(new int[]{0}).equalTo(new int[]{0}).with(new AddNewGraphs());
        JoinOperator.EquiJoin edges = rowsWithGraphIdSets.join(this.edgesWithIds).where(new int[]{0}).equalTo(new int[]{0}).with(new AddNewGraphs());
        vertices = vertices.map(new PropertyDecoder());
        edges = edges.map(new PropertyDecoder());
        return (GraphCollection)this.factory.fromDataSets((org.apache.flink.api.java.DataSet)graphHeads, (org.apache.flink.api.java.DataSet)vertices, (org.apache.flink.api.java.DataSet)edges);
    }

    private void removeSlowOptimizationRule() {
        ArrayList<RelOptRule> ruleList = new ArrayList<RelOptRule>();
        for (RelOptRule rule : this.session.tableEnv().getLogicalOptRuleSet()) {
            if (DISABLED_RULES.contains(rule.toString())) continue;
            ruleList.add(rule);
        }
        CalciteConfigBuilder builder = new CalciteConfigBuilder().replaceLogicalOptRuleSet(RuleSets.ofList(ruleList));
        CalciteConfig calciteConfig = this.session.tableEnv().config().getCalciteConfig();
        if (calciteConfig.replacesDecoRuleSet()) {
            builder.replaceDecoRuleSet((RuleSet)calciteConfig.getDecoRuleSet().get());
        }
        if (calciteConfig.replacesNormRuleSet()) {
            builder.replaceNormRuleSet((RuleSet)calciteConfig.getNormRuleSet().get());
        }
        if (calciteConfig.replacesPhysicalOptRuleSet()) {
            builder.replacePhysicalOptRuleSet((RuleSet)calciteConfig.getPhysicalOptRuleSet().get());
        }
        if (calciteConfig.replacesSqlOperatorTable()) {
            builder.replaceSqlOperatorTable((SqlOperatorTable)calciteConfig.getSqlOperatorTable().get());
        }
        if (calciteConfig.getSqlParserConfig().isDefined()) {
            builder.replaceSqlParserConfig((SqlParser.Config)calciteConfig.getSqlParserConfig().get());
        }
        if (calciteConfig.getSqlToRelConverterConfig().isDefined()) {
            builder.replaceSqlToRelConverterConfig((SqlToRelConverter.Config)calciteConfig.getSqlToRelConverterConfig().get());
        }
        this.session.tableEnv().config().setCalciteConfig(builder.build());
    }

    public Table getTable() {
        return this.records.table().table();
    }
}

