/*
 * Decompiled with CFR 0.152.
 */
package org.gradlex.maven.gmm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.Maven;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.gradlex.maven.gmm.Capability;
import org.gradlex.maven.gmm.GradleModuleMetadataWriter;

@Mojo(name="gmm", defaultPhase=LifecyclePhase.PACKAGE)
public class GradleModuleMetadataMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter
    protected List<Dependency> platformDependencies;
    @Parameter
    protected List<Capability> capabilities;
    @Parameter
    protected List<Dependency> removedDependencies;
    @Parameter
    protected List<Dependency> compileOnlyApiDependencies;
    @Parameter(defaultValue="${project.build.directory}/publications/maven")
    private File outputDirectory;
    @Inject
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        if (!this.project.getArtifact().getFile().isFile()) {
            this.getLog().info((CharSequence)("Skipping Gradle Metadata generation as the project artifact cannot be published: " + this.project.getArtifact().getFile()));
            return;
        }
        this.addMarkerToPomIfNotPresent();
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        File moduleFile = new File(this.outputDirectory, "module.json");
        try (FileWriter fileWriter = new FileWriter(moduleFile);){
            GradleModuleMetadataWriter.generateTo(this.project, GradleModuleMetadataMojo.getMavenVersion(), this.platformDependencies, this.capabilities, this.removedDependencies, this.compileOnlyApiDependencies, fileWriter);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating file " + moduleFile, (Exception)e);
        }
        this.projectHelper.attachArtifact(this.project, "module", moduleFile);
    }

    private void addMarkerToPomIfNotPresent() {
        String marker = "do_not_remove: published-with-gradle-metadata";
        File pomFile = this.project.getFile();
        try {
            String pomContent = new String(Files.readAllBytes(pomFile.toPath()));
            if (!pomContent.contains(marker)) {
                String newContent = pomContent.replaceFirst("</modelVersion>", "</modelVersion> <!-- " + marker + " -->");
                Files.write(pomFile.toPath(), newContent.getBytes(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getMavenVersion() throws MojoExecutionException {
        String string;
        block10: {
            InputStream resource = Maven.class.getClassLoader().getResourceAsStream("org/apache/maven/messages/build.properties");
            try {
                if (resource == null) {
                    throw new MojoExecutionException("Unable to determine Maven version.");
                }
                Properties properties = new Properties();
                properties.load(resource);
                String version = properties.getProperty("version");
                if (version == null) {
                    throw new MojoExecutionException("Unable to determine Maven version.");
                }
                string = version;
                if (resource == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to determine Maven version.", (Exception)e);
                }
            }
            resource.close();
        }
        return string;
    }
}

