/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.wasm.predefined.wasi.fd;

import com.oracle.truffle.api.nodes.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import org.graalvm.wasm.memory.WasmMemory;
import org.graalvm.wasm.memory.WasmMemoryLibrary;
import org.graalvm.wasm.predefined.wasi.FlagUtils;
import org.graalvm.wasm.predefined.wasi.fd.Fd;
import org.graalvm.wasm.predefined.wasi.fd.FdUtils;
import org.graalvm.wasm.predefined.wasi.types.Errno;
import org.graalvm.wasm.predefined.wasi.types.Fdflags;
import org.graalvm.wasm.predefined.wasi.types.Filetype;
import org.graalvm.wasm.predefined.wasi.types.Rights;
import org.graalvm.wasm.predefined.wasi.types.Whence;

abstract class SeekableByteChannelFd
extends Fd {
    private SeekableByteChannel channel;
    private InputStream inputStream;
    private OutputStream outputStream;

    SeekableByteChannelFd(SeekableByteChannel channel, Filetype type, long fsRightsBase, long fsRightsInheriting, short fdFlags) {
        super(type, fsRightsBase, fsRightsInheriting, fdFlags);
        this.setChannel(channel);
    }

    protected SeekableByteChannel getChannel() {
        return this.channel;
    }

    protected void setChannel(SeekableByteChannel channel) {
        this.channel = channel;
        this.inputStream = Channels.newInputStream(channel);
        this.outputStream = Channels.newOutputStream(channel);
    }

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public Errno read(Node node, WasmMemory memory, int iovecArrayAddress, int iovecCount, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdRead)) {
            return Errno.Notcapable;
        }
        return FdUtils.readFromStream(node, memory, this.inputStream, iovecArrayAddress, iovecCount, sizeAddress);
    }

    @Override
    public Errno write(Node node, WasmMemory memory, int iovecArrayAddress, int iovecCount, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdWrite)) {
            return Errno.Notcapable;
        }
        return FdUtils.writeToStream(node, memory, this.outputStream, iovecArrayAddress, iovecCount, sizeAddress);
    }

    @Override
    public Errno pread(Node node, WasmMemory memory, int iovecArrayAddress, int iovecCount, long offset, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdRead)) {
            return Errno.Notcapable;
        }
        if (FlagUtils.isSet(this.fdFlags, Fdflags.Append)) {
            return Errno.Nosys;
        }
        return FdUtils.readFromStreamAt(node, memory, this.inputStream, iovecArrayAddress, iovecCount, this.channel, offset, sizeAddress);
    }

    @Override
    public Errno pwrite(Node node, WasmMemory memory, int iovecArrayAddress, int iovecCount, long offset, int sizeAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdWrite)) {
            return Errno.Notcapable;
        }
        if (FlagUtils.isSet(this.fdFlags, Fdflags.Append)) {
            return Errno.Nosys;
        }
        return FdUtils.writeToStreamAt(node, memory, this.outputStream, iovecArrayAddress, iovecCount, this.channel, offset, sizeAddress);
    }

    @Override
    public Errno seek(Node node, WasmMemory memory, long offset, Whence whence, int newOffsetAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdSeek)) {
            return Errno.Notcapable;
        }
        try {
            long newOffset;
            switch (whence) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case Set: {
                    long l = offset;
                    break;
                }
                case Cur: {
                    long l = this.channel.position() + offset;
                    break;
                }
                case End: {
                    long l = newOffset = this.channel.size() + offset;
                }
            }
            if (newOffset < 0L) {
                return Errno.Inval;
            }
            this.channel.position(newOffset);
            WasmMemoryLibrary.getUncached().store_i64(memory, node, newOffsetAddress, this.channel.position());
        }
        catch (IOException e) {
            return Errno.Io;
        }
        return Errno.Success;
    }

    @Override
    public Errno tell(Node node, WasmMemory memory, int offsetAddress) {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdTell)) {
            return Errno.Notcapable;
        }
        try {
            WasmMemoryLibrary.getUncached().store_i64(memory, node, offsetAddress, this.channel.position());
        }
        catch (IOException e) {
            return Errno.Io;
        }
        return Errno.Success;
    }

    @Override
    public Errno datasync() {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdDatasync)) {
            return Errno.Notcapable;
        }
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            return Errno.Io;
        }
        return Errno.Success;
    }

    @Override
    public Errno sync() {
        if (!FlagUtils.isSet(this.fsRightsBase, Rights.FdSync)) {
            return Errno.Notcapable;
        }
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            return Errno.Io;
        }
        return Errno.Success;
    }
}

